/*
 * Decompiled with CFR 0.152.
 */
package org.doxygen.tools;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.doxygen.tools.DoxygenTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenConfig {
    private Map<String, DoxygenTask.Property> taskProperties = new TreeMap<String, DoxygenTask.Property>();

    public DoxygenConfig() {
        this.setProperty("DETAILS_AT_TOP", true);
        this.setProperty("EXPAND_TOC", true);
        this.setProperty("FILE_PATTERNS", "*.java");
        this.setProperty("GENERATE_LATEX", false);
        this.setProperty("GENERATE_TREEVIEW", true);
        this.setProperty("HIDE_UNDOC_MEMBERS", true);
        this.setProperty("INLINE_SOURCES", true);
        this.setProperty("INPUT", "src");
        this.setProperty("OPTIMIZE_OUTPUT_JAVA", true);
        this.setProperty("OUTPUT_DIRECTORY", "doc");
        this.setProperty("QUIET", true);
        this.setProperty("RECURSIVE", true);
        this.setProperty("SOURCE_BROWSER", true);
    }

    public final void setProperty(String keyName, String value) {
        DoxygenTask.Property nestedElement = this.getProperty(keyName);
        this.taskProperties.put(keyName, nestedElement);
        String val = value;
        if (val.indexOf(32) > -1) {
            val = "\"" + val + "\"";
        }
        nestedElement.setValue(val);
    }

    public final void setProperty(String keyName, int value) {
        DoxygenTask.Property nestedElement = this.getProperty(keyName);
        this.taskProperties.put(keyName, nestedElement);
        nestedElement.setValue("" + value);
    }

    public final void setProperty(String keyName, boolean value) {
        DoxygenTask.Property nestedElement = this.getProperty(keyName);
        this.taskProperties.put(keyName, nestedElement);
        String val = "YES";
        if (!value) {
            val = "NO";
        }
        nestedElement.setValue(val);
    }

    public final DoxygenTask.Property getProperty(String keyName) {
        DoxygenTask.Property retval = null;
        if (this.taskProperties.containsKey(keyName)) {
            retval = this.taskProperties.get(keyName);
        }
        if (retval == null) {
            retval = new DoxygenTask.Property();
            retval.setName(keyName);
        }
        return retval;
    }

    public final void writeDoxygenConfig(String theConfigFilename) {
        PrintStream ps = null;
        TreeMap<String, String> map = this.readDoxygenConfig(theConfigFilename);
        this.cascadeDoxygenConfig(map);
        try {
            ps = new PrintStream(new FileOutputStream(DoxygenTask.CONFIG_FILE));
            Set<String> keys = map.keySet();
            Iterator<String> i$ = keys.iterator();
            while (i$.hasNext()) {
                String key;
                String param = key = i$.next();
                String value = map.get(key);
                String line = param + "\t=";
                if (value != null) {
                    line = line + " " + value;
                }
                ps.println(line);
            }
            DoxygenTask.activityLog(false, "Updated Doxygen config file: [" + DoxygenTask.CONFIG_FILE + "]");
        }
        catch (IOException ioe) {
            throw new BuildException("Unable to update Doxygen config file: [" + theConfigFilename + "]", (Throwable)ioe);
        }
        finally {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
    }

    public final TreeMap<String, String> readDoxygenConfig(String theConfigFilename) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(theConfigFilename));
            Set<Object> names = p.keySet();
            for (Object obj : names) {
                map.put((String)obj, p.getProperty((String)obj));
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Unable to read Doxygen config file: [" + theConfigFilename + "]", (Throwable)ioe);
        }
        return map;
    }

    public final void cascadeDoxygenConfig(TreeMap<String, String> map) {
        Collection<DoxygenTask.Property> coll = this.taskProperties.values();
        for (DoxygenTask.Property nestedElement : coll) {
            map.put(nestedElement.getName(), nestedElement.getValue());
        }
    }
}

