/*
 * Decompiled with CFR 0.152.
 */
package org.doxygen.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.doxygen.tools.DoxygenTask;
import org.doxygen.tools.DoxygenVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenProcess {
    public static String DOXY_TEMP = "";
    private String doxygenPath = "doxygen";

    public final void setDoxygenPath(String path) {
        this.doxygenPath = path;
    }

    public final void checkVersion(String versionCompatibility) {
        if (versionCompatibility == null) {
            return;
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--version");
            String fileVersion = this.invokeDoxygen(args);
            DoxygenTask.activityLog(false, "Detected Doxygen version:" + fileVersion + "  " + "Project requires version: " + versionCompatibility);
            DoxygenVersion systemVersion = new DoxygenVersion(fileVersion);
            if (!systemVersion.isCompatible(versionCompatibility)) {
                String message = "Detected Doxygen version does not satisfy project requirements.\n";
                throw new BuildException(message);
            }
        }
        catch (NumberFormatException nfe) {
            throw new BuildException("Unable to detect Doxygen version.", (Throwable)nfe);
        }
    }

    public final void createConfig(String theConfigFilename) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-s");
        args.add("-g");
        args.add(theConfigFilename);
        this.invokeDoxygen(args);
    }

    public final void executeDoxygenConfig(String theConfigFilename) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(theConfigFilename);
        this.invokeDoxygen(args);
    }

    private String invokeDoxygen(List<String> args) {
        String[] arguments = new String[1 + args.size()];
        StringBuilder res = new StringBuilder();
        arguments[0] = this.doxygenPath;
        try {
            Execute doxygen = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new FileOutputStream(DOXY_TEMP)));
            StringBuilder sb = new StringBuilder("Exec: " + arguments[0] + " ");
            int i = 1;
            for (String arg : args) {
                if (arg.indexOf(" ") != -1) {
                    arg = "\"" + arg + "\"";
                }
                arguments[i] = arg;
                sb.append(arguments[i] + " ");
                ++i;
            }
            DoxygenTask.activityLog(true, sb.toString());
            doxygen.setCommandline(arguments);
            doxygen.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(DOXY_TEMP)));
            String line = br.readLine();
            while (line != null) {
                res.append(line);
                line = br.readLine();
                DoxygenTask.activityLog(false, line);
            }
            return res.toString();
        }
        catch (IOException ioe) {
            throw new BuildException("Doxygen not found on the PATH.", (Throwable)ioe);
        }
    }

    static {
        try {
            DOXY_TEMP = File.createTempFile("doxygen", ".log").getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

