/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.EdgeScorer;
import edu.uci.ics.jung.algorithms.scoring.VertexScorer;
import edu.uci.ics.jung.algorithms.util.MapBinaryHeap;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetweennessCentrality<V, E>
implements VertexScorer<V, Double>,
EdgeScorer<E, Double> {
    protected Graph<V, E> graph;
    protected Map<V, Double> vertex_scores;
    protected Map<E, Double> edge_scores;
    protected Map<V, BetweennessData> vertex_data;

    public BetweennessCentrality(Graph<V, E> graph) {
        this.initialize(graph);
        this.computeBetweenness(new LinkedList(), (Transformer<E, ? extends Number>)new ConstantTransformer((Object)1));
    }

    public BetweennessCentrality(Graph<V, E> graph, Transformer<E, ? extends Number> edge_weights) {
        for (Object e : graph.getEdges()) {
            double e_weight = ((Number)edge_weights.transform(e)).doubleValue();
            if (!(e_weight < 0.0)) continue;
            throw new IllegalArgumentException(String.format("Weight for edge '%s' is < 0: %d", e, e_weight));
        }
        this.initialize(graph);
        this.computeBetweenness(new MapBinaryHeap(new BetweennessComparator()), edge_weights);
    }

    protected void initialize(Graph<V, E> graph) {
        this.graph = graph;
        this.vertex_scores = new HashMap<V, Double>();
        this.edge_scores = new HashMap<E, Double>();
        this.vertex_data = new HashMap<V, BetweennessData>();
        for (Object v : graph.getVertices()) {
            this.vertex_scores.put((Double)v, 0.0);
        }
        for (Object e : graph.getEdges()) {
            this.edge_scores.put(e, 0.0);
        }
    }

    protected void computeBetweenness(Queue<V> queue, Transformer<E, ? extends Number> edge_weights) {
        for (Object v : this.graph.getVertices()) {
            for (Object s : this.graph.getVertices()) {
                this.vertex_data.put((BetweennessData)s, new BetweennessData());
            }
            if (v.equals(new Integer(0))) {
                System.out.println("pause");
            }
            this.vertex_data.get(v).numSPs = 1.0;
            this.vertex_data.get(v).distance = 0.0;
            Stack<V> stack = new Stack<V>();
            queue.offer(v);
            while (!queue.isEmpty()) {
                double x_potential_dist;
                BetweennessData x_data;
                V x;
                V w = queue.poll();
                stack.push(w);
                BetweennessData w_data = this.vertex_data.get(w);
                for (E e : this.graph.getOutEdges(w)) {
                    x = this.graph.getOpposite(w, e);
                    if (x.equals(w)) continue;
                    double wx_weight = ((Number)edge_weights.transform(e)).doubleValue();
                    x_data = this.vertex_data.get(x);
                    x_potential_dist = w_data.distance + wx_weight;
                    if (x_data.distance < 0.0) {
                        x_data.distance = x_potential_dist;
                        queue.offer(x);
                    }
                    if (!(x_data.distance > x_potential_dist)) continue;
                    x_data.distance = x_potential_dist;
                    x_data.incomingEdges.clear();
                    ((MapBinaryHeap)queue).update(x);
                }
                for (E e : this.graph.getOutEdges(w)) {
                    x = this.graph.getOpposite(w, e);
                    if (x.equals(w)) continue;
                    double e_weight = ((Number)edge_weights.transform(e)).doubleValue();
                    x_data = this.vertex_data.get(x);
                    x_potential_dist = w_data.distance + e_weight;
                    if (x_data.distance != x_potential_dist) continue;
                    x_data.numSPs += w_data.numSPs;
                    x_data.incomingEdges.add(e);
                }
            }
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                for (Object e : this.vertex_data.get(x).incomingEdges) {
                    V w = this.graph.getOpposite(x, e);
                    double partialDependency = this.vertex_data.get(w).numSPs / this.vertex_data.get(x).numSPs * (1.0 + this.vertex_data.get(x).dependency);
                    this.vertex_data.get(w).dependency += partialDependency;
                    double e_score = this.edge_scores.get(e);
                    this.edge_scores.put(e, e_score + partialDependency);
                }
                if (x.equals(v)) continue;
                double x_score = this.vertex_scores.get(x);
                this.vertex_scores.put((Double)x, x_score += this.vertex_data.get(x).dependency);
            }
        }
        if (this.graph instanceof UndirectedGraph) {
            for (Object v : this.graph.getVertices()) {
                double v_score = this.vertex_scores.get(v);
                this.vertex_scores.put((Double)v, v_score /= 2.0);
            }
            for (Object e : this.graph.getEdges()) {
                double e_score = this.edge_scores.get(e);
                this.edge_scores.put(e, e_score /= 2.0);
            }
        }
        this.vertex_data.clear();
    }

    @Override
    public Double getVertexScore(V v) {
        return this.vertex_scores.get(v);
    }

    @Override
    public Double getEdgeScore(E e) {
        return this.edge_scores.get(e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BetweennessComparator
    implements Comparator<V> {
        private BetweennessComparator() {
        }

        @Override
        public int compare(V v1, V v2) {
            return BetweennessCentrality.this.vertex_data.get(v1).distance > BetweennessCentrality.this.vertex_data.get(v2).distance ? 1 : -1;
        }
    }

    private class BetweennessData {
        double distance = -1.0;
        double numSPs = 0.0;
        List<E> incomingEdges = new ArrayList();
        double dependency = 0.0;

        BetweennessData() {
        }

        public String toString() {
            return "[d:" + this.distance + ", sp:" + this.numSPs + ", p:" + this.incomingEdges + ", d:" + this.dependency + "]\n";
        }
    }
}

