/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.GraphDecorator;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateTree<V, E>
extends GraphDecorator<V, E>
implements Tree<V, E>,
Serializable {
    protected V root;
    protected Map<V, Integer> vertex_depths = new HashMap<V, Integer>();

    public static final <V, E> Factory<Tree<V, E>> getFactory() {
        return new Factory<Tree<V, E>>(){

            public Tree<V, E> create() {
                return new DelegateTree(new DirectedSparseMultigraph());
            }
        };
    }

    public DelegateTree() {
        this(DirectedSparseMultigraph.getFactory());
    }

    public DelegateTree(Factory<DirectedGraph<V, E>> graphFactory) {
        super((Graph)graphFactory.create());
    }

    public DelegateTree(DirectedGraph<V, E> graph) {
        super(graph);
    }

    @Override
    public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
        return this.addChild(e, v1, v2, edgeType);
    }

    @Override
    public boolean addEdge(E e, V v1, V v2) {
        return this.addChild(e, v1, v2);
    }

    @Override
    public boolean addVertex(V vertex) {
        if (this.root == null) {
            this.root = vertex;
            this.vertex_depths.put((Integer)vertex, 0);
            return this.delegate.addVertex(vertex);
        }
        throw new UnsupportedOperationException("Unless you are setting the root, use addChild()");
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.delegate.containsVertex(vertex)) {
            return false;
        }
        for (V v : this.getChildren(vertex)) {
            this.removeVertex(v);
            this.vertex_depths.remove(v);
        }
        this.vertex_depths.remove(vertex);
        return this.delegate.removeVertex(vertex);
    }

    public boolean addChild(E edge, V parent, V child, EdgeType edgeType) {
        Collection vertices = this.delegate.getVertices();
        if (!vertices.contains(parent)) {
            throw new IllegalArgumentException("Tree must already contain parent " + parent);
        }
        if (vertices.contains(child)) {
            throw new IllegalArgumentException("Tree must not already contain child " + child);
        }
        this.vertex_depths.put((Integer)child, this.vertex_depths.get(parent) + 1);
        return this.delegate.addEdge(edge, parent, child, edgeType);
    }

    public boolean addChild(E edge, V parent, V child) {
        Collection vertices = this.delegate.getVertices();
        if (!vertices.contains(parent)) {
            throw new IllegalArgumentException("Tree must already contain parent " + parent);
        }
        if (vertices.contains(child)) {
            throw new IllegalArgumentException("Tree must not already contain child " + child);
        }
        this.vertex_depths.put((Integer)child, this.vertex_depths.get(parent) + 1);
        return this.delegate.addEdge(edge, parent, child);
    }

    @Override
    public int getChildCount(V parent) {
        if (!this.delegate.containsVertex(parent)) {
            return 0;
        }
        return this.getChildren(parent).size();
    }

    @Override
    public Collection<V> getChildren(V parent) {
        if (!this.delegate.containsVertex(parent)) {
            return null;
        }
        return this.delegate.getSuccessors(parent);
    }

    @Override
    public V getParent(V child) {
        if (!this.delegate.containsVertex(child)) {
            return null;
        }
        Collection<V> predecessors = this.delegate.getPredecessors(child);
        if (predecessors.size() == 0) {
            return null;
        }
        return predecessors.iterator().next();
    }

    public List<V> getPath(V vertex) {
        if (!this.delegate.containsVertex(vertex)) {
            return null;
        }
        ArrayList<V> list = new ArrayList<V>();
        list.add(vertex);
        V parent = this.getParent(vertex);
        while (parent != null) {
            list.add(list.size(), parent);
            parent = this.getParent(parent);
        }
        return list;
    }

    @Override
    public V getRoot() {
        return this.root;
    }

    public void setRoot(V root) {
        this.addVertex(root);
    }

    public boolean removeChild(V orphan) {
        return this.removeVertex(orphan);
    }

    @Override
    public int getDepth(V v) {
        return this.vertex_depths.get(v);
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (Object v : this.getVertices()) {
            height = Math.max(height, this.getDepth(v));
        }
        return height;
    }

    public boolean isInternal(V v) {
        if (!this.delegate.containsVertex(v)) {
            return false;
        }
        return !this.isLeaf(v) && !this.isRoot(v);
    }

    public boolean isLeaf(V v) {
        if (!this.delegate.containsVertex(v)) {
            return false;
        }
        return this.getChildren(v).size() == 0;
    }

    public boolean isRoot(V v) {
        if (!this.delegate.containsVertex(v)) {
            return false;
        }
        return this.getParent(v) == null;
    }

    @Override
    public int getIncidentCount(E edge) {
        if (!this.delegate.containsEdge(edge)) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean addEdge(E edge, Collection<? extends V> vertices) {
        Pair<V> pair = null;
        pair = vertices instanceof Pair ? (Pair<V>)vertices : new Pair<V>(vertices);
        return this.addEdge(edge, pair.getFirst(), pair.getSecond());
    }

    public String toString() {
        return "Tree of " + this.delegate.toString();
    }

    @Override
    public Collection<Tree<V, E>> getTrees() {
        return Collections.singleton(this);
    }

    @Override
    public Collection<E> getChildEdges(V vertex) {
        return this.getOutEdges(vertex);
    }

    @Override
    public E getParentEdge(V vertex) {
        return this.getInEdges(vertex).iterator().next();
    }
}

