/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndirectedSparseMultigraph<V, E>
extends AbstractTypedGraph<V, E>
implements UndirectedGraph<V, E>,
MultiGraph<V, E>,
Serializable {
    protected Map<V, Set<E>> vertices = new HashMap<V, Set<E>>();
    protected Map<E, Pair<V>> edges = new HashMap<E, Pair<V>>();

    public static <V, E> Factory<UndirectedGraph<V, E>> getFactory() {
        return new Factory<UndirectedGraph<V, E>>(){

            public UndirectedGraph<V, E> create() {
                return new UndirectedSparseMultigraph();
            }
        };
    }

    public UndirectedSparseMultigraph() {
        super(EdgeType.UNDIRECTED);
    }

    @Override
    public Collection<E> getEdges() {
        return Collections.unmodifiableCollection(this.edges.keySet());
    }

    @Override
    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.keySet());
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.vertices.keySet().contains(vertex);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.edges.keySet().contains(edge);
    }

    protected Collection<E> getIncident_internal(V vertex) {
        return this.vertices.get(vertex);
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new HashSet());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        for (E edge : new ArrayList<E>(this.getIncident_internal(vertex))) {
            this.removeEdge(edge);
        }
        this.vertices.remove(vertex);
        return true;
    }

    @Override
    public boolean addEdge(E edge, V v1, V v2, EdgeType edgeType) {
        return this.addEdge(edge, new Pair<V>(v1, v2), edgeType);
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edge_type) {
        this.validateEdgeType(edge_type);
        Pair<? extends V> new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        this.edges.put(edge, new_endpoints);
        if (!this.containsVertex(v1)) {
            this.addVertex(v1);
        }
        if (!this.containsVertex(v2)) {
            this.addVertex(v2);
        }
        this.vertices.get(v1).add(edge);
        this.vertices.get(v2).add(edge);
        return true;
    }

    @Override
    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair<V> endpoints = this.getEndpoints(edge);
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        this.vertices.get(v1).remove(edge);
        this.vertices.get(v2).remove(edge);
        this.edges.remove(edge);
        return true;
    }

    @Override
    public Collection<E> getInEdges(V vertex) {
        return this.getIncidentEdges(vertex);
    }

    @Override
    public Collection<E> getOutEdges(V vertex) {
        return this.getIncidentEdges(vertex);
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        return this.getNeighbors(vertex);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        return this.getNeighbors(vertex);
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> neighbors = new HashSet<V>();
        for (E edge : this.getIncident_internal(vertex)) {
            Pair<V> endpoints = this.getEndpoints(edge);
            V e_a = endpoints.getFirst();
            V e_b = endpoints.getSecond();
            if (vertex.equals(e_a)) {
                neighbors.add(e_b);
                continue;
            }
            neighbors.add(e_a);
        }
        return Collections.unmodifiableCollection(neighbors);
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getIncident_internal(vertex));
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        for (E edge : this.getIncident_internal(v1)) {
            Pair<V> endpoints = this.getEndpoints(edge);
            V e_a = endpoints.getFirst();
            V e_b = endpoints.getSecond();
            if ((!v1.equals(e_a) || !v2.equals(e_b)) && (!v1.equals(e_b) || !v2.equals(e_a))) continue;
            return edge;
        }
        return null;
    }

    @Override
    public Pair<V> getEndpoints(E edge) {
        return this.edges.get(edge);
    }

    @Override
    public V getDest(E directed_edge) {
        return null;
    }

    @Override
    public V getSource(E directed_edge) {
        return null;
    }

    @Override
    public boolean isDest(V vertex, E edge) {
        return false;
    }

    @Override
    public boolean isSource(V vertex, E edge) {
        return false;
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }
}

