/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;

public class DFSAdmin
extends FsShell {
    public DFSAdmin() {
        this(null);
    }

    public DFSAdmin(Configuration conf) {
        super(conf);
    }

    public void report() throws IOException {
        if (this.fs instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
            DistributedFileSystem.DiskStatus ds = dfs.getDiskStatus();
            long capacity = ds.getCapacity();
            long used = ds.getDfsUsed();
            long remaining = ds.getRemaining();
            long presentCapacity = used + remaining;
            boolean mode = dfs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET);
            UpgradeStatusReport status = dfs.distributedUpgradeProgress(FSConstants.UpgradeAction.GET_STATUS);
            if (mode) {
                System.out.println("Safe mode is ON");
            }
            if (status != null) {
                System.out.println(status.getStatusText(false));
            }
            System.out.println("Configured Capacity: " + capacity + " (" + StringUtils.byteDesc(capacity) + ")");
            System.out.println("Present Capacity: " + presentCapacity + " (" + StringUtils.byteDesc(presentCapacity) + ")");
            System.out.println("DFS Remaining: " + remaining + " (" + StringUtils.byteDesc(remaining) + ")");
            System.out.println("DFS Used: " + used + " (" + StringUtils.byteDesc(used) + ")");
            System.out.println("DFS Used%: " + StringUtils.limitDecimalTo2(1.0 * (double)used / (double)presentCapacity * 100.0) + "%");
            System.out.println("Under replicated blocks: " + dfs.getUnderReplicatedBlocksCount());
            System.out.println("Blocks with corrupt replicas: " + dfs.getCorruptBlocksCount());
            System.out.println("Missing blocks: " + dfs.getMissingBlocksCount());
            System.out.println();
            System.out.println("-------------------------------------------------");
            DatanodeInfo[] live = dfs.getClient().datanodeReport(FSConstants.DatanodeReportType.LIVE);
            DatanodeInfo[] dead = dfs.getClient().datanodeReport(FSConstants.DatanodeReportType.DEAD);
            System.out.println("Datanodes available: " + live.length + " (" + (live.length + dead.length) + " total, " + dead.length + " dead)\n");
            for (DatanodeInfo dn : live) {
                System.out.println(dn.getDatanodeReport());
                System.out.println();
            }
            for (DatanodeInfo dn : dead) {
                System.out.println(dn.getDatanodeReport());
                System.out.println();
            }
        }
    }

    public void setSafeMode(String[] argv, int idx) throws IOException {
        FSConstants.SafeModeAction action;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + this.fs.getUri());
            return;
        }
        if (idx != argv.length - 1) {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        Boolean waitExitSafe = false;
        if ("leave".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_LEAVE;
        } else if ("enter".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_ENTER;
        } else if ("get".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_GET;
        } else if ("wait".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_GET;
            waitExitSafe = true;
        } else {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        boolean inSafeMode = dfs.setSafeMode(action);
        if (waitExitSafe.booleanValue()) {
            while (inSafeMode) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Wait Interrupted");
                }
                inSafeMode = dfs.setSafeMode(action);
            }
        }
        System.out.println("Safe mode is " + (inSafeMode ? "ON" : "OFF"));
    }

    public int saveNamespace() throws IOException {
        int exitCode = -1;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + this.fs.getUri());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.saveNamespace();
        exitCode = 0;
        return exitCode;
    }

    public int refreshNodes() throws IOException {
        int exitCode = -1;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + this.fs.getUri());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.refreshNodes();
        exitCode = 0;
        return exitCode;
    }

    private void printHelp(String cmd) {
        String summary = "hadoop dfsadmin is the command to execute DFS administrative commands.\nThe full syntax is: \n\nhadoop dfsadmin [-report] [-safemode <enter | leave | get | wait>]\n\t[-saveNamespace]\n\t[-refreshNodes]\n\t[-setQuota <quota> <dirname>...<dirname>]\n\t[-clrQuota <dirname>...<dirname>]\n\t[-setSpaceQuota <quota> <dirname>...<dirname>]\n\t[-clrSpaceQuota <dirname>...<dirname>]\n\t[-refreshServiceAcl]\n\t[-refreshUserToGroupsMappings]\n\t[refreshSuperUserGroupsConfiguration]\n\t[-help [cmd]]\n";
        String report = "-report: \tReports basic filesystem information and statistics.\n";
        String safemode = "-safemode <enter|leave|get|wait>:  Safe mode maintenance command.\n\t\tSafe mode is a Namenode state in which it\n\t\t\t1.  does not accept changes to the name space (read-only)\n\t\t\t2.  does not replicate or delete blocks.\n\t\tSafe mode is entered automatically at Namenode startup, and\n\t\tleaves safe mode automatically when the configured minimum\n\t\tpercentage of blocks satisfies the minimum replication\n\t\tcondition.  Safe mode can also be entered manually, but then\n\t\tit can only be turned off manually as well.\n";
        String saveNamespace = "-saveNamespace:\tSave current namespace into storage directories and reset edits log.\n\t\tRequires superuser permissions and safe mode.\n";
        String refreshNodes = "-refreshNodes: \tUpdates the set of hosts allowed to connect to namenode.\n\n\t\tRe-reads the config file to update values defined by \n\t\tdfs.hosts and dfs.host.exclude and reads the \n\t\tentires (hostnames) in those files.\n\n\t\tEach entry not defined in dfs.hosts but in \n\t\tdfs.hosts.exclude is decommissioned. Each entry defined \n\t\tin dfs.hosts and also in dfs.host.exclude is stopped from \n\t\tdecommissioning if it has aleady been marked for decommission.\n\t\tEntires not present in both the lists are decommissioned.\n";
        String finalizeUpgrade = "-finalizeUpgrade: Finalize upgrade of HDFS.\n\t\tDatanodes delete their previous version working directories,\n\t\tfollowed by Namenode doing the same.\n\t\tThis completes the upgrade process.\n";
        String upgradeProgress = "-upgradeProgress <status|details|force>: \n\t\trequest current distributed upgrade status, \n\t\ta detailed status or force the upgrade to proceed.\n";
        String metaSave = "-metasave <filename>: \tSave Namenode's primary data structures\n\t\tto <filename> in the directory specified by hadoop.log.dir property.\n\t\t<filename> will contain one line for each of the following\n\t\t\t1. Datanodes heart beating with Namenode\n\t\t\t2. Blocks waiting to be replicated\n\t\t\t3. Blocks currrently being replicated\n\t\t\t4. Blocks waiting to be deleted\n";
        String refreshServiceAcl = "-refreshServiceAcl: Reload the service-level authorization policy file\n\t\tNamenode will reload the authorization policy file.\n";
        String refreshUserToGroupsMappings = "-refreshUserToGroupsMappings: Refresh user-to-groups mappings\n";
        String refreshSuperUserGroupsConfiguration = "-refreshSuperUserGroupsConfiguration: Refresh superuser proxy groups mappings\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("report".equals(cmd)) {
            System.out.println(report);
        } else if ("safemode".equals(cmd)) {
            System.out.println(safemode);
        } else if ("saveNamespace".equals(cmd)) {
            System.out.println(saveNamespace);
        } else if ("refreshNodes".equals(cmd)) {
            System.out.println(refreshNodes);
        } else if ("finalizeUpgrade".equals(cmd)) {
            System.out.println(finalizeUpgrade);
        } else if ("upgradeProgress".equals(cmd)) {
            System.out.println(upgradeProgress);
        } else if ("metasave".equals(cmd)) {
            System.out.println(metaSave);
        } else if (SetQuotaCommand.matches("-" + cmd)) {
            System.out.println("-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n");
        } else if (ClearQuotaCommand.matches("-" + cmd)) {
            System.out.println("-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
        } else if (SetSpaceQuotaCommand.matches("-" + cmd)) {
            System.out.println("-setSpaceQuota <quota> <dirname>...<dirname>: Set the disk space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be speciefied with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n");
        } else if (ClearSpaceQuotaCommand.matches("-" + cmd)) {
            System.out.println("-clrSpaceQuota <dirname>...<dirname>: Clear the disk space quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
        } else if ("refreshServiceAcl".equals(cmd)) {
            System.out.println(refreshServiceAcl);
        } else if ("refreshUserToGroupsMappings".equals(cmd)) {
            System.out.println(refreshUserToGroupsMappings);
        } else if ("refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.out.println(refreshSuperUserGroupsConfiguration);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(report);
            System.out.println(safemode);
            System.out.println(saveNamespace);
            System.out.println(refreshNodes);
            System.out.println(finalizeUpgrade);
            System.out.println(upgradeProgress);
            System.out.println(metaSave);
            System.out.println("-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n");
            System.out.println("-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
            System.out.println("-setSpaceQuota <quota> <dirname>...<dirname>: Set the disk space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be speciefied with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n");
            System.out.println("-clrSpaceQuota <dirname>...<dirname>: Clear the disk space quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
            System.out.println(refreshServiceAcl);
            System.out.println(refreshUserToGroupsMappings);
            System.out.println(refreshSuperUserGroupsConfiguration);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    public int finalizeUpgrade() throws IOException {
        int exitCode = -1;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.out.println("FileSystem is " + this.fs.getUri());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.finalizeUpgrade();
        exitCode = 0;
        return exitCode;
    }

    public int upgradeProgress(String[] argv, int idx) throws IOException {
        FSConstants.UpgradeAction action;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.out.println("FileSystem is " + this.fs.getUri());
            return -1;
        }
        if (idx != argv.length - 1) {
            DFSAdmin.printUsage("-upgradeProgress");
            return -1;
        }
        if ("status".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.UpgradeAction.GET_STATUS;
        } else if ("details".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.UpgradeAction.DETAILED_STATUS;
        } else if ("force".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.UpgradeAction.FORCE_PROCEED;
        } else {
            DFSAdmin.printUsage("-upgradeProgress");
            return -1;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        UpgradeStatusReport status = dfs.distributedUpgradeProgress(action);
        String statusText = status == null ? "There are no upgrades in progress." : status.getStatusText(action == FSConstants.UpgradeAction.DETAILED_STATUS);
        System.out.println(statusText);
        return 0;
    }

    public int metaSave(String[] argv, int idx) throws IOException {
        String pathname = argv[idx];
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.metaSave(pathname);
        System.out.println("Created file " + pathname + " on server " + dfs.getUri());
        return 0;
    }

    private static UserGroupInformation getUGI() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    public int refreshServiceAcl() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshAuthorizationPolicyProtocol refreshProtocol = (RefreshAuthorizationPolicyProtocol)RPC.getProxy(RefreshAuthorizationPolicyProtocol.class, 1L, NameNode.getAddress(conf), DFSAdmin.getUGI(), conf, NetUtils.getSocketFactory(conf, RefreshAuthorizationPolicyProtocol.class));
        refreshProtocol.refreshServiceAcl();
        return 0;
    }

    public int refreshUserToGroupsMappings() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = (RefreshUserMappingsProtocol)RPC.getProxy(RefreshUserMappingsProtocol.class, 1L, NameNode.getAddress(conf), DFSAdmin.getUGI(), conf, NetUtils.getSocketFactory(conf, RefreshUserMappingsProtocol.class));
        refreshProtocol.refreshUserToGroupsMappings();
        return 0;
    }

    public int refreshSuperUserGroupsConfiguration() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = (RefreshUserMappingsProtocol)RPC.getProxy(RefreshUserMappingsProtocol.class, 1L, NameNode.getAddress(conf), DFSAdmin.getUGI(), conf, NetUtils.getSocketFactory(conf, RefreshUserMappingsProtocol.class));
        refreshProtocol.refreshSuperUserGroupsConfiguration();
        return 0;
    }

    private static void printUsage(String cmd) {
        if ("-report".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-report]");
        } else if ("-safemode".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-safemode enter | leave | get | wait]");
        } else if ("-saveNamespace".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-saveNamespace]");
        } else if ("-refreshNodes".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshNodes]");
        } else if ("-finalizeUpgrade".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-finalizeUpgrade]");
        } else if ("-upgradeProgress".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-upgradeProgress status | details | force]");
        } else if ("-metasave".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-metasave filename]");
        } else if (SetQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-setQuota <quota> <dirname>...<dirname>]");
        } else if (ClearQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-clrQuota <dirname>...<dirname>]");
        } else if (SetSpaceQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-setSpaceQuota <quota> <dirname>...<dirname>]");
        } else if (ClearSpaceQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-clrSpaceQuota <dirname>...<dirname>]");
        } else if ("-refreshServiceAcl".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshServiceAcl]");
        } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshUserToGroupsMappings]");
        } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshSuperUserGroupsConfiguration]");
        } else {
            System.err.println("Usage: java DFSAdmin");
            System.err.println("           [-report]");
            System.err.println("           [-safemode enter | leave | get | wait]");
            System.err.println("           [-saveNamespace]");
            System.err.println("           [-refreshNodes]");
            System.err.println("           [-finalizeUpgrade]");
            System.err.println("           [-upgradeProgress status | details | force]");
            System.err.println("           [-metasave filename]");
            System.err.println("           [-refreshServiceAcl]");
            System.err.println("           [-refreshUserToGroupsMappings]");
            System.err.println("           [-refreshSuperUserGroupsConfiguration]");
            System.err.println("           [-setQuota <quota> <dirname>...<dirname>]");
            System.err.println("           [-clrQuota <dirname>...<dirname>]");
            System.err.println("           [-setSpaceQuota <quota> <dirname>...<dirname>]");
            System.err.println("           [-clrSpaceQuota <dirname>...<dirname>]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage(System.err);
        }
    }

    @Override
    public int run(String[] argv) throws Exception {
        String cmd;
        if (argv.length < 1) {
            DFSAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if ("-safemode".equals(cmd = argv[i++])) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-report".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-saveNamespace".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshNodes".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-finalizeUpgrade".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-upgradeProgress".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-metasave".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshServiceAcl".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshUserToGroupsMappings".equals(cmd) && argv.length != 1) {
            DFSAdmin.printUsage(cmd);
            return exitCode;
        }
        try {
            this.init();
        }
        catch (RPC.VersionMismatch v) {
            System.err.println("Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            System.err.println("Bad connection to DFS... command aborted.");
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-report".equals(cmd)) {
                this.report();
            } else if ("-safemode".equals(cmd)) {
                this.setSafeMode(argv, i);
            } else if ("-saveNamespace".equals(cmd)) {
                exitCode = this.saveNamespace();
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-finalizeUpgrade".equals(cmd)) {
                exitCode = this.finalizeUpgrade();
            } else if ("-upgradeProgress".equals(cmd)) {
                exitCode = this.upgradeProgress(argv, i);
            } else if ("-metasave".equals(cmd)) {
                exitCode = this.metaSave(argv, i);
            } else if (ClearQuotaCommand.matches(cmd)) {
                exitCode = new ClearQuotaCommand(argv, i, this.fs).runAll();
            } else if (SetQuotaCommand.matches(cmd)) {
                exitCode = new SetQuotaCommand(argv, i, this.fs).runAll();
            } else if (ClearSpaceQuotaCommand.matches(cmd)) {
                exitCode = new ClearSpaceQuotaCommand(argv, i, this.fs).runAll();
            } else if (SetSpaceQuotaCommand.matches(cmd)) {
                exitCode = new SetSpaceQuotaCommand(argv, i, this.fs).runAll();
            } else if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshServiceAcl();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-help".equals(cmd)) {
                if (i < argv.length) {
                    this.printHelp(argv[i]);
                } else {
                    this.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                DFSAdmin.printUsage("");
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            DFSAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        return exitCode;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new DFSAdmin(), argv);
        System.exit(res);
    }

    private static class SetSpaceQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "setSpaceQuota";
        private static final String USAGE = "-setSpaceQuota <quota> <dirname>...<dirname>";
        private static final String DESCRIPTION = "-setSpaceQuota <quota> <dirname>...<dirname>: Set the disk space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be speciefied with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n";
        private long quota;

        SetSpaceQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(NAME, 2, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            String str = parameters.remove(0).trim();
            this.quota = StringUtils.TraditionalBinaryPrefix.string2long(str);
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-setSpaceQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, Long.MAX_VALUE, this.quota);
        }
    }

    private static class ClearSpaceQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "clrSpaceQuota";
        private static final String USAGE = "-clrSpaceQuota <dirname>...<dirname>";
        private static final String DESCRIPTION = "-clrSpaceQuota <dirname>...<dirname>: Clear the disk space quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.";

        ClearSpaceQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(NAME, 1, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-clrSpaceQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, Long.MAX_VALUE, -1L);
        }
    }

    private static class SetQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "setQuota";
        private static final String USAGE = "-setQuota <quota> <dirname>...<dirname>";
        private static final String DESCRIPTION = "-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n";
        private final long quota;

        SetQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(NAME, 2, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.quota = Long.parseLong(parameters.remove(0));
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-setQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, this.quota, Long.MAX_VALUE);
        }
    }

    private static class ClearQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "clrQuota";
        private static final String USAGE = "-clrQuota <dirname>...<dirname>";
        private static final String DESCRIPTION = "-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.";

        ClearQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(NAME, 1, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-clrQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, -1L, Long.MAX_VALUE);
        }
    }

    private static abstract class DFSAdminCommand
    extends Command {
        final DistributedFileSystem dfs;

        public DFSAdminCommand(FileSystem fs) {
            super(fs.getConf());
            if (!(fs instanceof DistributedFileSystem)) {
                throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not a distributed file system");
            }
            this.dfs = (DistributedFileSystem)fs;
        }
    }
}

