/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.CoarseToFineNBestParser;
import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.MultiThreadedParserWrapper;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.io.PTBLineLexer;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.ui.TreeJPanel;
import edu.berkeley.nlp.util.Numberer;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BerkeleyParser {
    static TreeJPanel tjp;
    static JFrame frame;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        optParser = new OptionParser(Options.class);
        opts = (Options)optParser.parse(args, true);
        threshold = 1.0;
        inFileName = opts.grFileName;
        pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        grammar = pData.getGrammar();
        lexicon = pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        if (opts.chinese) {
            Corpus.myTreebank = Corpus.TreeBankType.CHINESE;
        }
        parser = null;
        parser = opts.kbest == 1 ? new CoarseToFineMaxRuleParser(grammar, lexicon, threshold, -1, opts.viterbi, opts.substates, opts.scores, opts.accurate, opts.variational, true, true) : new CoarseToFineNBestParser(grammar, lexicon, opts.kbest, threshold, -1, opts.viterbi, opts.substates, opts.scores, opts.accurate, opts.variational, false, true);
        parser.binarization = pData.getBinarization();
        if (opts.render) {
            BerkeleyParser.tjp = new TreeJPanel();
        }
        m_parser = null;
        if (opts.nThreads > 1) {
            System.err.println("Parsing with " + opts.nThreads + " threads in parallel.");
            m_parser = new MultiThreadedParserWrapper(parser, opts.nThreads);
        }
        try {
            block24: {
                inputData = opts.inputFile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.inputFile), "UTF-8"));
                outputData = opts.outputFile == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputFile), "UTF-8"), true);
                tokenizer = null;
                if (opts.tokenize) {
                    tokenizer = new PTBLineLexer();
                }
                line = "";
                while ((line = inputData.readLine()) != null) {
                    sentence = null;
                    posTags = null;
                    if (opts.goldPOS) {
                        sentence = new ArrayList<E>();
                        posTags = new ArrayList<String>();
                        tmp = Arrays.asList(line.split("\t"));
                        if (tmp.size() == 0) continue;
                        sentence.add(tmp.get(0));
                        tags = tmp.get(1).split("-");
                        posTags.add(tags[0]);
                        while (!(line = inputData.readLine()).equals("")) {
                            tmp = Arrays.asList(line.split("\t"));
                            if (tmp.size() != 0) {
                                sentence.add(tmp.get(0));
                                tags = tmp.get(1).split("-");
                                posTags.add(tags[0]);
                                continue;
                            }
                            break;
                        }
                    } else {
                        sentence = opts.tokenize == false ? Arrays.asList(line.split("\\s+")) : tokenizer.tokenizeLine(line);
                    }
                    if (sentence.size() > opts.maxLength) {
                        outputData.write("(())\n");
                        if (opts.kbest > 1) {
                            outputData.write("\n");
                        }
                        System.err.println("Skipping sentence with " + sentence.size() + " words since it is too long.");
                        continue;
                    }
                    if (opts.nThreads > 1) {
                        m_parser.parseThisSentence(sentence);
                        while (m_parser.hasNext()) {
                            parsedTrees = m_parser.getNext();
                            BerkeleyParser.outputTrees(parsedTrees, outputData, parser, opts, "");
                        }
                        continue;
                    }
                    parsedTrees = null;
                    if (opts.kbest > 1) {
                        parsedTrees = parser.getKBestConstrainedParses(sentence, posTags, opts.kbest);
                        if (parsedTrees.size() == 0) {
                            parsedTrees.add(new Tree<String>("ROOT"));
                        }
                    } else {
                        parsedTrees = new ArrayList<Tree<String>>();
                        parsedTree = parser.getBestConstrainedParse(sentence, posTags, null);
                        if (opts.goldPOS && parsedTree.getChildren().isEmpty()) {
                            parsedTree = parser.getBestConstrainedParse(sentence, null, null);
                        }
                        parsedTrees.add(parsedTree);
                    }
                    BerkeleyParser.outputTrees(parsedTrees, outputData, parser, opts, line);
                }
                if (opts.nThreads <= 1) break block24;
                ** GOTO lbl90
                {
                    parsedTrees = m_parser.getNext();
                    BerkeleyParser.outputTrees(parsedTrees, outputData, parser, opts, line);
                    do {
                        if (m_parser.hasNext()) continue block5;
lbl90:
                        // 2 sources

                    } while (!m_parser.isDone());
                }
            }
            if (opts.dumpPosteriors) {
                fileName = String.valueOf(opts.grFileName) + ".posteriors";
                parser.dumpPosteriors(fileName, -1);
            }
            outputData.flush();
            outputData.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private static void outputTrees(List<Tree<String>> parseTrees, PrintWriter outputData, CoarseToFineMaxRuleParser parser, Options opts, String line) {
        for (Tree<String> parsedTree : parseTrees) {
            double treeLL;
            if (opts.sentence_likelihood) {
                double allLL = parsedTree.getChildren().isEmpty() ? Double.NEGATIVE_INFINITY : parser.getLogLikelihood();
                outputData.write(String.valueOf(allLL) + "\t");
            }
            if (opts.tree_likelihood) {
                treeLL = parsedTree.getChildren().isEmpty() ? Double.NEGATIVE_INFINITY : parser.getLogLikelihood(parsedTree);
                outputData.write(String.valueOf(treeLL) + "\t");
            }
            if (!opts.binarize) {
                parsedTree = TreeAnnotations.unAnnotateTree(parsedTree);
            }
            if (opts.confidence) {
                treeLL = parsedTree.getChildren().isEmpty() ? Double.NEGATIVE_INFINITY : parser.getConfidence(parsedTree);
                outputData.write(String.valueOf(treeLL) + "\t");
            } else if (opts.modelScore) {
                double score = parsedTree.getChildren().isEmpty() ? Double.NEGATIVE_INFINITY : parser.getModelScore(parsedTree);
                outputData.write(String.format("%.8f\t", score));
            }
            if (!parsedTree.getChildren().isEmpty()) {
                String treeString = parsedTree.getChildren().get(0).toString();
                outputData.write("( " + treeString + " )\n");
            } else {
                outputData.write("(())\n");
            }
            if (!opts.render) continue;
            try {
                BerkeleyParser.writeTreeToImage(parsedTree, String.valueOf(line.replaceAll("[^a-zA-Z]", "")) + ".png");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (opts.dumpPosteriors) {
            int blockSize = 50;
            String fileName = String.valueOf(opts.grFileName) + ".posteriors";
            parser.dumpPosteriors(fileName, blockSize);
        }
        if (opts.kbest > 1) {
            outputData.write("\n");
        }
        outputData.flush();
    }

    public static void writeTreeToImage(Tree<String> tree, String fileName) throws IOException {
        tjp.setTree(tree);
        BufferedImage bi = new BufferedImage(tjp.width(), tjp.height(), 2);
        int t = tjp.height();
        Graphics2D g2 = bi.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(1, 1.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, tjp.width(), tjp.height());
        g2.fill(rect);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        tjp.paintComponent(g2);
        g2.dispose();
        ImageIO.write((RenderedImage)bi, "png", new File(fileName));
    }

    public static class Options {
        @Option(name="-gr", required=true, usage="Grammarfile (Required)\n")
        public String grFileName;
        @Option(name="-tokenize", usage="Tokenize input first. (Default: false=text is already tokenized)")
        public boolean tokenize = false;
        @Option(name="-viterbi", usage="Compute viterbi derivation instead of max-rule tree (Default: max-rule)")
        public boolean viterbi;
        @Option(name="-binarize", usage="Output binarized trees. (Default: false)")
        public boolean binarize;
        @Option(name="-scores", usage="Output inside scores (only for binarized viterbi trees). (Default: false)")
        public boolean scores;
        @Option(name="-substates", usage="Output subcategories (only for binarized viterbi trees). (Default: false)")
        public boolean substates;
        @Option(name="-accurate", usage="Set thresholds for accuracy. (Default: set thresholds for efficiency)")
        public boolean accurate;
        @Option(name="-modelScore", usage="Output effective model score (max rule score for max rule parser) (Default: false)")
        public boolean modelScore;
        @Option(name="-confidence", usage="Output confidence measure, i.e. likelihood of tree given words: P(T|w) (Default: false)")
        public boolean confidence;
        @Option(name="-sentence_likelihood", usage="Output sentence likelihood, i.e. summing out all parse trees: P(w) (Default: false)")
        public boolean sentence_likelihood;
        @Option(name="-tree_likelihood", usage="Output joint likelihood of tree and words: P(t,w) (Default: false)")
        public boolean tree_likelihood;
        @Option(name="-variational", usage="Use variational rule score approximation instead of max-rule (Default: false)")
        public boolean variational;
        @Option(name="-render", usage="Write rendered tree to image file. (Default: false)")
        public boolean render;
        @Option(name="-chinese", usage="Enable some Chinese specific features in the lexicon.")
        public boolean chinese;
        @Option(name="-inputFile", usage="Read input from this file instead of reading it from STDIN.")
        public String inputFile;
        @Option(name="-maxLength", usage="Maximum sentence length (Default = 200).")
        public int maxLength = 200;
        @Option(name="-nThreads", usage="Parse in parallel using n threads (Default: 1).")
        public int nThreads = 1;
        @Option(name="-kbest", usage="Output the k best parse max-rule trees (Default: 1).")
        public int kbest = 1;
        @Option(name="-outputFile", usage="Store output in this file instead of printing it to STDOUT.")
        public String outputFile;
        @Option(name="-useGoldPOS", usage="Read data in CoNLL format, including gold part of speech tags.")
        public boolean goldPOS;
        @Option(name="-dumpPosteriors", usage="Dump max-rule posteriors to disk.")
        public boolean dumpPosteriors;
    }
}

