/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ScalingTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseToFineMaxRuleDerivationParser
extends CoarseToFineMaxRuleParser {
    protected double[][][][] maxcScore;
    protected double[][][][] maxsScore;
    protected int[][][][] maxcSplit;
    protected int[][][][] maxcChild;
    protected int[][][][] maxcChildSub;
    protected int[][][][] maxcLeftChild;
    protected int[][][][] maxcRightChild;
    protected int[][][][] maxcLeftChildSub;
    protected int[][][][] maxcRightChildSub;

    public CoarseToFineMaxRuleDerivationParser(Grammar gr, Lexicon lex, double unaryPenalty, int endL, boolean viterbi, boolean sub, boolean score, boolean accurate, boolean variational, boolean useGoldPOS, boolean initializeCascade) {
        super(gr, lex, unaryPenalty, endL, viterbi, sub, score, accurate, variational, useGoldPOS, initializeCascade);
    }

    @Override
    void doConstrainedMaxCScores(List<String> sentence, Grammar grammar, Lexicon lexicon, boolean scale) {
        this.numSubStatesArray = grammar.numSubStates;
        this.maxcScore = new double[this.length][this.length + 1][this.numStates][];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates][];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates][];
        this.maxcChildSub = new int[this.length][this.length + 1][this.numStates][];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates][];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates][];
        this.maxcLeftChildSub = new int[this.length][this.length + 1][this.numStates][];
        this.maxcRightChildSub = new int[this.length][this.length + 1][this.numStates][];
        double initVal = Double.NEGATIVE_INFINITY;
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                int state = 0;
                while (state < this.numSubStatesArray.length) {
                    if (this.allowedStates[start][end][state]) {
                        this.maxcSplit[start][end][state] = new int[this.numSubStatesArray[state]];
                        this.maxcChild[start][end][state] = new int[this.numSubStatesArray[state]];
                        this.maxcChildSub[start][end][state] = new int[this.numSubStatesArray[state]];
                        this.maxcLeftChild[start][end][state] = new int[this.numSubStatesArray[state]];
                        this.maxcRightChild[start][end][state] = new int[this.numSubStatesArray[state]];
                        this.maxcLeftChildSub[start][end][state] = new int[this.numSubStatesArray[state]];
                        this.maxcRightChildSub[start][end][state] = new int[this.numSubStatesArray[state]];
                        this.maxcScore[start][end][state] = new double[this.numSubStatesArray[state]];
                        Arrays.fill(this.maxcSplit[start][end][state], -1);
                        Arrays.fill(this.maxcChild[start][end][state], -1);
                        Arrays.fill(this.maxcChildSub[start][end][state], -1);
                        Arrays.fill(this.maxcLeftChild[start][end][state], -1);
                        Arrays.fill(this.maxcRightChild[start][end][state], -1);
                        Arrays.fill(this.maxcLeftChildSub[start][end][state], -1);
                        Arrays.fill(this.maxcRightChildSub[start][end][state], -1);
                        Arrays.fill(this.maxcScore[start][end][state], initVal);
                    }
                    ++state;
                }
                ++end;
            }
            ++start;
        }
        double logNormalizer = this.iScore[0][this.length][0][0];
        int diff = 1;
        while (diff <= this.length) {
            int start2 = 0;
            while (start2 < this.length - diff + 1) {
                int end = start2 + diff;
                if (diff > 1) {
                    int pState = 0;
                    while (pState < this.numSubStatesArray.length) {
                        if (this.allowedStates[start2][end][pState]) {
                            BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                            int nParentStates = this.numSubStatesArray[pState];
                            int i = 0;
                            while (i < parentRules.length) {
                                boolean iPossibleL;
                                BinaryRule r = parentRules[i];
                                short lState = r.leftChildState;
                                short rState = r.rightChildState;
                                int narrowR = this.narrowRExtent[start2][lState];
                                boolean bl = iPossibleL = narrowR < end;
                                if (iPossibleL) {
                                    boolean iPossibleR;
                                    int narrowL = this.narrowLExtent[end][rState];
                                    boolean bl2 = iPossibleR = narrowL >= narrowR;
                                    if (iPossibleR) {
                                        int min;
                                        int min1 = narrowR;
                                        int min2 = this.wideLExtent[end][rState];
                                        int n = min = min1 > min2 ? min1 : min2;
                                        if (min <= narrowL) {
                                            int max;
                                            int max1 = this.wideRExtent[start2][lState];
                                            int max2 = narrowL;
                                            int n2 = max = max1 < max2 ? max1 : max2;
                                            if (min <= max) {
                                                double[][][] scores = r.getScores2();
                                                int nLeftChildStates = this.numSubStatesArray[lState];
                                                int nRightChildStates = this.numSubStatesArray[rState];
                                                int split = min;
                                                while (split <= max) {
                                                    double ruleScore = 0.0;
                                                    if (this.allowedStates[start2][split][lState] && this.allowedStates[split][end][rState]) {
                                                        double scalingFactor = 0.0;
                                                        if (scale) {
                                                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start2][end][pState] + this.iScale[start2][split][lState] + this.iScale[split][end][rState] - this.iScale[0][this.length][0]));
                                                        }
                                                        int lp = 0;
                                                        while (lp < nLeftChildStates) {
                                                            double lIS = this.iScore[start2][split][lState][lp];
                                                            if (lIS != 0.0) {
                                                                int rp = 0;
                                                                while (rp < nRightChildStates) {
                                                                    double rIS;
                                                                    if (scores[lp][rp] != null && (rIS = this.iScore[split][end][rState][rp]) != 0.0) {
                                                                        double leftChildScore = this.maxcScore[start2][split][lState][lp];
                                                                        double rightChildScore = this.maxcScore[split][end][rState][rp];
                                                                        if (leftChildScore != initVal && rightChildScore != initVal) {
                                                                            double gScore = leftChildScore + scalingFactor + rightChildScore;
                                                                            int np = 0;
                                                                            while (np < nParentStates) {
                                                                                double ruleS;
                                                                                double scoreToBeat;
                                                                                double pOS = this.oScore[start2][end][pState][np];
                                                                                if (pOS != 0.0 && !(gScore < (scoreToBeat = this.maxcScore[start2][end][pState][np])) && (ruleS = scores[lp][rp][np]) != 0.0 && (ruleScore = pOS * ruleS * lIS * rIS / logNormalizer) != 0.0) {
                                                                                    if (this.doVariational) {
                                                                                        ruleScore /= this.oScore[start2][end][pState][np] / logNormalizer * this.iScore[start2][end][pState][np];
                                                                                    }
                                                                                    if ((ruleScore = gScore + Math.log(ruleScore)) > scoreToBeat) {
                                                                                        this.maxcScore[start2][end][pState][np] = ruleScore;
                                                                                        this.maxcSplit[start2][end][pState][np] = split;
                                                                                        this.maxcLeftChild[start2][end][pState][np] = lState;
                                                                                        this.maxcRightChild[start2][end][pState][np] = rState;
                                                                                        this.maxcLeftChildSub[start2][end][pState][np] = lp;
                                                                                        this.maxcRightChildSub[start2][end][pState][np] = rp;
                                                                                    }
                                                                                }
                                                                                ++np;
                                                                            }
                                                                        }
                                                                    }
                                                                    ++rp;
                                                                }
                                                            }
                                                            ++lp;
                                                        }
                                                    }
                                                    ++split;
                                                }
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        ++pState;
                    }
                } else {
                    int tag = 0;
                    while (tag < this.numSubStatesArray.length) {
                        if (this.allowedStates[start2][end][tag]) {
                            int nTagStates = this.numSubStatesArray[tag];
                            String word = sentence.get(start2);
                            if (!grammar.isGrammarTag(tag)) {
                                double[] lexiconScoreArray = lexicon.score(word, (short)tag, start2, false, false);
                                double lexiconScores = 0.0;
                                int tp = 0;
                                while (tp < nTagStates) {
                                    double pOS = this.oScore[start2][end][tag][tp];
                                    double ruleS = lexiconScoreArray[tp];
                                    lexiconScores = pOS * ruleS / logNormalizer;
                                    double scalingFactor = 0.0;
                                    if (this.doVariational) {
                                        lexiconScores = 1.0;
                                    } else if (scale) {
                                        scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start2][end][tag] - this.iScale[0][this.length][0]));
                                    }
                                    this.maxcScore[start2][end][tag][tp] = Math.log(lexiconScores) + scalingFactor;
                                    ++tp;
                                }
                            }
                        }
                        ++tag;
                    }
                }
                double[][] maxcScoreStartEnd = new double[this.numStates][];
                int i = 0;
                while (i < this.numStates) {
                    if (this.allowedStates[start2][end][i]) {
                        maxcScoreStartEnd[i] = new double[this.numSubStatesArray[i]];
                        int j = 0;
                        while (j < this.numSubStatesArray[i]) {
                            maxcScoreStartEnd[i][j] = this.maxcScore[start2][end][i][j];
                            ++j;
                        }
                    }
                    ++i;
                }
                double[][] ruleScores = null;
                if (this.doVariational) {
                    ruleScores = new double[this.numStates][this.numStates];
                }
                boolean foundOne = false;
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (this.allowedStates[start2][end][pState]) {
                        int nParentStates = this.numSubStatesArray[pState];
                        UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                        if (this.doVariational) {
                            unaries = grammar.getUnaryRulesByParent(pState).toArray(new UnaryRule[0]);
                        }
                        int r = 0;
                        while (r < unaries.length) {
                            UnaryRule ur = unaries[r];
                            short cState = ur.childState;
                            if (pState != cState && this.iScore[start2][end][cState] != null) {
                                double scalingFactor = 0.0;
                                if (scale) {
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start2][end][pState] + this.iScale[start2][end][cState] - this.iScale[0][this.length][0]));
                                }
                                double[][] scores = ur.getScores2();
                                int nChildStates = this.numSubStatesArray[cState];
                                double ruleScore = 0.0;
                                int cp = 0;
                                while (cp < nChildStates) {
                                    double childScore;
                                    double cIS = this.iScore[start2][end][cState][cp];
                                    if (cIS != 0.0 && (childScore = this.maxcScore[start2][end][cState][cp]) != initVal && scores[cp] != null) {
                                        int np = 0;
                                        while (np < nParentStates) {
                                            double ruleS;
                                            double gScore;
                                            double pOS = this.oScore[start2][end][pState][np];
                                            if (!(pOS < 0.0) && !((gScore = scalingFactor + childScore) < maxcScoreStartEnd[pState][np]) && (ruleS = scores[cp][np]) != 0.0) {
                                                ruleScore = pOS * ruleS * cIS / logNormalizer;
                                                foundOne = true;
                                                if (ruleScore != 0.0) {
                                                    if (this.doVariational) {
                                                        ruleScore /= this.oScore[start2][end][pState][np] / logNormalizer * this.iScore[start2][end][pState][np];
                                                    }
                                                    if ((ruleScore = gScore + Math.log(ruleScore)) > maxcScoreStartEnd[pState][np]) {
                                                        maxcScoreStartEnd[pState][np] = ruleScore;
                                                        this.maxcChild[start2][end][pState][np] = cState;
                                                        this.maxcChildSub[start2][end][pState][np] = cp;
                                                    }
                                                }
                                            }
                                            ++np;
                                        }
                                    }
                                    ++cp;
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                this.maxcScore[start2][end] = maxcScoreStartEnd;
                ++start2;
            }
            ++diff;
        }
    }

    @Override
    public Tree<String> extractBestMaxRuleParse(int start, int end, List<String> sentence) {
        return this.extractBestMaxRuleParse1(start, end, 0, 0, sentence);
    }

    public Tree<String> extractBestMaxRuleParse1(int start, int end, int state, int substate, List<String> sentence) {
        int cState = this.maxcChild[start][end][state][substate];
        int cSubState = this.maxcChildSub[start][end][state][substate];
        if (cState == -1) {
            return this.extractBestMaxRuleParse2(start, end, state, substate, sentence);
        }
        ArrayList child = new ArrayList();
        child.add(this.extractBestMaxRuleParse2(start, end, cState, cSubState, sentence));
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        ++this.totalUsedUnaries;
        int intermediateNode = this.grammar.getUnaryIntermediate((short)state, (short)cState);
        if (intermediateNode > 0) {
            ArrayList restoredChild = new ArrayList();
            ++this.nTimesRestoredUnaries;
            String stateStr2 = (String)this.tagNumberer.object(intermediateNode);
            if (stateStr2.endsWith("^g")) {
                stateStr2 = stateStr2.substring(0, stateStr2.length() - 2);
            }
            restoredChild.add(new Tree<String>(stateStr2, child));
            return new Tree<String>(stateStr, restoredChild);
        }
        return new Tree<String>(stateStr, child);
    }

    public Tree<String> extractBestMaxRuleParse2(int start, int end, int state, int substate, List<String> sentence) {
        boolean posLevel;
        ArrayList children = new ArrayList();
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        boolean bl = posLevel = end - start == 1;
        if (posLevel) {
            if (this.grammar.isGrammarTag(state)) {
                ArrayList childs = new ArrayList();
                childs.add(new Tree<String>(sentence.get(start)));
                String stateStr2 = (String)this.tagNumberer.object(this.maxcChild[start][end][state][substate]);
                children.add(new Tree<String>(stateStr2, childs));
            } else {
                children.add(new Tree<String>(sentence.get(start)));
            }
        } else {
            int split = this.maxcSplit[start][end][state][substate];
            if (split == -1) {
                System.err.println("Warning: no symbol can generate the span from " + start + " to " + end + ".");
                System.err.println("The score is " + this.maxcScore[start][end][state] + " and the state is supposed to be " + stateStr);
                System.err.println("The insideScores are " + Arrays.toString(this.iScore[start][end][state]) + " and the outsideScores are " + Arrays.toString(this.oScore[start][end][state]));
                System.err.println("The maxcScore is " + this.maxcScore[start][end][state]);
                return new Tree<String>("ROOT");
            }
            int lState = this.maxcLeftChild[start][end][state][substate];
            int lSubState = this.maxcLeftChildSub[start][end][state][substate];
            int rState = this.maxcRightChild[start][end][state][substate];
            int rSubState = this.maxcRightChildSub[start][end][state][substate];
            Tree<String> leftChildTree = this.extractBestMaxRuleParse1(start, split, lState, lSubState, sentence);
            Tree<String> rightChildTree = this.extractBestMaxRuleParse1(split, end, rState, rSubState, sentence);
            children.add(leftChildTree);
            children.add(rightChildTree);
        }
        return new Tree<String>(stateStr, children);
    }
}

