/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConstrainedArrayParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Posterior;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseToFineMaxRuleParser
extends ConstrainedArrayParser {
    boolean[][][][] allowedSubStates;
    boolean[][][] allowedStates;
    boolean[][] vAllowedStates;
    double[][] spanMass;
    Grammar[] grammarCascade;
    Lexicon[] lexiconCascade;
    int[][][] lChildMap;
    int[][][] rChildMap;
    int startLevel;
    int endLevel;
    protected short[] numSubStatesArray;
    double[] maxThresholds;
    double logLikelihood;
    Tree<String> bestTree;
    boolean isBaseline;
    protected final boolean doVariational;
    protected double[][][] viScore;
    protected double[][][] voScore;
    protected double savedScore;
    protected double[][][] maxcScore;
    protected double[][][] maxsScore;
    protected int[][][] maxcSplit;
    protected int[][][] maxcChild;
    protected int[][][] maxcLeftChild;
    protected int[][][] maxcRightChild;
    protected double unaryPenalty;
    int nLevels;
    final boolean[] grammarTags;
    final boolean viterbiParse;
    final boolean outputSub;
    final boolean outputScore;
    Numberer wordNumberer = Numberer.getGlobalNumberer("words");
    final boolean accurate;
    final boolean useGoldPOS;
    double[] unscaledScoresToAdd;
    ArrayParser llParser;
    List<Posterior> posteriorsToDump;
    int level;
    int nThBlock = 0;

    public CoarseToFineMaxRuleParser(Grammar gr, Lexicon lex, double unaryPenalty, int endL, boolean viterbi, boolean sub, boolean score, boolean accurate, boolean variational, boolean useGoldPOS, boolean initializeCascade) {
        this.grammar = gr;
        this.lexicon = lex;
        this.numSubStatesArray = (short[])gr.numSubStates.clone();
        this.unaryPenalty = unaryPenalty;
        this.accurate = accurate;
        this.viterbiParse = viterbi;
        this.outputScore = score;
        this.outputSub = sub;
        this.doVariational = variational;
        this.useGoldPOS = useGoldPOS;
        this.totalUsedUnaries = 0L;
        this.nTimesRestoredUnaries = 0;
        this.nRules = 0L;
        this.nRulesInf = 0L;
        this.tagNumberer = Numberer.getGlobalNumberer("tags");
        this.numStates = gr.numStates;
        this.maxNSubStates = this.maxSubStates(gr);
        this.idxC = new int[this.maxNSubStates];
        this.scoresToAdd = new double[this.maxNSubStates];
        this.unscaledScoresToAdd = new double[this.maxNSubStates];
        this.grammarTags = new boolean[this.numStates];
        int i = 0;
        while (i < this.numStates) {
            this.grammarTags[i] = gr.isGrammarTag(i);
            ++i;
        }
        this.grammarTags[0] = true;
        this.nLevels = (int)Math.ceil(Math.log(ArrayUtil.max(this.numSubStatesArray)) / Math.log(2.0));
        this.grammarCascade = new Grammar[this.nLevels + 3];
        this.lexiconCascade = new Lexicon[this.nLevels + 3];
        this.maxThresholds = new double[this.nLevels + 3];
        this.lChildMap = new int[this.nLevels][][];
        this.rChildMap = new int[this.nLevels][][];
        this.startLevel = -1;
        this.endLevel = endL;
        if (this.endLevel == -1) {
            this.endLevel = this.nLevels;
        }
        boolean bl = this.isBaseline = this.endLevel == 0;
        if (initializeCascade) {
            this.initCascade(gr, lex);
        }
    }

    public void initCascade(CoarseToFineMaxRuleParser otherParser) {
        this.lChildMap = otherParser.lChildMap;
        this.rChildMap = otherParser.rChildMap;
        this.grammarCascade = otherParser.grammarCascade;
        this.lexiconCascade = otherParser.lexiconCascade;
        this.binarization = otherParser.binarization;
    }

    public void initCascade(Grammar gr, Lexicon lex) {
        int level = this.startLevel;
        while (level <= this.endLevel + 1) {
            if (level != -1) {
                Grammar tmpGrammar = null;
                Lexicon tmpLexicon = null;
                if (level == this.endLevel) {
                    tmpGrammar = gr.copyGrammar(false);
                    tmpLexicon = lex.copyLexicon();
                } else if (level > this.endLevel) {
                    tmpGrammar = gr;
                    tmpLexicon = lex;
                } else {
                    int[][] fromMapping = gr.computeMapping(1);
                    int[][] toSubstateMapping = gr.computeSubstateMapping(level);
                    int[][] toMapping = gr.computeToMapping(level, toSubstateMapping);
                    int[][] curLChildMap = new int[toSubstateMapping.length][];
                    int[][] curRChildMap = new int[toSubstateMapping.length][];
                    double[] condProbs = gr.computeConditionalProbabilities(fromMapping, toMapping);
                    tmpGrammar = level == -1 ? gr.projectTo0LevelGrammar(condProbs, fromMapping, toMapping) : gr.projectGrammar(condProbs, fromMapping, toSubstateMapping);
                    tmpLexicon = lex.projectLexicon(condProbs, fromMapping, toSubstateMapping);
                    if (level > 0) {
                        this.lChildMap[level + this.startLevel] = curLChildMap;
                        this.rChildMap[level + this.startLevel] = curRChildMap;
                        gr.computeReverseSubstateMapping(level, curLChildMap, curRChildMap);
                    }
                }
                tmpGrammar.splitRules();
                double filter = 1.0E-4;
                if (level >= 0 && level < this.endLevel) {
                    tmpGrammar.removeUnlikelyRules(filter, 1.0);
                    tmpLexicon.removeUnlikelyTags(filter, 1.0);
                } else if (level >= this.endLevel) {
                    tmpGrammar.removeUnlikelyRules(1.0E-10, 1.0);
                    tmpLexicon.removeUnlikelyTags(1.0E-10, 1.0);
                }
                if (level <= this.endLevel || this.viterbiParse) {
                    tmpGrammar.logarithmMode();
                    tmpLexicon.logarithmMode();
                }
                this.grammarCascade[level - this.startLevel] = tmpGrammar;
                this.lexiconCascade[level - this.startLevel] = tmpLexicon;
            }
            ++level;
        }
    }

    void doConstrainedInsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        if (!viterbi && logScores) {
            throw new Error("This would require logAdds and is slow. Exponentiate the scores instead.");
        }
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int np;
                int end = start + diff;
                int pState = 0;
                while (pState < this.numStates) {
                    if (diff != 1 && this.allowedStates[start][end][pState]) {
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        int nParentStates = this.numSubStatesArray[pState];
                        Arrays.fill(this.scoresToAdd, initVal);
                        boolean somethingChanged = false;
                        int numRules = parentRules.length;
                        int i = 0;
                        while (i < numRules) {
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (iPossibleL) {
                                boolean iPossibleR;
                                int narrowL = this.narrowLExtent[end][rState];
                                boolean bl2 = iPossibleR = narrowL >= narrowR;
                                if (iPossibleR) {
                                    int min;
                                    int min1 = narrowR;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (min <= narrowL) {
                                        int max;
                                        int max1 = this.wideRExtent[start][lState];
                                        int max2 = narrowL;
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (min <= max) {
                                            double[][][] scores = r.getScores2();
                                            int nLeftChildStates = this.numSubStatesArray[lState];
                                            int nRightChildStates = this.numSubStatesArray[rState];
                                            int split = min;
                                            while (split <= max) {
                                                if (this.allowedStates[start][split][lState] && this.allowedStates[split][end][rState]) {
                                                    int lp = 0;
                                                    while (lp < nLeftChildStates) {
                                                        double lS = this.iScore[start][split][lState][lp];
                                                        if (lS != initVal) {
                                                            int rp = 0;
                                                            while (rp < nRightChildStates) {
                                                                double rS;
                                                                if (scores[lp][rp] != null && (rS = this.iScore[split][end][rState][rp]) != initVal) {
                                                                    int np2 = 0;
                                                                    while (np2 < nParentStates) {
                                                                        double pS;
                                                                        if (this.allowedSubStates[start][end][pState][np2] && (pS = scores[lp][rp][np2]) != initVal) {
                                                                            double thisRound;
                                                                            double d = thisRound = logScores ? pS + lS + rS : pS * lS * rS;
                                                                            if (viterbi) {
                                                                                this.scoresToAdd[np2] = Math.max(thisRound, this.scoresToAdd[np2]);
                                                                            } else {
                                                                                int n3 = np2;
                                                                                this.scoresToAdd[n3] = this.scoresToAdd[n3] + thisRound;
                                                                            }
                                                                            somethingChanged = true;
                                                                        }
                                                                        ++np2;
                                                                    }
                                                                }
                                                                ++rp;
                                                            }
                                                        }
                                                        ++lp;
                                                    }
                                                }
                                                ++split;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        if (somethingChanged) {
                            np = 0;
                            while (np < nParentStates) {
                                if (this.scoresToAdd[np] > initVal) {
                                    this.iScore[start][end][pState][np] = this.scoresToAdd[np];
                                }
                                ++np;
                            }
                            if (start > this.narrowLExtent[end][pState]) {
                                this.narrowLExtent[end][pState] = start;
                                this.wideLExtent[end][pState] = start;
                            } else if (start < this.wideLExtent[end][pState]) {
                                this.wideLExtent[end][pState] = start;
                            }
                            if (end < this.narrowRExtent[start][pState]) {
                                this.narrowRExtent[start][pState] = end;
                                this.wideRExtent[start][pState] = end;
                            } else if (end > this.wideRExtent[start][pState]) {
                                this.wideRExtent[start][pState] = end;
                            }
                        }
                    }
                    ++pState;
                }
                double[][] scoresAfterUnaries = new double[this.numStates][];
                boolean somethingChanged = false;
                int pState2 = 0;
                while (pState2 < this.numStates) {
                    if (this.allowedStates[start][end][pState2]) {
                        UnaryRule[] unaries = null;
                        unaries = viterbi ? grammar.getClosedViterbiUnaryRulesByParent(pState2) : grammar.getClosedSumUnaryRulesByParent(pState2);
                        int nParentStates = this.numSubStatesArray[pState2];
                        boolean firstTime = true;
                        int numRules = unaries.length;
                        int r = 0;
                        while (r < numRules) {
                            UnaryRule ur = unaries[r];
                            short cState = ur.childState;
                            if (pState2 != cState && this.iScore[start][end][cState] != null) {
                                double[][] scores = ur.getScores2();
                                int nChildStates = this.numSubStatesArray[cState];
                                int cp = 0;
                                while (cp < nChildStates) {
                                    if (scores[cp] != null) {
                                        int np3 = 0;
                                        while (np3 < nParentStates) {
                                            double iS;
                                            double pS;
                                            if (this.allowedSubStates[start][end][pState2][np3] && (pS = scores[cp][np3]) != initVal && (iS = this.iScore[start][end][cState][cp]) != initVal) {
                                                double thisRound;
                                                if (firstTime) {
                                                    firstTime = false;
                                                    scoresAfterUnaries[pState2] = new double[nParentStates];
                                                    Arrays.fill(scoresAfterUnaries[pState2], initVal);
                                                }
                                                double d = thisRound = logScores ? iS + pS : iS * pS;
                                                if (viterbi) {
                                                    scoresAfterUnaries[pState2][np3] = Math.max(thisRound, scoresAfterUnaries[pState2][np3]);
                                                } else {
                                                    double[] dArray = scoresAfterUnaries[pState2];
                                                    int n = np3;
                                                    dArray[n] = dArray[n] + thisRound;
                                                }
                                                somethingChanged = true;
                                            }
                                            ++np3;
                                        }
                                    }
                                    ++cp;
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState2;
                }
                if (somethingChanged) {
                    pState2 = 0;
                    while (pState2 < this.numStates) {
                        int nParentStates = this.numSubStatesArray[pState2];
                        double[] thisCell = scoresAfterUnaries[pState2];
                        if (thisCell != null) {
                            np = 0;
                            while (np < nParentStates) {
                                if (thisCell[np] > initVal) {
                                    this.iScore[start][end][pState2][np] = viterbi ? Math.max(this.iScore[start][end][pState2][np], thisCell[np]) : this.iScore[start][end][pState2][np] + thisCell[np];
                                }
                                ++np;
                            }
                            if (start > this.narrowLExtent[end][pState2]) {
                                this.narrowLExtent[end][pState2] = start;
                                this.wideLExtent[end][pState2] = start;
                            } else if (start < this.wideLExtent[end][pState2]) {
                                this.wideLExtent[end][pState2] = start;
                            }
                            if (end < this.narrowRExtent[start][pState2]) {
                                this.narrowRExtent[start][pState2] = end;
                                this.wideRExtent[start][pState2] = end;
                            } else if (end > this.wideRExtent[start][pState2]) {
                                this.wideRExtent[start][pState2] = end;
                            }
                        }
                        ++pState2;
                    }
                }
                ++start;
            }
            ++diff;
        }
    }

    void doConstrainedOutsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        int diff = this.length;
        while (diff >= 1) {
            int start = 0;
            while (start + diff <= this.length) {
                int r;
                int numRules;
                int end = start + diff;
                double[][] scoresAfterUnaries = new double[this.numStates][];
                boolean somethingChanged = false;
                int cState = 0;
                while (cState < this.numStates) {
                    if ((diff <= 1 || grammar.isGrammarTag[cState]) && this.oScore[start][end][cState] != null) {
                        UnaryRule[] rules = null;
                        rules = viterbi ? grammar.getClosedViterbiUnaryRulesByChild(cState) : grammar.getClosedSumUnaryRulesByChild(cState);
                        int nChildStates = this.numSubStatesArray[cState];
                        numRules = rules.length;
                        r = 0;
                        while (r < numRules) {
                            UnaryRule ur = rules[r];
                            short pState = ur.parentState;
                            if (pState != cState && this.oScore[start][end][pState] != null) {
                                double[][] scores = ur.getScores2();
                                int nParentStates = this.numSubStatesArray[pState];
                                int cp = 0;
                                while (cp < nChildStates) {
                                    if (scores[cp] != null && this.allowedSubStates[start][end][cState][cp]) {
                                        int np = 0;
                                        while (np < nParentStates) {
                                            double oS;
                                            double pS = scores[cp][np];
                                            if (pS != initVal && (oS = this.oScore[start][end][pState][np]) != initVal) {
                                                double thisRound;
                                                double d = thisRound = logScores ? oS + pS : oS * pS;
                                                if (scoresAfterUnaries[cState] == null) {
                                                    scoresAfterUnaries[cState] = new double[this.numSubStatesArray[cState]];
                                                    if (viterbi) {
                                                        Arrays.fill(scoresAfterUnaries[cState], initVal);
                                                    }
                                                }
                                                if (viterbi) {
                                                    scoresAfterUnaries[cState][cp] = Math.max(thisRound, scoresAfterUnaries[cState][cp]);
                                                } else {
                                                    double[] dArray = scoresAfterUnaries[cState];
                                                    int n = cp;
                                                    dArray[n] = dArray[n] + thisRound;
                                                }
                                                somethingChanged = true;
                                            }
                                            ++np;
                                        }
                                    }
                                    ++cp;
                                }
                            }
                            ++r;
                        }
                    }
                    ++cState;
                }
                if (somethingChanged) {
                    cState = 0;
                    while (cState < this.numStates) {
                        double[] thisCell = scoresAfterUnaries[cState];
                        if (thisCell != null) {
                            int cp = 0;
                            while (cp < this.numSubStatesArray[cState]) {
                                if (thisCell[cp] > initVal) {
                                    if (viterbi) {
                                        this.oScore[start][end][cState][cp] = Math.max(this.oScore[start][end][cState][cp], thisCell[cp]);
                                    } else {
                                        double[] dArray = this.oScore[start][end][cState];
                                        int n = cp;
                                        dArray[n] = dArray[n] + thisCell[cp];
                                    }
                                }
                                ++cp;
                            }
                        }
                        ++cState;
                    }
                }
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    block46: {
                        if (this.oScore[start][end][pState] == null) break block46;
                        int nParentChildStates = this.numSubStatesArray[pState];
                        BinaryRule[] rules = grammar.splitRulesWithP(pState);
                        numRules = rules.length;
                        r = 0;
                        while (r < numRules) {
                            block47: {
                                int min;
                                int max;
                                short rState;
                                short lState;
                                BinaryRule br;
                                block48: {
                                    int max1;
                                    br = rules[r];
                                    lState = br.leftChildState;
                                    int min1 = this.narrowRExtent[start][lState];
                                    if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) break block47;
                                    max = max1;
                                    min = min1;
                                    if (max - min <= 2) break block48;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (max1 < min) break block47;
                                    int max2 = this.wideRExtent[start][lState];
                                    int n2 = max = max1 < max2 ? max1 : max2;
                                    if (max < min) break block47;
                                }
                                double[][][] scores = br.getScores2();
                                int nLeftChildStates = this.numSubStatesArray[lState];
                                int nRightChildStates = this.numSubStatesArray[rState];
                                int split = min;
                                while (split <= max) {
                                    if (this.oScore[start][split][lState] != null && this.oScore[split][end][rState] != null) {
                                        double[] rightScores = new double[nRightChildStates];
                                        if (viterbi) {
                                            Arrays.fill(rightScores, initVal);
                                        }
                                        Arrays.fill(this.scoresToAdd, initVal);
                                        somethingChanged = false;
                                        int lp = 0;
                                        while (lp < nLeftChildStates) {
                                            double lS = this.iScore[start][split][lState][lp];
                                            if (lS != initVal) {
                                                int rp = 0;
                                                while (rp < nRightChildStates) {
                                                    double rS;
                                                    if (scores[lp][rp] != null && (rS = this.iScore[split][end][rState][rp]) != initVal) {
                                                        int np = 0;
                                                        while (np < nParentChildStates) {
                                                            double oS;
                                                            double pS = scores[lp][rp][np];
                                                            if (pS != initVal && (oS = this.oScore[start][end][pState][np]) != initVal) {
                                                                double thisRoundR;
                                                                double thisRoundL = logScores ? pS + rS + oS : pS * rS * oS;
                                                                double d = thisRoundR = logScores ? pS + lS + oS : pS * lS * oS;
                                                                if (viterbi) {
                                                                    this.scoresToAdd[lp] = Math.max(thisRoundL, this.scoresToAdd[lp]);
                                                                    rightScores[rp] = Math.max(thisRoundR, rightScores[rp]);
                                                                } else {
                                                                    int n = lp;
                                                                    this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                                                    int n3 = rp;
                                                                    rightScores[n3] = rightScores[n3] + thisRoundR;
                                                                }
                                                                somethingChanged = true;
                                                            }
                                                            ++np;
                                                        }
                                                    }
                                                    ++rp;
                                                }
                                            }
                                            ++lp;
                                        }
                                        if (somethingChanged) {
                                            int cp = 0;
                                            while (cp < nLeftChildStates) {
                                                if (this.scoresToAdd[cp] > initVal) {
                                                    if (viterbi) {
                                                        this.oScore[start][split][lState][cp] = Math.max(this.oScore[start][split][lState][cp], this.scoresToAdd[cp]);
                                                    } else {
                                                        double[] dArray = this.oScore[start][split][lState];
                                                        int n = cp;
                                                        dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                                    }
                                                }
                                                ++cp;
                                            }
                                            cp = 0;
                                            while (cp < nRightChildStates) {
                                                if (rightScores[cp] > initVal) {
                                                    if (viterbi) {
                                                        this.oScore[split][end][rState][cp] = Math.max(this.oScore[split][end][rState][cp], rightScores[cp]);
                                                    } else {
                                                        double[] dArray = this.oScore[split][end][rState];
                                                        int n = cp;
                                                        dArray[n] = dArray[n] + rightScores[cp];
                                                    }
                                                }
                                                ++cp;
                                            }
                                        }
                                    }
                                    ++split;
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                ++start;
            }
            --diff;
        }
    }

    void initializeChart(List<String> sentence, Lexicon lexicon, boolean noSubstates, boolean noSmoothing, List<String> posTags, boolean scale) {
        int start = 0;
        int end = start + 1;
        for (String word : sentence) {
            end = start + 1;
            int goldTag = -1;
            if (this.useGoldPOS && posTags != null) {
                goldTag = this.tagNumberer.number(posTags.get(start));
            }
            int tag = 0;
            while (tag < this.numSubStatesArray.length) {
                if (!(!noSubstates && !this.allowedStates[start][end][tag] || this.grammarTags[tag] || this.useGoldPOS && posTags != null && tag != goldTag)) {
                    this.narrowRExtent[start][tag] = end;
                    this.narrowLExtent[end][tag] = start;
                    this.wideRExtent[start][tag] = end;
                    this.wideLExtent[end][tag] = start;
                    double[] lexiconScores = lexicon.score(word, (short)tag, start, noSmoothing, false);
                    if (scale) {
                        this.iScale[start][end][tag] = 0;
                    }
                    int n = 0;
                    while (n < lexiconScores.length) {
                        if (noSubstates || this.allowedSubStates[start][end][tag][n]) {
                            double prob = lexiconScores[n];
                            if (noSubstates) {
                                this.viScore[start][end][tag] = prob;
                            } else {
                                this.iScore[start][end][tag][n] = prob;
                            }
                        }
                        n = (short)(n + 1);
                    }
                }
                ++tag;
            }
            ++start;
        }
    }

    protected void createArrays(boolean firstTime, int numStates, short[] numSubStatesArray, int level, double initVal, boolean justInit) {
        if (firstTime) {
            this.viScore = new double[this.length][this.length + 1][];
            this.voScore = new double[this.length][this.length + 1][];
            this.iScore = new double[this.length][this.length + 1][][];
            this.oScore = new double[this.length][this.length + 1][][];
            this.allowedSubStates = new boolean[this.length][this.length + 1][][];
            this.allowedStates = new boolean[this.length][this.length + 1][];
            this.vAllowedStates = new boolean[this.length][this.length + 1];
        }
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                if (firstTime) {
                    this.viScore[start][end] = new double[numStates];
                    this.voScore[start][end] = new double[numStates];
                    this.iScore[start][end] = new double[numStates][];
                    this.oScore[start][end] = new double[numStates][];
                    this.allowedSubStates[start][end] = new boolean[numStates][];
                    this.allowedStates[start][end] = (boolean[])this.grammarTags.clone();
                    this.vAllowedStates[start][end] = true;
                }
                int state = 0;
                while (state < numSubStatesArray.length) {
                    if (firstTime || this.allowedStates[start][end][state]) {
                        if (level < 1) {
                            this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                            this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        } else {
                            this.iScore[start][end][state] = new double[numSubStatesArray[state]];
                            this.oScore[start][end][state] = new double[numSubStatesArray[state]];
                            Arrays.fill(this.iScore[start][end][state], initVal);
                            Arrays.fill(this.oScore[start][end][state], initVal);
                            boolean[] newAllowedSubStates = new boolean[numSubStatesArray[state]];
                            if (this.allowedSubStates[start][end][state] == null) {
                                Arrays.fill(newAllowedSubStates, true);
                                this.allowedSubStates[start][end][state] = newAllowedSubStates;
                            } else if (!justInit) {
                                int[][] curLChildMap = this.lChildMap[level - 2];
                                int[][] curRChildMap = this.rChildMap[level - 2];
                                int i = 0;
                                while (i < this.allowedSubStates[start][end][state].length) {
                                    boolean val;
                                    newAllowedSubStates[curLChildMap[state][i]] = val = this.allowedSubStates[start][end][state][i];
                                    newAllowedSubStates[curRChildMap[state][i]] = val;
                                    ++i;
                                }
                                this.allowedSubStates[start][end][state] = newAllowedSubStates;
                            }
                        }
                    } else if (level < 1) {
                        this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                    } else {
                        this.iScore[start][end][state] = null;
                        this.oScore[start][end][state] = null;
                    }
                    ++state;
                }
                if (level > 0 && start == 0 && end == this.length && this.iScore[start][end][0] == null) {
                    System.out.println("ROOT does not span the entire tree!");
                }
                ++end;
            }
            ++start;
        }
        this.narrowRExtent = new int[this.length + 1][numStates];
        this.wideRExtent = new int[this.length + 1][numStates];
        this.narrowLExtent = new int[this.length + 1][numStates];
        this.wideLExtent = new int[this.length + 1][numStates];
        int loc = 0;
        while (loc <= this.length) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
            ++loc;
        }
        this.iScale = null;
        this.oScale = null;
    }

    @Override
    protected void clearArrays() {
        this.oScore = null;
        this.iScore = null;
        this.voScore = null;
        this.viScore = null;
        this.allowedSubStates = null;
        this.vAllowedStates = null;
        this.wideLExtent = null;
        this.narrowLExtent = null;
        this.wideRExtent = null;
        this.narrowRExtent = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void pruneChart(double threshold, short[] numSubStatesArray, int level) {
        int startDiff;
        double sentenceProb;
        int totalStates = 0;
        int previouslyPossible = 0;
        int nowPossible = 0;
        double d = sentenceProb = level < 1 ? this.viScore[0][this.length][0] : this.iScore[0][this.length][0][0];
        if (level < 1) {
            totalStates = previouslyPossible = this.length;
            nowPossible = previouslyPossible;
        }
        int diff = startDiff = level < 0 ? 2 : 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                int lastState = level < 0 ? 1 : numSubStatesArray.length;
                int state = 0;
                while (state < lastState) {
                    block19: {
                        block23: {
                            double oS;
                            double iS;
                            block24: {
                                block22: {
                                    block21: {
                                        block20: {
                                            if (diff > 1 && !this.grammarTags[state]) break block19;
                                            if (state != 0) break block20;
                                            this.allowedStates[start][end][state] = true;
                                            break block19;
                                        }
                                        if (level != 0) break block21;
                                        if (this.vAllowedStates[start][end]) break block22;
                                        this.allowedStates[start][end][state] = false;
                                        ++totalStates;
                                        break block19;
                                    }
                                    if (level <= 0 || this.allowedStates[start][end][state]) break block22;
                                    totalStates += numSubStatesArray[state];
                                    break block19;
                                }
                                if (level >= 1) break block23;
                                ++totalStates;
                                ++previouslyPossible;
                                iS = this.viScore[start][end][state];
                                oS = this.voScore[start][end][state];
                                if (iS != Double.NEGATIVE_INFINITY && oS != Double.NEGATIVE_INFINITY) break block24;
                                if (level == 0) {
                                    this.allowedStates[start][end][state] = false;
                                    break block19;
                                } else {
                                    this.vAllowedStates[start][end] = false;
                                }
                                break block19;
                            }
                            double posterior = iS + oS - sentenceProb;
                            if (posterior > threshold) {
                                if (level == 0) {
                                    this.allowedStates[start][end][state] = true;
                                } else {
                                    this.vAllowedStates[start][end] = true;
                                }
                                ++nowPossible;
                                break block19;
                            } else if (level == 0) {
                                this.allowedStates[start][end][state] = false;
                                break block19;
                            } else {
                                this.vAllowedStates[start][end] = false;
                            }
                            break block19;
                        }
                        boolean nonePossible = true;
                        int substate = 0;
                        while (substate < numSubStatesArray[state]) {
                            ++totalStates;
                            if (this.allowedSubStates[start][end][state][substate]) {
                                ++previouslyPossible;
                                double iS = this.iScore[start][end][state][substate];
                                double oS = this.oScore[start][end][state][substate];
                                if (iS == Double.NEGATIVE_INFINITY || oS == Double.NEGATIVE_INFINITY) {
                                    this.allowedSubStates[start][end][state][substate] = false;
                                } else {
                                    double posterior = iS + oS - sentenceProb;
                                    if (posterior > threshold) {
                                        this.allowedSubStates[start][end][state][substate] = true;
                                        ++nowPossible;
                                        nonePossible = false;
                                    } else {
                                        this.allowedSubStates[start][end][state][substate] = false;
                                    }
                                }
                            }
                            ++substate;
                        }
                        if (nonePossible) {
                            this.allowedStates[start][end][state] = false;
                        }
                    }
                    ++state;
                }
                ++start;
            }
            ++diff;
        }
    }

    public void doPreParses(List<String> sentence, Tree<StateSet> tree, boolean noSmoothing, List<String> posTags) {
        boolean keepGoldAlive = tree != null;
        this.clearArrays();
        this.length = (short)sentence.size();
        double score = 0.0;
        Grammar curGrammar = null;
        Lexicon curLexicon = null;
        double[] accurateThresholds = new double[]{-8.0, -12.0, -12.0, -11.0, -12.0, -12.0, -14.0};
        double[] fastThresholds = new double[]{-8.0, -9.75, -10.0, -9.6, -9.66, -8.01, -7.4, -10.0};
        double[] pruningThreshold = null;
        pruningThreshold = this.accurate ? accurateThresholds : fastThresholds;
        this.level = this.startLevel;
        while (this.level <= this.endLevel) {
            if (this.level != -1 && (this.isBaseline || this.level != this.endLevel)) {
                curGrammar = this.grammarCascade[this.level - this.startLevel];
                curLexicon = this.lexiconCascade[this.level - this.startLevel];
                this.createArrays(this.level == 0, curGrammar.numStates, curGrammar.numSubStates, this.level, Double.NEGATIVE_INFINITY, false);
                this.initializeChart(sentence, curLexicon, this.level < 1, noSmoothing, posTags, false);
                boolean viterbi = true;
                boolean logScores = true;
                if (this.level < 1) {
                    this.doConstrainedViterbiInsideScores(curGrammar, this.level == this.startLevel);
                    score = this.viScore[0][this.length][0];
                } else {
                    this.doConstrainedInsideScores(curGrammar, true, true);
                    score = this.iScore[0][this.length][0][0];
                }
                if (score != Double.NEGATIVE_INFINITY) {
                    if (this.level < 1) {
                        this.voScore[0][this.length][0] = 0.0;
                        this.doConstrainedViterbiOutsideScores(curGrammar, this.level == this.startLevel);
                    } else {
                        this.oScore[0][this.length][0][0] = 0.0;
                        this.doConstrainedOutsideScores(curGrammar, true, true);
                    }
                    this.pruneChart(pruningThreshold[this.level + 1], curGrammar.numSubStates, this.level);
                    if (keepGoldAlive) {
                        this.ensureGoldTreeSurvives(tree, this.level);
                    }
                }
            }
            ++this.level;
        }
    }

    protected void ensureGoldTreeSurvives(Tree<StateSet> tree, int level) {
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (child.isLeaf()) continue;
            this.ensureGoldTreeSurvives(child, level);
        }
        StateSet node = tree.getLabel();
        short state = node.getState();
        if (level < 0) {
            this.vAllowedStates[node.from][node.to] = true;
        } else {
            short start = node.from;
            short end = node.to;
            this.allowedStates[start][end][state] = true;
            if (this.allowedSubStates[start][end] == null) {
                this.allowedSubStates[start][end] = new boolean[this.numSubStatesArray.length][];
            }
            this.allowedSubStates[start][end][state] = null;
        }
    }

    private void setGoldTreeCountsToOne(Tree<StateSet> tree) {
        StateSet node = tree.getLabel();
        short state = node.getState();
        this.iScore[node.from][node.to][state][0] = 1.0;
        this.oScore[node.from][node.to][state][0] = 1.0;
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (child.isLeaf()) continue;
            this.setGoldTreeCountsToOne(child);
        }
    }

    public void updateFinalGrammarAndLexicon(Grammar grammar, Lexicon lexicon) {
        this.grammarCascade[this.endLevel - this.startLevel + 1] = grammar;
        this.lexiconCascade[this.endLevel - this.startLevel + 1] = lexicon;
        Grammar tmpGrammar = grammar.copyGrammar(false);
        tmpGrammar.logarithmMode();
        Lexicon tmpLexicon = lexicon.copyLexicon();
        tmpLexicon.logarithmMode();
        this.grammarCascade[this.endLevel - this.startLevel] = null;
        this.lexiconCascade[this.endLevel - this.startLevel] = null;
    }

    @Override
    public Tree<String> getBestParse(List<String> sentence) {
        return this.getBestConstrainedParse(sentence, null, false);
    }

    public double getLogInsideScore() {
        return this.logLikelihood;
    }

    @Override
    public Tree<String> getBestConstrainedParse(List<String> sentence, List<String> posTags, boolean[][][][] allowedS) {
        if (allowedS == null) {
            return this.getBestConstrainedParse(sentence, posTags, false);
        }
        this.clearArrays();
        this.length = (short)sentence.size();
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        double initVal = this.viterbiParse ? Double.NEGATIVE_INFINITY : 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.allowedSubStates = allowedS;
        this.createArrays(true, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.setConstraints(allowedS);
        return this.getBestConstrainedParse(sentence, posTags, true);
    }

    private void setConstraints(boolean[][][][] allowedS) {
        this.allowedSubStates = allowedS;
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                int state = 0;
                while (state < this.numSubStatesArray.length) {
                    boolean onePossible = false;
                    if (this.allowedSubStates[start][end][state] != null) {
                        int substate = 0;
                        while (substate < this.numSubStatesArray[state]) {
                            if (this.allowedSubStates[start][end][state][substate]) {
                                onePossible = true;
                                break;
                            }
                            ++substate;
                        }
                        if (onePossible) {
                            this.allowedStates[start][end][state] = true;
                        }
                    }
                    ++state;
                }
                ++end;
            }
            ++start;
        }
    }

    public Tree<String> getBestConstrainedParse(List<String> sentence, List<String> posTags, boolean noPreparse) {
        if (sentence.size() == 0) {
            return new Tree<String>("ROOT");
        }
        if (!noPreparse) {
            this.doPreParses(sentence, null, false, posTags);
        }
        this.bestTree = new Tree<String>("ROOT");
        double score = 0.0;
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        double initVal = this.viterbiParse ? Double.NEGATIVE_INFINITY : 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(false, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.initializeChart(sentence, curLexicon, false, false, posTags, false);
        this.doConstrainedInsideScores(curGrammar, this.viterbiParse, this.viterbiParse);
        score = this.iScore[0][this.length][0][0];
        if (!this.viterbiParse) {
            score = Math.log(score);
        }
        this.logLikelihood = score;
        if (score != Double.NEGATIVE_INFINITY) {
            if (!this.viterbiParse) {
                this.oScore[0][this.length][0][0] = 1.0;
                this.doConstrainedOutsideScores(curGrammar, this.viterbiParse, false);
                this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, false);
            }
        } else {
            this.setupScaling();
            this.initializeChart(sentence, curLexicon, false, false, posTags, true);
            this.doScaledConstrainedInsideScores(curGrammar);
            score = this.iScore[0][this.length][0][0];
            if (!this.viterbiParse) {
                score = Math.log(score) + (double)(100 * this.iScale[0][this.length][0]);
            }
            this.oScore[0][this.length][0][0] = 1.0;
            this.oScale[0][this.length][0] = 0;
            this.doScaledConstrainedOutsideScores(curGrammar);
            this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, true);
            score = this.iScore[0][this.length][0][0];
            if (!this.viterbiParse) {
                score = Math.log(score);
            }
        }
        this.grammar = curGrammar;
        this.lexicon = curLexicon;
        if (score != Double.NEGATIVE_INFINITY) {
            if (this.viterbiParse) {
                this.bestTree = this.extractBestViterbiParse(0, 0, 0, this.length, sentence);
            } else {
                this.bestTree = this.extractBestMaxRuleParse(0, this.length, sentence);
                this.savedScore = this.maxcScore[0][this.length][0];
            }
        }
        return this.bestTree;
    }

    public double getModelScore(Tree<String> parsedTree) {
        if (this.viterbiParse) {
            return this.logLikelihood;
        }
        return this.savedScore;
    }

    public double getConfidence(Tree<String> tree) {
        if (this.logLikelihood == Double.NEGATIVE_INFINITY) {
            return this.logLikelihood;
        }
        double treeLL = this.getLogLikelihood(tree);
        double sentenceLL = this.getLogLikelihood();
        return treeLL - sentenceLL;
    }

    @Override
    public double getLogLikelihood(Tree<String> tree) {
        Iterator<Tree<StateSet>> iterator;
        if (this.logLikelihood == Double.NEGATIVE_INFINITY) {
            return this.logLikelihood;
        }
        if (this.viterbiParse) {
            return this.logLikelihood;
        }
        ArrayList<Tree<String>> resultList = new ArrayList<Tree<String>>();
        Tree<String> newTree = TreeAnnotations.processTree(tree, 1, 0, this.binarization, false);
        resultList.add(newTree);
        StateSetTreeList resultStateSetTrees = new StateSetTreeList(resultList, this.numSubStatesArray, false, this.tagNumberer);
        if (this.llParser == null) {
            this.llParser = new ArrayParser(this.grammar, this.lexicon);
        }
        if ((iterator = resultStateSetTrees.iterator()).hasNext()) {
            Tree<StateSet> t = iterator.next();
            this.llParser.doInsideScores(t, false, false, null);
            double ll = Math.log(t.getLabel().getIScore(0));
            return ll += (double)(100 * t.getLabel().getIScale());
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getLogLikelihood() {
        if (this.logLikelihood == Double.NEGATIVE_INFINITY) {
            return this.logLikelihood;
        }
        if (this.viterbiParse) {
            return this.logLikelihood;
        }
        this.logLikelihood = Math.log(this.iScore[0][this.length][0][0]);
        if (this.iScale != null) {
            this.logLikelihood += (double)(100 * this.iScale[0][this.length][0]);
        }
        return this.logLikelihood;
    }

    void doConstrainedMaxCScores(List<String> sentence, Grammar grammar, Lexicon lexicon, boolean scale) {
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = Double.NEGATIVE_INFINITY;
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        ArrayUtil.fill(this.maxcScore, Double.NEGATIVE_INFINITY);
        double logNormalizer = this.iScore[0][this.length][0][0];
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    int pState = 0;
                    while (pState < this.numSubStatesArray.length) {
                        if (this.allowedStates[start][end][pState]) {
                            BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                            int nParentStates = this.numSubStatesArray[pState];
                            int i = 0;
                            while (i < parentRules.length) {
                                boolean iPossibleL;
                                BinaryRule r = parentRules[i];
                                short lState = r.leftChildState;
                                short rState = r.rightChildState;
                                int narrowR = this.narrowRExtent[start][lState];
                                boolean bl = iPossibleL = narrowR < end;
                                if (iPossibleL) {
                                    boolean iPossibleR;
                                    int narrowL = this.narrowLExtent[end][rState];
                                    boolean bl2 = iPossibleR = narrowL >= narrowR;
                                    if (iPossibleR) {
                                        int min;
                                        int min1 = narrowR;
                                        int min2 = this.wideLExtent[end][rState];
                                        int n = min = min1 > min2 ? min1 : min2;
                                        if (min <= narrowL) {
                                            int max;
                                            int max1 = this.wideRExtent[start][lState];
                                            int max2 = narrowL;
                                            int n2 = max = max1 < max2 ? max1 : max2;
                                            if (min <= max) {
                                                double[][][] scores = r.getScores2();
                                                int nLeftChildStates = this.numSubStatesArray[lState];
                                                int nRightChildStates = this.numSubStatesArray[rState];
                                                double scoreToBeat = this.maxcScore[start][end][pState];
                                                int split = min;
                                                while (split <= max) {
                                                    double ruleScore = 0.0;
                                                    if (this.allowedStates[start][split][lState] && this.allowedStates[split][end][rState]) {
                                                        double leftChildScore = this.maxcScore[start][split][lState];
                                                        double rightChildScore = this.maxcScore[split][end][rState];
                                                        if (leftChildScore != initVal && rightChildScore != initVal) {
                                                            double gScore;
                                                            double scalingFactor = 0.0;
                                                            if (scale) {
                                                                scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - this.iScale[0][this.length][0]));
                                                            }
                                                            if (!((gScore = leftChildScore + scalingFactor + rightChildScore) < scoreToBeat)) {
                                                                int lp = 0;
                                                                while (lp < nLeftChildStates) {
                                                                    double lIS = this.iScore[start][split][lState][lp];
                                                                    if (lIS != 0.0) {
                                                                        int rp = 0;
                                                                        while (rp < nRightChildStates) {
                                                                            double rIS;
                                                                            if (scores[lp][rp] != null && (rIS = this.iScore[split][end][rState][rp]) != 0.0) {
                                                                                int np = 0;
                                                                                while (np < nParentStates) {
                                                                                    double ruleS;
                                                                                    double pOS = this.oScore[start][end][pState][np];
                                                                                    if (pOS != 0.0 && (ruleS = scores[lp][rp][np]) != 0.0) {
                                                                                        ruleScore += pOS * ruleS * lIS * rIS / logNormalizer;
                                                                                    }
                                                                                    ++np;
                                                                                }
                                                                            }
                                                                            ++rp;
                                                                        }
                                                                    }
                                                                    ++lp;
                                                                }
                                                                if (ruleScore != 0.0) {
                                                                    if (this.doVariational) {
                                                                        double norm = 0.0;
                                                                        int np = 0;
                                                                        while (np < nParentStates) {
                                                                            norm += this.oScore[start][end][pState][np] / logNormalizer * this.iScore[start][end][pState][np];
                                                                            ++np;
                                                                        }
                                                                        ruleScore /= norm;
                                                                    }
                                                                    if ((gScore += Math.log(ruleScore)) > scoreToBeat) {
                                                                        scoreToBeat = gScore;
                                                                        this.maxcScore[start][end][pState] = gScore;
                                                                        this.maxcSplit[start][end][pState] = split;
                                                                        this.maxcLeftChild[start][end][pState] = lState;
                                                                        this.maxcRightChild[start][end][pState] = rState;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    ++split;
                                                }
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        ++pState;
                    }
                } else {
                    int tag = 0;
                    while (tag < this.numSubStatesArray.length) {
                        if (this.allowedStates[start][end][tag]) {
                            int nTagStates = this.numSubStatesArray[tag];
                            String word = sentence.get(start);
                            if (!grammar.isGrammarTag(tag)) {
                                double[] lexiconScoreArray = lexicon.score(word, (short)tag, start, false, false);
                                double lexiconScores = 0.0;
                                int tp = 0;
                                while (tp < nTagStates) {
                                    double pOS = this.oScore[start][end][tag][tp];
                                    double ruleS = lexiconScoreArray[tp];
                                    lexiconScores += pOS * ruleS / logNormalizer;
                                    ++tp;
                                }
                                double scalingFactor = 0.0;
                                if (this.doVariational) {
                                    lexiconScores = 1.0;
                                } else if (scale) {
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][tag] - this.iScale[0][this.length][0]));
                                }
                                this.maxcScore[start][end][tag] = Math.log(lexiconScores) + scalingFactor;
                            }
                        }
                        ++tag;
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                int i = 0;
                while (i < this.numStates) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                    ++i;
                }
                double[][] ruleScores = null;
                if (this.doVariational) {
                    ruleScores = new double[this.numStates][this.numStates];
                }
                boolean foundOne = false;
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (this.allowedStates[start][end][pState]) {
                        int nParentStates = this.numSubStatesArray[pState];
                        UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                        if (this.doVariational) {
                            unaries = grammar.getUnaryRulesByParent(pState).toArray(new UnaryRule[0]);
                        }
                        int r = 0;
                        while (r < unaries.length) {
                            double childScore;
                            UnaryRule ur = unaries[r];
                            short cState = ur.childState;
                            if (pState != cState && this.iScore[start][end][cState] != null && (childScore = this.maxcScore[start][end][cState]) != initVal) {
                                double gScore;
                                double scalingFactor = 0.0;
                                if (scale) {
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - this.iScale[0][this.length][0]));
                                }
                                if (!((gScore = scalingFactor + childScore) < maxcScoreStartEnd[pState])) {
                                    double[][] scores = ur.getScores2();
                                    int nChildStates = this.numSubStatesArray[cState];
                                    double ruleScore = 0.0;
                                    int cp = 0;
                                    while (cp < nChildStates) {
                                        double cIS = this.iScore[start][end][cState][cp];
                                        if (cIS != 0.0 && scores[cp] != null) {
                                            int np = 0;
                                            while (np < nParentStates) {
                                                double ruleS;
                                                double pOS = this.oScore[start][end][pState][np];
                                                if (!(pOS < 0.0) && (ruleS = scores[cp][np]) != 0.0) {
                                                    ruleScore += pOS * ruleS * cIS / logNormalizer;
                                                    foundOne = true;
                                                }
                                                ++np;
                                            }
                                        }
                                        ++cp;
                                    }
                                    if (ruleScore != 0.0) {
                                        if (this.doVariational) {
                                            double norm = 0.0;
                                            int np = 0;
                                            while (np < nParentStates) {
                                                norm += this.oScore[start][end][pState][np] / logNormalizer * this.iScore[start][end][pState][np];
                                                ++np;
                                            }
                                            ruleScores[pState][cState] = Math.max(ruleScore /= norm, ruleScores[pState][cState]);
                                        }
                                        if ((gScore += Math.log(ruleScore)) > maxcScoreStartEnd[pState]) {
                                            maxcScoreStartEnd[pState] = gScore;
                                            this.maxcChild[start][end][pState] = cState;
                                        }
                                    }
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                if (foundOne && this.doVariational) {
                    maxcScoreStartEnd = this.closeVariationalRules(ruleScores, start, end);
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
                ++start;
            }
            ++diff;
        }
    }

    public Tree<String> extractBestMaxRuleParse(int start, int end, List<String> sentence) {
        return this.extractBestMaxRuleParse1(start, end, 0, sentence);
    }

    public Tree<String> extractBestMaxRuleParse1(int start, int end, int state, List<String> sentence) {
        int cState = this.maxcChild[start][end][state];
        if (cState == -1) {
            return this.extractBestMaxRuleParse2(start, end, state, sentence);
        }
        ArrayList child = new ArrayList();
        child.add(this.extractBestMaxRuleParse2(start, end, cState, sentence));
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        ++this.totalUsedUnaries;
        int intermediateNode = this.grammar.getUnaryIntermediate((short)state, (short)cState);
        if (intermediateNode > 0) {
            ArrayList restoredChild = new ArrayList();
            ++this.nTimesRestoredUnaries;
            String stateStr2 = (String)this.tagNumberer.object(intermediateNode);
            if (stateStr2.endsWith("^g")) {
                stateStr2 = stateStr2.substring(0, stateStr2.length() - 2);
            }
            restoredChild.add(new Tree<String>(stateStr2, child));
            return new Tree<String>(stateStr, restoredChild);
        }
        return new Tree<String>(stateStr, child);
    }

    public Tree<String> extractBestMaxRuleParse2(int start, int end, int state, List<String> sentence) {
        boolean posLevel;
        ArrayList children = new ArrayList();
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        boolean bl = posLevel = end - start == 1;
        if (posLevel) {
            if (this.grammar.isGrammarTag(state)) {
                ArrayList childs = new ArrayList();
                childs.add(new Tree<String>(sentence.get(start)));
                String stateStr2 = (String)this.tagNumberer.object(this.maxcChild[start][end][state]);
                children.add(new Tree<String>(stateStr2, childs));
            } else {
                children.add(new Tree<String>(sentence.get(start)));
            }
        } else {
            int split = this.maxcSplit[start][end][state];
            if (split == -1) {
                System.err.println("Warning: no symbol can generate the span from " + start + " to " + end + ".");
                System.err.println("The score is " + this.maxcScore[start][end][state] + " and the state is supposed to be " + stateStr);
                System.err.println("The insideScores are " + Arrays.toString(this.iScore[start][end][state]) + " and the outsideScores are " + Arrays.toString(this.oScore[start][end][state]));
                System.err.println("The maxcScore is " + this.maxcScore[start][end][state]);
                return new Tree<String>("ROOT");
            }
            int lState = this.maxcLeftChild[start][end][state];
            int rState = this.maxcRightChild[start][end][state];
            Tree<String> leftChildTree = this.extractBestMaxRuleParse1(start, split, lState, sentence);
            Tree<String> rightChildTree = this.extractBestMaxRuleParse1(split, end, rState, sentence);
            children.add(leftChildTree);
            children.add(rightChildTree);
        }
        return new Tree<String>(stateStr, children);
    }

    void doConstrainedViterbiInsideScores(Grammar grammar, boolean level0grammar) {
        this.numSubStatesArray = grammar.numSubStates;
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                int lastState = level0grammar ? 1 : this.numSubStatesArray.length;
                int pState = 0;
                while (pState < lastState) {
                    if (diff != 1 && this.grammarTags[pState] && this.vAllowedStates[start][end]) {
                        double oldIScore;
                        double bestIScore = oldIScore = this.viScore[start][end][pState];
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        int i = 0;
                        while (i < parentRules.length) {
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (iPossibleL) {
                                boolean iPossibleR;
                                int narrowL = this.narrowLExtent[end][rState];
                                boolean bl2 = iPossibleR = narrowL >= narrowR;
                                if (iPossibleR) {
                                    int min;
                                    int min1 = narrowR;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (min <= narrowL) {
                                        int max;
                                        int max1 = this.wideRExtent[start][lState];
                                        int max2 = narrowL;
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (min <= max) {
                                            double[][][] scores = r.getScores2();
                                            double pS = Double.NEGATIVE_INFINITY;
                                            if (scores[0][0] != null) {
                                                pS = scores[0][0][0];
                                            }
                                            if (pS != Double.NEGATIVE_INFINITY) {
                                                int split = min;
                                                while (split <= max) {
                                                    double tot;
                                                    double rS;
                                                    double lS;
                                                    if (this.vAllowedStates[start][split] && this.vAllowedStates[split][end] && (lS = this.viScore[start][split][lState]) != Double.NEGATIVE_INFINITY && (rS = this.viScore[split][end][rState]) != Double.NEGATIVE_INFINITY && (tot = pS + lS + rS) >= bestIScore) {
                                                        bestIScore = tot;
                                                    }
                                                    ++split;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        if (bestIScore > oldIScore) {
                            this.viScore[start][end][pState] = bestIScore;
                            if (oldIScore == Double.NEGATIVE_INFINITY) {
                                if (start > this.narrowLExtent[end][pState]) {
                                    this.narrowLExtent[end][pState] = start;
                                    this.wideLExtent[end][pState] = start;
                                } else if (start < this.wideLExtent[end][pState]) {
                                    this.wideLExtent[end][pState] = start;
                                }
                                if (end < this.narrowRExtent[start][pState]) {
                                    this.narrowRExtent[start][pState] = end;
                                    this.wideRExtent[start][pState] = end;
                                } else if (end > this.wideRExtent[start][pState]) {
                                    this.wideRExtent[start][pState] = end;
                                }
                            }
                        }
                    }
                    ++pState;
                }
                int lastStateU = level0grammar && diff > 1 ? 1 : this.numSubStatesArray.length;
                int pState2 = 0;
                while (pState2 < lastStateU) {
                    if (this.grammarTags[pState2] && (diff == 1 || this.vAllowedStates[start][end])) {
                        double oldIScore;
                        UnaryRule[] unaries = grammar.getClosedViterbiUnaryRulesByParent(pState2);
                        double bestIScore = oldIScore = this.viScore[start][end][pState2];
                        int r = 0;
                        while (r < unaries.length) {
                            double iS;
                            UnaryRule ur = unaries[r];
                            short cState = ur.childState;
                            if (pState2 != cState && (iS = this.viScore[start][end][cState]) != Double.NEGATIVE_INFINITY) {
                                double tot;
                                double[][] scores = ur.getScores2();
                                double pS = Double.NEGATIVE_INFINITY;
                                if (scores[0] != null) {
                                    pS = scores[0][0];
                                }
                                if (pS != Double.NEGATIVE_INFINITY && (tot = iS + pS) >= bestIScore) {
                                    bestIScore = tot;
                                }
                            }
                            ++r;
                        }
                        if (bestIScore > oldIScore) {
                            this.viScore[start][end][pState2] = bestIScore;
                            if (oldIScore == Double.NEGATIVE_INFINITY) {
                                if (start > this.narrowLExtent[end][pState2]) {
                                    this.narrowLExtent[end][pState2] = start;
                                    this.wideLExtent[end][pState2] = start;
                                } else if (start < this.wideLExtent[end][pState2]) {
                                    this.wideLExtent[end][pState2] = start;
                                }
                                if (end < this.narrowRExtent[start][pState2]) {
                                    this.narrowRExtent[start][pState2] = end;
                                    this.wideRExtent[start][pState2] = end;
                                } else if (end > this.wideRExtent[start][pState2]) {
                                    this.wideRExtent[start][pState2] = end;
                                }
                            }
                        }
                    }
                    ++pState2;
                }
                ++start;
            }
            ++diff;
        }
    }

    void doConstrainedViterbiOutsideScores(Grammar grammar, boolean level0grammar) {
        int diff = this.length;
        while (diff >= 1) {
            int start = 0;
            while (start + diff <= this.length) {
                int end = start + diff;
                int lastState = level0grammar ? 1 : this.numSubStatesArray.length;
                int cState = 0;
                while (cState < lastState) {
                    double iS;
                    if (this.vAllowedStates[start][end] && (iS = this.viScore[start][end][cState]) != Double.NEGATIVE_INFINITY) {
                        double oldOScore;
                        double bestOScore = oldOScore = this.voScore[start][end][cState];
                        UnaryRule[] rules = grammar.getClosedViterbiUnaryRulesByChild(cState);
                        int r = 0;
                        while (r < rules.length) {
                            double[][] scores;
                            double pS;
                            double tot;
                            double oS;
                            UnaryRule ur = rules[r];
                            short pState = ur.parentState;
                            if (cState != pState && (oS = this.voScore[start][end][pState]) != Double.NEGATIVE_INFINITY && (tot = oS + (pS = (scores = ur.getScores2())[0][0])) > bestOScore) {
                                bestOScore = tot;
                            }
                            ++r;
                        }
                        if (bestOScore > oldOScore) {
                            this.voScore[start][end][cState] = bestOScore;
                        }
                    }
                    ++cState;
                }
                int pState = 0;
                while (pState < lastState) {
                    block18: {
                        double oS;
                        if (!this.grammarTags[pState] || (oS = this.voScore[start][end][pState]) == Double.NEGATIVE_INFINITY) break block18;
                        BinaryRule[] rules = grammar.splitRulesWithP(pState);
                        int r = 0;
                        while (r < rules.length) {
                            block19: {
                                int min;
                                int max;
                                short rState;
                                short lState;
                                BinaryRule br;
                                block20: {
                                    int max1;
                                    br = rules[r];
                                    lState = br.leftChildState;
                                    int min1 = this.narrowRExtent[start][lState];
                                    if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) break block19;
                                    max = max1;
                                    min = min1;
                                    if (max - min <= 2) break block20;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (max1 < min) break block19;
                                    int max2 = this.wideRExtent[start][lState];
                                    int n2 = max = max1 < max2 ? max1 : max2;
                                    if (max < min) break block19;
                                }
                                double[][][] scores = br.getScores2();
                                double pS = Double.NEGATIVE_INFINITY;
                                if (scores[0][0] != null) {
                                    pS = scores[0][0][0];
                                }
                                if (pS != Double.NEGATIVE_INFINITY) {
                                    int split = min;
                                    while (split <= max) {
                                        double rS;
                                        double lS;
                                        if (this.vAllowedStates[start][split] && this.vAllowedStates[split][end] && (lS = this.viScore[start][split][lState]) != Double.NEGATIVE_INFINITY && (rS = this.viScore[split][end][rState]) != Double.NEGATIVE_INFINITY) {
                                            double totR;
                                            double totL = pS + rS + oS;
                                            if (totL > this.voScore[start][split][lState]) {
                                                this.voScore[start][split][lState] = totL;
                                            }
                                            if ((totR = pS + lS + oS) > this.voScore[split][end][rState]) {
                                                this.voScore[split][end][rState] = totR;
                                            }
                                        }
                                        ++split;
                                    }
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                ++start;
            }
            --diff;
        }
    }

    @Override
    public void printUnaryStats() {
        System.out.println("Touched " + this.touchedRules + " rules.");
        System.out.println("Used a total of " + this.totalUsedUnaries + " unaries.");
        System.out.println("Restored " + this.nTimesRestoredUnaries + " unary chains.");
    }

    public Tree<String> extractBestViterbiParse(int gState, int gp, int start, int end, List<String> sentence) {
        double bestScore = this.iScore[start][end][gState][gp];
        String goalStr = (String)this.tagNumberer.object(gState);
        if (goalStr.endsWith("^g")) {
            goalStr = goalStr.substring(0, goalStr.length() - 2);
        }
        if (this.outputSub) {
            goalStr = String.valueOf(goalStr) + "-" + gp;
        }
        if (this.outputScore) {
            goalStr = String.valueOf(goalStr) + " " + bestScore;
        }
        if (end - start == 1) {
            if (!this.grammarTags[gState]) {
                ArrayList child = new ArrayList();
                child.add(new Tree<String>(sentence.get(start)));
                return new Tree<String>(goalStr, child);
            }
            double veryBestScore = Double.NEGATIVE_INFINITY;
            int newIndex = -1;
            int newCp = -1;
            UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
            double childScore = bestScore;
            int r = 0;
            while (r < unaries.length) {
                UnaryRule ur = unaries[r];
                short cState = ur.childState;
                if (cState != gState && !this.grammarTags[cState] && this.allowedStates[start][end][cState]) {
                    double[][] scores = ur.getScores2();
                    int cp = 0;
                    while (cp < scores.length) {
                        double ruleScore;
                        if (scores[cp] != null && (ruleScore = this.iScore[start][end][cState][cp] + scores[cp][gp]) >= veryBestScore) {
                            childScore = this.iScore[start][end][cState][cp];
                            veryBestScore = ruleScore;
                            newIndex = cState;
                            newCp = cp;
                        }
                        ++cp;
                    }
                }
                ++r;
            }
            ArrayList child1 = new ArrayList();
            child1.add(new Tree<String>(sentence.get(start)));
            String goalStr1 = (String)this.tagNumberer.object(newIndex);
            if (this.outputSub) {
                goalStr1 = String.valueOf(goalStr1) + "-" + newCp;
            }
            if (this.outputScore) {
                goalStr1 = String.valueOf(goalStr1) + " " + childScore;
            }
            if (goalStr1 == null) {
                System.out.println("goalStr1==null with newIndex==" + newIndex + " goalStr==" + goalStr);
            }
            ArrayList child = new ArrayList();
            child.add(new Tree<String>(goalStr1, child1));
            return new Tree<String>(goalStr, child);
        }
        BinaryRule[] parentRules = this.grammar.splitRulesWithP(gState);
        int split = start + 1;
        while (split < end) {
            int i = 0;
            while (i < parentRules.length) {
                short rState;
                BinaryRule br = parentRules[i];
                short lState = br.leftChildState;
                if (this.iScore[start][split][lState] != null && this.iScore[split][end][rState = br.rightChildState] != null) {
                    double[][][] scores = br.getScores2();
                    int lp = 0;
                    while (lp < scores.length) {
                        int rp = 0;
                        while (rp < scores[lp].length) {
                            double score;
                            if (scores[lp][rp] != null && this.matches(score = scores[lp][rp][gp] + this.iScore[start][split][lState][lp] + this.iScore[split][end][rState][rp], bestScore)) {
                                Tree<String> leftChildTree = this.extractBestViterbiParse(lState, lp, start, split, sentence);
                                Tree<String> rightChildTree = this.extractBestViterbiParse(rState, rp, split, end, sentence);
                                ArrayList children = new ArrayList();
                                children.add(leftChildTree);
                                children.add(rightChildTree);
                                Tree<String> result = new Tree<String>(goalStr, children);
                                return result;
                            }
                            ++rp;
                        }
                        ++lp;
                    }
                }
                ++i;
            }
            ++split;
        }
        UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
        int r = 0;
        while (r < unaries.length) {
            UnaryRule ur = unaries[r];
            short cState = ur.childState;
            if (cState != gState && this.iScore[start][end][cState] != null) {
                double[][] scores = ur.getScores2();
                int cp = 0;
                while (cp < scores.length) {
                    double score;
                    if (scores[cp] != null && this.matches(score = scores[cp][gp] + this.iScore[start][end][cState][cp], bestScore)) {
                        Tree<String> childTree = this.extractBestViterbiParse(cState, cp, start, end, sentence);
                        ArrayList children = new ArrayList();
                        children.add(childTree);
                        Tree<String> result = new Tree<String>(goalStr, children);
                        return result;
                    }
                    ++cp;
                }
            }
            ++r;
        }
        System.err.println("Warning: could not find the optimal way to build state " + goalStr + " spanning from " + start + " to " + end + ".");
        return new Tree<String>("ROOT");
    }

    public double computeTightThresholds(List<String> sentence) {
        this.clearArrays();
        this.length = (short)sentence.size();
        double score = 0.0;
        Grammar curGrammar = null;
        Lexicon curLexicon = null;
        double[] pruningThreshold = new double[]{-16.0, -16.0, -16.0, -16.0, -16.0, -16.0, -16.0, -16.0};
        int level = this.startLevel;
        while (level < this.endLevel) {
            if (level != -1) {
                curGrammar = this.grammarCascade[level - this.startLevel];
                curLexicon = this.lexiconCascade[level - this.startLevel];
                this.createArrays(level == 0, curGrammar.numStates, curGrammar.numSubStates, level, Double.NEGATIVE_INFINITY, false);
                this.initializeChart(sentence, curLexicon, level < 1, false, null, false);
                boolean viterbi = true;
                boolean logScores = true;
                if (level < 1) {
                    this.doConstrainedViterbiInsideScores(curGrammar, level == this.startLevel);
                    score = this.viScore[0][this.length][0];
                } else {
                    this.doConstrainedInsideScores(curGrammar, true, true);
                    score = this.iScore[0][this.length][0][0];
                }
                if (score == Double.NEGATIVE_INFINITY) {
                    return -1.0;
                }
                System.out.println("\nFound a parse for sentence with length " + this.length + ". The LL is " + score + ".");
                if (level < 1) {
                    this.voScore[0][this.length][0] = 0.0;
                    this.doConstrainedViterbiOutsideScores(curGrammar, level == this.startLevel);
                } else {
                    this.oScore[0][this.length][0][0] = 0.0;
                    this.doConstrainedOutsideScores(curGrammar, true, true);
                }
                double minThresh = -10.0;
                if (level >= 0) {
                    minThresh = this.getTightestThrehold(0, this.length, 0, true, level);
                    if (minThresh == Double.NEGATIVE_INFINITY) {
                        System.out.println("Something is wrong.");
                        return -20.0;
                    }
                    System.out.println("Can set the threshold for level " + level + " to " + minThresh);
                    this.maxThresholds[level] = Math.min(this.maxThresholds[level], minThresh);
                }
                this.pruneChart(pruningThreshold[level + 1], curGrammar.numSubStates, level);
            }
            ++level;
        }
        return -1.0;
    }

    private double getTightestThrehold(int start, int end, int state, boolean canStartWithUnary, int level) {
        int cState;
        boolean posLevel;
        boolean bl = posLevel = end - start == 1;
        if (posLevel) {
            return -2.0;
        }
        double minChildren = Double.POSITIVE_INFINITY;
        if (canStartWithUnary && (cState = this.maxcChild[start][end][state]) != -1) {
            return this.getTightestThrehold(start, end, cState, false, level);
        }
        int split = this.maxcSplit[start][end][state];
        double lThresh = this.getTightestThrehold(start, split, this.maxcLeftChild[start][end][state], true, level);
        double rThresh = this.getTightestThrehold(split, end, this.maxcRightChild[start][end][state], true, level);
        minChildren = Math.min(lThresh, rThresh);
        double sentenceProb = level < 1 ? this.viScore[0][this.length][0] : this.iScore[0][this.length][0][0];
        double maxThreshold = Double.NEGATIVE_INFINITY;
        int substate = 0;
        while (substate < this.numSubStatesArray[state]) {
            double posterior;
            double oS;
            double iS = level < 1 ? this.viScore[start][end][state] : this.iScore[start][end][state][substate];
            double d = oS = level < 1 ? this.voScore[start][end][state] : this.oScore[start][end][state][substate];
            if (iS != Double.NEGATIVE_INFINITY && oS != Double.NEGATIVE_INFINITY && (posterior = iS + oS - sentenceProb) > maxThreshold) {
                maxThreshold = posterior;
            }
            ++substate;
        }
        return Math.min(maxThreshold, minChildren);
    }

    public void doGoldInsideOutsideScores(Tree<StateSet> tree, List<String> sentence) {
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        this.allowedStates = new boolean[this.length][this.length + 1][this.numSubStatesArray.length];
        this.ensureGoldTreeSurvives(tree, this.endLevel);
        double initVal = 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(false, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.initializeChart(sentence, curLexicon, false, true, null, false);
    }

    public Tree<String> removeStars(Tree<String> tree) {
        String transformedLabel = tree.getLabel();
        int starIndex = transformedLabel.indexOf("*");
        if (starIndex != -1) {
            transformedLabel = transformedLabel.substring(0, starIndex);
        }
        if (tree.isPreTerminal()) {
            return new Tree<String>(transformedLabel, tree.getChildren());
        }
        ArrayList transformedChildren = new ArrayList();
        for (Tree<String> child : tree.getChildren()) {
            transformedChildren.add(this.removeStars(child));
        }
        return new Tree<String>(transformedLabel, transformedChildren);
    }

    private double[] closeVariationalRules(double[][] ruleScores, int start, int end) {
        double[] closedScores = new double[this.numStates];
        int i = 0;
        while (i < this.numStates) {
            closedScores[i] = this.maxcScore[start][end][i];
            ++i;
        }
        int length = 1;
        while (length < 10) {
            int startState = 0;
            while (startState < this.numStates) {
                int endState = 0;
                while (endState < this.numStates) {
                    int interState = 0;
                    while (interState < this.numStates) {
                        ruleScores[startState][endState] = Math.max(ruleScores[startState][endState], ruleScores[startState][interState] * ruleScores[interState][endState]);
                        ++interState;
                    }
                    ++endState;
                }
                ++startState;
            }
            ++length;
        }
        int childState = 0;
        while (childState < this.numStates) {
            double childScore = this.maxcScore[start][end][childState];
            if (childScore != 0.0) {
                int parentState = 0;
                while (parentState < this.numStates) {
                    double newScore = childScore * ruleScores[parentState][childState];
                    if (newScore > closedScores[parentState]) {
                        closedScores[parentState] = newScore;
                        this.maxcChild[start][end][parentState] = childState;
                    }
                    ++parentState;
                }
            }
            ++childState;
        }
        return closedScores;
    }

    void doScaledConstrainedInsideScores(Grammar grammar) {
        double initVal = 0.0;
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (diff != 1 && this.allowedStates[start][end][pState]) {
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        int nParentStates = this.numSubStatesArray[pState];
                        boolean somethingChanged = false;
                        int i = 0;
                        while (i < parentRules.length) {
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (iPossibleL) {
                                boolean iPossibleR;
                                int narrowL = this.narrowLExtent[end][rState];
                                boolean bl2 = iPossibleR = narrowL >= narrowR;
                                if (iPossibleR) {
                                    int min;
                                    int min1 = narrowR;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (min <= narrowL) {
                                        int max;
                                        int max1 = this.wideRExtent[start][lState];
                                        int max2 = narrowL;
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (min <= max) {
                                            double[][][] scores = r.getScores2();
                                            int nLeftChildStates = this.numSubStatesArray[lState];
                                            int nRightChildStates = this.numSubStatesArray[rState];
                                            int split = min;
                                            while (split <= max) {
                                                boolean changeThisRound = false;
                                                if (this.allowedStates[start][split][lState] && this.allowedStates[split][end][rState]) {
                                                    int lp = 0;
                                                    while (lp < nLeftChildStates) {
                                                        double lS = this.iScore[start][split][lState][lp];
                                                        if (lS != initVal) {
                                                            int rp = 0;
                                                            while (rp < nRightChildStates) {
                                                                double rS;
                                                                if (scores[lp][rp] != null && (rS = this.iScore[split][end][rState][rp]) != initVal) {
                                                                    int np = 0;
                                                                    while (np < nParentStates) {
                                                                        double pS;
                                                                        if (this.allowedSubStates[start][end][pState][np] && (pS = scores[lp][rp][np]) != initVal) {
                                                                            double thisRound = pS * lS * rS;
                                                                            int n3 = np;
                                                                            this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + thisRound;
                                                                            somethingChanged = true;
                                                                            changeThisRound = true;
                                                                        }
                                                                        ++np;
                                                                    }
                                                                }
                                                                ++rp;
                                                            }
                                                        }
                                                        ++lp;
                                                    }
                                                    if (changeThisRound) {
                                                        int parentScale = this.iScale[start][end][pState];
                                                        int currentScale = this.iScale[start][split][lState] + this.iScale[split][end][rState];
                                                        if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                                            if (parentScale == Integer.MIN_VALUE) {
                                                                this.iScale[start][end][pState] = currentScale;
                                                            } else {
                                                                int newScale = Math.max(currentScale, parentScale);
                                                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                                                ScalingTools.scaleArrayToScale(this.iScore[start][end][pState], parentScale, newScale);
                                                                this.iScale[start][end][pState] = newScale;
                                                            }
                                                        }
                                                        int np = 0;
                                                        while (np < nParentStates) {
                                                            double[] dArray = this.iScore[start][end][pState];
                                                            int n4 = np;
                                                            dArray[n4] = dArray[n4] + this.unscaledScoresToAdd[np];
                                                            ++np;
                                                        }
                                                        Arrays.fill(this.unscaledScoresToAdd, 0.0);
                                                    }
                                                }
                                                ++split;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        if (somethingChanged) {
                            if (start > this.narrowLExtent[end][pState]) {
                                this.narrowLExtent[end][pState] = start;
                                this.wideLExtent[end][pState] = start;
                            } else if (start < this.wideLExtent[end][pState]) {
                                this.wideLExtent[end][pState] = start;
                            }
                            if (end < this.narrowRExtent[start][pState]) {
                                this.narrowRExtent[start][pState] = end;
                                this.wideRExtent[start][pState] = end;
                            } else if (end > this.wideRExtent[start][pState]) {
                                this.wideRExtent[start][pState] = end;
                            }
                        }
                    }
                    ++pState;
                }
                double[][] scoresAfterUnaries = new double[this.numStates][];
                int pState2 = 0;
                while (pState2 < this.numSubStatesArray.length) {
                    if (this.allowedStates[start][end][pState2]) {
                        int parentScale;
                        UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState2);
                        int nParentStates = this.numSubStatesArray[pState2];
                        int scaleBeforeUnaries = parentScale = this.iScale[start][end][pState2];
                        boolean somethingChanged = false;
                        int r = 0;
                        while (r < unaries.length) {
                            UnaryRule ur = unaries[r];
                            short cState = ur.childState;
                            if (pState2 != cState && this.iScore[start][end][cState] != null) {
                                double[][] scores = ur.getScores2();
                                boolean changeThisRound = false;
                                int nChildStates = this.numSubStatesArray[cState];
                                int cp = 0;
                                while (cp < nChildStates) {
                                    double iS;
                                    if (scores[cp] != null && (iS = this.iScore[start][end][cState][cp]) != initVal) {
                                        int np = 0;
                                        while (np < nParentStates) {
                                            double pS;
                                            if (this.allowedSubStates[start][end][pState2][np] && (pS = scores[cp][np]) != initVal) {
                                                double thisRound = iS * pS;
                                                int n = np;
                                                this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + thisRound;
                                                somethingChanged = true;
                                                changeThisRound = true;
                                            }
                                            ++np;
                                        }
                                    }
                                    ++cp;
                                }
                                if (changeThisRound) {
                                    if (scoresAfterUnaries[pState2] == null) {
                                        scoresAfterUnaries[pState2] = new double[this.numSubStatesArray[pState2]];
                                    }
                                    int currentScale = this.iScale[start][end][cState];
                                    if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                        if (parentScale == Integer.MIN_VALUE) {
                                            parentScale = currentScale;
                                        } else {
                                            int newScale = Math.max(currentScale, parentScale);
                                            ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                            ScalingTools.scaleArrayToScale(scoresAfterUnaries[pState2], parentScale, newScale);
                                            parentScale = newScale;
                                        }
                                    }
                                    int np = 0;
                                    while (np < nParentStates) {
                                        double[] dArray = scoresAfterUnaries[pState2];
                                        int n = np;
                                        dArray[n] = dArray[n] + this.unscaledScoresToAdd[np];
                                        ++np;
                                    }
                                    Arrays.fill(this.unscaledScoresToAdd, 0.0);
                                }
                            }
                            ++r;
                        }
                        if (somethingChanged) {
                            int newScale = Math.max(scaleBeforeUnaries, parentScale);
                            ScalingTools.scaleArrayToScale(this.iScore[start][end][pState2], scaleBeforeUnaries, newScale);
                            ScalingTools.scaleArrayToScale(scoresAfterUnaries[pState2], parentScale, newScale);
                            this.iScale[start][end][pState2] = newScale;
                            if (start > this.narrowLExtent[end][pState2]) {
                                this.narrowLExtent[end][pState2] = start;
                                this.wideLExtent[end][pState2] = start;
                            } else if (start < this.wideLExtent[end][pState2]) {
                                this.wideLExtent[end][pState2] = start;
                            }
                            if (end < this.narrowRExtent[start][pState2]) {
                                this.narrowRExtent[start][pState2] = end;
                                this.wideRExtent[start][pState2] = end;
                            } else if (end > this.wideRExtent[start][pState2]) {
                                this.wideRExtent[start][pState2] = end;
                            }
                        }
                        int np = 0;
                        while (np < nParentStates) {
                            double val;
                            if (scoresAfterUnaries[pState2] != null && (val = scoresAfterUnaries[pState2][np]) > 0.0) {
                                double[] dArray = this.iScore[start][end][pState2];
                                int n = np;
                                dArray[n] = dArray[n] + val;
                            }
                            ++np;
                        }
                    }
                    ++pState2;
                }
                ++start;
            }
            ++diff;
        }
    }

    void doScaledConstrainedOutsideScores(Grammar grammar) {
        double initVal = 0.0;
        int diff = this.length;
        while (diff >= 1) {
            int start = 0;
            while (start + diff <= this.length) {
                block44: {
                    int end = start + diff;
                    double[][] scoresAfterUnaries = new double[this.numStates][];
                    int cState = 0;
                    while (cState < this.numSubStatesArray.length) {
                        if (this.allowedStates[start][end][cState]) {
                            int childScale;
                            UnaryRule[] rules = grammar.getClosedSumUnaryRulesByChild(cState);
                            int nChildStates = this.numSubStatesArray[cState];
                            boolean somethingChanged = false;
                            int scaleBeforeUnaries = childScale = this.oScale[start][end][cState];
                            int r = 0;
                            while (r < rules.length) {
                                UnaryRule ur = rules[r];
                                short pState = ur.parentState;
                                if (pState != cState && this.allowedStates[start][end][pState]) {
                                    int nParentStates = this.numSubStatesArray[pState];
                                    double[][] scores = ur.getScores2();
                                    boolean changeThisRound = false;
                                    int cp = 0;
                                    while (cp < nChildStates) {
                                        if (scores[cp] != null && this.allowedSubStates[start][end][cState][cp]) {
                                            int np = 0;
                                            while (np < nParentStates) {
                                                double oS;
                                                double pS;
                                                if (this.allowedSubStates[start][end][pState][np] && (pS = scores[cp][np]) != initVal && (oS = this.oScore[start][end][pState][np]) != initVal) {
                                                    double thisRound = oS * pS;
                                                    int n = cp;
                                                    this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + thisRound;
                                                    somethingChanged = true;
                                                    changeThisRound = true;
                                                }
                                                ++np;
                                            }
                                        }
                                        ++cp;
                                    }
                                    if (changeThisRound) {
                                        if (scoresAfterUnaries[cState] == null) {
                                            scoresAfterUnaries[cState] = new double[this.numSubStatesArray[cState]];
                                        }
                                        int currentScale = this.oScale[start][end][pState];
                                        if (childScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                            if (childScale == Integer.MIN_VALUE) {
                                                childScale = currentScale;
                                            } else {
                                                int newScale = Math.max(currentScale, childScale);
                                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                                ScalingTools.scaleArrayToScale(scoresAfterUnaries[cState], childScale, newScale);
                                                childScale = newScale;
                                            }
                                        }
                                        int cp2 = 0;
                                        while (cp2 < nChildStates) {
                                            double[] dArray = scoresAfterUnaries[cState];
                                            int n = cp2;
                                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp2];
                                            ++cp2;
                                        }
                                        Arrays.fill(this.unscaledScoresToAdd, initVal);
                                    }
                                }
                                ++r;
                            }
                            if (somethingChanged) {
                                int newScale = Math.max(scaleBeforeUnaries, childScale);
                                ScalingTools.scaleArrayToScale(this.oScore[start][end][cState], scaleBeforeUnaries, newScale);
                                ScalingTools.scaleArrayToScale(scoresAfterUnaries[cState], childScale, newScale);
                                this.oScale[start][end][cState] = newScale;
                            }
                            int cp = 0;
                            while (cp < nChildStates) {
                                double val;
                                if (scoresAfterUnaries[cState] != null && (val = scoresAfterUnaries[cState][cp]) > 0.0) {
                                    double[] dArray = this.oScore[start][end][cState];
                                    int n = cp;
                                    dArray[n] = dArray[n] + val;
                                }
                                ++cp;
                            }
                        }
                        ++cState;
                    }
                    if (diff == 1) break block44;
                    int pState = 0;
                    while (pState < this.numSubStatesArray.length) {
                        block45: {
                            if (!this.allowedStates[start][end][pState]) break block45;
                            int nParentChildStates = this.numSubStatesArray[pState];
                            BinaryRule[] rules = grammar.splitRulesWithP(pState);
                            int r = 0;
                            while (r < rules.length) {
                                block46: {
                                    int min;
                                    int max;
                                    short rState;
                                    short lState;
                                    BinaryRule br;
                                    block47: {
                                        int max1;
                                        br = rules[r];
                                        lState = br.leftChildState;
                                        int min1 = this.narrowRExtent[start][lState];
                                        if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) break block46;
                                        max = max1;
                                        min = min1;
                                        if (max - min <= 2) break block47;
                                        int min2 = this.wideLExtent[end][rState];
                                        int n = min = min1 > min2 ? min1 : min2;
                                        if (max1 < min) break block46;
                                        int max2 = this.wideRExtent[start][lState];
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (max < min) break block46;
                                    }
                                    double[][][] scores = br.getScores2();
                                    int nLeftChildStates = this.numSubStatesArray[lState];
                                    int nRightChildStates = this.numSubStatesArray[rState];
                                    int split = min;
                                    while (split <= max) {
                                        if (this.allowedStates[start][split][lState] && this.allowedStates[split][end][rState]) {
                                            boolean somethingChanged = false;
                                            int lp = 0;
                                            while (lp < nLeftChildStates) {
                                                double lS = this.iScore[start][split][lState][lp];
                                                int rp = 0;
                                                while (rp < nRightChildStates) {
                                                    if (scores[lp][rp] != null) {
                                                        double rS = this.iScore[split][end][rState][rp];
                                                        int np = 0;
                                                        while (np < nParentChildStates) {
                                                            double oS;
                                                            double pS = scores[lp][rp][np];
                                                            if (pS != initVal && (oS = this.oScore[start][end][pState][np]) != initVal) {
                                                                double thisRoundL = pS * rS * oS;
                                                                double thisRoundR = pS * lS * oS;
                                                                int n = lp;
                                                                this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                                                int n3 = rp;
                                                                this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + thisRoundR;
                                                                somethingChanged = true;
                                                            }
                                                            ++np;
                                                        }
                                                    }
                                                    ++rp;
                                                }
                                                ++lp;
                                            }
                                            if (somethingChanged) {
                                                int cp;
                                                int newScale;
                                                if (DoubleArrays.max(this.scoresToAdd) != 0.0) {
                                                    int leftScale = this.oScale[start][split][lState];
                                                    int currentScale = this.oScale[start][end][pState] + this.iScale[split][end][rState];
                                                    if (leftScale != (currentScale = ScalingTools.scaleArray(this.scoresToAdd, currentScale))) {
                                                        if (leftScale == Integer.MIN_VALUE) {
                                                            this.oScale[start][split][lState] = currentScale;
                                                        } else {
                                                            newScale = Math.max(currentScale, leftScale);
                                                            ScalingTools.scaleArrayToScale(this.scoresToAdd, currentScale, newScale);
                                                            ScalingTools.scaleArrayToScale(this.oScore[start][split][lState], leftScale, newScale);
                                                            this.oScale[start][split][lState] = newScale;
                                                        }
                                                    }
                                                    cp = 0;
                                                    while (cp < nLeftChildStates) {
                                                        if (this.scoresToAdd[cp] > initVal) {
                                                            double[] dArray = this.oScore[start][split][lState];
                                                            int n = cp;
                                                            dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                                        }
                                                        ++cp;
                                                    }
                                                    Arrays.fill(this.scoresToAdd, 0.0);
                                                }
                                                if (DoubleArrays.max(this.unscaledScoresToAdd) != 0.0) {
                                                    int rightScale = this.oScale[split][end][rState];
                                                    int currentScale = this.oScale[start][end][pState] + this.iScale[start][split][lState];
                                                    if (rightScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                                        if (rightScale == Integer.MIN_VALUE) {
                                                            this.oScale[split][end][rState] = currentScale;
                                                        } else {
                                                            newScale = Math.max(currentScale, rightScale);
                                                            ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                                            ScalingTools.scaleArrayToScale(this.oScore[split][end][rState], rightScale, newScale);
                                                            this.oScale[split][end][rState] = newScale;
                                                        }
                                                    }
                                                    cp = 0;
                                                    while (cp < nRightChildStates) {
                                                        if (this.unscaledScoresToAdd[cp] > initVal) {
                                                            double[] dArray = this.oScore[split][end][rState];
                                                            int n = cp;
                                                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                                                        }
                                                        ++cp;
                                                    }
                                                    Arrays.fill(this.unscaledScoresToAdd, 0.0);
                                                }
                                            }
                                        }
                                        ++split;
                                    }
                                }
                                ++r;
                            }
                        }
                        ++pState;
                    }
                }
                ++start;
            }
            --diff;
        }
    }

    protected void setupScaling() {
        int end;
        this.iScale = new int[this.length][this.length + 1][];
        this.oScale = new int[this.length][this.length + 1][];
        int start = 0;
        while (start < this.length) {
            end = start + 1;
            while (end <= this.length) {
                this.iScale[start][end] = new int[this.numStates];
                this.oScale[start][end] = new int[this.numStates];
                Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
                ++end;
            }
            ++start;
        }
        start = 0;
        while (start < this.length) {
            end = start + 1;
            while (end <= this.length) {
                int state = 0;
                while (state < this.numSubStatesArray.length) {
                    if (this.allowedStates[start][end][state]) {
                        Arrays.fill(this.iScore[start][end][state], 0.0);
                    }
                    ++state;
                }
                ++end;
            }
            ++start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object call() {
        Tree<String> parse = this.getBestParse(this.nextSentence);
        this.nextSentence = null;
        ArrayList<Tree<String>> result = new ArrayList<Tree<String>>();
        result.add(parse);
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.add(result, -this.nextSentenceID);
            this.queue.notifyAll();
        }
        return null;
    }

    @Override
    public CoarseToFineMaxRuleParser newInstance() {
        CoarseToFineMaxRuleParser newParser = new CoarseToFineMaxRuleParser(this.grammar, this.lexicon, this.unaryPenalty, this.endLevel, this.viterbiParse, this.outputSub, this.outputScore, this.accurate, this.doVariational, this.useGoldPOS, false);
        newParser.initCascade(this);
        return newParser;
    }

    public double getSentenceProbability(int start, int end, boolean sumScores) {
        double score = 0.0;
        if (sumScores) {
            int pState = 0;
            while (pState < this.numSubStatesArray.length) {
                if (this.allowedStates[start][end + 1][pState]) {
                    int cp = 0;
                    while (cp < this.numSubStatesArray[pState]) {
                        score += this.iScore[start][end + 1][pState][cp];
                        ++cp;
                    }
                }
                ++pState;
            }
        } else {
            score = this.iScore[start][end + 1][0][0];
        }
        return Math.log(score);
    }

    public boolean[][][] getAllowedStates() {
        return this.allowedStates;
    }

    public boolean[][][][] getAllowedSubStates() {
        return this.allowedSubStates;
    }

    public void dumpPosteriors(String fileName, int blockSize) {
        if (this.posteriorsToDump == null && blockSize > 0) {
            this.posteriorsToDump = new ArrayList<Posterior>(blockSize);
        }
        if (this.posteriorsToDump.size() == blockSize || blockSize == -1) {
            fileName = String.valueOf(fileName) + "." + this.nThBlock++;
            try {
                ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(fileName)));
                out.writeObject(this.posteriorsToDump);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                System.out.println("IOException: " + e);
            }
            if (blockSize == -1) {
                return;
            }
            this.posteriorsToDump = new ArrayList<Posterior>(blockSize);
        }
        Posterior posterior = new Posterior(this.iScore, this.oScore, this.iScale, this.oScale, this.allowedStates);
        this.posteriorsToDump.add(posterior);
    }
}

