/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseToFineTwoChartsParser
extends CoarseToFineMaxRuleParser {
    protected double[][][][] iScorePreU;
    protected double[][][][] iScorePostU;
    protected double[][][][] oScorePreU;
    protected double[][][][] oScorePostU;

    public CoarseToFineTwoChartsParser(Grammar gr, Lexicon lex, double unaryPenalty, int endL, boolean viterbi, boolean sub, boolean score, boolean accurate) {
        super(gr, lex, unaryPenalty, endL, viterbi, sub, score, accurate, false, false, true);
    }

    @Override
    void doConstrainedInsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        if (!viterbi && logScores) {
            throw new Error("This would require logAdds and is slow. Exponentiate the scores instead.");
        }
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int nParentStates;
                int end = start + diff;
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (diff != 1 && this.allowedSubStates[start][end][pState] != null) {
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        nParentStates = this.numSubStatesArray[pState];
                        Arrays.fill(this.scoresToAdd, initVal);
                        boolean somethingChanged = false;
                        int i = 0;
                        while (i < parentRules.length) {
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (iPossibleL) {
                                boolean iPossibleR;
                                int narrowL = this.narrowLExtent[end][rState];
                                boolean bl2 = iPossibleR = narrowL >= narrowR;
                                if (iPossibleR) {
                                    int min;
                                    int min1 = narrowR;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (min <= narrowL) {
                                        int max;
                                        int max1 = this.wideRExtent[start][lState];
                                        int max2 = narrowL;
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (min <= max) {
                                            double[][][] scores = r.getScores2();
                                            int nLeftChildStates = this.numSubStatesArray[lState];
                                            int nRightChildStates = this.numSubStatesArray[rState];
                                            int split = min;
                                            while (split <= max) {
                                                if (this.allowedSubStates[start][split][lState] != null && this.allowedSubStates[split][end][rState] != null) {
                                                    int lp = 0;
                                                    while (lp < nLeftChildStates) {
                                                        double lS = this.iScorePostU[start][split][lState][lp];
                                                        if (lS != initVal) {
                                                            int rp = 0;
                                                            while (rp < nRightChildStates) {
                                                                double rS;
                                                                if (scores[lp][rp] != null && (rS = this.iScorePostU[split][end][rState][rp]) != initVal) {
                                                                    int np = 0;
                                                                    while (np < nParentStates) {
                                                                        double pS;
                                                                        if (this.allowedSubStates[start][end][pState][np] && (pS = scores[lp][rp][np]) != initVal) {
                                                                            double thisRound;
                                                                            double d = thisRound = logScores ? pS + lS + rS : pS * lS * rS;
                                                                            if (viterbi) {
                                                                                this.scoresToAdd[np] = Math.max(thisRound, this.scoresToAdd[np]);
                                                                            } else {
                                                                                int n3 = np;
                                                                                this.scoresToAdd[n3] = this.scoresToAdd[n3] + thisRound;
                                                                            }
                                                                            somethingChanged = true;
                                                                        }
                                                                        ++np;
                                                                    }
                                                                }
                                                                ++rp;
                                                            }
                                                        }
                                                        ++lp;
                                                    }
                                                }
                                                ++split;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        if (somethingChanged) {
                            int np = 0;
                            while (np < nParentStates) {
                                if (this.scoresToAdd[np] > initVal) {
                                    this.iScorePreU[start][end][pState][np] = this.scoresToAdd[np];
                                }
                                ++np;
                            }
                            if (start > this.narrowLExtent[end][pState]) {
                                this.narrowLExtent[end][pState] = start;
                                this.wideLExtent[end][pState] = start;
                            } else if (start < this.wideLExtent[end][pState]) {
                                this.wideLExtent[end][pState] = start;
                            }
                            if (end < this.narrowRExtent[start][pState]) {
                                this.narrowRExtent[start][pState] = end;
                                this.wideRExtent[start][pState] = end;
                            } else if (end > this.wideRExtent[start][pState]) {
                                this.wideRExtent[start][pState] = end;
                            }
                        }
                    }
                    ++pState;
                }
                pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (this.allowedSubStates[start][end][pState] != null) {
                        UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                        nParentStates = this.numSubStatesArray[pState];
                        boolean firstTime = true;
                        boolean somethingChanged = false;
                        int r = 0;
                        while (r < unaries.length) {
                            UnaryRule ur = unaries[r];
                            short cState = ur.childState;
                            if (pState != cState && this.iScorePreU[start][end][cState] != null) {
                                double[][] scores = ur.getScores2();
                                int nChildStates = this.numSubStatesArray[cState];
                                int cp = 0;
                                while (cp < nChildStates) {
                                    double iS;
                                    if (scores[cp] != null && (iS = this.iScorePreU[start][end][cState][cp]) != initVal) {
                                        int np = 0;
                                        while (np < nParentStates) {
                                            double pS;
                                            if (this.allowedSubStates[start][end][pState][np] && (pS = scores[cp][np]) != initVal) {
                                                double thisRound;
                                                if (firstTime) {
                                                    firstTime = false;
                                                    Arrays.fill(this.scoresToAdd, initVal);
                                                }
                                                double d = thisRound = logScores ? iS + pS : iS * pS;
                                                if (viterbi) {
                                                    this.scoresToAdd[np] = Math.max(thisRound, this.scoresToAdd[np]);
                                                } else {
                                                    int n = np;
                                                    this.scoresToAdd[n] = this.scoresToAdd[n] + thisRound;
                                                }
                                                somethingChanged = true;
                                            }
                                            ++np;
                                        }
                                    }
                                    ++cp;
                                }
                            }
                            ++r;
                        }
                        if (!somethingChanged) {
                            this.iScorePostU[start][end][pState] = (double[])this.iScorePreU[start][end][pState].clone();
                        } else {
                            int np = 0;
                            while (np < nParentStates) {
                                this.iScorePostU[start][end][pState][np] = this.scoresToAdd[np] > initVal ? (viterbi ? Math.max(this.iScorePreU[start][end][pState][np], this.scoresToAdd[np]) : this.iScorePreU[start][end][pState][np] + this.scoresToAdd[np]) : this.iScorePreU[start][end][pState][np];
                                ++np;
                            }
                            if (start > this.narrowLExtent[end][pState]) {
                                this.narrowLExtent[end][pState] = start;
                                this.wideLExtent[end][pState] = start;
                            } else if (start < this.wideLExtent[end][pState]) {
                                this.wideLExtent[end][pState] = start;
                            }
                            if (end < this.narrowRExtent[start][pState]) {
                                this.narrowRExtent[start][pState] = end;
                                this.wideRExtent[start][pState] = end;
                            } else if (end > this.wideRExtent[start][pState]) {
                                this.wideRExtent[start][pState] = end;
                            }
                        }
                    }
                    ++pState;
                }
                ++start;
            }
            ++diff;
        }
    }

    @Override
    void doConstrainedOutsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        int diff = this.length;
        while (diff >= 1) {
            int start = 0;
            while (start + diff <= this.length) {
                int end = start + diff;
                boolean somethingChanged = false;
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (this.oScorePreU[start][end][pState] != null) {
                        UnaryRule[] rules = grammar.getClosedSumUnaryRulesByParent(pState);
                        int r = 0;
                        while (r < rules.length) {
                            UnaryRule ur = rules[r];
                            short cState = ur.childState;
                            if (pState != cState && this.oScorePreU[start][end][cState] != null) {
                                double[][] scores = ur.getScores2();
                                int nParentStates = this.numSubStatesArray[pState];
                                int nChildStates = scores.length;
                                boolean firstTime = true;
                                int cp = 0;
                                while (cp < nChildStates) {
                                    if (scores[cp] != null && this.allowedSubStates[start][end][cState][cp]) {
                                        int np = 0;
                                        while (np < nParentStates) {
                                            double oS;
                                            double pS = scores[cp][np];
                                            if (pS != initVal && (oS = this.oScorePreU[start][end][pState][np]) != initVal) {
                                                double thisRound;
                                                double d = thisRound = logScores ? oS + pS : oS * pS;
                                                if (firstTime) {
                                                    firstTime = false;
                                                    Arrays.fill(this.scoresToAdd, initVal);
                                                }
                                                if (viterbi) {
                                                    this.scoresToAdd[cp] = Math.max(thisRound, this.scoresToAdd[cp]);
                                                } else {
                                                    int n = cp;
                                                    this.scoresToAdd[n] = this.scoresToAdd[n] + thisRound;
                                                }
                                                somethingChanged = true;
                                            }
                                            ++np;
                                        }
                                    }
                                    ++cp;
                                }
                                if (somethingChanged) {
                                    cp = 0;
                                    while (cp < nChildStates) {
                                        if (this.scoresToAdd[cp] > initVal) {
                                            if (viterbi) {
                                                this.oScorePostU[start][end][cState][cp] = Math.max(this.oScorePostU[start][end][cState][cp], this.scoresToAdd[cp]);
                                            } else {
                                                double[] dArray = this.oScorePostU[start][end][cState];
                                                int n = cp;
                                                dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                            }
                                        }
                                        ++cp;
                                    }
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                int cState = 0;
                while (cState < this.numSubStatesArray.length) {
                    if (this.oScorePostU[start][end][cState] != null) {
                        int cp = 0;
                        while (cp < this.numSubStatesArray[cState]) {
                            if (viterbi) {
                                this.oScorePostU[start][end][cState][cp] = Math.max(this.oScorePostU[start][end][cState][cp], this.oScorePreU[start][end][cState][cp]);
                            } else {
                                double[] dArray = this.oScorePostU[start][end][cState];
                                int n = cp;
                                dArray[n] = dArray[n] + this.oScorePreU[start][end][cState][cp];
                            }
                            ++cp;
                        }
                    }
                    ++cState;
                }
                pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    block47: {
                        if (this.oScorePostU[start][end][pState] == null) break block47;
                        int nParentChildStates = this.numSubStatesArray[pState];
                        BinaryRule[] rules = grammar.splitRulesWithP(pState);
                        int r = 0;
                        while (r < rules.length) {
                            block48: {
                                int min;
                                int max;
                                short rState;
                                short lState;
                                BinaryRule br;
                                block49: {
                                    int max1;
                                    br = rules[r];
                                    lState = br.leftChildState;
                                    int min1 = this.narrowRExtent[start][lState];
                                    if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) break block48;
                                    max = max1;
                                    min = min1;
                                    if (max - min <= 2) break block49;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (max1 < min) break block48;
                                    int max2 = this.wideRExtent[start][lState];
                                    int n2 = max = max1 < max2 ? max1 : max2;
                                    if (max < min) break block48;
                                }
                                double[][][] scores = br.getScores2();
                                int nLeftChildStates = this.numSubStatesArray[lState];
                                int nRightChildStates = this.numSubStatesArray[rState];
                                int split = min;
                                while (split <= max) {
                                    if (this.oScorePreU[start][split][lState] != null && this.oScorePreU[split][end][rState] != null) {
                                        double[] rightScores = new double[nRightChildStates];
                                        Arrays.fill(this.scoresToAdd, initVal);
                                        Arrays.fill(rightScores, initVal);
                                        somethingChanged = false;
                                        int lp = 0;
                                        while (lp < nLeftChildStates) {
                                            double lS = this.iScorePostU[start][split][lState][lp];
                                            if (lS != initVal) {
                                                int rp = 0;
                                                while (rp < nRightChildStates) {
                                                    double rS;
                                                    if (scores[lp][rp] != null && (rS = this.iScorePostU[split][end][rState][rp]) != initVal) {
                                                        int np = 0;
                                                        while (np < nParentChildStates) {
                                                            double oS;
                                                            double pS = scores[lp][rp][np];
                                                            if (pS != initVal && (oS = this.oScorePostU[start][end][pState][np]) != initVal) {
                                                                double thisRoundR;
                                                                double thisRoundL = logScores ? pS + rS + oS : pS * rS * oS;
                                                                double d = thisRoundR = logScores ? pS + lS + oS : pS * lS * oS;
                                                                if (viterbi) {
                                                                    this.scoresToAdd[lp] = Math.max(thisRoundL, this.scoresToAdd[lp]);
                                                                    rightScores[rp] = Math.max(thisRoundR, rightScores[rp]);
                                                                } else {
                                                                    int n = lp;
                                                                    this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                                                    int n3 = rp;
                                                                    rightScores[n3] = rightScores[n3] + thisRoundR;
                                                                }
                                                                somethingChanged = true;
                                                            }
                                                            ++np;
                                                        }
                                                    }
                                                    ++rp;
                                                }
                                            }
                                            ++lp;
                                        }
                                        if (somethingChanged) {
                                            int cp = 0;
                                            while (cp < nLeftChildStates) {
                                                if (this.scoresToAdd[cp] > initVal) {
                                                    if (viterbi) {
                                                        this.oScorePreU[start][split][lState][cp] = Math.max(this.oScorePreU[start][split][lState][cp], this.scoresToAdd[cp]);
                                                    } else {
                                                        double[] dArray = this.oScorePreU[start][split][lState];
                                                        int n = cp;
                                                        dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                                    }
                                                }
                                                ++cp;
                                            }
                                            cp = 0;
                                            while (cp < nRightChildStates) {
                                                if (rightScores[cp] > initVal) {
                                                    if (viterbi) {
                                                        this.oScorePreU[split][end][rState][cp] = Math.max(this.oScorePreU[split][end][rState][cp], rightScores[cp]);
                                                    } else {
                                                        double[] dArray = this.oScorePreU[split][end][rState];
                                                        int n = cp;
                                                        dArray[n] = dArray[n] + rightScores[cp];
                                                    }
                                                }
                                                ++cp;
                                            }
                                        }
                                    }
                                    ++split;
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                ++start;
            }
            --diff;
        }
    }

    void initializeChart(List<String> sentence, Lexicon lexicon, boolean noSubstates, boolean noSmoothing) {
        int start = 0;
        int end = start + 1;
        for (String word : sentence) {
            end = start + 1;
            int tag = 0;
            while (tag < this.numSubStatesArray.length) {
                if ((noSubstates || this.allowedSubStates[start][end][tag] != null) && !this.grammarTags[tag]) {
                    this.narrowRExtent[start][tag] = end;
                    this.narrowLExtent[end][tag] = start;
                    this.wideRExtent[start][tag] = end;
                    this.wideLExtent[end][tag] = start;
                    double[] lexiconScores = lexicon.score(word, (short)tag, start, noSmoothing, false);
                    int n = 0;
                    while (n < lexiconScores.length) {
                        double prob = lexiconScores[n];
                        if (noSubstates) {
                            this.viScore[start][end][tag] = prob;
                        } else {
                            this.iScorePreU[start][end][tag][n] = prob;
                        }
                        n = (short)(n + 1);
                    }
                }
                ++tag;
            }
            ++start;
        }
    }

    @Override
    protected void createArrays(boolean firstTime, int numStates, short[] numSubStatesArray, int level, double initVal, boolean justInit) {
        if (firstTime) {
            this.viScore = new double[this.length][this.length + 1][];
            this.voScore = new double[this.length][this.length + 1][];
            this.iScorePreU = new double[this.length][this.length + 1][][];
            this.iScorePostU = new double[this.length][this.length + 1][][];
            this.oScorePreU = new double[this.length][this.length + 1][][];
            this.oScorePostU = new double[this.length][this.length + 1][][];
            this.allowedSubStates = new boolean[this.length][this.length + 1][][];
            this.allowedStates = new boolean[this.length][this.length + 1][];
            this.vAllowedStates = new boolean[this.length][this.length + 1];
        }
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                if (firstTime) {
                    this.viScore[start][end] = new double[numStates];
                    this.voScore[start][end] = new double[numStates];
                    this.iScorePreU[start][end] = new double[numStates][];
                    this.iScorePostU[start][end] = new double[numStates][];
                    this.oScorePreU[start][end] = new double[numStates][];
                    this.oScorePostU[start][end] = new double[numStates][];
                    this.allowedSubStates[start][end] = new boolean[numStates][];
                    this.allowedStates[start][end] = (boolean[])this.grammarTags.clone();
                    if (level == 1 && end - start == 1) {
                        Arrays.fill(this.allowedStates[start][end], true);
                    }
                    this.vAllowedStates[start][end] = true;
                }
                int state = 0;
                while (state < numSubStatesArray.length) {
                    if (this.allowedSubStates[start][end][state] != null) {
                        if (level < 1) {
                            this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                            this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        } else {
                            this.iScorePreU[start][end][state] = new double[numSubStatesArray[state]];
                            this.iScorePostU[start][end][state] = new double[numSubStatesArray[state]];
                            this.oScorePreU[start][end][state] = new double[numSubStatesArray[state]];
                            this.oScorePostU[start][end][state] = new double[numSubStatesArray[state]];
                            Arrays.fill(this.iScorePreU[start][end][state], initVal);
                            Arrays.fill(this.iScorePostU[start][end][state], initVal);
                            Arrays.fill(this.oScorePreU[start][end][state], initVal);
                            Arrays.fill(this.oScorePostU[start][end][state], initVal);
                        }
                    } else if (level < 1) {
                        this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                    } else {
                        this.iScorePreU[start][end][state] = null;
                        this.iScorePostU[start][end][state] = null;
                        this.oScorePreU[start][end][state] = null;
                        this.oScorePostU[start][end][state] = null;
                    }
                    ++state;
                }
                if (level > 0 && start == 0 && end == this.length && this.iScorePostU[start][end][0] == null) {
                    System.out.println("ROOT does not span the entire tree!");
                }
                ++end;
            }
            ++start;
        }
        this.narrowRExtent = new int[this.length + 1][numStates];
        this.wideRExtent = new int[this.length + 1][numStates];
        this.narrowLExtent = new int[this.length + 1][numStates];
        this.wideLExtent = new int[this.length + 1][numStates];
        int loc = 0;
        while (loc <= this.length) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
            ++loc;
        }
    }

    @Override
    protected void clearArrays() {
        this.oScorePostU = null;
        this.oScorePreU = null;
        this.iScorePostU = null;
        this.iScorePreU = null;
        this.voScore = null;
        this.viScore = null;
        this.allowedSubStates = null;
        this.vAllowedStates = null;
        this.wideLExtent = null;
        this.narrowLExtent = null;
        this.wideRExtent = null;
        this.narrowRExtent = null;
    }

    public void doPreParses(List<String> sentence, Tree<StateSet> tree, boolean noSmoothing) {
        boolean keepGoldAlive = tree != null;
        this.clearArrays();
        this.length = (short)sentence.size();
        double score = 0.0;
        Grammar curGrammar = null;
        Lexicon curLexicon = null;
        double[] accurateThresholds = new double[]{-8.0, -12.0, -12.0, -11.0, -12.0, -12.0, -14.0};
        double[] fastThresholds = new double[]{-8.0, -9.75, -10.0, -9.6, -9.66, -8.01, -7.4, -10.0};
        double[] pruningThreshold = null;
        pruningThreshold = this.accurate ? accurateThresholds : fastThresholds;
        int level = this.startLevel;
        while (level < this.endLevel) {
            if (level != -1 && (this.isBaseline || level != this.endLevel)) {
                curGrammar = this.grammarCascade[level - this.startLevel];
                curLexicon = this.lexiconCascade[level - this.startLevel];
                this.createArrays(level == 0, curGrammar.numStates, curGrammar.numSubStates, level, Double.NEGATIVE_INFINITY, false);
                this.initializeChart(sentence, curLexicon, level < 1, noSmoothing);
                boolean viterbi = true;
                boolean logScores = true;
                if (level < 1) {
                    this.doConstrainedViterbiInsideScores(curGrammar, level == this.startLevel);
                    score = this.viScore[0][this.length][0];
                } else {
                    this.doConstrainedInsideScores(curGrammar, true, true);
                    score = this.iScorePostU[0][this.length][0][0];
                }
                if (score != Double.NEGATIVE_INFINITY) {
                    if (level < 1) {
                        this.voScore[0][this.length][0] = 0.0;
                        this.doConstrainedViterbiOutsideScores(curGrammar, level == this.startLevel);
                    } else {
                        this.oScorePreU[0][this.length][0][0] = 0.0;
                        this.doConstrainedOutsideScores(curGrammar, true, true);
                    }
                    this.pruneChart(Double.NEGATIVE_INFINITY, curGrammar.numSubStates, level);
                }
            }
            ++level;
        }
    }

    public Tree<String> getBestConstrainedParse(List<String> sentence, List<Integer>[][] pStates) {
        this.doPreParses(sentence, null, false);
        this.bestTree = new Tree<String>("ROOT");
        double score = 0.0;
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        this.grammar = curGrammar;
        this.lexicon = curLexicon;
        double initVal = this.viterbiParse ? Double.NEGATIVE_INFINITY : 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(false, curGrammar.numStates, curGrammar.numSubStates, level, initVal, !this.isBaseline);
        this.initializeChart(sentence, curLexicon, false, false);
        this.doConstrainedInsideScores(curGrammar, this.viterbiParse, false);
        score = this.iScorePostU[0][this.length][0][0];
        if (!this.viterbiParse) {
            score = Math.log(score);
        }
        this.logLikelihood = score;
        if (score != Double.NEGATIVE_INFINITY) {
            if (!this.viterbiParse) {
                this.oScorePreU[0][this.length][0][0] = 1.0;
                this.doConstrainedOutsideScores(curGrammar, this.viterbiParse, false);
                this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, false);
            }
            this.bestTree = this.viterbiParse ? this.extractBestViterbiParse(0, 0, 0, this.length, sentence) : this.extractBestMaxRuleParse(0, this.length, sentence);
        }
        this.maxcScore = null;
        this.maxcSplit = null;
        this.maxcChild = null;
        this.maxcLeftChild = null;
        this.maxcRightChild = null;
        return this.bestTree;
    }

    void doConstrainedMaxCScores(List<String> sentence, Grammar grammar, SophisticatedLexicon lexicon) {
        this.numSubStatesArray = grammar.numSubStates;
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        double threshold = 0.01;
        double logNormalizer = this.iScorePostU[0][this.length][0][0];
        double thresh2 = threshold * logNormalizer;
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    int pState = 0;
                    while (pState < this.numSubStatesArray.length) {
                        if (this.oScorePostU[start][end][pState] != null) {
                            BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                            int nParentStates = this.numSubStatesArray[pState];
                            int i = 0;
                            while (i < parentRules.length) {
                                boolean iPossibleL;
                                BinaryRule r = parentRules[i];
                                short lState = r.leftChildState;
                                short rState = r.rightChildState;
                                int narrowR = this.narrowRExtent[start][lState];
                                boolean bl = iPossibleL = narrowR < end;
                                if (iPossibleL) {
                                    boolean iPossibleR;
                                    int narrowL = this.narrowLExtent[end][rState];
                                    boolean bl2 = iPossibleR = narrowL >= narrowR;
                                    if (iPossibleR) {
                                        int min;
                                        int min1 = narrowR;
                                        int min2 = this.wideLExtent[end][rState];
                                        int n = min = min1 > min2 ? min1 : min2;
                                        if (min <= narrowL) {
                                            int max;
                                            int max1 = this.wideRExtent[start][lState];
                                            int max2 = narrowL;
                                            int n2 = max = max1 < max2 ? max1 : max2;
                                            if (min <= max) {
                                                double[][][] scores = r.getScores2();
                                                int nLeftChildStates = this.numSubStatesArray[lState];
                                                int nRightChildStates = this.numSubStatesArray[rState];
                                                int split = min;
                                                while (split <= max) {
                                                    double ruleScore = 0.0;
                                                    if (this.iScorePostU[start][split][lState] != null && this.iScorePostU[split][end][rState] != null) {
                                                        int lp = 0;
                                                        while (lp < nLeftChildStates) {
                                                            double lIS = this.iScorePostU[start][split][lState][lp];
                                                            if (!(lIS < thresh2)) {
                                                                int rp = 0;
                                                                while (rp < nRightChildStates) {
                                                                    double rIS;
                                                                    if (scores[lp][rp] != null && !((rIS = this.iScorePostU[split][end][rState][rp]) < thresh2)) {
                                                                        int np = 0;
                                                                        while (np < nParentStates) {
                                                                            double ruleS;
                                                                            double pOS = this.oScorePostU[start][end][pState][np];
                                                                            if (!(pOS < thresh2) && (ruleS = scores[lp][rp][np]) != 0.0) {
                                                                                ruleScore += pOS * ruleS * lIS * rIS / logNormalizer;
                                                                            }
                                                                            ++np;
                                                                        }
                                                                    }
                                                                    ++rp;
                                                                }
                                                            }
                                                            ++lp;
                                                        }
                                                        double leftChildScore = this.maxcScore[start][split][lState];
                                                        double rightChildScore = this.maxcScore[split][end][rState];
                                                        double scale = 1.0;
                                                        double gScore = ruleScore * leftChildScore * rightChildScore * scale;
                                                        if (gScore > this.maxcScore[start][end][pState]) {
                                                            this.maxcScore[start][end][pState] = gScore;
                                                            this.maxcSplit[start][end][pState] = split;
                                                            this.maxcLeftChild[start][end][pState] = lState;
                                                            this.maxcRightChild[start][end][pState] = rState;
                                                        }
                                                    }
                                                    ++split;
                                                }
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        ++pState;
                    }
                } else {
                    int tag = 0;
                    while (tag < this.numSubStatesArray.length) {
                        if (this.allowedSubStates[start][end][tag] != null) {
                            int nTagStates = this.numSubStatesArray[tag];
                            String word = sentence.get(start);
                            if (!grammar.isGrammarTag(tag)) {
                                double[] lexiconScoreArray = lexicon.score(word, (short)tag, start, false, false);
                                double lexiconScores = 0.0;
                                int tp = 0;
                                while (tp < nTagStates) {
                                    double pOS = this.oScorePostU[start][end][tag][tp];
                                    if (!(pOS < thresh2)) {
                                        double ruleS = lexiconScoreArray[tp];
                                        lexiconScores += pOS * ruleS / logNormalizer;
                                    }
                                    ++tp;
                                }
                                double scale = 1.0;
                                this.maxcScore[start][end][tag] = lexiconScores * scale;
                            }
                        }
                        ++tag;
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                int i = 0;
                while (i < this.numStates) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                    ++i;
                }
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (this.oScorePostU[start][end][pState] != null) {
                        UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                        int nParentStates = this.numSubStatesArray[pState];
                        int r = 0;
                        while (r < unaries.length) {
                            UnaryRule ur = unaries[r];
                            short cState = ur.childState;
                            if (pState != cState && this.iScorePostU[start][end][cState] != null) {
                                double[][] scores = ur.getScores2();
                                int nChildStates = this.numSubStatesArray[cState];
                                double ruleScore = 0.0;
                                int cp = 0;
                                while (cp < nChildStates) {
                                    double cIS = this.iScorePreU[start][end][cState][cp];
                                    if (!(cIS < thresh2) && scores[cp] != null) {
                                        int np = 0;
                                        while (np < nParentStates) {
                                            double ruleS;
                                            double pOS = this.oScorePreU[start][end][pState][np];
                                            if (!(pOS < thresh2) && (ruleS = scores[cp][np]) != 0.0) {
                                                ruleScore += pOS * ruleS * cIS / logNormalizer;
                                            }
                                            ++np;
                                        }
                                    }
                                    ++cp;
                                }
                                double childScore = this.maxcScore[start][end][cState];
                                double scale = 1.0;
                                double gScore = ruleScore / this.unaryPenalty * childScore * scale;
                                if (gScore > maxcScoreStartEnd[pState]) {
                                    maxcScoreStartEnd[pState] = gScore;
                                    this.maxcChild[start][end][pState] = cState;
                                }
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
                ++start;
            }
            ++diff;
        }
    }

    public double doInsideOutsideScores(List<String> sentence, Tree<StateSet> tree) {
        boolean noSmoothing = true;
        this.doPreParses(sentence, tree, true);
        this.length = (short)sentence.size();
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        double initVal = 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(this.isBaseline, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.initializeChart(sentence, curLexicon, false, true);
        this.doConstrainedInsideScores(curGrammar, false, false);
        this.logLikelihood = Math.log(this.iScorePostU[0][this.length][0][0]);
        this.oScorePreU[0][this.length][0][0] = 1.0;
        this.doConstrainedOutsideScores(curGrammar, false, false);
        return this.logLikelihood;
    }

    public double doConstrainedInsideOutsideScores(List<String> sentence, boolean[][][][] cons) {
        boolean noSmoothing = true;
        this.clearArrays();
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        this.numSubStatesArray = curGrammar.numSubStates;
        this.length = (short)sentence.size();
        this.setConstraints(cons);
        double initVal = 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(true, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.initializeChart(sentence, curLexicon, false, true);
        this.doConstrainedInsideScores(curGrammar, false, false);
        this.logLikelihood = Math.log(this.iScorePostU[0][this.length][0][0]);
        this.oScorePreU[0][this.length][0][0] = 1.0;
        this.doConstrainedOutsideScores(curGrammar, false, false);
        return this.logLikelihood;
    }

    @Override
    protected void pruneChart(double threshold, short[] numSubStatesArray, int level) {
        int startDiff;
        double sentenceProb;
        int totalStates = 0;
        int previouslyPossible = 0;
        int nowPossible = 0;
        double d = sentenceProb = level < 1 ? this.viScore[0][this.length][0] : this.iScorePostU[0][this.length][0][0];
        if (level < 1) {
            totalStates = previouslyPossible = this.length;
            nowPossible = previouslyPossible;
        }
        int diff = startDiff = level < 0 ? 2 : 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                int lastState = level < 0 ? 1 : numSubStatesArray.length;
                int state = 0;
                while (state < lastState) {
                    if (diff <= 1 || this.grammarTags[state]) {
                        if (level == 0 && !this.vAllowedStates[start][end]) {
                            this.allowedSubStates[start][end][state] = null;
                            ++totalStates;
                        } else if (level < 1) {
                            ++totalStates;
                            ++previouslyPossible;
                            double iS = this.viScore[start][end][state];
                            double oS = this.voScore[start][end][state];
                            if (iS == Double.NEGATIVE_INFINITY || oS == Double.NEGATIVE_INFINITY) {
                                if (level == 0) {
                                    this.allowedSubStates[start][end][state] = null;
                                } else {
                                    this.vAllowedStates[start][end] = false;
                                }
                            } else {
                                double posterior = iS + oS - sentenceProb;
                                if (posterior > threshold) {
                                    boolean[] tmp = new boolean[numSubStatesArray[state]];
                                    Arrays.fill(tmp, true);
                                    if (level == 0) {
                                        this.allowedSubStates[start][end][state] = tmp;
                                    } else {
                                        this.vAllowedStates[start][end] = true;
                                    }
                                    ++nowPossible;
                                } else if (level == 0) {
                                    this.allowedSubStates[start][end][state] = null;
                                } else {
                                    this.vAllowedStates[start][end] = false;
                                }
                            }
                        } else {
                            boolean nonePossible = true;
                            int substate = 0;
                            while (substate < numSubStatesArray[state]) {
                                ++totalStates;
                                if (this.allowedSubStates[start][end][state][substate]) {
                                    ++previouslyPossible;
                                    double iS = this.iScorePostU[start][end][state][substate];
                                    double oS = this.oScorePostU[start][end][state][substate];
                                    if (iS == Double.NEGATIVE_INFINITY || oS == Double.NEGATIVE_INFINITY) {
                                        this.allowedSubStates[start][end][state][substate] = false;
                                    } else {
                                        double posterior = iS + oS - sentenceProb;
                                        if (posterior > threshold) {
                                            this.allowedSubStates[start][end][state][substate] = true;
                                            ++nowPossible;
                                            nonePossible = false;
                                        } else {
                                            this.allowedSubStates[start][end][state][substate] = false;
                                        }
                                    }
                                }
                                ++substate;
                            }
                            if (nonePossible) {
                                this.allowedSubStates[start][end][state] = null;
                            }
                        }
                    }
                    ++state;
                }
                ++start;
            }
            ++diff;
        }
        String parse = "";
        parse = level == -1 ? "Pre-Parse" : (level == 0 ? "X-Bar" : String.valueOf((int)Math.pow(2.0, level)) + "-Substates");
    }

    public void incrementExpectedCounts(Linearizer linearizer, double[] probs, Grammar grammar, Lexicon lexicon, List<StateSet> sentence, boolean hardCounts, int lexiconOffset) {
        throw new Error("Currently disabled");
    }

    private void setConstraints(boolean[][][][] allowedSubStates2) {
        this.allowedSubStates = new boolean[this.length][this.length + 1][][];
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                this.allowedSubStates[start][end] = new boolean[this.numStates][];
                int state = 0;
                while (state < this.numStates) {
                    if (allowedSubStates2 == null) {
                        boolean[] tmp = new boolean[this.numSubStatesArray[state]];
                        Arrays.fill(tmp, true);
                        this.allowedSubStates[start][end][state] = tmp;
                    } else if (allowedSubStates2[start][end][state] != null) {
                        this.allowedSubStates[start][end][state] = new boolean[this.numSubStatesArray[state]];
                        int substate = 0;
                        while (substate < allowedSubStates2[start][end][state].length) {
                            if (allowedSubStates2[start][end][state][substate]) {
                                this.allowedSubStates[start][end][state][2 * substate] = true;
                                if (state != 0) {
                                    this.allowedSubStates[start][end][state][2 * substate + 1] = true;
                                }
                            }
                            ++substate;
                        }
                    }
                    ++state;
                }
                ++end;
            }
            ++start;
        }
    }

    public double[][][][] getPreUnaryInsideScores() {
        return this.iScorePreU;
    }

    public double[][][][] getPostUnaryInsideScores() {
        return this.iScorePostU;
    }

    public double[][][][] getPreUnaryOutsideScores() {
        return this.oScorePreU;
    }

    public double[][][][] getPostUnaryOutsideScores() {
        return this.oScorePostU;
    }
}

