/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedArrayParser
extends ArrayParser
implements Callable {
    List<Integer>[][] possibleStates;
    protected double[][][][] iScore;
    protected double[][][][] oScore;
    protected short[] numSubStatesArray;
    public long totalUsedUnaries;
    public long nRules;
    public long nRulesInf;
    protected int[][][] iScale;
    protected int[][][] oScale;
    Binarization binarization;
    Counter<String> stateCounter = new Counter();
    Counter<String> ruleCounter = new Counter();
    public boolean viterbi = false;
    public int nTimesRestoredUnaries;
    boolean noConstrains = false;
    protected List<String> nextSentence;
    protected int nextSentenceID;
    int myID;
    PriorityQueue<List<Tree<String>>> queue;

    public void setID(int i, PriorityQueue<List<Tree<String>>> q) {
        this.myID = i;
        this.queue = q;
    }

    public void setNextSentence(List<String> nextS, int nextID) {
        this.nextSentence = nextS;
        this.nextSentenceID = nextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object call() {
        Tree<String> parse = this.getBestParse(this.nextSentence);
        this.nextSentence = null;
        ArrayList<Tree<String>> result = new ArrayList<Tree<String>>();
        result.add(parse);
        PriorityQueue<List<Tree<String>>> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.add(result, -this.nextSentenceID);
            this.queue.notifyAll();
        }
        return null;
    }

    public ConstrainedArrayParser newInstance() {
        ConstrainedArrayParser newParser = new ConstrainedArrayParser(this.grammar, this.lexicon, this.numSubStatesArray);
        return newParser;
    }

    public double getLogLikelihood(Tree<String> t) {
        System.out.println("Unsuported for now!");
        return Double.NEGATIVE_INFINITY;
    }

    public Tree<String>[] getSampledTrees(List<String> sentence, List<Integer>[][] pStates, int n) {
        return null;
    }

    public void setNoConstraints(boolean noC) {
        this.noConstrains = noC;
    }

    public List<Tree<String>> getKBestConstrainedParses(List<String> sentence, List<String> posTags, int k) {
        return null;
    }

    public ConstrainedArrayParser() {
    }

    public ConstrainedArrayParser(Grammar gr, Lexicon lex, short[] nSub) {
        super(gr, lex);
        this.numSubStatesArray = nSub;
        this.totalUsedUnaries = 0L;
        this.nTimesRestoredUnaries = 0;
        this.nRules = 0L;
        this.nRulesInf = 0L;
    }

    private String getStateString(Tree<StateSet> tree) {
        return this.tagNumberer.object(tree.getLabel().getState()) + "&" + (short)tree.getLabel().getIScore(0);
    }

    private void tallyStatesAndRules(Tree<StateSet> bestStateSetTree) {
        if (bestStateSetTree.isLeaf() || bestStateSetTree.isPreTerminal()) {
            return;
        }
        String stateString = this.getStateString(bestStateSetTree);
        this.stateCounter.incrementCount(stateString, 1.0);
        String ruleString = String.valueOf(stateString) + "->";
        for (Tree<StateSet> child : bestStateSetTree.getChildren()) {
            this.tallyStatesAndRules(child);
            ruleString = String.valueOf(ruleString) + "|" + this.getStateString(child);
        }
        this.ruleCounter.incrementCount(ruleString, 1.0);
    }

    public void printStateAndRuleTallies() {
        System.out.println("STATE TALLIES");
        for (String state : this.stateCounter.keySet()) {
            System.out.println(String.valueOf(state) + " " + this.stateCounter.getCount(state));
        }
        System.out.println("RULE TALLIES");
        for (String rule : this.ruleCounter.keySet()) {
            System.out.println(String.valueOf(rule) + " " + this.ruleCounter.getCount(rule));
        }
    }

    protected void createArrays() {
        int end;
        this.clearArrays();
        this.iScore = new double[this.length][this.length + 1][][];
        this.oScore = new double[this.length][this.length + 1][][];
        this.iScale = new int[this.length][this.length + 1][];
        this.oScale = new int[this.length][this.length + 1][];
        int start = 0;
        while (start < this.length) {
            end = start + 1;
            this.iScore[start][end] = new double[this.numStates][];
            this.oScore[start][end] = new double[this.numStates][];
            this.iScale[start][end] = new int[this.numStates];
            this.oScale[start][end] = new int[this.numStates];
            int state = 0;
            while (state < this.numStates) {
                this.iScore[start][end][state] = new double[this.numSubStatesArray[state]];
                this.oScore[start][end][state] = new double[this.numSubStatesArray[state]];
                Arrays.fill(this.iScore[start][end][state], Double.NEGATIVE_INFINITY);
                Arrays.fill(this.oScore[start][end][state], Double.NEGATIVE_INFINITY);
                ++state;
            }
            ++start;
        }
        start = 0;
        while (start < this.length) {
            end = start + 2;
            while (end <= this.length) {
                this.iScore[start][end] = new double[this.numStates][];
                this.oScore[start][end] = new double[this.numStates][];
                this.iScale[start][end] = new int[this.numStates];
                this.oScale[start][end] = new int[this.numStates];
                List<Object> pStates = null;
                if (this.noConstrains) {
                    pStates = new ArrayList();
                    int i = 0;
                    while (i < this.numStates) {
                        pStates.add(i);
                        ++i;
                    }
                } else {
                    pStates = this.possibleStates[start][end];
                }
                Iterator<Object> iterator = pStates.iterator();
                while (iterator.hasNext()) {
                    int state = (Integer)iterator.next();
                    this.iScore[start][end][state] = new double[this.numSubStatesArray[state]];
                    this.oScore[start][end][state] = new double[this.numSubStatesArray[state]];
                    Arrays.fill(this.iScore[start][end][state], Double.NEGATIVE_INFINITY);
                    Arrays.fill(this.oScore[start][end][state], Double.NEGATIVE_INFINITY);
                }
                if (start == 0 && end == this.length) {
                    if (pStates.size() == 0) {
                        System.out.println("no states span the entire tree!");
                    }
                    if (this.iScore[start][end][0] == null) {
                        System.out.println("ROOT does not span the entire tree!");
                    }
                }
                ++end;
            }
            ++start;
        }
        this.narrowRExtent = new int[this.length + 1][this.numStates];
        this.wideRExtent = new int[this.length + 1][this.numStates];
        this.narrowLExtent = new int[this.length + 1][this.numStates];
        this.wideLExtent = new int[this.length + 1][this.numStates];
        int loc = 0;
        while (loc <= this.length) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
            ++loc;
        }
    }

    void initializeChart(List<String> sentence) {
        int start = 0;
        int end = start + 1;
        for (String word : sentence) {
            end = start + 1;
            short tag = 0;
            while (tag < this.grammar.numSubStates.length) {
                if (!this.grammar.isGrammarTag[tag]) {
                    this.narrowRExtent[start][tag] = end;
                    this.narrowLExtent[end][tag] = start;
                    this.wideRExtent[start][tag] = end;
                    this.wideLExtent[end][tag] = start;
                    double[] lexiconScores = this.lexicon.score(word, tag, start, false, false);
                    short n = 0;
                    while (n < this.numSubStatesArray[tag]) {
                        double prob;
                        this.iScore[start][end][tag][n] = prob = lexiconScores[n];
                        n = (short)(n + 1);
                    }
                }
                tag = (short)(tag + 1);
            }
            ++start;
        }
    }

    public Tree<String> getBestConstrainedParse(List<String> sentence, List<String> posTags, boolean[][][][] allowedS) {
        return this.getBestConstrainedParse(sentence, posTags);
    }

    public Tree<String> getBestConstrainedParse(List<String> sentence, List<String> posTags) {
        this.length = (short)sentence.size();
        this.noConstrains = true;
        this.createArrays();
        this.initializeChart(sentence);
        this.doConstrainedInsideScores();
        Tree<String> bestTree = new Tree<String>("ROOT");
        double score = this.iScore[0][this.length][0][0];
        if (score > Double.NEGATIVE_INFINITY) {
            Tree<StateSet> bestStateSetTree = this.extractBestStateSetTree(this.zero, this.zero, this.zero, this.length, sentence);
            bestTree = this.restoreStateSetTreeUnaries(bestStateSetTree);
        } else {
            System.out.println("()\nDid NOT find a parse for sentence with length " + this.length + ".");
        }
        return bestTree;
    }

    void doConstrainedInsideScores() {
        this.grammar.logarithmMode();
        this.lexicon.logarithmMode();
        int diff = 1;
        while (diff <= this.length) {
            System.out.print(String.valueOf(diff) + " ");
            int start = 0;
            while (start < this.length - diff + 1) {
                int pState;
                int end = start + diff;
                List<Object> possibleSt = null;
                if (this.noConstrains) {
                    possibleSt = new ArrayList();
                    int i = 0;
                    while (i < this.numStates) {
                        possibleSt.add(i);
                        ++i;
                    }
                } else {
                    possibleSt = this.possibleStates[start][end];
                }
                Iterator<Object> iterator = possibleSt.iterator();
                while (iterator.hasNext()) {
                    pState = (Integer)iterator.next();
                    BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                    int i = 0;
                    while (i < parentRules.length) {
                        boolean iPossibleL;
                        BinaryRule r = parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (iPossibleL) {
                            boolean iPossibleR;
                            int narrowL = this.narrowLExtent[end][rState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (iPossibleR) {
                                int min;
                                int min1 = narrowR;
                                int min2 = this.wideLExtent[end][rState];
                                int n = min = min1 > min2 ? min1 : min2;
                                if (min <= narrowL) {
                                    int max;
                                    int max1 = this.wideRExtent[start][lState];
                                    int max2 = narrowL;
                                    int n2 = max = max1 < max2 ? max1 : max2;
                                    if (min <= max) {
                                        double[][][] scores = r.getScores2();
                                        int nParentSubStates = this.numSubStatesArray[pState];
                                        int np = 0;
                                        while (np < nParentSubStates) {
                                            double oldIScore;
                                            double bestIScore = oldIScore = this.iScore[start][end][pState][np];
                                            int split = min;
                                            while (split <= max) {
                                                if (this.iScore[start][split][lState] != null && this.iScore[split][end][rState] != null) {
                                                    int lp = 0;
                                                    while (lp < scores.length) {
                                                        double lS = this.iScore[start][split][lState][lp];
                                                        if (lS != Double.NEGATIVE_INFINITY) {
                                                            int rp = 0;
                                                            while (rp < scores[0].length) {
                                                                ++this.nRules;
                                                                double pS = Double.NEGATIVE_INFINITY;
                                                                if (scores[lp][rp] != null) {
                                                                    pS = scores[lp][rp][np];
                                                                }
                                                                if (pS == Double.NEGATIVE_INFINITY) {
                                                                    ++this.nRulesInf;
                                                                } else {
                                                                    double tot;
                                                                    double rS = this.iScore[split][end][rState][rp];
                                                                    if (rS != Double.NEGATIVE_INFINITY && (tot = pS + lS + rS) >= bestIScore) {
                                                                        bestIScore = tot;
                                                                    }
                                                                }
                                                                ++rp;
                                                            }
                                                        }
                                                        ++lp;
                                                    }
                                                }
                                                ++split;
                                            }
                                            if (bestIScore > oldIScore) {
                                                this.iScore[start][end][pState][np] = bestIScore;
                                                if (oldIScore == Double.NEGATIVE_INFINITY) {
                                                    if (start > this.narrowLExtent[end][pState]) {
                                                        this.narrowLExtent[end][pState] = start;
                                                        this.wideLExtent[end][pState] = start;
                                                    } else if (start < this.wideLExtent[end][pState]) {
                                                        this.wideLExtent[end][pState] = start;
                                                    }
                                                    if (end < this.narrowRExtent[start][pState]) {
                                                        this.narrowRExtent[start][pState] = end;
                                                        this.wideRExtent[start][pState] = end;
                                                    } else if (end > this.wideRExtent[start][pState]) {
                                                        this.wideRExtent[start][pState] = end;
                                                    }
                                                }
                                            }
                                            ++np;
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                iterator = possibleSt.iterator();
                while (iterator.hasNext()) {
                    pState = (Integer)iterator.next();
                    UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(pState);
                    int r = 0;
                    while (r < unaries.length) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (this.iScore[start][end][cState] != null) {
                            double[][] scores = ur.getScores2();
                            int nParentSubStates = this.numSubStatesArray[pState];
                            int np = 0;
                            while (np < nParentSubStates) {
                                double oldIScore;
                                double bestIScore = oldIScore = this.iScore[start][end][pState][np];
                                int cp = 0;
                                while (cp < scores.length) {
                                    double pS = Double.NEGATIVE_INFINITY;
                                    if (scores[cp] != null) {
                                        pS = scores[cp][np];
                                    }
                                    ++this.nRules;
                                    if (pS == Double.NEGATIVE_INFINITY) {
                                        ++this.nRulesInf;
                                    } else {
                                        double tot;
                                        double iS = this.iScore[start][end][cState][cp];
                                        if (iS != Double.NEGATIVE_INFINITY && (tot = iS + pS) >= bestIScore) {
                                            bestIScore = tot;
                                        }
                                    }
                                    ++cp;
                                }
                                if (bestIScore > oldIScore) {
                                    this.iScore[start][end][pState][np] = bestIScore;
                                    if (oldIScore == Double.NEGATIVE_INFINITY) {
                                        if (start > this.narrowLExtent[end][pState]) {
                                            this.narrowLExtent[end][pState] = start;
                                            this.wideLExtent[end][pState] = start;
                                        } else if (start < this.wideLExtent[end][pState]) {
                                            this.wideLExtent[end][pState] = start;
                                        }
                                        if (end < this.narrowRExtent[start][pState]) {
                                            this.narrowRExtent[start][pState] = end;
                                            this.wideRExtent[start][pState] = end;
                                        } else if (end > this.wideRExtent[start][pState]) {
                                            this.wideRExtent[start][pState] = end;
                                        }
                                    }
                                }
                                ++np;
                            }
                        }
                        ++r;
                    }
                }
                ++start;
            }
            ++diff;
        }
    }

    void doConstrainedOutsideScores() {
        this.grammar.logarithmMode();
        this.lexicon.logarithmMode();
        int diff = this.length;
        while (diff >= 1) {
            int start = 0;
            while (start + diff <= this.length) {
                int pState;
                int end = start + diff;
                List<Object> possibleParentSt = null;
                if (this.noConstrains) {
                    possibleParentSt = new ArrayList();
                    int i = 0;
                    while (i < this.numStates) {
                        possibleParentSt.add(i);
                        ++i;
                    }
                } else {
                    possibleParentSt = this.possibleStates[start][end];
                }
                Iterator<Object> iterator = possibleParentSt.iterator();
                while (iterator.hasNext()) {
                    pState = (Integer)iterator.next();
                    UnaryRule[] rules = this.grammar.getClosedViterbiUnaryRulesByParent(pState);
                    int r = 0;
                    while (r < rules.length) {
                        UnaryRule ur = rules[r];
                        short cState = ur.childState;
                        if (this.oScore[start][end][cState] != null) {
                            double[][] scores = ur.getScores2();
                            int cp = 0;
                            while (cp < scores.length) {
                                double oldOScore;
                                double bestOScore = oldOScore = this.oScore[start][end][cState][cp];
                                double iS = this.iScore[start][end][cState][cp];
                                if (iS != Double.NEGATIVE_INFINITY) {
                                    int np = 0;
                                    while (np < scores[0].length) {
                                        double tot;
                                        double oS = this.oScore[start][end][pState][np];
                                        double pS = Double.NEGATIVE_INFINITY;
                                        if (scores[cp] != null) {
                                            pS = scores[cp][np];
                                        }
                                        if ((tot = oS + pS) > bestOScore) {
                                            bestOScore = tot;
                                        }
                                        ++np;
                                    }
                                    if (bestOScore > oldOScore) {
                                        this.oScore[start][end][cState][cp] = bestOScore;
                                    }
                                }
                                ++cp;
                            }
                        }
                        ++r;
                    }
                }
                pState = 0;
                while (pState < this.numStates) {
                    BinaryRule[] rules = this.grammar.splitRulesWithP(pState);
                    int r = 0;
                    while (r < rules.length) {
                        block28: {
                            int min;
                            int max;
                            short rState;
                            short lState;
                            BinaryRule br;
                            block29: {
                                int max1;
                                int min1;
                                br = rules[r];
                                if (this.oScore[start][end][br.parentState] == null || end < (min1 = this.narrowRExtent[start][lState = br.leftChildState]) || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) break block28;
                                max = max1;
                                min = min1;
                                if (max - min <= 2) break block29;
                                int min2 = this.wideLExtent[end][rState];
                                int n = min = min1 > min2 ? min1 : min2;
                                if (max1 < min) break block28;
                                int max2 = this.wideRExtent[start][lState];
                                int n2 = max = max1 < max2 ? max1 : max2;
                                if (max < min) break block28;
                            }
                            double[][][] scores = br.getScores2();
                            int split = min;
                            while (split <= max) {
                                if (this.oScore[start][split][lState] != null && this.oScore[split][end][rState] != null) {
                                    int lp = 0;
                                    while (lp < scores.length) {
                                        double lS = this.iScore[start][split][lState][lp];
                                        if (lS != Double.NEGATIVE_INFINITY) {
                                            int rp = 0;
                                            while (rp < scores[lp].length) {
                                                double rS = this.iScore[split][end][rState][rp];
                                                if (rS != Double.NEGATIVE_INFINITY && scores[lp][rp] != null) {
                                                    int np = 0;
                                                    while (np < scores[lp][rp].length) {
                                                        double totR;
                                                        double pS = scores[lp][rp][np];
                                                        double oS = this.oScore[start][end][br.parentState][np];
                                                        double totL = pS + rS + oS;
                                                        if (totL > this.oScore[start][split][lState][lp]) {
                                                            this.oScore[start][split][lState][lp] = totL;
                                                        }
                                                        if ((totR = pS + lS + oS) > this.oScore[split][end][rState][rp]) {
                                                            this.oScore[split][end][rState][rp] = totR;
                                                        }
                                                        ++np;
                                                    }
                                                }
                                                ++rp;
                                            }
                                        }
                                        ++lp;
                                    }
                                }
                                ++split;
                            }
                        }
                        ++r;
                    }
                    ++pState;
                }
                ++start;
            }
            --diff;
        }
    }

    public void showScores(double[][][][] scores, String title) {
        System.out.println(title);
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                System.out.print("[" + start + " " + end + "]: ");
                List<Object> possibleSt = null;
                if (this.noConstrains) {
                    possibleSt = new ArrayList();
                    int i = 0;
                    while (i < this.numStates) {
                        possibleSt.add(i);
                        ++i;
                    }
                } else {
                    possibleSt = this.possibleStates[start][end];
                }
                Iterator<Object> iterator = possibleSt.iterator();
                while (iterator.hasNext()) {
                    int state = (Integer)iterator.next();
                    if (scores[start][end][state] == null) continue;
                    int s = 0;
                    while (s < this.grammar.numSubStates[state]) {
                        Numberer n = this.grammar.tagNumberer;
                        System.out.print("(" + StringUtils.escapeString(n.object(state).toString(), new char[]{'\"'}, '\\') + "[" + s + "] " + scores[start][end][state][s] + ")");
                        ++s;
                    }
                }
                System.out.println();
                ++start;
            }
            ++diff;
        }
    }

    public Tree<String> extractBestParse(int gState, int gp, int start, int end, List<String> sentence) {
        double bestScore = this.iScore[start][end][gState][gp];
        String goalStr = (String)this.tagNumberer.object(gState);
        if (end - start == 1) {
            if (!this.grammar.isGrammarTag[gState]) {
                ArrayList child = new ArrayList();
                child.add(new Tree<String>(sentence.get(start)));
                return new Tree<String>(goalStr, child);
            }
            double veryBestScore = Double.NEGATIVE_INFINITY;
            int newIndex = -1;
            UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
            int r = 0;
            while (r < unaries.length) {
                UnaryRule ur = unaries[r];
                short cState = ur.childState;
                double[][] scores = ur.getScores2();
                int cp = 0;
                while (cp < scores.length) {
                    double ruleScore;
                    if (scores[cp] != null && (ruleScore = this.iScore[start][end][cState][cp] + scores[cp][gp]) >= veryBestScore && (gState != cState || gp != cp) && !this.grammar.isGrammarTag[ur.getChildState()]) {
                        veryBestScore = ruleScore;
                        newIndex = cState;
                    }
                    ++cp;
                }
                ++r;
            }
            ArrayList child1 = new ArrayList();
            child1.add(new Tree<String>(sentence.get(start)));
            String goalStr1 = (String)this.tagNumberer.object(newIndex);
            if (goalStr1 == null) {
                System.out.println("goalStr1==null with newIndex==" + newIndex + " goalStr==" + goalStr);
            }
            ArrayList child = new ArrayList();
            child.add(new Tree<String>(goalStr1, child1));
            return new Tree<String>(goalStr, child);
        }
        int split = start + 1;
        while (split < end) {
            BinaryRule[] parentRules = this.grammar.splitRulesWithP(gState);
            int i = 0;
            while (i < parentRules.length) {
                short rState;
                BinaryRule br = parentRules[i];
                short lState = br.leftChildState;
                if (this.iScore[start][split][lState] != null && this.iScore[split][end][rState = br.rightChildState] != null) {
                    double[][][] scores = br.getScores2();
                    int lp = 0;
                    while (lp < scores.length) {
                        int rp = 0;
                        while (rp < scores[lp].length) {
                            double score;
                            if (scores[lp][rp] != null && this.matches(score = scores[lp][rp][gp] + this.iScore[start][split][lState][lp] + this.iScore[split][end][rState][rp], bestScore)) {
                                Tree<String> leftChildTree = this.extractBestParse(lState, lp, start, split, sentence);
                                Tree<String> rightChildTree = this.extractBestParse(rState, rp, split, end, sentence);
                                ArrayList children = new ArrayList();
                                children.add(leftChildTree);
                                children.add(rightChildTree);
                                Tree<String> result = new Tree<String>(goalStr, children);
                                return result;
                            }
                            ++rp;
                        }
                        ++lp;
                    }
                }
                ++i;
            }
            ++split;
        }
        UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
        int r = 0;
        while (r < unaries.length) {
            UnaryRule ur = unaries[r];
            short cState = ur.childState;
            if (this.iScore[start][end][cState] != null) {
                double[][] scores = ur.getScores2();
                int cp = 0;
                while (cp < scores.length) {
                    if (scores[cp] != null) {
                        double score = scores[cp][gp] + this.iScore[start][end][cState][cp];
                        if ((cState != ur.parentState || cp != gp) && this.matches(score, bestScore)) {
                            Tree<String> childTree = this.extractBestParse(cState, cp, start, end, sentence);
                            ArrayList children = new ArrayList();
                            children.add(childTree);
                            Tree<String> result = new Tree<String>(goalStr, children);
                            return result;
                        }
                    }
                    ++cp;
                }
            }
            ++r;
        }
        System.err.println("Warning: could not find the optimal way to build state " + goalStr + " spanning from " + start + " to " + end + ".");
        return null;
    }

    public Tree<StateSet> extractBestStateSetTree(short gState, short gp, short start, short end, List<String> sentence) {
        Object scores;
        double bestScore = this.iScore[start][end][gState][gp];
        if (end - start == 1) {
            if (!this.grammar.isGrammarTag(gState)) {
                ArrayList child = new ArrayList();
                StateSet node = new StateSet(this.zero, this.zero, sentence.get(start), start, end);
                child.add(new Tree<StateSet>(node));
                StateSet root = new StateSet(gState, this.one, null, start, end);
                root.allocate();
                root.setIScore(0, gp);
                return new Tree<StateSet>(root, child);
            }
            double veryBestScore = Double.NEGATIVE_INFINITY;
            short newIndex = -1;
            short newSubstate = -1;
            UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
            int r = 0;
            while (r < unaries.length) {
                UnaryRule ur = unaries[r];
                short cState = ur.childState;
                double[][] scores2 = ur.getScores2();
                short cp = 0;
                while (cp < scores2.length) {
                    double ruleScore;
                    if (scores2[cp] != null && this.iScore[start][end][cState] != null && (ruleScore = this.iScore[start][end][cState][cp] + scores2[cp][gp]) >= veryBestScore && (gState != cState || gp != cp) && !this.grammar.isGrammarTag(cState)) {
                        veryBestScore = ruleScore;
                        newIndex = cState;
                        newSubstate = cp;
                    }
                    cp = (short)(cp + 1);
                }
                ++r;
            }
            ArrayList child1 = new ArrayList();
            StateSet node1 = new StateSet(this.zero, this.zero, sentence.get(start), start, end);
            child1.add(new Tree<StateSet>(node1));
            if (newIndex == -1) {
                System.out.println("goalStr1==null with newIndex==" + newIndex + " goalState==" + gState);
            }
            ArrayList child = new ArrayList();
            StateSet node = new StateSet(newIndex, this.one, null, start, end);
            node.allocate();
            node.setIScore(0, newSubstate);
            child.add(new Tree<StateSet>(node, child1));
            StateSet root = new StateSet(gState, this.one, null, start, end);
            root.allocate();
            root.setIScore(0, gp);
            return new Tree<StateSet>(root, child);
        }
        double bestBScore = Double.NEGATIVE_INFINITY;
        int split = start + 1;
        while (split < end) {
            BinaryRule[] parentRules = this.grammar.splitRulesWithP(gState);
            int i = 0;
            while (i < parentRules.length) {
                short rState;
                BinaryRule br = parentRules[i];
                short lState = br.leftChildState;
                if (this.iScore[start][split][lState] != null && this.iScore[split][end][rState = br.rightChildState] != null) {
                    scores = br.getScores2();
                    short lp = 0;
                    while (lp < ((double[][])scores).length) {
                        short rp = 0;
                        while (rp < scores[lp].length) {
                            if (scores[lp][rp] != null) {
                                void score = scores[lp][rp][gp] + this.iScore[start][split][lState][lp] + this.iScore[split][end][rState][rp];
                                if (score > bestBScore) {
                                    bestBScore = score;
                                }
                                if (this.matches((double)score, bestScore)) {
                                    Tree<StateSet> leftChildTree = this.extractBestStateSetTree(lState, lp, start, (short)split, sentence);
                                    Tree<StateSet> rightChildTree = this.extractBestStateSetTree(rState, rp, (short)split, end, sentence);
                                    ArrayList children = new ArrayList();
                                    children.add(leftChildTree);
                                    children.add(rightChildTree);
                                    StateSet root = new StateSet(gState, this.one, null, start, end);
                                    root.allocate();
                                    root.setIScore(0, gp);
                                    Tree<StateSet> result = new Tree<StateSet>(root, children);
                                    return result;
                                }
                            }
                            rp = (short)(rp + 1);
                        }
                        lp = (short)(lp + 1);
                    }
                }
                i = (short)(i + 1);
            }
            ++split;
        }
        double bestUScore = Double.NEGATIVE_INFINITY;
        UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
        int r = 0;
        while (r < unaries.length) {
            UnaryRule ur = unaries[r];
            short cState = ur.childState;
            if (this.iScore[start][end][cState] != null) {
                scores = ur.getScores2();
                short cp = 0;
                while (cp < ((double[][])scores).length) {
                    if (scores[cp] != null) {
                        double rScore = scores[cp][gp];
                        double score = rScore + this.iScore[start][end][cState][cp];
                        if (score > bestUScore) {
                            bestUScore = score;
                        }
                        if ((cState != ur.parentState || cp != gp) && this.matches(score, bestScore)) {
                            Tree<StateSet> childTree = this.extractBestStateSetTree(cState, cp, start, end, sentence);
                            ArrayList children = new ArrayList();
                            children.add(childTree);
                            StateSet root = new StateSet(gState, this.one, null, start, end);
                            root.allocate();
                            root.setIScore(0, gp);
                            Tree<StateSet> result = new Tree<StateSet>(root, children);
                            ++this.totalUsedUnaries;
                            return result;
                        }
                    }
                    cp = (short)(cp + 1);
                }
            }
            r = (short)(r + 1);
        }
        System.err.println("Warning: could not find the optimal way to build state " + gState + " spanning from " + start + " to " + end + ".");
        System.err.println("The goal score was " + bestScore + ", but the best we found was a binary rule giving " + bestBScore + " and a unary rule giving " + bestUScore);
        this.showScores(this.iScore, "iScores");
        return null;
    }

    protected Tree<String> restoreStateSetTreeUnaries(Tree<StateSet> t) {
        Tree<String> result;
        if (t.isLeaf()) {
            System.err.println("Tried to restore unary from a leaf...");
            return null;
        }
        if (t.isPreTerminal()) {
            ArrayList child = new ArrayList();
            child.add(new Tree<String>(t.getChildren().get(0).getLabel().getWord()));
            return new Tree<String>((String)this.tagNumberer.object(t.getLabel().getState()), child);
        }
        if (t.getChildren().size() != 1) {
            Tree<String> leftChildTree = this.restoreStateSetTreeUnaries(t.getChildren().get(0));
            Tree<String> rightChildTree = this.restoreStateSetTreeUnaries(t.getChildren().get(1));
            ArrayList children = new ArrayList();
            children.add(leftChildTree);
            children.add(rightChildTree);
            return new Tree<String>((String)this.tagNumberer.object(t.getLabel().getState()), children);
        }
        StateSet parent = t.getLabel();
        StateSet child = t.getChildren().get(0).getLabel();
        short pLabel = parent.getState();
        short pSubState = (short)parent.getIScore(0);
        short cLabel = child.getState();
        short cSubState = (short)child.getIScore(0);
        ArrayList goodChild = new ArrayList();
        goodChild.add(this.restoreStateSetTreeUnaries(t.getChildren().get(0)));
        Tree<String> working = result = new Tree<String>((String)this.tagNumberer.object(pLabel), goodChild);
        return working;
    }

    public double[][][][] getInsideScores() {
        return ArrayUtil.clone(this.iScore);
    }

    public double[][][][] getOutsideScores() {
        return ArrayUtil.clone(this.oScore);
    }

    public void printUnaryStats() {
        System.out.println(" Used a total of " + this.totalUsedUnaries + " unary productions.");
        System.out.println(" restored unaries " + this.nTimesRestoredUnaries);
        System.out.println(" Out of " + this.nRules + " rules " + this.nRulesInf + " had probability=-Inf.");
    }

    public void projectConstraints(boolean[][][][] allowed, boolean allSubstatesAllowed) {
        System.err.println("Not supported!\nThis parser cannot project constraints!");
    }

    public short[] getNumSubStatesArray() {
        return this.numSubStatesArray;
    }
}

