/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.io.PennTreebankReader;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Counter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Corpus {
    public static TreeBankType myTreebank = TreeBankType.WSJ;
    ArrayList<Tree<String>> trainTrees = new ArrayList();
    ArrayList<Tree<String>> validationTrees = new ArrayList();
    ArrayList<Tree<String>> devTestTrees = new ArrayList();
    ArrayList<Tree<String>> finalTestTrees = new ArrayList();

    public Corpus(String path, TreeBankType treebank, double fraction, boolean onlyTest) {
        this(path, treebank, fraction, onlyTest, -1, false);
    }

    public Corpus(String path, TreeBankType treebank, double fraction, boolean onlyTest, int skipSection, boolean skipBilingual) {
        this(path, treebank, onlyTest, skipSection, skipBilingual);
        int beforeSize = this.trainTrees.size();
        if (fraction < 0.0) {
            int startIndex = (int)Math.ceil((double)beforeSize * -1.0 * fraction);
            this.trainTrees = new ArrayList<Tree<String>>(this.trainTrees.subList(startIndex, this.trainTrees.size()));
        } else if (fraction < 1.0) {
            int endIndex = (int)Math.ceil((double)beforeSize * fraction);
            this.trainTrees = new ArrayList<Tree<String>>(this.trainTrees.subList(0, endIndex));
        }
        int nTrainingWords = 0;
        for (Tree<String> tree : this.trainTrees) {
            nTrainingWords += tree.getYield().size();
        }
        System.out.println("In training set we have # of words: " + nTrainingWords);
        int afterSize = this.trainTrees.size();
        System.out.println("reducing number of training trees from " + beforeSize + " to " + afterSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Corpus(String path, TreeBankType treebank, boolean onlyTest, int skipSection, boolean skipBilingual) {
        boolean dummy;
        myTreebank = treebank;
        boolean bl = dummy = path == null;
        if (dummy) {
            System.out.println("Loading one dummy sentence into training set only.");
            int exampleNumber = 6;
            ArrayList<String> sentences = new ArrayList<String>();
            switch (exampleNumber) {
                case 0: {
                    sentences.add("((S (A x) (C x)))");
                    sentences.add("((S (E x) (B x)))");
                    break;
                }
                case 1: {
                    sentences.add("((S (NP (NP (DT The) (JJ complicated) (NN language)) (PP (IN in) (NP (DT the) (JJ huge) (JJ new) (NN law)))) (VP (VBZ has) (VP (VBD muddied) (NP (DT the) (NN fight)))) (. .)))");
                    break;
                }
                case 2: {
                    sentences.add("((S (Z1 (Z2 x) (NNPS x)) (U3 (Uu (A1 (NNP x1) (NNPS x2))))))");
                    sentences.add("((S (K (U2 (Z1 (Z2 x) (NNP x)))) (U7 (NNS x))))");
                    sentences.add("((S (Z1 (NNPS x) (NN x)) (F (CC y) (ZZ z))))");
                    break;
                }
                case 3: {
                    sentences.add("((X (C (B b) (B b)) (F (E (D d)))))");
                    sentences.add("((Y (C (B a) (B a)) (E (D d))))");
                    sentences.add("((X (C (B b) (B b)) (E (D d))))");
                    break;
                }
                case 4: {
                    sentences.add("( (S (SBAR (IN In) (NN order) (S (VP (TO to) (VP (VB strengthen) (NP (NP (JJ cultural) (NN exchange) (CC and) (NN contact)) (PP (IN between) (NP (NP (NP (DT the) (NNS descendents)) (PP (IN of) (NP (DT the) (NNPS Emperors)))) (UCP (PP (IN at) (NP (NN home))) (CC and) (ADVP (RB abroad)))))))))) (, ,) (NP (NNP China)) (VP (MD will) (VP (VB hold) (NP (DT the) (JJ \") (NNP China) (NNP Art) (NNP Festival) (NN \")) (PP (IN in) (NP (NP (NNP Beijing)) (CC and) (NNP Shenzhen))) (ADVP (RB simultaneously)) (PP (IN from) (NP (DT the) (NN 8th))) (PP (TO to) (NP (NP (DT the) (JJ 18th)) (PP (IN of) (NP (NNP December))))) (NP (DT this) (NN year)))) (. .)) )");
                    sentences.add("( (S (PP (IN In) (NP (NP (NN order) (S (VP (TO to) (VP (VB strengthen) (NP (NP (JJ cultural) (NN exchange) (CC and) (NN contact)) (PP (IN between) (NP (NP (DT the) (NNS descendents)) (PP (IN of) (NP (DT the) (NNPS Emperors))) (PP (IN at) (NP (NN home)))))))))) (CC and) (ADVP (RB abroad)))) (, ,) (NP (NNP China)) (VP (MD will) (VP (VB hold) (NP (DT the) (JJ \") (NNP China) (NNP Art) (NNP Festival) (NN \")) (PP (IN in) (NP (NP (NNP Beijing)) (CC and) (NNP Shenzhen))) (ADVP (RB simultaneously)) (PP (IN from) (NP (DT the) (NN 8th))) (PP (TO to) (NP (NP (DT the) (JJ 18th)) (PP (IN of) (NP (NNP December))))) (NP (DT this) (NN year)))) (. .)) )");
                    sentences.add("( (S (PP (IN In) (NP (NN order) (S (VP (TO to) (VP (VB strengthen) (NP (NP (JJ cultural) (NN exchange) (CC and) (NN contact)) (PP (IN between) (NP (NP (DT the) (NNS descendents)) (PP (IN of) (NP (DT the) (NNPS Emperors)))))) (UCP (PP (IN at) (ADVP (RB home))) (CC and) (ADVP (RB abroad)))))))) (, ,) (NP (NNP China)) (VP (MD will) (VP (VB hold) (NP (DT the) (`` \") (NNP China) (NNP Art) (NNP Festival) (NN \")) (PP (IN in) (NP (NNP Beijing) (CC and) (NNP Shenzhen))) (ADVP (RB simultaneously)) (PP (PP (IN from) (NP (DT the) (NN 8th))) (PP (IN to) (NP (DT the) (NN 18th))) (PP (IN of) (NP (NNP December)))) (NP (DT this) (NN year)))) (. .)) )");
                    break;
                }
                case 5: {
                    sentences.add("((X (C (B a) (B a)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (E (D d) (D d))))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (E (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    break;
                }
                case 6: {
                    sentences.add("((Y (C (B @) (B b)) (E (D d) (D d))))");
                    sentences.add("((Y (C (B b) (D b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (U (C (B b) (B b))) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    break;
                }
                case 7: {
                    sentences.add("((X (S (NP (X (PRP I))) (VP like))))");
                    sentences.add("((X (C (U (V (W (B a) (B a))))) (D d)))");
                    sentences.add("((X (Y (Z (V (C (B a) (B a))) (D d)))))");
                    sentences.add("((X (C (B a) (B a)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (E (D d) (D d))))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (U (C (B b) (B b))) (D d)))");
                    sentences.add("((Y (E (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                    sentences.add("((Y (C (B b) (B b)) (D d)))");
                }
            }
            for (String sentence : sentences) {
                Tree normalizedTree;
                Trees.PennTreeReader reader = new Trees.PennTreeReader(new StringReader(sentence));
                Tree tree = reader.next();
                Trees.StandardTreeNormalizer treeTransformer = new Trees.StandardTreeNormalizer();
                tree = normalizedTree = treeTransformer.transformTree(tree);
                this.trainTrees.add(tree);
                this.devTestTrees.add(tree);
                this.validationTrees.add(tree);
            }
            return;
        } else {
            try {
                if (myTreebank == TreeBankType.CHINESE) {
                    System.out.println("Loading CHINESE data!");
                    this.loadChinese(path, skipBilingual);
                    return;
                }
                if (myTreebank == TreeBankType.WSJ) {
                    System.out.println("Loading ENGLISH WSJ data!");
                    this.loadWSJ(path, onlyTest, skipSection);
                    return;
                }
                if (myTreebank == TreeBankType.GERMAN) {
                    System.out.println("Loading GERMAN data!");
                    this.loadGerman(path);
                    return;
                }
                if (myTreebank == TreeBankType.BROWN) {
                    System.out.println("Loading BROWN data!");
                    this.loadBrown(path);
                    return;
                }
                if (myTreebank == TreeBankType.SPANISH) {
                    System.out.println("Loading SPANISH data!");
                    this.loadSpanish(path);
                    return;
                }
                if (myTreebank == TreeBankType.FRENCH) {
                    System.out.println("Loading FRENCH data!");
                    this.loadCONLL(path, true);
                    return;
                }
                if (myTreebank == TreeBankType.CONLL) {
                    System.out.println("Loading CoNLL converted data!");
                    this.loadCONLL(path, false);
                    return;
                }
                if (myTreebank != TreeBankType.SINGLEFILE) return;
                System.out.println("Loading data from single file!");
                this.loadSingleFile(path);
                return;
            }
            catch (Exception e) {
                System.out.println("Error loading trees!");
                System.out.println(e.getStackTrace().toString());
                throw new Error(e.getMessage(), e);
            }
        }
    }

    private void loadChinese(String pathChinese, boolean skipBilingual) throws Exception {
        System.out.print("Loading Chinese treebank trees...");
        if (!skipBilingual) {
            this.trainTrees.addAll(Corpus.readTrees(pathChinese, 1, 25, Charset.forName("GB18030")));
            this.trainTrees.addAll(Corpus.readTrees(pathChinese, 26, 270, Charset.forName("GB18030")));
        }
        this.trainTrees.addAll(Corpus.readTrees(pathChinese, 400, 1151, Charset.forName("GB18030")));
        this.devTestTrees.addAll(Corpus.readTrees(pathChinese, 301, 325, Charset.forName("GB18030")));
        this.validationTrees.addAll(Corpus.readTrees(pathChinese, 301, 325, Charset.forName("GB18030")));
        this.finalTestTrees.addAll(Corpus.readTrees(pathChinese, 271, 300, Charset.forName("GB18030")));
        System.out.print(this.trainTrees.size() + " " + this.validationTrees.size() + " " + this.devTestTrees.size() + " " + this.finalTestTrees.size() + " trees...");
        System.out.println("done");
    }

    private void loadBrown(String pathBrown) throws Exception {
        String[] sections = new String[]{"cf", "cg", "ck", "cl", "cm", "cn", "cp", "cr"};
        int[] sectionTrainCounts = new int[sections.length];
        int i = 0;
        while (i < sections.length) {
            ArrayList<Tree<String>> sectionTrainTrees = new ArrayList<Tree<String>>();
            ArrayList<Tree<String>> sectionValidationTrees = new ArrayList<Tree<String>>();
            ArrayList<Tree<String>> sectionDevTestTrees = new ArrayList<Tree<String>>();
            ArrayList<Tree<String>> sectionFinalTestTrees = new ArrayList<Tree<String>>();
            String sectionPath = String.valueOf(pathBrown) + "/" + sections[i];
            List<Tree<String>> sectionTrees = Corpus.readTrees(sectionPath, 0, 1000, Charset.defaultCharset());
            Corpus.splitTrainValidTest(sectionTrees, sectionTrainTrees, sectionValidationTrees, sectionDevTestTrees, sectionFinalTestTrees);
            this.trainTrees.addAll(sectionTrainTrees);
            this.validationTrees.addAll(sectionValidationTrees);
            this.devTestTrees.addAll(sectionDevTestTrees);
            this.finalTestTrees.addAll(sectionFinalTestTrees);
            sectionTrainCounts[i] = sectionTrainTrees.size();
            System.out.println("I read " + sectionTrainCounts[i] + " training trees from section " + sections[i]);
            ++i;
        }
    }

    private void loadSpanish(String path) throws Exception {
        System.out.print("Loading Spanish trees...");
        this.trainTrees.addAll(Corpus.readTrees(path, 1, 1, Charset.defaultCharset()));
        this.validationTrees.addAll(Corpus.readTrees(path, 2, 279, Charset.defaultCharset()));
        this.devTestTrees.addAll(Corpus.readTrees(path, 2, 279, Charset.defaultCharset()));
        this.finalTestTrees.addAll(Corpus.readTrees(path, 2, 279, Charset.defaultCharset()));
        System.out.println("done");
    }

    private void loadSingleFile(String path) throws Exception {
        System.out.print("Loading trees from single file...");
        InputStreamReader inputData = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
        Trees.PennTreeReader treeReader = new Trees.PennTreeReader(inputData);
        while (treeReader.hasNext()) {
            this.trainTrees.add((Tree<String>)treeReader.next());
        }
        Trees.StandardTreeNormalizer treeTransformer = new Trees.StandardTreeNormalizer();
        ArrayList<Tree<String>> normalizedTreeList = new ArrayList<Tree<String>>();
        for (Tree<String> tree : this.trainTrees) {
            Tree<String> normalizedTree = treeTransformer.transformTree(tree);
            normalizedTreeList.add(normalizedTree);
        }
        if (normalizedTreeList.size() == 0) {
            throw new Exception("failed to load any trees at " + path);
        }
        this.trainTrees = normalizedTreeList;
        this.devTestTrees = this.trainTrees;
        System.out.println("done");
    }

    private void loadCONLL(String path, boolean useLatinEncoding) throws Exception {
        Charset charSet = useLatinEncoding ? Charset.forName("ISO8859_1") : Charset.forName("UTF-8");
        System.out.print("Loading CoNLL trees...");
        this.trainTrees = this.readAndPreprocessTrees(path, 1, 1, charSet);
        this.validationTrees = this.readAndPreprocessTrees(path, 2, 2, charSet);
        this.devTestTrees = this.readAndPreprocessTrees(path, 2, 2, charSet);
        this.finalTestTrees = this.readAndPreprocessTrees(path, 3, 3, charSet);
        for (Tree<String> t : this.trainTrees) {
            if (t.getChildren().size() == 1) continue;
            System.out.println("Malformed v: " + t);
        }
        for (Tree<String> t : this.devTestTrees) {
            if (t.getChildren().size() == 1) continue;
            System.out.println("Malformed v: " + t);
        }
        for (Tree<String> t : this.finalTestTrees) {
            if (t.getChildren().size() == 1) continue;
            System.out.println("Malformed t: " + t);
        }
        System.out.println("done");
    }

    private ArrayList<Tree<String>> readAndPreprocessTrees(String path, int i, int j, Charset charSet) throws Exception {
        ArrayList<Tree<String>> tmp = new ArrayList<Tree<String>>();
        ArrayList<Tree<String>> tmp2 = new ArrayList<Tree<String>>();
        tmp.addAll(Corpus.readTrees(path, i, j, charSet));
        for (Tree<String> t : tmp) {
            if (!t.getLabel().equals("ROOT")) {
                Tree<String> rootedTree;
                ArrayList childrenList = new ArrayList(1);
                childrenList.add(t);
                t = rootedTree = new Tree<String>("ROOT", childrenList);
            }
            tmp2.add(t);
        }
        return tmp2;
    }

    private void loadWSJ(String pathWSJ, boolean onlyTest, int skipSection) throws Exception {
        System.out.print("Loading WSJ trees...");
        if (!onlyTest) {
            if (skipSection == -1) {
                this.trainTrees.addAll(Corpus.readTrees(pathWSJ, 200, 2199, Charset.defaultCharset()));
            } else {
                System.out.println("Skipping section " + skipSection + ".");
                if (skipSection == 2) {
                    this.trainTrees.addAll(Corpus.readTrees(pathWSJ, 300, 2199, Charset.defaultCharset()));
                } else if (skipSection == 21) {
                    this.trainTrees.addAll(Corpus.readTrees(pathWSJ, 200, 2099, Charset.defaultCharset()));
                } else {
                    int middle = skipSection * 100;
                    this.trainTrees.addAll(Corpus.readTrees(pathWSJ, 200, middle - 1, Charset.defaultCharset()));
                    this.trainTrees.addAll(Corpus.readTrees(pathWSJ, middle + 100, 2199, Charset.defaultCharset()));
                }
            }
            this.validationTrees.addAll(Corpus.readTrees(pathWSJ, 2100, 2199, Charset.defaultCharset()));
        }
        this.devTestTrees.addAll(Corpus.readTrees(pathWSJ, 2200, 2299, Charset.defaultCharset()));
        this.finalTestTrees.addAll(Corpus.readTrees(pathWSJ, 2300, 2399, Charset.defaultCharset()));
        System.out.println("done");
    }

    private void loadGerman(String path) throws Exception {
        System.out.print("Loading German trees...");
        List<Tree<String>> tmp = Corpus.readTrees(path, 1, 3, Charset.forName("UTF-8"));
        int i = 0;
        for (Tree<String> tree : tmp) {
            ArrayList childrenList = new ArrayList(1);
            tree.setLabel("PSEUDO");
            childrenList.add(tree);
            Tree<String> rootedTree = new Tree<String>("ROOT", childrenList);
            tree = rootedTree;
            if (i < 18602) {
                this.trainTrees.add(tree);
            } else if (i > 19601) {
                this.finalTestTrees.add(tree);
            } else {
                this.validationTrees.add(tree);
                this.devTestTrees.add(tree);
            }
            ++i;
        }
        System.out.println("done.\nThere are " + this.trainTrees.size() + " " + this.devTestTrees.size() + " " + this.finalTestTrees.size() + " trees.");
    }

    public static List<Tree<String>> readTrees(String basePath, int low, int high, Charset charset) throws Exception {
        Collection<Tree<String>> trees = PennTreebankReader.readTrees(basePath, low, high, charset);
        Trees.StandardTreeNormalizer treeTransformer = new Trees.StandardTreeNormalizer();
        ArrayList<Tree<String>> normalizedTreeList = new ArrayList<Tree<String>>();
        for (Tree<String> tree : trees) {
            Tree<String> normalizedTree = treeTransformer.transformTree(tree);
            normalizedTreeList.add(normalizedTree);
        }
        if (normalizedTreeList.size() == 0) {
            throw new Exception("failed to load any trees at " + basePath + " from " + low + " to " + high);
        }
        return normalizedTreeList;
    }

    public static void splitTrainValidTest(List<Tree<String>> sectionTrees, List<Tree<String>> trainTrees, List<Tree<String>> validationTrees, List<Tree<String>> devTestTrees, List<Tree<String>> finalTestTrees) {
        int CYCLE_SIZE = 10;
        int i = 0;
        while (i < sectionTrees.size()) {
            if (i % 10 < 7) {
                trainTrees.add(sectionTrees.get(i));
            } else if (i % 10 == 7) {
                validationTrees.add(sectionTrees.get(i));
            } else if (i % 10 == 8) {
                devTestTrees.add(sectionTrees.get(i));
            } else if (i % 10 == 9) {
                finalTestTrees.add(sectionTrees.get(i));
            }
            ++i;
        }
    }

    public static List<Tree<String>> filterTreesForConditional(List<Tree<String>> trees, boolean filterAllUnaries, boolean filterStupidFrickinWHNP, boolean justCollapseUnaryChains) {
        ArrayList<Tree<String>> filteredTrees = new ArrayList<Tree<String>>(trees.size());
        block0: for (Tree<String> tree : trees) {
            if (tree.getYield().size() == 1) continue;
            if (tree.hasUnaryChain()) {
                if (!justCollapseUnaryChains) continue;
                tree.removeUnaryChains();
            }
            if (filterStupidFrickinWHNP) {
                for (Tree<String> n : tree.getNonTerminals()) {
                    if (n.getLabel().contains("WHNP")) continue block0;
                }
            }
            if (filterAllUnaries && tree.hasUnariesOtherThanRoot()) continue;
            filteredTrees.add(tree);
        }
        return filteredTrees;
    }

    public static List<Tree<String>> binarizeAndFilterTrees(List<Tree<String>> trees, int verticalAnnotations, int horizontalAnnotations, int sentenceMaxLength, Binarization binarization, boolean manualAnnotation, boolean VERBOSE) {
        return Corpus.binarizeAndFilterTrees(trees, verticalAnnotations, horizontalAnnotations, sentenceMaxLength, binarization, manualAnnotation, VERBOSE, false);
    }

    public static List<Tree<String>> binarizeAndFilterTrees(List<Tree<String>> trees, int verticalAnnotations, int horizontalAnnotations, int sentenceMaxLength, Binarization binarization, boolean manualAnnotation, boolean VERBOSE, boolean markUnaryParents) {
        ArrayList<Tree<String>> binarizedTrees = new ArrayList<Tree<String>>();
        System.out.print("Binarizing and annotating trees...");
        if (VERBOSE) {
            System.out.println("annotation levels: vertical=" + verticalAnnotations + " horizontal=" + horizontalAnnotations);
        }
        int i = 0;
        for (Tree<String> tree : trees) {
            List<String> testSentence = tree.getYield();
            ++i;
            if (testSentence.size() > sentenceMaxLength) continue;
            binarizedTrees.add(TreeAnnotations.processTree(tree, verticalAnnotations, horizontalAnnotations, binarization, manualAnnotation, markUnaryParents, true));
        }
        System.out.print("done.\n");
        return binarizedTrees;
    }

    public List<Tree<String>> getTrainTrees() {
        return this.trainTrees;
    }

    public List<Tree<String>> getValidationTrees() {
        return this.validationTrees;
    }

    public List<Tree<String>> getDevTestingTrees() {
        return this.devTestTrees;
    }

    public List<Tree<String>> getFinalTestingTrees() {
        return this.finalTestTrees;
    }

    public static List<Tree<String>> makePosTrees(List<Tree<String>> trees) {
        System.out.print("Making POS-trees...");
        ArrayList<Tree<String>> posTrees = new ArrayList<Tree<String>>();
        for (Tree<String> tree : trees) {
            posTrees.add(Corpus.makePosTree(tree));
        }
        System.out.print(" done.\n");
        return posTrees;
    }

    public static Tree<String> makePosTree(Tree<String> tree) {
        Tree<String> tmpTree;
        List<Tree<String>> terminals = tree.getTerminals();
        List<String> preTerminals = tree.getPreTerminalYield();
        int n = preTerminals.size();
        String label = "STOP";
        ArrayList tmpChildList = new ArrayList();
        tmpChildList.add(new Tree<String>(label));
        Tree<String> posTree = tmpTree = new Tree<String>(label, tmpChildList);
        int i = n - 1;
        while (i >= 0) {
            label = preTerminals.get(i);
            tmpChildList = new ArrayList();
            tmpChildList.add(terminals.get(i));
            tmpTree = new Tree<String>(label, tmpChildList);
            tmpChildList = new ArrayList();
            tmpChildList.add(tmpTree);
            tmpChildList.add(posTree);
            posTree = new Tree<String>(label, tmpChildList);
            --i;
        }
        tmpChildList = new ArrayList();
        tmpChildList.add(posTree);
        posTree = new Tree<String>(tree.getLabel(), tmpChildList);
        return posTree;
    }

    public static void replaceRareWords(StateSetTreeList trainTrees, SimpleLexicon lexicon, int threshold) {
        List<StateSet> words;
        Counter<String> wordCounts = new Counter<String>();
        for (Tree<StateSet> tree : trainTrees) {
            words = tree.getYield();
            for (StateSet word : words) {
                String wordString = word.getWord();
                wordCounts.incrementCount(wordString, 1.0);
                lexicon.wordIndexer.add(wordString);
            }
        }
        for (Tree<StateSet> tree : trainTrees) {
            words = tree.getYield();
            int ind = 0;
            for (StateSet word : words) {
                String sig = word.getWord();
                if (wordCounts.getCount(sig) <= (double)threshold) {
                    sig = lexicon.getSignature(word.getWord(), ind);
                    word.setWord(sig);
                }
                ++ind;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void replaceRareWords(List<Tree<String>> trainTrees, SimpleLexicon lexicon, int threshold) {
        List<Object> words;
        Counter<String> wordCounts = new Counter<String>();
        for (Tree<String> tree : trainTrees) {
            words = tree.getYield();
            for (String string : words) {
                wordCounts.incrementCount(string, 1.0);
                lexicon.wordIndexer.add(string);
            }
        }
        for (Tree<String> tree : trainTrees) {
            words = tree.getTerminals();
            boolean bl = false;
            for (Tree tree2 : words) {
                void var7_9;
                String sig = (String)tree2.getLabel();
                if (wordCounts.getCount(sig) <= (double)threshold) {
                    sig = lexicon.getSignature((String)tree2.getLabel(), (int)var7_9);
                    tree2.setLabel(sig);
                }
                ++var7_9;
            }
        }
    }

    public static void lowercaseWords(List<Tree<String>> trainTrees) {
        for (Tree<String> tree : trainTrees) {
            List<Tree<String>> words = tree.getTerminals();
            for (Tree<String> word : words) {
                String lWord = word.getLabel().toLowerCase();
                word.setLabel(lWord);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TreeBankType {
        BROWN,
        WSJ,
        CHINESE,
        GERMAN,
        SPANISH,
        FRENCH,
        CONLL,
        SINGLEFILE;

    }
}

