/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.CounterMap;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusStatistics {
    short zero = 0;
    short one = 1;
    int[] counts;
    Collection<Tree<StateSet>> trees;
    Counter<UnaryRule> unaryRuleCounter;
    Counter<BinaryRule> binaryRuleCounter;
    int[] contexts;
    CounterMap<Integer, String> posCounter;

    public CorpusStatistics(Numberer tagNumberer, Collection<Tree<StateSet>> trees) {
        this.counts = new int[tagNumberer.objects().size()];
        this.trees = trees;
        this.unaryRuleCounter = new Counter();
        this.binaryRuleCounter = new Counter();
        this.contexts = new int[tagNumberer.objects().size()];
        this.posCounter = new CounterMap();
    }

    public void countSymbols() {
        for (Tree<StateSet> tree : this.trees) {
            this.addCount(tree);
        }
    }

    private void addCount(Tree<StateSet> tree) {
        short s = tree.getLabel().getState();
        this.counts[s] = (int)((double)this.counts[s] + 1.0);
        if (!tree.isPreTerminal()) {
            for (Tree<StateSet> child : tree.getChildren()) {
                this.addCount(child);
            }
        }
    }

    public void countRuleParents() {
        for (Tree<StateSet> tree : this.trees) {
            this.addParent(tree);
        }
        for (BinaryRule br : this.binaryRuleCounter.keySet()) {
            short s = br.parentState;
            this.contexts[s] = this.contexts[s] + 1;
            short s2 = br.leftChildState;
            this.contexts[s2] = this.contexts[s2] + 1;
            short s3 = br.rightChildState;
            this.contexts[s3] = this.contexts[s3] + 1;
        }
        for (UnaryRule ur : this.unaryRuleCounter.keySet()) {
            short s = ur.parentState;
            this.contexts[s] = this.contexts[s] + 1;
            short s4 = ur.childState;
            this.contexts[s4] = this.contexts[s4] + 1;
        }
        int i = 0;
        while (i < this.contexts.length) {
            Counter<String> tempC = this.posCounter.getCounter(i);
            int n = i++;
            this.contexts[n] = this.contexts[n] + tempC.size();
        }
    }

    public int[] getContextCounts() {
        return this.contexts;
    }

    private void addParent(Tree<StateSet> tree) {
        short parentState;
        short s = parentState = tree.getLabel().getState();
        this.counts[s] = (int)((double)this.counts[s] + 1.0);
        if (!tree.isPreTerminal()) {
            Rule r;
            if (tree.getChildren().size() == 1) {
                r = new UnaryRule(parentState, tree.getChildren().get(0).getLabel().getState(), new double[1][1]);
                this.unaryRuleCounter.incrementCount((UnaryRule)r, 1.0);
            } else {
                r = new BinaryRule(parentState, tree.getChildren().get(0).getLabel().getState(), tree.getChildren().get(1).getLabel().getState(), new double[1][1][1]);
                this.binaryRuleCounter.incrementCount((BinaryRule)r, 1.0);
            }
            for (Tree<StateSet> child : tree.getChildren()) {
                this.addParent(child);
            }
        } else {
            this.posCounter.incrementCount(Integer.valueOf(parentState), tree.getChildren().get(0).getLabel().getWord(), 1.0);
        }
    }

    public int[] getSymbolCounts() {
        this.countSymbols();
        return this.counts;
    }

    public void printStateCountArray(Numberer tagNumberer, int[] array) {
        PriorityQueue<String> pq = new PriorityQueue<String>(array.length);
        int i = 0;
        while (i < array.length) {
            pq.add((String)tagNumberer.object(i), array[i]);
            ++i;
        }
        i = 0;
        while (pq.hasNext()) {
            int p = (int)pq.getPriority();
            System.out.println(String.valueOf(++i) + ". " + (String)pq.next() + "\t " + p);
        }
    }
}

