/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.util.Numberer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class DumpGrammar {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java -cp berkeleyParser.jar edu/berkeley/nlp/parser/DumpGrammar <grammar> <output file name> [<threshold>] \n reads in a serialized grammar file and writes it to a text file.");
            System.exit(2);
        }
        String inFileName = args[0];
        String outName = args[1];
        System.out.println("Loading grammar from file " + inFileName + ".");
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        SophisticatedLexicon lexicon = (SophisticatedLexicon)pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        DumpGrammar.dumpGrammar(outName, grammar, lexicon);
    }

    public static void dumpGrammar(String outName, Grammar grammar, SophisticatedLexicon lexicon) {
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        grammar.splitRules();
        Numberer n = Numberer.getGlobalNumberer("tags");
        System.out.println("Writing output to files " + outName + ".xxx");
        try {
            Object scores;
            int number;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".binary")));
            PrintWriter outN = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".num.binary")));
            int state = 0;
            while (state < grammar.numStates) {
                BinaryRule[] parentRules = grammar.splitRulesWithP(state);
                int i = 0;
                while (i < parentRules.length) {
                    String pState;
                    String rState;
                    number = 0;
                    BinaryRule r = parentRules[i];
                    scores = r.getScores2();
                    String lState = (String)n.object(r.leftChildState);
                    if (lState.endsWith("^g")) {
                        lState = lState.substring(0, lState.length() - 2);
                    }
                    if ((rState = (String)n.object(r.rightChildState)).endsWith("^g")) {
                        rState = rState.substring(0, rState.length() - 2);
                    }
                    if ((pState = (String)n.object(r.parentState)).endsWith("^g")) {
                        pState = pState.substring(0, pState.length() - 2);
                    }
                    StringBuilder sb = new StringBuilder();
                    int lS = 0;
                    while (lS < ((double[][][])scores).length) {
                        int rS = 0;
                        while (rS < scores[lS].length) {
                            if (scores[lS][rS] != null) {
                                int pS = 0;
                                while (pS < scores[lS][rS].length) {
                                    double p = scores[lS][rS][pS];
                                    if (p > 0.0) {
                                        sb.append(String.valueOf(pState) + "_" + pS + " " + lState + "_" + lS + " " + rState + "_" + rS + " " + p + "\n");
                                        ++number;
                                    }
                                    ++pS;
                                }
                            }
                            ++rS;
                        }
                        ++lS;
                    }
                    out.print(sb.toString());
                    outN.print(String.valueOf(number) + "\n");
                    ++i;
                }
                ++state;
            }
            out.flush();
            outN.flush();
            out.close();
            outN.close();
            out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".unary")));
            outN = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".num.unary")));
            state = 0;
            while (state < grammar.numStates) {
                UnaryRule[] unaries = grammar.getClosedViterbiUnaryRulesByParent(state);
                int r = 0;
                while (r < unaries.length) {
                    String pState;
                    number = 0;
                    UnaryRule ur = unaries[r];
                    scores = ur.getScores2();
                    String cState = (String)n.object(ur.childState);
                    if (cState.endsWith("^g")) {
                        cState = cState.substring(0, cState.length() - 2);
                    }
                    if ((pState = (String)n.object(ur.parentState)).endsWith("^g")) {
                        pState = pState.substring(0, pState.length() - 2);
                    }
                    StringBuilder sb = new StringBuilder();
                    int cS = 0;
                    while (cS < ((double[][][])scores).length) {
                        if (scores[cS] != null) {
                            int pS = 0;
                            while (pS < scores[cS].length) {
                                double[] p = scores[cS][pS];
                                if (p > 0.0) {
                                    sb.append(String.valueOf(pState) + "_" + pS + " " + cState + "_" + cS + " " + (double)p + "\n");
                                    ++number;
                                }
                                ++pS;
                            }
                        }
                        ++cS;
                    }
                    out.print(sb.toString());
                    outN.print(String.valueOf(number) + "\n");
                    ++r;
                }
                ++state;
            }
            out.flush();
            outN.flush();
            out.close();
            outN.close();
            grammar.writeSplitTrees(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".hierarchy")));
            out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".numstates")));
            state = 0;
            while (state < grammar.numStates) {
                String tag = (String)tagNumberer.object(state);
                if (tag.endsWith("^g")) {
                    tag = tag.substring(0, tag.length() - 2);
                }
                out.write(String.valueOf(tag) + "\t" + grammar.numSubStates[state] + "\n");
                ++state;
            }
            out.flush();
            out.close();
            out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".lexicon")));
            out.write(lexicon.toString());
            out.flush();
            out.close();
            out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(outName) + ".words")));
            for (String word : lexicon.wordCounter.keySet()) {
                out.write(String.valueOf(word) + "\n");
            }
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

