/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryCounterTable;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.UnaryCounterTable;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.CounterMap;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grammar
implements Serializable {
    public int finalLevel;
    public boolean[] isGrammarTag;
    public boolean useEntropicPrior = false;
    private List<BinaryRule>[] binaryRulesWithParent;
    private List<BinaryRule>[] binaryRulesWithLC;
    private List<BinaryRule>[] binaryRulesWithRC;
    private BinaryRule[][] splitRulesWithLC;
    private BinaryRule[][] splitRulesWithRC;
    private BinaryRule[][] splitRulesWithP;
    public List<UnaryRule>[] unaryRulesWithParent;
    public List<UnaryRule>[] unaryRulesWithC;
    private List<UnaryRule>[] sumProductClosedUnaryRulesWithParent;
    public short numStates;
    public short[] numSubStates;
    public Map<BinaryRule, BinaryRule> binaryRuleMap;
    BinaryRule bSearchRule;
    public Map<UnaryRule, UnaryRule> unaryRuleMap;
    UnaryRule uSearchRule;
    UnaryCounterTable unaryRuleCounter = null;
    BinaryCounterTable binaryRuleCounter = null;
    CounterMap<Integer, Integer> symbolCounter = new CounterMap();
    private static final long serialVersionUID = 1L;
    protected Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    public List<UnaryRule>[] closedSumRulesWithParent = null;
    public List<UnaryRule>[] closedSumRulesWithChild = null;
    public List<UnaryRule>[] closedViterbiRulesWithParent = null;
    public List<UnaryRule>[] closedViterbiRulesWithChild = null;
    public UnaryRule[][] closedSumRulesWithP = null;
    public UnaryRule[][] closedSumRulesWithC = null;
    public UnaryRule[][] closedViterbiRulesWithP = null;
    public UnaryRule[][] closedViterbiRulesWithC = null;
    private Map bestSumRulesUnderMax = null;
    private Map bestViterbiRulesUnderMax = null;
    public double threshold;
    public Smoother smoother = null;
    private int[][] closedViterbiPaths = null;
    private int[][] closedSumPaths = null;
    public boolean findClosedPaths;
    boolean logarithmMode;
    public Tree<Short>[] splitTrees;

    public void clearUnaryIntermediates() {
        ArrayUtil.fill(this.closedSumPaths, 0);
        ArrayUtil.fill(this.closedViterbiPaths, 0);
    }

    public void addBinary(BinaryRule br) {
        this.binaryRulesWithParent[br.parentState].add(br);
        this.binaryRulesWithLC[br.leftChildState].add(br);
        this.binaryRulesWithRC[br.rightChildState].add(br);
        this.binaryRuleMap.put(br, br);
    }

    public void addUnary(UnaryRule ur) {
        if (!this.unaryRulesWithParent[ur.parentState].contains(ur)) {
            this.unaryRulesWithParent[ur.parentState].add(ur);
            this.unaryRulesWithC[ur.childState].add(ur);
            this.unaryRuleMap.put(ur, ur);
        }
    }

    public Numberer getTagNumberer() {
        return this.tagNumberer;
    }

    public List<UnaryRule> getUnaryRulesByParent(int state) {
        if (state >= this.unaryRulesWithParent.length) {
            return Collections.EMPTY_LIST;
        }
        return this.unaryRulesWithParent[state];
    }

    public List<UnaryRule>[] getSumProductClosedUnaryRulesByParent() {
        return this.sumProductClosedUnaryRulesWithParent;
    }

    public List<BinaryRule> getBinaryRulesByLeftChild(int state) {
        if (state >= this.binaryRulesWithLC.length) {
            return Collections.EMPTY_LIST;
        }
        return this.binaryRulesWithLC[state];
    }

    public List<BinaryRule> getBinaryRulesByRightChild(int state) {
        if (state >= this.binaryRulesWithRC.length) {
            return Collections.EMPTY_LIST;
        }
        return this.binaryRulesWithRC[state];
    }

    public List<UnaryRule> getUnaryRulesByChild(int state) {
        if (state >= this.unaryRulesWithC.length) {
            return Collections.EMPTY_LIST;
        }
        return this.unaryRulesWithC[state];
    }

    public String toString_old() {
        return null;
    }

    public void writeData(Writer w) throws IOException {
        this.finalLevel = (short)(Math.log(this.numSubStates[1]) / Math.log(2.0));
        PrintWriter out = new PrintWriter(w);
        int state = 0;
        while (state < this.numStates) {
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            int i = 0;
            while (i < parentRules.length) {
                BinaryRule r = parentRules[i];
                out.print(r.toString());
                ++i;
            }
            ++state;
        }
        state = 0;
        while (state < this.numStates) {
            UnaryRule[] unaries = this.getClosedViterbiUnaryRulesByParent(state);
            int r = 0;
            while (r < unaries.length) {
                UnaryRule ur = unaries[r];
                out.print(ur.toString());
                ++r;
            }
            ++state;
        }
        out.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> ruleStrings = new ArrayList<String>();
        int state = 0;
        while (state < this.numStates) {
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            int i = 0;
            while (i < parentRules.length) {
                BinaryRule r = parentRules[i];
                ruleStrings.add(r.toString());
                ++i;
            }
            ++state;
        }
        state = 0;
        while (state < this.numStates) {
            UnaryRule[] unaries = this.getClosedSumUnaryRulesByParent(state);
            int r = 0;
            while (r < unaries.length) {
                UnaryRule ur = unaries[r];
                ruleStrings.add(ur.toString());
                ++r;
            }
            ++state;
        }
        for (String ruleString : CollectionUtils.sort(ruleStrings)) {
            sb.append(ruleString);
        }
        return sb.toString();
    }

    public int getNumberOfRules() {
        int nRules = 0;
        int state = 0;
        while (state < this.numStates) {
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            int i = 0;
            while (i < parentRules.length) {
                BinaryRule bRule = parentRules[i];
                double[][][] scores = bRule.getScores2();
                int j = 0;
                while (j < scores.length) {
                    int k = 0;
                    while (k < scores[j].length) {
                        if (scores[j][k] != null) {
                            nRules += scores[j][k].length;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            UnaryRule[] unaries = this.getClosedSumUnaryRulesByParent(state);
            int r = 0;
            while (r < unaries.length) {
                UnaryRule uRule = unaries[r];
                if (uRule.childState != uRule.parentState) {
                    double[][] scores = uRule.getScores2();
                    int j = 0;
                    while (j < scores.length) {
                        if (scores[j] != null) {
                            nRules += scores[j].length;
                        }
                        ++j;
                    }
                }
                ++r;
            }
            ++state;
        }
        return nRules;
    }

    public void printUnaryRules() {
        UnaryRule uRule2;
        UnaryRule[] unaries;
        int state1 = 0;
        while (state1 < this.numStates) {
            unaries = this.getUnaryRulesByParent(state1);
            for (UnaryRule uRule : unaries) {
                uRule2 = this.unaryRuleMap.get(uRule);
                if (uRule.getScores2().equals(uRule2.getScores2())) continue;
                System.out.print("BY PARENT:\n" + uRule + uRule2 + "\n");
            }
            ++state1;
        }
        state1 = 0;
        while (state1 < this.numStates) {
            unaries = this.getClosedViterbiUnaryRulesByParent(state1);
            int r = 0;
            while (r < unaries.length) {
                UnaryRule uRule = unaries[r];
                uRule2 = this.unaryRuleMap.get(uRule);
                if (this.unariesAreNotEqual(uRule, uRule2)) {
                    System.out.print("VITERBI CLOSED:\n" + uRule + uRule2 + "\n");
                }
                ++r;
            }
            ++state1;
        }
        state1 = 0;
        while (state1 < this.numStates) {
            BinaryRule[] parentRules = this.splitRulesWithP(state1);
            int i = 0;
            while (i < parentRules.length) {
                BinaryRule bRule = parentRules[i];
                BinaryRule bRule2 = this.binaryRuleMap.get(bRule);
                if (!bRule.getScores2().equals(bRule2.getScores2())) {
                    System.out.print("BINARY: " + bRule + bRule2 + "\n");
                }
                ++i;
            }
            ++state1;
        }
    }

    public boolean unariesAreNotEqual(UnaryRule u1, UnaryRule u2) {
        if (u2 == null) {
            return false;
        }
        double[][] s1 = u1.getScores2();
        double[][] s2 = u2.getScores2();
        int i = 0;
        while (i < s1.length) {
            if (s1[i] != null && s2[i] != null) {
                int j = 0;
                while (j < s1[i].length) {
                    if (s1[i][j] != s2[i][j]) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public void init() {
        this.binaryRuleMap = new HashMap<BinaryRule, BinaryRule>();
        this.unaryRuleMap = new HashMap<UnaryRule, UnaryRule>();
        this.bestSumRulesUnderMax = new HashMap();
        this.bestViterbiRulesUnderMax = new HashMap();
        this.binaryRulesWithParent = new List[this.numStates];
        this.binaryRulesWithLC = new List[this.numStates];
        this.binaryRulesWithRC = new List[this.numStates];
        this.unaryRulesWithParent = new List[this.numStates];
        this.unaryRulesWithC = new List[this.numStates];
        this.closedSumRulesWithParent = new List[this.numStates];
        this.closedSumRulesWithChild = new List[this.numStates];
        this.closedViterbiRulesWithParent = new List[this.numStates];
        this.closedViterbiRulesWithChild = new List[this.numStates];
        this.isGrammarTag = new boolean[this.numStates];
        this.closedViterbiPaths = new int[this.numStates][this.numStates];
        this.closedSumPaths = new int[this.numStates][this.numStates];
        short s = 0;
        while (s < this.numStates) {
            this.binaryRulesWithParent[s] = new ArrayList<BinaryRule>();
            this.binaryRulesWithLC[s] = new ArrayList<BinaryRule>();
            this.binaryRulesWithRC[s] = new ArrayList<BinaryRule>();
            this.unaryRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.unaryRulesWithC[s] = new ArrayList<UnaryRule>();
            this.closedSumRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.closedSumRulesWithChild[s] = new ArrayList<UnaryRule>();
            this.closedViterbiRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.closedViterbiRulesWithChild[s] = new ArrayList<UnaryRule>();
            double[][] scores = new double[this.numSubStates[s]][this.numSubStates[s]];
            int i = 0;
            while (i < scores.length) {
                scores[i][i] = 1.0;
                ++i;
            }
            UnaryRule selfR = new UnaryRule(s, s, scores);
            this.relaxViterbiRule(selfR);
            s = (short)(s + 1);
        }
    }

    public Grammar(short[] nSubStates, boolean findClosedPaths, Smoother smoother, Grammar oldGrammar, double thresh) {
        this.findClosedPaths = findClosedPaths;
        this.smoother = smoother;
        this.threshold = thresh;
        this.unaryRuleCounter = new UnaryCounterTable(nSubStates);
        this.binaryRuleCounter = new BinaryCounterTable(nSubStates);
        this.symbolCounter = new CounterMap();
        this.numStates = (short)this.tagNumberer.total();
        this.numSubStates = nSubStates;
        this.bSearchRule = new BinaryRule(0, 0, 0);
        this.uSearchRule = new UnaryRule(0, 0);
        this.logarithmMode = false;
        if (oldGrammar != null) {
            this.splitTrees = oldGrammar.splitTrees;
        } else {
            this.splitTrees = new Tree[this.numStates];
            boolean hasAnySplits = false;
            int tag = 0;
            while (!hasAnySplits && tag < this.numStates) {
                hasAnySplits = hasAnySplits || this.numSubStates[tag] > 1;
                ++tag;
            }
            tag = 0;
            while (tag < this.numStates) {
                ArrayList children = new ArrayList(this.numSubStates[tag]);
                if (hasAnySplits) {
                    short substate = 0;
                    while (substate < this.numSubStates[tag]) {
                        children.add(substate, new Tree<Short>(substate));
                        substate = (short)(substate + 1);
                    }
                }
                this.splitTrees[tag] = new Tree<Short>((short)0, children);
                ++tag;
            }
        }
        this.init();
    }

    public void setSmoother(Smoother smoother) {
        this.smoother = smoother;
    }

    public static double generateMMTRandomNumber(Random r) {
        double f = r.nextDouble();
        f = f * 2.0 - 1.0;
        return Math.exp(f *= Math.log(3.0));
    }

    public void optimize(double randomness) {
        this.init();
        if (randomness > 0.0) {
            int j;
            int i;
            Random random = GrammarTrainer.RANDOM;
            for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
                double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
                i = 0;
                while (i < unaryCounts.length) {
                    if (unaryCounts[i] == null) {
                        unaryCounts[i] = new double[this.numSubStates[unaryRule.getParentState()]];
                    }
                    j = 0;
                    while (j < unaryCounts[i].length) {
                        double r = random.nextDouble() * randomness;
                        double[] dArray = unaryCounts[i];
                        int n = j++;
                        dArray[n] = dArray[n] + r;
                    }
                    ++i;
                }
                this.unaryRuleCounter.setCount(unaryRule, unaryCounts);
            }
            for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
                double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
                i = 0;
                while (i < binaryCounts.length) {
                    j = 0;
                    while (j < binaryCounts[i].length) {
                        if (binaryCounts[i][j] == null) {
                            binaryCounts[i][j] = new double[this.numSubStates[binaryRule.getParentState()]];
                        }
                        int k = 0;
                        while (k < binaryCounts[i][j].length) {
                            double r = random.nextDouble() * randomness;
                            double[] dArray = binaryCounts[i][j];
                            int n = k++;
                            dArray[n] = dArray[n] + r;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.binaryRuleCounter.setCount(binaryRule, binaryCounts);
            }
        }
        this.normalize();
        this.smooth(false);
    }

    public void removeUnlikelyRules(double thresh, double power) {
        if (this.isLogarithmMode()) {
            power = Math.log(power);
        }
        int total = 0;
        int removed = 0;
        int state = 0;
        while (state < this.numStates) {
            int r = 0;
            while (r < this.splitRulesWithP[state].length) {
                BinaryRule rule = this.splitRulesWithP[state][r];
                int lC = 0;
                while (lC < rule.scores.length) {
                    int rC = 0;
                    while (rC < rule.scores[lC].length) {
                        if (rule.scores[lC][rC] != null) {
                            boolean isNull = true;
                            int p = 0;
                            while (p < rule.scores[lC][rC].length) {
                                ++total;
                                if (rule.scores[lC][rC][p] < thresh) {
                                    rule.scores[lC][rC][p] = 0.0;
                                    ++removed;
                                } else {
                                    if (power != 1.0) {
                                        rule.scores[lC][rC][p] = Math.pow(rule.scores[lC][rC][p], power);
                                    }
                                    isNull = false;
                                }
                                ++p;
                            }
                            if (isNull) {
                                rule.scores[lC][rC] = null;
                            }
                        }
                        ++rC;
                    }
                    ++lC;
                }
                this.splitRulesWithP[state][r] = rule;
                ++r;
            }
            for (UnaryRule rule : this.unaryRulesWithParent[state]) {
                int c = 0;
                while (c < rule.scores.length) {
                    if (rule.scores[c] != null) {
                        boolean isNull = true;
                        int p = 0;
                        while (p < rule.scores[c].length) {
                            ++total;
                            if (rule.scores[c][p] <= thresh) {
                                ++removed;
                                rule.scores[c][p] = 0.0;
                            } else {
                                if (power != 1.0) {
                                    rule.scores[c][p] = Math.pow(rule.scores[c][p], power);
                                }
                                isNull = false;
                            }
                            ++p;
                        }
                        if (isNull) {
                            rule.scores[c] = null;
                        }
                    }
                    ++c;
                }
            }
            ++state;
        }
    }

    public void smooth(boolean noNormalize) {
        int i;
        this.smoother.smooth(this.unaryRuleCounter, this.binaryRuleCounter);
        if (!noNormalize) {
            this.normalize();
        }
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            i = 0;
            while (i < unaryCounts.length) {
                if (unaryCounts[i] != null) {
                    double allZero = 0.0;
                    int j = 0;
                    while (allZero == 0.0 && j < unaryCounts[i].length) {
                        allZero += unaryCounts[i][j++];
                    }
                    if (allZero == 0.0) {
                        unaryCounts[i] = null;
                    }
                }
                ++i;
            }
            unaryRule.setScores2(unaryCounts);
            this.addUnary(unaryRule);
        }
        this.computePairsOfUnaries();
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            i = 0;
            while (i < binaryCounts.length) {
                int j = 0;
                while (j < binaryCounts[i].length) {
                    if (binaryCounts[i][j] != null) {
                        double allZero = 0.0;
                        int k = 0;
                        while (allZero == 0.0 && k < binaryCounts[i][j].length) {
                            allZero += binaryCounts[i][j][k++];
                        }
                        if (allZero == 0.0) {
                            binaryCounts[i][j] = null;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            binaryRule.setScores2(binaryCounts);
            this.addBinary(binaryRule);
        }
        this.unaryRuleCounter = new UnaryCounterTable(this.numSubStates);
        this.binaryRuleCounter = new BinaryCounterTable(this.numSubStates);
        this.symbolCounter = new CounterMap();
    }

    public void clearCounts() {
        this.unaryRuleCounter = new UnaryCounterTable(this.numSubStates);
        this.binaryRuleCounter = new BinaryCounterTable(this.numSubStates);
        this.symbolCounter = new CounterMap();
    }

    public void normalize() {
        int nParentSubStates;
        short parentState;
        this.tallyParentCounts();
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            parentState = unaryRule.getParentState();
            nParentSubStates = this.numSubStates[parentState];
            int nChildStates = this.numSubStates[unaryRule.childState];
            double[] parentCount = new double[nParentSubStates];
            int i = 0;
            while (i < nParentSubStates) {
                parentCount[i] = this.symbolCounter.getCount(Integer.valueOf(parentState), i);
                ++i;
            }
            boolean allZero = true;
            int j = 0;
            while (j < nChildStates) {
                if (unaryCounts[j] != null) {
                    int i2 = 0;
                    while (i2 < nParentSubStates) {
                        if (parentCount[i2] != 0.0) {
                            double nVal = unaryCounts[j][i2] / parentCount[i2];
                            if (nVal < this.threshold || SloppyMath.isVeryDangerous(nVal)) {
                                nVal = 0.0;
                            }
                            unaryCounts[j][i2] = nVal;
                        }
                        allZero = allZero && unaryCounts[j][i2] == 0.0;
                        ++i2;
                    }
                }
                ++j;
            }
            if (allZero) {
                System.out.println("Maybe an underflow? Rule: " + unaryRule + "\n" + ArrayUtil.toString(unaryCounts));
            }
            this.unaryRuleCounter.setCount(unaryRule, unaryCounts);
        }
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            parentState = binaryRule.parentState;
            nParentSubStates = this.numSubStates[parentState];
            double[] parentCount = new double[nParentSubStates];
            int i = 0;
            while (i < nParentSubStates) {
                parentCount[i] = this.symbolCounter.getCount(Integer.valueOf(parentState), i);
                ++i;
            }
            int j = 0;
            while (j < binaryCounts.length) {
                int k = 0;
                while (k < binaryCounts[j].length) {
                    if (binaryCounts[j][k] != null) {
                        int i3 = 0;
                        while (i3 < nParentSubStates) {
                            if (parentCount[i3] != 0.0) {
                                double nVal = binaryCounts[j][k][i3] / parentCount[i3];
                                if (nVal < this.threshold || SloppyMath.isVeryDangerous(nVal)) {
                                    nVal = 0.0;
                                }
                                binaryCounts[j][k][i3] = nVal;
                            }
                            ++i3;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            this.binaryRuleCounter.setCount(binaryRule, binaryCounts);
        }
    }

    public void checkNumberOfSubstates() {
        short nParentSubStates;
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            nParentSubStates = this.numSubStates[unaryRule.parentState];
            short nChildSubStates = this.numSubStates[unaryRule.childState];
            if (unaryCounts.length != nChildSubStates) {
                System.out.println("Unary Rule " + unaryRule + " should have " + nChildSubStates + " childsubstates.");
            }
            if (unaryCounts[0] == null || unaryCounts[0].length == nParentSubStates) continue;
            System.out.println("Unary Rule " + unaryRule + " should have " + nParentSubStates + " parentsubstates.");
        }
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            nParentSubStates = this.numSubStates[binaryRule.parentState];
            short nLeftChildSubStates = this.numSubStates[binaryRule.leftChildState];
            short nRightChildSubStates = this.numSubStates[binaryRule.rightChildState];
            if (binaryCounts.length != nLeftChildSubStates) {
                System.out.println("Unary Rule " + binaryRule + " should have " + nLeftChildSubStates + " left childsubstates.");
            }
            if (binaryCounts[0].length != nRightChildSubStates) {
                System.out.println("Unary Rule " + binaryRule + " should have " + nRightChildSubStates + " right childsubstates.");
            }
            if (binaryCounts[0][0] == null || binaryCounts[0][0].length == nParentSubStates) continue;
            System.out.println("Unary Rule " + binaryRule + " should have " + nParentSubStates + " parentsubstates.");
        }
        System.out.println("Done with checks.");
    }

    private void tallyParentCounts() {
        int i;
        int j;
        double[] sum;
        int nParentSubStates;
        short parentState;
        this.symbolCounter = new CounterMap();
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            parentState = unaryRule.getParentState();
            this.isGrammarTag[parentState] = true;
            if (unaryRule.childState == parentState) continue;
            nParentSubStates = this.numSubStates[parentState];
            sum = new double[nParentSubStates];
            j = 0;
            while (j < unaryCounts.length) {
                if (unaryCounts[j] != null) {
                    int i2 = 0;
                    while (i2 < nParentSubStates) {
                        double val = unaryCounts[j][i2];
                        int n = i2++;
                        sum[n] = sum[n] + val;
                    }
                }
                ++j;
            }
            i = 0;
            while (i < nParentSubStates) {
                this.symbolCounter.incrementCount(Integer.valueOf(parentState), i, sum[i]);
                ++i;
            }
        }
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            parentState = binaryRule.parentState;
            this.isGrammarTag[parentState] = true;
            nParentSubStates = this.numSubStates[parentState];
            sum = new double[nParentSubStates];
            j = 0;
            while (j < binaryCounts.length) {
                int k = 0;
                while (k < binaryCounts[j].length) {
                    if (binaryCounts[j][k] != null) {
                        int i3 = 0;
                        while (i3 < nParentSubStates) {
                            double val = binaryCounts[j][k][i3];
                            int n = i3++;
                            sum[n] = sum[n] + val;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            i = 0;
            while (i < nParentSubStates) {
                this.symbolCounter.incrementCount(Integer.valueOf(parentState), i, sum[i]);
                ++i;
            }
        }
    }

    public void tallyStateSetTree(Tree<StateSet> tree, Grammar old_grammar) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            return;
        }
        StateSet node = tree.getLabel();
        if (node.numSubStates() != 1) {
            System.err.println("The top symbol is split!");
            System.out.println(tree);
            System.exit(1);
        }
        double tree_score = node.getIScore(0);
        int tree_scale = node.getIScale();
        if (tree_score == 0.0) {
            System.out.println("Something is wrong with this tree. I will skip it.");
            return;
        }
        this.tallyStateSetTree(tree, tree_score, tree_scale, old_grammar);
    }

    public void tallyStateSetTree(Tree<StateSet> tree, double tree_score, double tree_scale, Grammar old_grammar) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short parentState = parent.getState();
        short nParentSubStates = this.numSubStates[parentState];
        switch (children.size()) {
            case 0: {
                break;
            }
            case 1: {
                StateSet stateSet = children.get(0).getLabel();
                short childState = stateSet.getState();
                short nChildSubStates = this.numSubStates[childState];
                UnaryRule urule = new UnaryRule(parentState, childState);
                double[][] oldUScores = old_grammar.getUnaryScore(urule);
                Object ucounts = this.unaryRuleCounter.getCount(urule);
                if (ucounts == null) {
                    ucounts = new double[nChildSubStates][];
                }
                double scalingFactor = ScalingTools.calcScaleFactor((double)(parent.getOScale() + stateSet.getIScale()) - tree_scale);
                short i = 0;
                while (i < nChildSubStates) {
                    double cIS;
                    if (oldUScores[i] != null && (cIS = stateSet.getIScore(i)) != 0.0) {
                        if (ucounts[i] == null) {
                            ucounts[i] = new double[nParentSubStates];
                        }
                        short j = 0;
                        while (j < nParentSubStates) {
                            double rS;
                            double pOS = parent.getOScore(j);
                            if (pOS != 0.0 && (rS = oldUScores[i][j]) != 0.0) {
                                if (tree_score == 0.0) {
                                    tree_score = 1.0;
                                }
                                double logRuleCount = rS * cIS / tree_score * scalingFactor * pOS;
                                double[] dArray = ucounts[i];
                                short s = j;
                                dArray[s] = dArray[s] + logRuleCount;
                            }
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
                this.unaryRuleCounter.setCount(urule, (double[][])ucounts);
                break;
            }
            case 2: {
                double[][][] bcounts;
                StateSet leftChild = children.get(0).getLabel();
                short lChildState = leftChild.getState();
                StateSet rightChild = children.get(1).getLabel();
                short rChildState = rightChild.getState();
                short nLeftChildSubStates = this.numSubStates[lChildState];
                short nRightChildSubStates = this.numSubStates[rChildState];
                BinaryRule brule = new BinaryRule(parentState, lChildState, rChildState);
                double[][][] oldBScores = old_grammar.getBinaryScore(brule);
                if (oldBScores == null) {
                    oldBScores = new double[nLeftChildSubStates][nRightChildSubStates][nParentSubStates];
                    ArrayUtil.fill(oldBScores, 1.0);
                }
                if ((bcounts = this.binaryRuleCounter.getCount(brule)) == null) {
                    bcounts = new double[nLeftChildSubStates][nRightChildSubStates][];
                }
                double scalingFactor = ScalingTools.calcScaleFactor((double)(parent.getOScale() + leftChild.getIScale() + rightChild.getIScale()) - tree_scale);
                short i = 0;
                while (i < nLeftChildSubStates) {
                    double lcIS = leftChild.getIScore(i);
                    if (lcIS != 0.0) {
                        short j = 0;
                        while (j < nRightChildSubStates) {
                            double rcIS;
                            if (oldBScores[i][j] != null && (rcIS = rightChild.getIScore(j)) != 0.0) {
                                if (bcounts[i][j] == null) {
                                    bcounts[i][j] = new double[nParentSubStates];
                                }
                                short k = 0;
                                while (k < nParentSubStates) {
                                    double rS;
                                    double pOS = parent.getOScore(k);
                                    if (pOS != 0.0 && (rS = oldBScores[i][j][k]) != 0.0) {
                                        if (tree_score == 0.0) {
                                            tree_score = 1.0;
                                        }
                                        double logRuleCount = rS * lcIS / tree_score * rcIS * scalingFactor * pOS;
                                        double[] dArray = bcounts[i][j];
                                        short s = k;
                                        dArray[s] = dArray[s] + logRuleCount;
                                    }
                                    k = (short)(k + 1);
                                }
                            }
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
                this.binaryRuleCounter.setCount(brule, bcounts);
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        for (Tree<StateSet> tree2 : children) {
            this.tallyStateSetTree(tree2, tree_score, tree_scale, old_grammar);
        }
    }

    public void tallyUninitializedStateSetTree(Tree<StateSet> tree) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short parentState = parent.getState();
        int nParentSubStates = parent.numSubStates();
        switch (children.size()) {
            case 0: {
                break;
            }
            case 1: {
                StateSet stateSet = children.get(0).getLabel();
                short childState = stateSet.getState();
                int nChildSubStates = stateSet.numSubStates();
                double[][] counts = new double[nChildSubStates][nParentSubStates];
                UnaryRule urule = new UnaryRule(parentState, childState, counts);
                this.unaryRuleCounter.incrementCount(urule, 1.0);
                break;
            }
            case 2: {
                StateSet leftChild = children.get(0).getLabel();
                short lChildState = leftChild.getState();
                StateSet rightChild = children.get(1).getLabel();
                short rChildState = rightChild.getState();
                int nLeftChildSubStates = leftChild.numSubStates();
                int nRightChildSubStates = rightChild.numSubStates();
                double[][][] bcounts = new double[nLeftChildSubStates][nRightChildSubStates][nParentSubStates];
                BinaryRule brule = new BinaryRule(parentState, lChildState, rChildState, bcounts);
                this.binaryRuleCounter.incrementCount(brule, 1.0);
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        for (Tree<StateSet> tree2 : children) {
            this.tallyUninitializedStateSetTree(tree2);
        }
    }

    public void makeCRArrays() {
        this.closedSumRulesWithP = new UnaryRule[this.numStates][];
        this.closedSumRulesWithC = new UnaryRule[this.numStates][];
        this.closedViterbiRulesWithP = new UnaryRule[this.numStates][];
        this.closedViterbiRulesWithC = new UnaryRule[this.numStates][];
        int i = 0;
        while (i < this.numStates) {
            this.closedSumRulesWithP[i] = this.closedSumRulesWithParent[i].toArray(new UnaryRule[0]);
            this.closedSumRulesWithC[i] = this.closedSumRulesWithChild[i].toArray(new UnaryRule[0]);
            this.closedViterbiRulesWithP[i] = this.closedViterbiRulesWithParent[i].toArray(new UnaryRule[0]);
            this.closedViterbiRulesWithC[i] = this.closedViterbiRulesWithChild[i].toArray(new UnaryRule[0]);
            ++i;
        }
    }

    public UnaryRule[] getClosedSumUnaryRulesByParent(int state) {
        if (this.closedSumRulesWithP == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedSumRulesWithP.length) {
            return new UnaryRule[0];
        }
        return this.closedSumRulesWithP[state];
    }

    public UnaryRule[] getClosedSumUnaryRulesByChild(int state) {
        if (this.closedSumRulesWithC == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedSumRulesWithC.length) {
            return new UnaryRule[0];
        }
        return this.closedSumRulesWithC[state];
    }

    public UnaryRule[] getClosedViterbiUnaryRulesByParent(int state) {
        if (this.closedViterbiRulesWithP == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedViterbiRulesWithP.length) {
            return new UnaryRule[0];
        }
        return this.closedViterbiRulesWithP[state];
    }

    public UnaryRule[] getClosedViterbiUnaryRulesByChild(int state) {
        if (this.closedViterbiRulesWithC == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedViterbiRulesWithC.length) {
            return new UnaryRule[0];
        }
        return this.closedViterbiRulesWithC[state];
    }

    public void purgeRules() {
        HashMap<UnaryRule, UnaryRule> bR = new HashMap<UnaryRule, UnaryRule>();
        HashMap<UnaryRule, UnaryRule> bR2 = new HashMap<UnaryRule, UnaryRule>();
        for (UnaryRule ur : this.bestSumRulesUnderMax.keySet()) {
            if (ur.parentState == ur.childState) continue;
            bR.put(ur, ur);
            bR2.put(ur, ur);
        }
        this.bestSumRulesUnderMax = bR;
        this.bestViterbiRulesUnderMax = bR2;
    }

    /*
     * Unable to fully structure code
     */
    public List<short[]> getBestViterbiPath(short pState, short np, short cState, short cp) {
        path = new ArrayList<short[]>();
        state = new short[]{pState, np};
        if (!this.findClosedPaths) {
            path.add(state);
            state = new short[]{cState, cp};
            path.add(state);
            return path;
        }
        if (pState != cState || np != cp) ** GOTO lbl19
        path.add(state);
        path.add(state);
        return path;
lbl-1000:
        // 1 sources

        {
            path.add(state);
            state[0] = (short)this.closedViterbiPaths[state[0]][state[1]];
lbl19:
            // 2 sources

            ** while (state[0] != cState || state[1] != cp)
        }
lbl20:
        // 1 sources

        path.add(state);
        return path;
    }

    private void closeRulesUnderMax(UnaryRule ur) {
        double[][] scores;
        UnaryRule resultR;
        int j;
        UnaryRule pr;
        short pState = ur.parentState;
        int nPSubStates = this.numSubStates[pState];
        short cState = ur.childState;
        double[][] uScores = ur.getScores2();
        int i = 0;
        while (i < this.closedSumRulesWithChild[pState].size()) {
            pr = this.closedSumRulesWithChild[pState].get(i);
            j = 0;
            while (j < this.closedSumRulesWithParent[cState].size()) {
                short parentState = pr.parentState;
                short nParentSubStates = this.numSubStates[parentState];
                UnaryRule cr = this.closedSumRulesWithParent[cState].get(j);
                resultR = new UnaryRule(parentState, cr.getChildState());
                scores = new double[this.numSubStates[cr.getChildState()]][nParentSubStates];
                int np = 0;
                while (np < scores[0].length) {
                    int cp = 0;
                    while (cp < scores.length) {
                        double sum = 0.0;
                        int unp = 0;
                        while (unp < nPSubStates) {
                            int ucp = 0;
                            while (ucp < uScores.length) {
                                sum += pr.getScore(np, unp) * cr.getScore(ucp, cp) * ur.getScore(unp, ucp);
                                ++ucp;
                            }
                            ++unp;
                        }
                        scores[cp][np] = sum;
                        ++cp;
                    }
                    ++np;
                }
                resultR.setScores2(scores);
                this.relaxSumRule(resultR, pState, cState);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.closedViterbiRulesWithChild[pState].size()) {
            pr = this.closedViterbiRulesWithChild[pState].get(i);
            j = 0;
            while (j < this.closedViterbiRulesWithParent[cState].size()) {
                UnaryRule cr = this.closedViterbiRulesWithParent[cState].get(j);
                short parentState = pr.parentState;
                short nParentSubStates = this.numSubStates[parentState];
                resultR = new UnaryRule(parentState, cr.getChildState());
                scores = new double[this.numSubStates[cr.getChildState()]][nParentSubStates];
                short[][] intermediateSubState1 = new short[nParentSubStates][this.numSubStates[cr.getChildState()]];
                short[][] intermediateSubState2 = new short[nParentSubStates][this.numSubStates[cr.getChildState()]];
                int np = 0;
                while (np < scores[0].length) {
                    int cp = 0;
                    while (cp < scores.length) {
                        double max = 0.0;
                        int unp = 0;
                        while (unp < nPSubStates) {
                            int ucp = 0;
                            while (ucp < uScores.length) {
                                double score = pr.getScore(np, unp) * cr.getScore(ucp, cp) * ur.getScore(unp, ucp);
                                if (score > max) {
                                    max = score;
                                    intermediateSubState1[np][cp] = unp;
                                    intermediateSubState2[np][cp] = ucp;
                                }
                                ucp = (short)(ucp + 1);
                            }
                            unp = (short)(unp + 1);
                        }
                        scores[cp][np] = max;
                        ++cp;
                    }
                    ++np;
                }
                resultR.setScores2(scores);
                this.relaxViterbiRule(resultR, pState, intermediateSubState1, cState, intermediateSubState2);
                j = (short)(j + 1);
            }
            i = (short)(i + 1);
        }
    }

    public int getUnaryIntermediate(short start, short end) {
        return this.closedSumPaths[start][end];
    }

    private boolean relaxSumRule(UnaryRule ur, int intState1, int intState2) {
        UnaryRule bestR = (UnaryRule)this.bestSumRulesUnderMax.get(ur);
        if (bestR == null) {
            this.bestSumRulesUnderMax.put(ur, ur);
            this.closedSumRulesWithParent[ur.parentState].add(ur);
            this.closedSumRulesWithChild[ur.childState].add(ur);
            return true;
        }
        boolean change = false;
        int i = 0;
        while (i < ur.scores[0].length) {
            int j = 0;
            while (j < ur.scores.length) {
                if (bestR.scores[j][i] < ur.scores[j][i]) {
                    bestR.scores[j][i] = ur.scores[j][i];
                    change = true;
                }
                ++j;
            }
            ++i;
        }
        return change;
    }

    public void computePairsOfUnaries() {
        short parentState = 0;
        while (parentState < this.numStates) {
            short childState = 0;
            while (childState < this.numStates) {
                if (parentState != childState) {
                    int nParentSubStates = this.numSubStates[parentState];
                    int nChildSubStates = this.numSubStates[childState];
                    UnaryRule resultRsum = new UnaryRule(parentState, childState);
                    UnaryRule resultRmax = new UnaryRule(parentState, childState);
                    double[][] scoresSum = new double[nChildSubStates][nParentSubStates];
                    double[][] scoresMax = new double[nChildSubStates][nParentSubStates];
                    double maxSumScore = -1.0;
                    int bestSumIntermed = -1;
                    int bestMaxIntermed = -2;
                    int i = 0;
                    while (i < this.unaryRulesWithParent[parentState].size()) {
                        UnaryRule pr = this.unaryRulesWithParent[parentState].get(i);
                        short state = pr.getChildState();
                        if (state == childState) {
                            double total = 0.0;
                            double[][] scores = pr.getScores2();
                            int cp = 0;
                            while (cp < nChildSubStates) {
                                if (scores[cp] != null) {
                                    int np = 0;
                                    while (np < nParentSubStates) {
                                        double sum = scores[cp][np];
                                        double[] dArray = scoresSum[cp];
                                        int n = np;
                                        dArray[n] = dArray[n] + sum;
                                        total += sum;
                                        if (sum > scoresMax[cp][np]) {
                                            scoresMax[cp][np] = sum;
                                            bestMaxIntermed = -1;
                                        }
                                        ++np;
                                    }
                                }
                                ++cp;
                            }
                            if (total > maxSumScore) {
                                bestSumIntermed = -1;
                                maxSumScore = total;
                            }
                        } else {
                            int j = 0;
                            while (j < this.unaryRulesWithC[childState].size()) {
                                UnaryRule cr = this.unaryRulesWithC[childState].get(j);
                                if (state == cr.getParentState()) {
                                    int nMySubStates = this.numSubStates[state];
                                    double total = 0.0;
                                    int np = 0;
                                    while (np < nParentSubStates) {
                                        int cp = 0;
                                        while (cp < nChildSubStates) {
                                            double sum = 0.0;
                                            double max = 0.0;
                                            int unp = 0;
                                            while (unp < nMySubStates) {
                                                double val = pr.getScore(np, unp) * cr.getScore(unp, cp);
                                                sum += val;
                                                max = Math.max(max, val);
                                                ++unp;
                                            }
                                            double[] dArray = scoresSum[cp];
                                            int n = np;
                                            dArray[n] = dArray[n] + sum;
                                            total += sum;
                                            if (max > scoresMax[cp][np]) {
                                                scoresMax[cp][np] = max;
                                                bestMaxIntermed = state;
                                            }
                                            ++cp;
                                        }
                                        ++np;
                                    }
                                    if (total > maxSumScore) {
                                        maxSumScore = total;
                                        bestSumIntermed = state;
                                    }
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    if (maxSumScore > -1.0) {
                        resultRsum.setScores2(scoresSum);
                        this.addUnary(resultRsum);
                        this.closedSumRulesWithParent[parentState].add(resultRsum);
                        this.closedSumRulesWithChild[childState].add(resultRsum);
                        this.closedSumPaths[parentState][childState] = bestSumIntermed;
                    }
                    if (bestMaxIntermed > -2) {
                        resultRmax.setScores2(scoresMax);
                        this.closedViterbiRulesWithParent[parentState].add(resultRmax);
                        this.closedViterbiRulesWithChild[childState].add(resultRmax);
                        this.closedViterbiPaths[parentState][childState] = bestMaxIntermed;
                    }
                }
                childState = (short)(childState + 1);
            }
            parentState = (short)(parentState + 1);
        }
    }

    private void relaxViterbiRule(UnaryRule ur, short intState1, short[][] intSubStates1, short intState2, short[][] intSubStates2) {
        throw new Error("Viterbi closure is broken!");
    }

    private void relaxViterbiRule(UnaryRule rule) {
        this.bestViterbiRulesUnderMax.put(rule, rule);
        this.closedViterbiRulesWithParent[rule.parentState].add(rule);
        this.closedViterbiRulesWithChild[rule.childState].add(rule);
        if (this.findClosedPaths) {
            int i = 0;
            while (i < rule.scores.length) {
                short j = 0;
                while (j < rule.scores[i].length) {
                    short[] pair = new short[]{rule.childState, j};
                    j = (short)(j + 1);
                }
                i = (short)(i + 1);
            }
        }
    }

    private List<UnaryRule>[] matrixMultiply(List<UnaryRule>[] parentRules, List<UnaryRule>[] childRules) {
        throw new Error("I'm broken by parent first");
    }

    private void matrixAdd(List<UnaryRule>[] rules1, List<UnaryRule>[] rules2) {
        throw new Error("I'm broken by parent first");
    }

    private List<UnaryRule>[] matrixUnity() {
        throw new Error("I'm broken by parent first");
    }

    private List<UnaryRule>[] sumProductUnaryClosure(List<UnaryRule>[] P) {
        throw new Error("I'm broken by parent first");
    }

    public double[][] matrixVectorPreMultiply(double[][] V, List<UnaryRule>[] M, List<Integer> possibleSt) {
        throw new Error("I'm broken by parent first");
    }

    public double[][] matrixVectorPostMultiply(List<UnaryRule>[] M, double[][] V, List<Integer> possibleSt) {
        throw new Error("I'm broken by parent first");
    }

    public void splitRules() {
        if (this.binaryRulesWithParent == null) {
            return;
        }
        this.splitRulesWithP = new BinaryRule[this.numStates][];
        this.splitRulesWithLC = new BinaryRule[this.numStates][];
        this.splitRulesWithRC = new BinaryRule[this.numStates][];
        int state = 0;
        while (state < this.numStates) {
            this.splitRulesWithLC[state] = this.toBRArray(this.binaryRulesWithLC[state]);
            this.splitRulesWithRC[state] = this.toBRArray(this.binaryRulesWithRC[state]);
            this.splitRulesWithP[state] = this.toBRArray(this.binaryRulesWithParent[state]);
            ++state;
        }
        this.binaryRulesWithParent = null;
        this.binaryRulesWithLC = null;
        this.binaryRulesWithRC = null;
        this.makeCRArrays();
    }

    public BinaryRule[] splitRulesWithLC(int state) {
        if (state >= this.splitRulesWithLC.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithLC[state];
    }

    public BinaryRule[] splitRulesWithRC(int state) {
        if (state >= this.splitRulesWithRC.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithRC[state];
    }

    public BinaryRule[] splitRulesWithP(int state) {
        if (this.splitRulesWithP == null) {
            this.splitRules();
        }
        if (state >= this.splitRulesWithP.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithP[state];
    }

    private BinaryRule[] toBRArray(List<BinaryRule> list) {
        BinaryRule[] array = new BinaryRule[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public double[][] getUnaryScore(short pState, short cState) {
        UnaryRule r = this.getUnaryRule(pState, cState);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.out.println("The requested rule (" + this.uSearchRule + ") is not in the grammar!");
        }
        double[][] uscores = new double[this.numSubStates[cState]][this.numSubStates[pState]];
        ArrayUtil.fill(uscores, 1.0);
        return uscores;
    }

    public UnaryRule getUnaryRule(short pState, short cState) {
        UnaryRule uRule = new UnaryRule(pState, cState);
        UnaryRule r = this.unaryRuleMap.get(uRule);
        return r;
    }

    public double[][] getUnaryScore(UnaryRule rule) {
        UnaryRule r = this.unaryRuleMap.get(rule);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.out.println("The requested rule (" + rule + ") is not in the grammar!");
        }
        double[][] uscores = new double[this.numSubStates[rule.getChildState()]][this.numSubStates[rule.getParentState()]];
        ArrayUtil.fill(uscores, 1.0);
        return uscores;
    }

    public double[][][] getBinaryScore(short pState, short lState, short rState) {
        BinaryRule r = this.getBinaryRule(pState, lState, rState);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.out.println("The requested rule (" + this.bSearchRule + ") is not in the grammar!");
        }
        double[][][] bscores = new double[this.numSubStates[lState]][this.numSubStates[rState]][this.numSubStates[pState]];
        ArrayUtil.fill(bscores, 1.0);
        return bscores;
    }

    public BinaryRule getBinaryRule(short pState, short lState, short rState) {
        BinaryRule bRule = new BinaryRule(pState, lState, rState);
        BinaryRule r = this.binaryRuleMap.get(bRule);
        return r;
    }

    public double[][][] getBinaryScore(BinaryRule rule) {
        BinaryRule r = this.binaryRuleMap.get(rule);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.out.println("The requested rule (" + rule + ") is not in the grammar!");
        }
        double[][][] bscores = new double[this.numSubStates[rule.getLeftChildState()]][this.numSubStates[rule.getRightChildState()]][this.numSubStates[rule.getParentState()]];
        ArrayUtil.fill(bscores, 1.0);
        return bscores;
    }

    public void printSymbolCounter(Numberer tagNumberer) {
        Set<Integer> set = this.symbolCounter.keySet();
        PriorityQueue<String> pq = new PriorityQueue<String>(set.size());
        for (Integer i : set) {
            pq.add((String)tagNumberer.object(i), this.symbolCounter.getCount(i, 0));
        }
        int i = 0;
        while (pq.hasNext()) {
            int p = (int)pq.getPriority();
            System.out.println(String.valueOf(++i) + ". " + (String)pq.next() + "\t " + p);
        }
    }

    public int getSymbolCount(Integer i) {
        return (int)this.symbolCounter.getCount(i, 0);
    }

    private void makeRulesAccessibleByChild() {
    }

    public Grammar splitAllStates(double randomness, int[] counts, boolean moreSubstatesThanCounts, int mode) {
        Rule newRule;
        if (this.logarithmMode) {
            throw new Error("Do not split states when Grammar is in logarithm mode");
        }
        short[] newNumSubStates = new short[this.numSubStates.length];
        int i = 0;
        while (i < this.numSubStates.length) {
            newNumSubStates[i] = (short)(this.numSubStates[i] * 2);
            i = (short)(i + 1);
        }
        boolean doNotNormalize = mode == 1;
        newNumSubStates[0] = 1;
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        Random random = GrammarTrainer.RANDOM;
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            newRule = binaryRule.splitRule(this.numSubStates, newNumSubStates, random, randomness, doNotNormalize, mode);
            grammar.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            newRule = unaryRule.splitRule(this.numSubStates, newNumSubStates, random, randomness, doNotNormalize, mode);
            grammar.addUnary((UnaryRule)newRule);
        }
        grammar.isGrammarTag = this.isGrammarTag;
        grammar.extendSplitTrees(this.splitTrees, this.numSubStates);
        grammar.computePairsOfUnaries();
        return grammar;
    }

    public void extendSplitTrees(Tree<Short>[] trees, short[] oldNumSubStates) {
        this.splitTrees = new Tree[this.numStates];
        int tag = 0;
        while (tag < this.splitTrees.length) {
            Tree<Short> splitTree = trees[tag].shallowClone();
            for (Tree<Short> leaf : splitTree.getTerminals()) {
                List<Tree<Short>> children = leaf.getChildren();
                if (this.numSubStates[tag] > oldNumSubStates[tag]) {
                    children.add(new Tree<Short>((short)(2 * leaf.getLabel())));
                    children.add(new Tree<Short>((short)(2 * leaf.getLabel() + 1)));
                    continue;
                }
                children.add(new Tree<Short>(leaf.getLabel()));
            }
            this.splitTrees[tag] = splitTree;
            ++tag;
        }
    }

    public int totalSubStates() {
        int count = 0;
        int i = 0;
        while (i < this.numStates) {
            count += this.numSubStates[i];
            ++i;
        }
        return count;
    }

    public void tallyMergeWeights(Tree<StateSet> tree, double[][] mergeWeights) {
        if (tree.isLeaf()) {
            return;
        }
        StateSet label = tree.getLabel();
        short state = label.getState();
        double[] probs = new double[label.numSubStates()];
        double total = 0.0;
        int i = 0;
        while (i < label.numSubStates()) {
            double tmp;
            probs[i] = tmp = label.getIScore(i) * label.getOScore(i);
            total += tmp;
            i = (short)(i + 1);
        }
        if (total == 0.0) {
            total = 1.0;
        }
        i = 0;
        while (i < label.numSubStates()) {
            double[] dArray = mergeWeights[state];
            int n = i;
            dArray[n] = dArray[n] + probs[i] / total;
            i = (short)(i + 1);
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            this.tallyMergeWeights(child, mergeWeights);
        }
    }

    public void normalizeMergeWeights(double[][] mergeWeights) {
        int state = 0;
        while (state < mergeWeights.length) {
            double sum = 0.0;
            int subState = 0;
            while (subState < this.numSubStates[state]) {
                sum += mergeWeights[state][subState];
                ++subState;
            }
            if (sum == 0.0) {
                sum = 1.0;
            }
            subState = 0;
            while (subState < this.numSubStates[state]) {
                double[] dArray = mergeWeights[state];
                int n = subState++;
                dArray[n] = dArray[n] / sum;
            }
            ++state;
        }
    }

    public void tallyMergeScores(Tree<StateSet> tree, double[][][] deltas, double[][] mergeWeights) {
        if (tree.isLeaf()) {
            return;
        }
        StateSet label = tree.getLabel();
        short state = label.getState();
        double[] separatedScores = new double[label.numSubStates()];
        double[] combinedScores = new double[label.numSubStates()];
        double separatedScoreSum = 0.0;
        short i = 0;
        while (i < label.numSubStates()) {
            double tmp;
            combinedScores[i] = separatedScores[i] = (tmp = label.getIScore(i) * label.getOScore(i));
            separatedScoreSum += tmp;
            ++i;
        }
        i = 0;
        while (i < this.numSubStates[state]) {
            short j = (short)(i + 1);
            while (j < this.numSubStates[state]) {
                double combinedScore;
                short[] map = new short[]{i, j};
                double[] tmp1 = new double[2];
                double[] tmp2 = new double[2];
                double mergeWeightSum = 0.0;
                int k = 0;
                while (k < 2) {
                    mergeWeightSum += mergeWeights[state][map[k]];
                    ++k;
                }
                if (mergeWeightSum == 0.0) {
                    mergeWeightSum = 1.0;
                }
                k = 0;
                while (k < 2) {
                    tmp1[k] = label.getIScore(map[k]) * mergeWeights[state][map[k]] / mergeWeightSum;
                    tmp2[k] = label.getOScore(map[k]);
                    ++k;
                }
                combinedScores[i] = combinedScore = (tmp1[0] + tmp1[1]) * (tmp2[0] + tmp2[1]);
                combinedScores[j] = 0.0;
                if (combinedScore != 0.0 && separatedScoreSum != 0.0) {
                    double[] dArray = deltas[state][i];
                    short s = j;
                    dArray[s] = dArray[s] + Math.log(separatedScoreSum / ArrayUtil.sum(combinedScores));
                }
                k = 0;
                while (k < 2) {
                    combinedScores[map[k]] = separatedScores[map[k]];
                    ++k;
                }
                if (Double.isNaN(deltas[state][i][j])) {
                    System.out.println(" deltas[" + this.tagNumberer.object(state) + "][" + i + "][" + j + "] = NaN");
                    System.out.println(String.valueOf(Arrays.toString(separatedScores)) + " " + Arrays.toString(tmp1) + " " + Arrays.toString(tmp2) + " " + combinedScore + " " + Arrays.toString(mergeWeights[state]));
                }
                j = (short)(j + 1);
            }
            i = (short)(i + 1);
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            this.tallyMergeScores(child, deltas, mergeWeights);
        }
    }

    public Grammar mergeStates(boolean[][][] mergeThesePairs, double[][] mergeWeights) {
        Rule newRule;
        int j;
        int parentSplit;
        Object oldScores;
        short pS;
        if (this.logarithmMode) {
            throw new Error("Do not merge grammars in logarithm mode!");
        }
        short[] newNumSubStates = new short[this.numSubStates.length];
        short[][] mapping = new short[this.numSubStates.length][];
        short[][][] partners = new short[this.numSubStates.length][][];
        Grammar.calculateMergeArrays(mergeThesePairs, newNumSubStates, mapping, partners, this.numSubStates);
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            pS = binaryRule.getParentState();
            short lcS = binaryRule.getLeftChildState();
            short rcS = binaryRule.getRightChildState();
            oldScores = binaryRule.getScores2();
            double[][][] newScores = new double[newNumSubStates[lcS]][newNumSubStates[rcS]][newNumSubStates[pS]];
            int i = 0;
            while (i < this.numSubStates[pS]) {
                if (partners[pS][i][0] == i) {
                    parentSplit = partners[pS][i].length;
                    j = 0;
                    while (j < this.numSubStates[lcS]) {
                        if (partners[lcS][j][0] == j) {
                            int leftSplit = partners[lcS][j].length;
                            int k = 0;
                            while (k < this.numSubStates[rcS]) {
                                if (partners[rcS][k][0] == k) {
                                    int js;
                                    int is;
                                    int ks;
                                    int rightSplit = partners[rcS][k].length;
                                    double[][][] scores = new double[leftSplit][rightSplit][parentSplit];
                                    int js2 = 0;
                                    while (js2 < leftSplit) {
                                        ks = 0;
                                        while (ks < rightSplit) {
                                            if (oldScores[partners[lcS][j][js2]][partners[rcS][k][ks]] != null) {
                                                int is2 = 0;
                                                while (is2 < parentSplit) {
                                                    scores[js2][ks][is2] = oldScores[partners[lcS][j][js2]][partners[rcS][k][ks]][partners[pS][i][is2]];
                                                    ++is2;
                                                }
                                            }
                                            ++ks;
                                        }
                                        ++js2;
                                    }
                                    if (rightSplit == 2) {
                                        is = 0;
                                        while (is < parentSplit) {
                                            js = 0;
                                            while (js < leftSplit) {
                                                double d = scores[js][0][is] + scores[js][1][is];
                                                scores[js][1][is] = d;
                                                scores[js][0][is] = d;
                                                ++js;
                                            }
                                            ++is;
                                        }
                                    }
                                    if (leftSplit == 2) {
                                        is = 0;
                                        while (is < parentSplit) {
                                            ks = 0;
                                            while (ks < rightSplit) {
                                                double d = scores[0][ks][is] + scores[1][ks][is];
                                                scores[1][ks][is] = d;
                                                scores[0][ks][is] = d;
                                                ++ks;
                                            }
                                            ++is;
                                        }
                                    }
                                    if (parentSplit == 2) {
                                        int js3 = 0;
                                        while (js3 < leftSplit) {
                                            ks = 0;
                                            while (ks < rightSplit) {
                                                double mergeWeightSum = mergeWeights[pS][partners[pS][i][0]] + mergeWeights[pS][partners[pS][i][1]];
                                                if (SloppyMath.isDangerous(mergeWeightSum)) {
                                                    mergeWeightSum = 1.0;
                                                }
                                                double d = (scores[js3][ks][0] * mergeWeights[pS][partners[pS][i][0]] + scores[js3][ks][1] * mergeWeights[pS][partners[pS][i][1]]) / mergeWeightSum;
                                                scores[js3][ks][1] = d;
                                                scores[js3][ks][0] = d;
                                                ++ks;
                                            }
                                            ++js3;
                                        }
                                    }
                                    is = 0;
                                    while (is < parentSplit) {
                                        js = 0;
                                        while (js < leftSplit) {
                                            int ks2 = 0;
                                            while (ks2 < rightSplit) {
                                                newScores[mapping[lcS][partners[lcS][j][js]]][mapping[rcS][partners[rcS][k][ks2]]][mapping[pS][partners[pS][i][is]]] = scores[js][ks2][is];
                                                ++ks2;
                                            }
                                            ++js;
                                        }
                                        ++is;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            newRule = new BinaryRule(binaryRule);
            ((BinaryRule)newRule).setScores2(newScores);
            grammar.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            pS = unaryRule.getParentState();
            short cS = unaryRule.getChildState();
            double[][] newScores = new double[newNumSubStates[cS]][newNumSubStates[pS]];
            oldScores = unaryRule.getScores2();
            boolean allZero = true;
            int i = 0;
            while (i < this.numSubStates[pS]) {
                if (partners[pS][i][0] == i) {
                    parentSplit = partners[pS][i].length;
                    j = 0;
                    while (j < this.numSubStates[cS]) {
                        if (partners[cS][j][0] == j) {
                            int is;
                            int childSplit = partners[cS][j].length;
                            double[][] scores = new double[childSplit][parentSplit];
                            int js = 0;
                            while (js < childSplit) {
                                if (oldScores[partners[cS][j][js]] != null) {
                                    int is3 = 0;
                                    while (is3 < parentSplit) {
                                        scores[js][is3] = (double)oldScores[partners[cS][j][js]][partners[pS][i][is3]];
                                        ++is3;
                                    }
                                }
                                ++js;
                            }
                            if (childSplit == 2) {
                                is = 0;
                                while (is < parentSplit) {
                                    double d = scores[0][is] + scores[1][is];
                                    scores[1][is] = d;
                                    scores[0][is] = d;
                                    ++is;
                                }
                            }
                            if (parentSplit == 2) {
                                js = 0;
                                while (js < childSplit) {
                                    double mergeWeightSum = mergeWeights[pS][partners[pS][i][0]] + mergeWeights[pS][partners[pS][i][1]];
                                    if (SloppyMath.isDangerous(mergeWeightSum)) {
                                        mergeWeightSum = 1.0;
                                    }
                                    double d = (scores[js][0] * mergeWeights[pS][partners[pS][i][0]] + scores[js][1] * mergeWeights[pS][partners[pS][i][1]]) / mergeWeightSum;
                                    scores[js][1] = d;
                                    scores[js][0] = d;
                                    ++js;
                                }
                            }
                            is = 0;
                            while (is < parentSplit) {
                                int js3 = 0;
                                while (js3 < childSplit) {
                                    newScores[mapping[cS][partners[cS][j][js3]]][mapping[pS][partners[pS][i][is]]] = scores[js3][is];
                                    allZero = allZero && scores[js3][is] == 0.0;
                                    ++js3;
                                }
                                ++is;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            newRule = new UnaryRule(unaryRule);
            ((UnaryRule)newRule).setScores2(newScores);
            grammar.addUnary((UnaryRule)newRule);
        }
        grammar.pruneSplitTree(partners, mapping);
        grammar.isGrammarTag = this.isGrammarTag;
        grammar.closedViterbiRulesWithParent = grammar.unaryRulesWithParent;
        grammar.closedSumRulesWithParent = grammar.unaryRulesWithParent;
        grammar.closedViterbiRulesWithChild = grammar.unaryRulesWithC;
        grammar.closedSumRulesWithChild = grammar.unaryRulesWithC;
        return grammar;
    }

    private void pruneSplitTree(short[][][] partners, short[][] mapping) {
        int tag = 0;
        while (tag < this.splitTrees.length) {
            Tree<Short> splitTree = this.splitTrees[tag];
            int maxDepth = splitTree.getDepth();
            for (Tree<Short> preTerminal : splitTree.getAtDepth(maxDepth - 2)) {
                List<Tree<Short>> children = preTerminal.getChildren();
                ArrayList newChildren = new ArrayList(2);
                int i = 0;
                while (i < children.size()) {
                    Tree<Short> child = children.get(i);
                    short curLoc = child.getLabel();
                    if (partners[tag][curLoc][0] == curLoc) {
                        newChildren.add(new Tree<Short>(mapping[tag][curLoc]));
                    }
                    ++i;
                }
                preTerminal.setChildren(newChildren);
            }
            ++tag;
        }
    }

    public static void checkNormalization(Grammar grammar) {
        short pS;
        double[][] psum = new double[grammar.numSubStates.length][];
        int pS2 = 0;
        while (pS2 < grammar.numSubStates.length) {
            psum[pS2] = new double[grammar.numSubStates[pS2]];
            ++pS2;
        }
        boolean[] sawPS = new boolean[grammar.numSubStates.length];
        for (UnaryRule ur : grammar.unaryRuleMap.values()) {
            pS = ur.getParentState();
            sawPS[pS] = true;
            short cS = ur.getChildState();
            double[][] scores = ur.getScores2();
            int ci = 0;
            while (ci < grammar.numSubStates[cS]) {
                if (scores[ci] != null) {
                    int pi = 0;
                    while (pi < grammar.numSubStates[pS]) {
                        double[] dArray = psum[pS];
                        int n = pi;
                        dArray[n] = dArray[n] + scores[ci][pi];
                        ++pi;
                    }
                }
                ++ci;
            }
        }
        for (BinaryRule br : grammar.binaryRuleMap.values()) {
            pS = br.getParentState();
            sawPS[pS] = true;
            short lcS = br.getLeftChildState();
            short rcS = br.getRightChildState();
            double[][][] scores = br.getScores2();
            int lci = 0;
            while (lci < grammar.numSubStates[lcS]) {
                int rci = 0;
                while (rci < grammar.numSubStates[rcS]) {
                    if (scores[lci][rci] != null) {
                        int pi = 0;
                        while (pi < grammar.numSubStates[pS]) {
                            double[] dArray = psum[pS];
                            int n = pi;
                            dArray[n] = dArray[n] + scores[lci][rci][pi];
                            ++pi;
                        }
                    }
                    ++rci;
                }
                ++lci;
            }
        }
        System.out.println();
        System.out.println("Checking for substates whose probs don't sum to 1");
        int pS3 = 0;
        while (pS3 < grammar.numSubStates.length) {
            if (sawPS[pS3]) {
                int pi = 0;
                while (pi < grammar.numSubStates[pS3]) {
                    if (Math.abs(1.0 - psum[pS3][pi]) > 0.001) {
                        System.out.println(" state " + pS3 + " substate " + pi + " gives bad psum: " + psum[pS3][pi]);
                    }
                    ++pi;
                }
            }
            ++pS3;
        }
    }

    public static void calculateMergeArrays(boolean[][][] mergeThesePairs, short[] newNumSubStates, short[][] mapping, short[][][] partners, short[] numSubStates) {
        int state = 0;
        while (state < numSubStates.length) {
            short[] mergeTarget = new short[mergeThesePairs[state].length];
            Arrays.fill(mergeTarget, (short)-1);
            short count = 0;
            mapping[state] = new short[numSubStates[state]];
            partners[state] = new short[numSubStates[state]][];
            short j = 0;
            while (j < numSubStates[state]) {
                if (mergeTarget[j] != -1) {
                    mapping[state][j] = mergeTarget[j];
                } else {
                    partners[state][j] = new short[1];
                    partners[state][j][0] = j;
                    mapping[state][j] = count;
                    count = (short)(count + 1);
                    short k = (short)(j + 1);
                    while (k < numSubStates[state]) {
                        if (mergeThesePairs[state][j][k]) {
                            mergeTarget[k] = mapping[state][j];
                            partners[state][j] = new short[2];
                            partners[state][j][0] = j;
                            partners[state][j][1] = k;
                            partners[state][k] = partners[state][j];
                        }
                        k = (short)(k + 1);
                    }
                }
                j = (short)(j + 1);
            }
            newNumSubStates[state] = count;
            state = (short)(state + 1);
        }
        newNumSubStates[0] = 1;
    }

    public void fixMergeWeightsEtc(boolean[][][] mergeThesePairs, double[][] mergeWeights, boolean[][][] complexMergePairs) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        short[][] mapping = new short[this.numSubStates.length][];
        short[][][] partners = new short[this.numSubStates.length][][];
        Grammar.calculateMergeArrays(mergeThesePairs, newNumSubStates, mapping, partners, this.numSubStates);
        int tag = 0;
        while (tag < this.numSubStates.length) {
            double[] newMergeWeights = new double[newNumSubStates[tag]];
            int i = 0;
            while (i < this.numSubStates[tag]) {
                short s = mapping[tag][i];
                newMergeWeights[s] = newMergeWeights[s] + mergeWeights[tag][i];
                ++i;
            }
            mergeWeights[tag] = newMergeWeights;
            boolean[][] newComplexMergePairs = new boolean[newNumSubStates[tag]][newNumSubStates[tag]];
            boolean[][] newMergeThesePairs = new boolean[newNumSubStates[tag]][newNumSubStates[tag]];
            int i2 = 0;
            while (i2 < complexMergePairs[tag].length) {
                int j = 0;
                while (j < complexMergePairs[tag].length) {
                    newComplexMergePairs[mapping[tag][i2]][mapping[tag][j]] = newComplexMergePairs[mapping[tag][i2]][mapping[tag][j]] || complexMergePairs[tag][i2][j];
                    newMergeThesePairs[mapping[tag][i2]][mapping[tag][j]] = newMergeThesePairs[mapping[tag][i2]][mapping[tag][j]] || mergeThesePairs[tag][i2][j];
                    ++j;
                }
                ++i2;
            }
            complexMergePairs[tag] = newComplexMergePairs;
            mergeThesePairs[tag] = newMergeThesePairs;
            ++tag;
        }
    }

    public void logarithmMode() {
        if (this.logarithmMode) {
            return;
        }
        this.logarithmMode = true;
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            Grammar.logarithmModeRule(this.unaryRuleMap.get(unaryRule));
        }
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            Grammar.logarithmModeRule(this.binaryRuleMap.get(binaryRule));
        }
        this.logarithmModeBRuleListArray(this.binaryRulesWithParent);
        this.logarithmModeBRuleListArray(this.binaryRulesWithLC);
        this.logarithmModeBRuleListArray(this.binaryRulesWithRC);
        this.logarithmModeBRuleArrayArray(this.splitRulesWithLC);
        this.logarithmModeBRuleArrayArray(this.splitRulesWithRC);
        this.logarithmModeBRuleArrayArray(this.splitRulesWithP);
        this.logarithmModeURuleListArray(this.unaryRulesWithParent);
        this.logarithmModeURuleListArray(this.unaryRulesWithC);
        this.logarithmModeURuleListArray(this.sumProductClosedUnaryRulesWithParent);
        this.logarithmModeURuleListArray(this.closedSumRulesWithParent);
        this.logarithmModeURuleListArray(this.closedSumRulesWithChild);
        this.logarithmModeURuleListArray(this.closedViterbiRulesWithParent);
        this.logarithmModeURuleListArray(this.closedViterbiRulesWithChild);
        this.logarithmModeURuleArrayArray(this.closedSumRulesWithP);
        this.logarithmModeURuleArrayArray(this.closedSumRulesWithC);
        this.logarithmModeURuleArrayArray(this.closedViterbiRulesWithP);
        this.logarithmModeURuleArrayArray(this.closedViterbiRulesWithC);
    }

    private void logarithmModeBRuleListArray(List<BinaryRule>[] a) {
        if (a != null) {
            List<BinaryRule>[] listArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                List<BinaryRule> l = listArray[n2];
                if (l != null) {
                    for (BinaryRule r : l) {
                        Grammar.logarithmModeRule(r);
                    }
                }
                ++n2;
            }
        }
    }

    private void logarithmModeURuleListArray(List<UnaryRule>[] a) {
        if (a != null) {
            List<UnaryRule>[] listArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                List<UnaryRule> l = listArray[n2];
                if (l != null) {
                    for (UnaryRule r : l) {
                        Grammar.logarithmModeRule(r);
                    }
                }
                ++n2;
            }
        }
    }

    private void logarithmModeBRuleArrayArray(BinaryRule[][] a) {
        if (a != null) {
            BinaryRule[][] binaryRuleArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryRule[] l = binaryRuleArray[n2];
                if (l != null) {
                    BinaryRule[] binaryRuleArray2 = l;
                    int n3 = l.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        BinaryRule r = binaryRuleArray2[n4];
                        Grammar.logarithmModeRule(r);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void logarithmModeURuleArrayArray(UnaryRule[][] a) {
        if (a != null) {
            UnaryRule[][] unaryRuleArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                UnaryRule[] l = unaryRuleArray[n2];
                if (l != null) {
                    UnaryRule[] unaryRuleArray2 = l;
                    int n3 = l.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        UnaryRule r = unaryRuleArray2[n4];
                        Grammar.logarithmModeRule(r);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private static void logarithmModeRule(BinaryRule r) {
        if (r == null || r.logarithmMode) {
            return;
        }
        r.logarithmMode = true;
        double[][][] scores = r.getScores2();
        int i = 0;
        while (i < scores.length) {
            int j = 0;
            while (j < scores[i].length) {
                if (scores[i][j] != null) {
                    int k = 0;
                    while (k < scores[i][j].length) {
                        scores[i][j][k] = Math.log(scores[i][j][k]);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        r.setScores2(scores);
    }

    private static void logarithmModeRule(UnaryRule r) {
        if (r == null || r.logarithmMode) {
            return;
        }
        r.logarithmMode = true;
        double[][] scores = r.getScores2();
        int j = 0;
        while (j < scores.length) {
            if (scores[j] != null) {
                int k = 0;
                while (k < scores[j].length) {
                    scores[j][k] = Math.log(scores[j][k]);
                    ++k;
                }
            }
            ++j;
        }
        r.setScores2(scores);
    }

    public boolean isLogarithmMode() {
        return this.logarithmMode;
    }

    public final boolean isGrammarTag(int n) {
        return this.isGrammarTag[n];
    }

    public Grammar projectGrammar(double[] condProbs, int[][] fromMapping, int[][] toSubstateMapping) {
        short pcS;
        short[] newNumSubStates = new short[this.numSubStates.length];
        int state = 0;
        while (state < this.numSubStates.length) {
            newNumSubStates[state] = (short)toSubstateMapping[state][0];
            ++state;
        }
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            pcS = binaryRule.getParentState();
            short lcS = binaryRule.getLeftChildState();
            short rcS = binaryRule.getRightChildState();
            double[][][] oldScores = binaryRule.getScores2();
            double[][][] newScores = new double[newNumSubStates[lcS]][newNumSubStates[rcS]][newNumSubStates[pcS]];
            int lS = 0;
            while (lS < this.numSubStates[lcS]) {
                int rS = 0;
                while (rS < this.numSubStates[rcS]) {
                    if (oldScores[lS][rS] != null) {
                        int pS = 0;
                        while (pS < this.numSubStates[pcS]) {
                            double[] dArray = newScores[toSubstateMapping[lcS][lS + 1]][toSubstateMapping[rcS][rS + 1]];
                            int n = toSubstateMapping[pcS][pS + 1];
                            dArray[n] = dArray[n] + condProbs[fromMapping[pcS][pS]] * oldScores[lS][rS][pS];
                            ++pS;
                        }
                    }
                    ++rS;
                }
                ++lS;
            }
            BinaryRule newRule = new BinaryRule(binaryRule, newScores);
            grammar.addBinary(newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            pcS = unaryRule.getParentState();
            short ccS = unaryRule.getChildState();
            double[][] oldScores = unaryRule.getScores2();
            double[][] newScores = new double[newNumSubStates[ccS]][newNumSubStates[pcS]];
            int cS = 0;
            while (cS < this.numSubStates[ccS]) {
                if (oldScores[cS] != null) {
                    int pS = 0;
                    while (pS < this.numSubStates[pcS]) {
                        double[] dArray = newScores[toSubstateMapping[ccS][cS + 1]];
                        int n = toSubstateMapping[pcS][pS + 1];
                        dArray[n] = dArray[n] + condProbs[fromMapping[pcS][pS]] * oldScores[cS][pS];
                        ++pS;
                    }
                }
                ++cS;
            }
            UnaryRule newRule = new UnaryRule(unaryRule, newScores);
            grammar.addUnary(newRule);
        }
        grammar.computePairsOfUnaries();
        grammar.makeCRArrays();
        grammar.isGrammarTag = this.isGrammarTag;
        return grammar;
    }

    public Grammar copyGrammar(boolean noUnaryChains) {
        Rule newRule;
        short[] newNumSubStates = (short[])this.numSubStates.clone();
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            newRule = new BinaryRule(binaryRule);
            grammar.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            newRule = new UnaryRule(unaryRule);
            grammar.addUnary((UnaryRule)newRule);
        }
        if (noUnaryChains) {
            this.closedViterbiRulesWithParent = this.unaryRulesWithParent;
            this.closedSumRulesWithParent = this.unaryRulesWithParent;
            this.closedViterbiRulesWithChild = this.unaryRulesWithC;
            this.closedSumRulesWithChild = this.unaryRulesWithC;
        } else {
            grammar.computePairsOfUnaries();
        }
        grammar.makeCRArrays();
        grammar.isGrammarTag = this.isGrammarTag;
        return grammar;
    }

    public Grammar projectTo0LevelGrammar(double[] condProbs, int[][] fromMapping, int[][] toMapping) {
        short s;
        short s2;
        short pcS;
        int newNumStates = fromMapping[fromMapping.length - 1][0];
        double[][] newBinaryProbs = new double[newNumStates][newNumStates];
        double[] newUnaryProbs = new double[newNumStates];
        short[] newNumSubStates = new short[this.numSubStates.length];
        Arrays.fill(newNumSubStates, (short)1);
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            pcS = binaryRule.getParentState();
            short lcS = binaryRule.getLeftChildState();
            short rcS = binaryRule.getRightChildState();
            double[][][] oldScores = binaryRule.getScores2();
            int lS = 0;
            while (lS < this.numSubStates[lcS]) {
                int rS = 0;
                while (rS < this.numSubStates[rcS]) {
                    if (oldScores[lS][rS] != null) {
                        int pS = 0;
                        while (pS < this.numSubStates[pcS]) {
                            double[] dArray = newBinaryProbs[toMapping[lcS][lS]];
                            int n = toMapping[rcS][rS];
                            dArray[n] = dArray[n] + condProbs[fromMapping[pcS][pS]] * oldScores[lS][rS][pS];
                            ++pS;
                        }
                    }
                    ++rS;
                }
                ++lS;
            }
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            pcS = unaryRule.getParentState();
            short ccS = unaryRule.getChildState();
            double[][] oldScores = unaryRule.getScores2();
            int cS = 0;
            while (cS < this.numSubStates[ccS]) {
                if (oldScores[cS] != null) {
                    int pS = 0;
                    while (pS < this.numSubStates[pcS]) {
                        int n = toMapping[ccS][cS];
                        newUnaryProbs[n] = newUnaryProbs[n] + condProbs[fromMapping[pcS][pS]] * oldScores[cS][pS];
                        ++pS;
                    }
                }
                ++cS;
            }
        }
        boolean bl = false;
        while (s2 < newBinaryProbs.length) {
            short rS = 0;
            while (rS < newBinaryProbs.length) {
                if (newBinaryProbs[s2][rS] > 0.0) {
                    double[][][] newScores = new double[1][1][1];
                    newScores[0][0][0] = newBinaryProbs[s2][rS];
                    BinaryRule newRule = new BinaryRule(0, s2, rS, newScores);
                    grammar.addBinary(newRule);
                }
                rS = (short)(rS + 1);
            }
            s2 = (short)(s2 + true);
        }
        boolean bl2 = false;
        while (s < newUnaryProbs.length) {
            if (newUnaryProbs[s] > 0.0) {
                double[][] newScores = new double[1][1];
                newScores[0][0] = newUnaryProbs[s];
                UnaryRule newRule = new UnaryRule(0, s, newScores);
                grammar.addUnary(newRule);
            }
            s = (short)(s + true);
        }
        grammar.computePairsOfUnaries();
        grammar.makeCRArrays();
        grammar.isGrammarTag = this.isGrammarTag;
        return grammar;
    }

    public double[] computeConditionalProbabilities(int[][] fromMapping, int[][] toMapping) {
        double[][] transitionProbs = this.computeProductionProbabilities(fromMapping);
        double[] expectedCounts = this.computeExpectedCounts(transitionProbs);
        double[] condProbs = new double[expectedCounts.length];
        int projectedState = 0;
        while (projectedState < toMapping[toMapping.length - 1][0]) {
            int substate;
            double sum = 0.0;
            int state = 0;
            while (state < fromMapping.length - 1) {
                substate = 0;
                while (substate < fromMapping[state].length) {
                    if (toMapping[state][substate] == projectedState) {
                        sum += expectedCounts[fromMapping[state][substate]];
                    }
                    ++substate;
                }
                ++state;
            }
            state = 0;
            while (state < fromMapping.length - 1) {
                substate = 0;
                while (substate < fromMapping[state].length) {
                    if (toMapping[state][substate] == projectedState) {
                        condProbs[fromMapping[state][substate]] = expectedCounts[fromMapping[state][substate]] / sum;
                    }
                    ++substate;
                }
                ++state;
            }
            ++projectedState;
        }
        return condProbs;
    }

    public int[][] computeToMapping(int level, int[][] toSubstateMapping) {
        if (level == -1) {
            return this.computeMapping(-1);
        }
        short[] numSubStates = this.numSubStates;
        int[][] mapping = new int[numSubStates.length + 1][];
        int k = 0;
        int state = 0;
        while (state < numSubStates.length) {
            mapping[state] = new int[numSubStates[state]];
            int oldVal = -1;
            int substate = 0;
            while (substate < numSubStates[state]) {
                if (substate == 0 || oldVal != toSubstateMapping[state][substate + 1]) {
                    // empty if block
                }
                mapping[state][substate] = ++k;
                oldVal = toSubstateMapping[state][substate + 1];
                ++substate;
            }
            ++k;
            ++state;
        }
        mapping[numSubStates.length] = new int[1];
        mapping[numSubStates.length][0] = k;
        return mapping;
    }

    public int[][] computeMapping(int level) {
        short[] numSubStates = this.numSubStates;
        int[][] mapping = new int[numSubStates.length + 1][];
        int k = 0;
        int state = 0;
        while (state < numSubStates.length) {
            mapping[state] = new int[numSubStates[state]];
            Arrays.fill(mapping[state], -1);
            int substate = 0;
            while (substate < numSubStates[state]) {
                mapping[state][substate] = level >= 1 ? k++ : (level == -1 ? (this.isGrammarTag(state) ? 0 : state) : state);
                ++substate;
            }
            ++state;
        }
        mapping[numSubStates.length] = new int[1];
        mapping[numSubStates.length][0] = level < 1 ? numSubStates.length : k;
        return mapping;
    }

    public int[][] computeSubstateMapping(int level) {
        short[] numSubStates = this.numSubStates;
        int[][] mapping = new int[numSubStates.length][];
        int state = 0;
        while (state < numSubStates.length) {
            mapping[state] = new int[numSubStates[state] + 1];
            int k = 0;
            if (level >= 0) {
                Arrays.fill(mapping[state], -1);
                Tree<Short> hierarchy = this.splitTrees[state];
                List<Tree<Short>> subTrees = hierarchy.getAtDepth(level);
                for (Tree<Short> subTree : subTrees) {
                    List<Short> leaves = subTree.getYield();
                    for (Short substate : leaves) {
                        if (substate == numSubStates[state]) {
                            System.out.print("Will crash.");
                        }
                        mapping[state][substate.shortValue() + 1] = k;
                    }
                    ++k;
                }
            } else {
                k = 1;
            }
            mapping[state][0] = k;
            ++state;
        }
        return mapping;
    }

    public void computeReverseSubstateMapping(int level, int[][] lChildMap, int[][] rChildMap) {
        int state = 0;
        while (state < this.numSubStates.length) {
            Tree<Short> hierarchy = this.splitTrees[state];
            List<Tree<Short>> subTrees = hierarchy.getAtDepth(level);
            lChildMap[state] = new int[subTrees.size()];
            rChildMap[state] = new int[subTrees.size()];
            for (Tree<Short> subTree : subTrees) {
                short substate = subTree.getLabel();
                if (subTree.isLeaf()) {
                    lChildMap[state][substate] = substate;
                    rChildMap[state][substate] = substate;
                    continue;
                }
                boolean first = true;
                int nChildren = subTree.getChildren().size();
                for (Tree<Short> child : subTree.getChildren()) {
                    if (first) {
                        lChildMap[state][substate] = child.getLabel().shortValue();
                        first = false;
                    } else {
                        rChildMap[state][substate] = child.getLabel().shortValue();
                    }
                    if (nChildren != 1) continue;
                    rChildMap[state][substate] = child.getLabel().shortValue();
                }
            }
            ++state;
        }
    }

    private double[] computeExpectedCounts(double[][] transitionProbs) {
        double[] expectedCounts = new double[transitionProbs.length];
        double[] tmpCounts = new double[transitionProbs.length];
        expectedCounts[0] = 1.0;
        tmpCounts[0] = 1.0;
        int iter = 0;
        double diff = 1.0;
        double sum = 1.0;
        while (diff > 1.0E-10 && iter < 50) {
            ++iter;
            int state = 1;
            while (state < expectedCounts.length) {
                int pState = 0;
                while (pState < expectedCounts.length) {
                    int n = state;
                    tmpCounts[n] = tmpCounts[n] + expectedCounts[pState] * transitionProbs[pState][state];
                    ++pState;
                }
                ++state;
            }
            diff = 0.0;
            sum = 1.0;
            state = 1;
            while (state < expectedCounts.length) {
                diff += Math.abs(expectedCounts[state] - tmpCounts[state]);
                expectedCounts[state] = tmpCounts[state];
                sum += tmpCounts[state];
                tmpCounts[state] = 0.0;
                ++state;
            }
            expectedCounts[0] = 1.0;
            tmpCounts[0] = 1.0;
        }
        return expectedCounts;
    }

    private double[][] computeProductionProbabilities(int[][] mapping) {
        short[] numSubStates = this.numSubStates;
        int totalStates = mapping[numSubStates.length][0];
        double[][] W = new double[totalStates][totalStates];
        int state = 0;
        while (state < numSubStates.length) {
            Object scores;
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            int i = 0;
            while (i < parentRules.length) {
                BinaryRule binaryRule = parentRules[i];
                short lState = binaryRule.leftChildState;
                short rState = binaryRule.rightChildState;
                scores = binaryRule.getScores2();
                int lS = 0;
                while (lS < numSubStates[lState]) {
                    int rS = 0;
                    while (rS < numSubStates[rState]) {
                        if (scores[lS][rS] != null) {
                            int pS = 0;
                            while (pS < numSubStates[state]) {
                                double[] dArray = W[mapping[state][pS]];
                                int n = mapping[lState][lS];
                                dArray[n] = dArray[n] + scores[lS][rS][pS];
                                double[] dArray2 = W[mapping[state][pS]];
                                int n2 = mapping[rState][rS];
                                dArray2[n2] = dArray2[n2] + scores[lS][rS][pS];
                                ++pS;
                            }
                        }
                        ++rS;
                    }
                    ++lS;
                }
                ++i;
            }
            List<UnaryRule> uRules = this.getUnaryRulesByParent(state);
            for (UnaryRule unaryRule : uRules) {
                short cState = unaryRule.childState;
                if (cState == state) continue;
                scores = unaryRule.getScores2();
                int cS = 0;
                while (cS < numSubStates[cState]) {
                    if (scores[cS] != null) {
                        int pS = 0;
                        while (pS < numSubStates[state]) {
                            double[] dArray = W[mapping[state][pS]];
                            int n = mapping[cState][cS];
                            dArray[n] = dArray[n] + scores[cS][pS];
                            ++pS;
                        }
                    }
                    ++cS;
                }
            }
            ++state;
        }
        return W;
    }

    public void computeProperClosures() {
        double[][] scores;
        int i;
        int[][] map = new int[this.numStates][];
        int index = 0;
        int state = 0;
        while (state < this.numStates) {
            map[state] = new int[this.numSubStates[state]];
            int substate = 0;
            while (substate < this.numSubStates[state]) {
                map[state][substate] = index++;
                ++substate;
            }
            ++state;
        }
        double[][][] sumClosureMatrix = new double[10][index][index];
        int parentState = 0;
        while (parentState < this.numStates) {
            i = 0;
            while (i < this.unaryRulesWithParent[parentState].size()) {
                UnaryRule rule = this.unaryRulesWithParent[parentState].get(i);
                short childState = rule.getChildState();
                scores = rule.getScores2();
                int childSubState = 0;
                while (childSubState < this.numSubStates[childState]) {
                    if (scores[childSubState] != null) {
                        int parentSubState = 0;
                        while (parentSubState < this.numSubStates[parentState]) {
                            sumClosureMatrix[0][map[parentState][parentSubState]][map[childState][childSubState]] = scores[childSubState][parentSubState];
                            ++parentSubState;
                        }
                    }
                    ++childSubState;
                }
                ++i;
            }
            ++parentState;
        }
        int length = 1;
        while (length < 10) {
            short interState = 0;
            while (interState < this.numStates) {
                int i2 = 0;
                while (i2 < this.unaryRulesWithParent[interState].size()) {
                    UnaryRule rule = this.unaryRulesWithParent[interState].get(i2);
                    short endState = rule.getChildState();
                    double[][] scores2 = rule.getScores2();
                    int startState = 0;
                    while (startState < this.numStates) {
                        int startSubState = 0;
                        while (startSubState < this.numSubStates[startState]) {
                            int endSubState = 0;
                            while (endSubState < this.numSubStates[endState]) {
                                double ruleScore = 0.0;
                                if (scores2[endSubState] != null) {
                                    int interSubState = 0;
                                    while (interSubState < this.numSubStates[interState]) {
                                        ruleScore += sumClosureMatrix[length - 1][map[startState][startSubState]][map[interState][interSubState]] * scores2[endSubState][interSubState];
                                        ++interSubState;
                                    }
                                    double[] dArray = sumClosureMatrix[length][map[startState][startSubState]];
                                    int n = map[endState][endSubState];
                                    dArray[n] = dArray[n] + ruleScore;
                                }
                                ++endSubState;
                            }
                            ++startSubState;
                        }
                        ++startState;
                    }
                    ++i2;
                }
                interState = (short)(interState + 1);
            }
            ++length;
        }
        double[][] sumClosureScores = new double[index][index];
        int length2 = 0;
        while (length2 < 10) {
            int startState = 0;
            while (startState < index) {
                int endState = 0;
                while (endState < index) {
                    double[] dArray = sumClosureScores[startState];
                    int n = endState;
                    dArray[n] = dArray[n] + sumClosureMatrix[length2][startState][endState];
                    ++endState;
                }
                ++startState;
            }
            ++length2;
        }
        this.closedSumRulesWithParent = new List[this.numStates];
        this.closedSumRulesWithChild = new List[this.numStates];
        short startState = 0;
        while (startState < this.numStates) {
            this.closedSumRulesWithParent[startState] = new ArrayList<UnaryRule>();
            this.closedSumRulesWithChild[startState] = new ArrayList<UnaryRule>();
            startState = (short)(startState + 1);
        }
        startState = 0;
        while (startState < this.numStates) {
            short endState = 0;
            while (endState < this.numStates) {
                if (startState != endState) {
                    boolean atLeastOneNonZero = false;
                    scores = new double[this.numSubStates[endState]][this.numSubStates[startState]];
                    int startSubState = 0;
                    while (startSubState < this.numSubStates[startState]) {
                        int endSubState = 0;
                        while (endSubState < this.numSubStates[endState]) {
                            double score = sumClosureScores[map[startState][startSubState]][map[endState][endSubState]];
                            if (score > 0.0) {
                                scores[endSubState][startSubState] = score;
                                atLeastOneNonZero = true;
                            }
                            ++endSubState;
                        }
                        ++startSubState;
                    }
                    if (atLeastOneNonZero) {
                        UnaryRule newUnary = new UnaryRule(startState, endState, scores);
                        this.addUnary(newUnary);
                        this.closedSumRulesWithParent[startState].add(newUnary);
                        this.closedSumRulesWithChild[endState].add(newUnary);
                    }
                }
                endState = (short)(endState + 1);
            }
            startState = (short)(startState + 1);
        }
        if (this.closedSumRulesWithP == null) {
            this.closedSumRulesWithP = new UnaryRule[this.numStates][];
            this.closedSumRulesWithC = new UnaryRule[this.numStates][];
        }
        i = 0;
        while (i < this.numStates) {
            this.closedSumRulesWithP[i] = this.closedSumRulesWithParent[i].toArray(new UnaryRule[0]);
            this.closedSumRulesWithC[i] = this.closedSumRulesWithChild[i].toArray(new UnaryRule[0]);
            ++i;
        }
    }

    public void writeSplitTrees(Writer w) {
        PrintWriter out = new PrintWriter(w);
        int state = 1;
        while (state < this.numStates) {
            String tag = (String)this.tagNumberer.object(state);
            if (this.isGrammarTag[state] && tag.endsWith("^g")) {
                tag = tag.substring(0, tag.length() - 2);
            }
            out.write(String.valueOf(tag) + "\t" + this.splitTrees[state].toString() + "\n");
            ++state;
        }
        out.flush();
        out.close();
    }

    public int[][] getClosedSumPaths() {
        return this.closedSumPaths;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RandomInitializationType {
        INITIALIZE_WITH_SMALL_RANDOMIZATION,
        INITIALIZE_LIKE_MMT;

    }

    public static class RuleNotFoundException
    extends Exception {
        private static final long serialVersionUID = 2L;
    }
}

