/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import java.util.HashMap;

public class GrammarAnalyzer {
    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        String inFileName = opts.grFileName;
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        Lexicon lexicon = pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        if (opts.threshold > -1.0) {
            System.out.println("Remving rules with probability below " + opts.threshold + ".");
            grammar.splitRules();
            grammar.removeUnlikelyRules(opts.threshold, 1.0);
            lexicon.removeUnlikelyTags(opts.threshold, 1.0);
        }
        int[] tagTotal = new int[grammar.numSubStates.length];
        int[] tagOne = new int[grammar.numSubStates.length];
        int[] gr = GrammarAnalyzer.computeAndPrintCounts(grammar, tagTotal, tagOne);
        GrammarAnalyzer.printStats("Grammar", gr);
        int[] lex = GrammarAnalyzer.computeAndPrintCounts(lexicon, tagTotal, tagOne);
        GrammarAnalyzer.printStats("Lexicon", lex);
        ArrayUtil.addInPlace(gr, lex);
        GrammarAnalyzer.printStats("Together", gr);
        System.out.println("\nTag specific statistics (x=1):");
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        int i = 0;
        while (i < tagTotal.length) {
            System.out.println(tagNumberer.object(i) + ": " + tagOne[i] + "/" + tagTotal[i]);
            ++i;
        }
        System.exit(0);
    }

    public static int[] computeAndPrintCounts(Grammar gr, int[] tagTotal, int[] tagOne) {
        int nulledOut = 0;
        int zero = 0;
        int belowOne = 0;
        int one = 0;
        int aboveOne = 0;
        int total = 0;
        int unaryEqualSlices = 0;
        int binaryEqualSlices = 0;
        int unarySlices = 0;
        int binarySlices = 0;
        int unaryEqual = 0;
        int binaryEqual = 0;
        int unary = 0;
        int binary = 0;
        int state = 0;
        while (state < gr.numStates) {
            int nParentSubStates = gr.numSubStates[state];
            for (UnaryRule uRule : gr.getUnaryRulesByParent(state)) {
                int nChildSubStates = gr.numSubStates[uRule.childState];
                total += nChildSubStates * nParentSubStates;
                ++unary;
                double[][] scores = uRule.getScores2();
                int j = 0;
                while (j < nChildSubStates) {
                    ++unarySlices;
                    if (scores[j] == null) {
                        nulledOut += nParentSubStates;
                    } else {
                        boolean sliceTheSame = true;
                        double first = scores[j][0];
                        int i = 0;
                        while (i < nParentSubStates) {
                            double p = scores[j][i];
                            if (p == 0.0) {
                                ++zero;
                            } else if (p == 1.0) {
                                ++one;
                            } else if (p > 1.0) {
                                ++aboveOne;
                            } else {
                                ++belowOne;
                            }
                            if (sliceTheSame && p != first) {
                                sliceTheSame = false;
                            }
                            int n = state;
                            tagTotal[n] = tagTotal[n] + 1;
                            if (p == 1.0) {
                                int n2 = state;
                                tagOne[n2] = tagOne[n2] + 1;
                            }
                            ++i;
                        }
                        if (sliceTheSame) {
                            ++unaryEqualSlices;
                        }
                    }
                    ++j;
                }
            }
            BinaryRule[] binaryRuleArray = gr.splitRulesWithP(state);
            int n = binaryRuleArray.length;
            int n3 = 0;
            while (n3 < n) {
                BinaryRule bRule = binaryRuleArray[n3];
                double[][][] scores = bRule.getScores2();
                ++binary;
                int j = 0;
                while (j < scores.length) {
                    int k = 0;
                    while (k < scores[j].length) {
                        total += nParentSubStates;
                        ++binarySlices;
                        if (scores[j][k] == null) {
                            nulledOut += nParentSubStates;
                        } else {
                            boolean sliceTheSame = true;
                            double first = scores[j][k][0];
                            int i = 0;
                            while (i < nParentSubStates) {
                                double p = scores[j][k][i];
                                if (p == 0.0) {
                                    ++zero;
                                } else if (p == 1.0) {
                                    ++one;
                                } else if (p > 1.0) {
                                    ++aboveOne;
                                } else {
                                    ++belowOne;
                                }
                                if (sliceTheSame && p != first) {
                                    sliceTheSame = false;
                                }
                                int n4 = state;
                                tagTotal[n4] = tagTotal[n4] + 1;
                                if (p == 1.0) {
                                    int n5 = state;
                                    tagOne[n5] = tagOne[n5] + 1;
                                }
                                ++i;
                            }
                            if (sliceTheSame) {
                                ++binaryEqualSlices;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++n3;
            }
            ++state;
        }
        System.out.println("Same across parent: " + unaryEqualSlices + "/" + unarySlices + " (unary), " + binaryEqualSlices + "/" + binarySlices + " (binary)");
        System.out.println("All the same: " + unaryEqual + "/" + unary + " (unary), " + binaryEqual + "/" + binary + " (binary)");
        return new int[]{nulledOut, zero, belowOne, one, aboveOne, total};
    }

    public static int[] computeAndPrintCounts(Lexicon lexicon, int[] tagTotal, int[] tagOne) {
        int zero = 0;
        int belowOne = 0;
        int one = 0;
        int aboveOne = 0;
        int total = 0;
        int equal = 0;
        int pairs = 0;
        if (lexicon instanceof SophisticatedLexicon) {
            SophisticatedLexicon lex = (SophisticatedLexicon)lexicon;
            short tag = 0;
            while (tag < lex.numSubStates.length) {
                HashMap<String, double[]> tagMap = lex.wordToTagCounters[tag];
                if (tagMap != null) {
                    for (String word : tagMap.keySet()) {
                        double[] lexiconScores = lex.score(word, tag, 0, false, false);
                        int i = 0;
                        while (i < lexiconScores.length) {
                            ++total;
                            double p = lexiconScores[i];
                            if (p == 0.0) {
                                ++zero;
                            } else if (p == 1.0) {
                                ++one;
                            } else if (p > 1.0) {
                                ++aboveOne;
                            } else {
                                ++belowOne;
                            }
                            short s = tag;
                            tagTotal[s] = tagTotal[s] + 1;
                            if (p == 1.0) {
                                short s2 = tag;
                                tagOne[s2] = tagOne[s2] + 1;
                            }
                            ++i;
                        }
                    }
                }
                tag = (short)(tag + 1);
            }
        } else {
            SimpleLexicon lex = (SimpleLexicon)lexicon;
            int tag = 0;
            while (tag < lex.scores.length) {
                if (lex.tagWordIndexer[tag].size() != 0) {
                    int word = 0;
                    while (word < lex.scores[tag][0].length) {
                        boolean allTheSame = true;
                        double first = lex.scores[tag][0][word];
                        ++pairs;
                        int substate = 0;
                        while (substate < lex.numSubStates[tag]) {
                            ++total;
                            double p = lex.scores[tag][substate][word];
                            if (p == 0.0) {
                                ++zero;
                            } else if (p == 1.0) {
                                ++one;
                            } else if (p > 1.0) {
                                ++aboveOne;
                            } else {
                                ++belowOne;
                            }
                            if (allTheSame && p != first) {
                                allTheSame = false;
                            }
                            int n = tag;
                            tagTotal[n] = tagTotal[n] + 1;
                            if (p == 1.0) {
                                int n2 = tag;
                                tagOne[n2] = tagOne[n2] + 1;
                            }
                            ++substate;
                        }
                        if (allTheSame) {
                            ++equal;
                        }
                        ++word;
                    }
                }
                ++tag;
            }
            System.out.println("Same across parent: " + equal + "/" + pairs);
        }
        int[] nArray = new int[6];
        nArray[1] = zero;
        nArray[2] = belowOne;
        nArray[3] = one;
        nArray[4] = aboveOne;
        nArray[5] = total;
        return nArray;
    }

    public static void printStats(String title, int[] vals) {
        int nulledOut = vals[0];
        int zero = vals[1];
        int belowOne = vals[2];
        int one = vals[3];
        int aboveOne = vals[4];
        int total = vals[5];
        System.out.println(String.valueOf(title) + " statistics:");
        System.out.println("Total rules:\t" + total);
        System.out.println("Total non-zero:\t" + (belowOne + one + aboveOne) + "\n");
        System.out.println("Nulled out:\t" + nulledOut);
        System.out.println("x = 0:\t\t" + zero);
        System.out.println("0 < x < 1:\t" + belowOne);
        System.out.println("x = 1:\t\t" + one);
        System.out.println("x > 1:\t\t" + aboveOne + "\n");
    }

    public static class Options {
        @Option(name="-in", required=true, usage="Grammarfile")
        public String grFileName;
        @Option(name="-t", usage="Threshold for pruning unlikely rules")
        public double threshold = -1.0;
    }
}

