/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConstrainedHierarchicalTwoChartParser;
import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.FullState;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.SearchState;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarStatistics {
    private static int topN = 10;
    public Grammar grammar;
    public Numberer tagNumberer;
    public int nScores;
    static NumberFormat f = NumberFormat.getInstance();

    public GrammarStatistics(Grammar grammar, Numberer tagNumberer, int nScores) {
        this.grammar = grammar;
        this.tagNumberer = tagNumberer;
        this.nScores = nScores;
    }

    PriorityQueue<SearchState> getTopProductions(FullState p) {
        PriorityQueue<SearchState> results = new PriorityQueue<SearchState>(this.nScores + 1);
        PriorityQueue<SearchState> unExpanded = new PriorityQueue<SearchState>();
        unExpanded.add(new SearchState(p, 0.0), 0.0);
        while (unExpanded.size() != 0 && (results.size() < this.nScores || ((SearchState)unExpanded.peek()).score > -results.peek().score)) {
            SearchState state = (SearchState)unExpanded.next();
            if (state.danglingState == null || state.produced.size() != 0 && !this.continues(state.danglingState.state)) {
                if (state.danglingState != null) {
                    state = state.extend(state.danglingState, null, 0.0, false);
                }
                results.add(state, -state.score);
                if (results.size() <= this.nScores) continue;
                results.next();
                continue;
            }
            for (UnaryRule unaryRule : this.grammar.getUnaryRulesByParent(state.danglingState.state)) {
                double[][] scores = unaryRule.getScores2();
                short cSubState = 0;
                while (cSubState < this.grammar.numSubStates[unaryRule.getChildState()]) {
                    if (scores[cSubState] != null) {
                        double rscore = scores[cSubState][state.danglingState.substate];
                        FullState s = new FullState(unaryRule.getChildState(), cSubState);
                        SearchState newState = state.extend(s, null, rscore, false);
                        unExpanded.add(newState, newState.score);
                    }
                    cSubState = (short)(cSubState + 1);
                }
            }
            BinaryRule[] binaryRuleArray = this.grammar.splitRulesWithP(state.danglingState.state);
            int n = binaryRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryRule binaryRule = binaryRuleArray[n2];
                double[][][] scores = binaryRule.getScores2();
                short lSubState = 0;
                while (lSubState < this.grammar.numSubStates[binaryRule.getLeftChildState()]) {
                    FullState ls = new FullState(binaryRule.getLeftChildState(), lSubState);
                    short rSubState = 0;
                    while (rSubState < this.grammar.numSubStates[binaryRule.getRightChildState()]) {
                        if (scores[lSubState][rSubState] != null) {
                            FullState rs = new FullState(binaryRule.getRightChildState(), rSubState);
                            double rscore = scores[lSubState][rSubState][state.danglingState.substate];
                            SearchState newState = this.continues(ls.state) ? state.extend(rs, ls, rscore, true) : state.extend(ls, rs, rscore, false);
                            unExpanded.add(newState, newState.score);
                        }
                        rSubState = (short)(rSubState + 1);
                    }
                    lSubState = (short)(lSubState + 1);
                }
                ++n2;
            }
        }
        return results;
    }

    PriorityQueue<SearchState> getTopParentRuleProductions(FullState c, double[] probState, double[][] probSubGivenState) {
        PriorityQueue<SearchState> results = new PriorityQueue<SearchState>(this.nScores + 1);
        PriorityQueue<SearchState> unExpanded = new PriorityQueue<SearchState>();
        double score = -(probState[c.state] + probSubGivenState[c.state][c.substate]);
        unExpanded.add(new SearchState(c, c, score), -score);
        int maxSize = 10000;
        while (unExpanded.size() != 0 && unExpanded.size() < maxSize && (results.size() < this.nScores || ((SearchState)unExpanded.peek()).score > -results.peek().score)) {
            SearchState newState;
            double rscore;
            FullState rs;
            FullState ps;
            short pSubState;
            SearchState state = (SearchState)unExpanded.next();
            if (state.danglingState == null || state.extended && !this.continues(state.danglingState.state)) {
                if (state.danglingState != null) {
                    state.parent = state.danglingState;
                }
                state.score += probState[state.parent.state] + probSubGivenState[state.parent.state][state.parent.substate];
                results.add(state, -state.score);
                if (results.size() <= this.nScores) continue;
                results.next();
                continue;
            }
            for (UnaryRule unaryRule : this.grammar.getUnaryRulesByChild(state.danglingState.state)) {
                double[][] scores = unaryRule.getScores2();
                if (scores[state.danglingState.substate] == null) continue;
                short pSubState2 = 0;
                while (pSubState2 < this.grammar.numSubStates[unaryRule.getParentState()]) {
                    double rscore2 = scores[state.danglingState.substate][pSubState2];
                    FullState s = new FullState(unaryRule.getParentState(), pSubState2);
                    SearchState newState2 = state.extendUp(null, s, rscore2, false);
                    unExpanded.add(newState2, newState2.score);
                    pSubState2 = (short)(pSubState2 + 1);
                }
            }
            BinaryRule[] binaryRuleArray = this.grammar.splitRulesWithLC(state.danglingState.state);
            int n = binaryRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryRule binaryRule = binaryRuleArray[n2];
                double[][][] scores = binaryRule.getScores2();
                pSubState = 0;
                while (pSubState < this.grammar.numSubStates[binaryRule.getParentState()]) {
                    ps = new FullState(binaryRule.getParentState(), pSubState);
                    short rSubState = 0;
                    while (rSubState < this.grammar.numSubStates[binaryRule.getRightChildState()]) {
                        if (scores[state.danglingState.substate][rSubState] != null) {
                            rs = new FullState(binaryRule.getRightChildState(), rSubState);
                            rscore = scores[state.danglingState.substate][rSubState][pSubState];
                            newState = state.extendUp(rs, ps, rscore, false);
                            unExpanded.add(newState, newState.score);
                        }
                        rSubState = (short)(rSubState + 1);
                    }
                    pSubState = (short)(pSubState + 1);
                }
                ++n2;
            }
            binaryRuleArray = this.grammar.splitRulesWithRC(state.danglingState.state);
            n = binaryRuleArray.length;
            n2 = 0;
            while (n2 < n) {
                BinaryRule binaryRule = binaryRuleArray[n2];
                double[][][] scores = binaryRule.getScores2();
                pSubState = 0;
                while (pSubState < this.grammar.numSubStates[binaryRule.getParentState()]) {
                    ps = new FullState(binaryRule.getParentState(), pSubState);
                    short lSubState = 0;
                    while (lSubState < this.grammar.numSubStates[binaryRule.getLeftChildState()]) {
                        if (scores[lSubState][state.danglingState.substate] != null) {
                            rs = new FullState(binaryRule.getLeftChildState(), lSubState);
                            rscore = scores[lSubState][state.danglingState.substate][pSubState];
                            newState = state.extendUp(rs, ps, rscore, true);
                            unExpanded.add(newState, newState.score);
                        }
                        lSubState = (short)(lSubState + 1);
                    }
                    pSubState = (short)(pSubState + 1);
                }
                ++n2;
            }
        }
        return results;
    }

    public boolean continues(short state) {
        return ((String)this.tagNumberer.object(state)).charAt(0) == '@';
    }

    public static String pad(String s, int width, char c) {
        StringBuffer sb = new StringBuffer(s);
        int i = s.length();
        while (i < width) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, false);
        System.out.println("Calling GrammarStatistics with " + optParser.getPassedInOptions());
        f.setMaximumFractionDigits(5);
        System.out.println("<html><body>");
        System.out.println("<h1>Links</h1><ul>");
        System.out.println("<li><a href=\"#lexicon\">Lexicon</a></li>");
        System.out.println("<li><a href=\"#grammar\">Grammar</a></li>");
        System.out.println("<li><a href=\"#trunks\">Trunks</a></li>");
        System.out.println("<li><a href=\"#parents\">Parents</a></li>");
        System.out.println("<li><a href=\"#parentrules\">Parent Rules</a></li>");
        System.out.println("</ul>");
        System.out.println("<!--");
        String inFileName = opts.in;
        String outName = opts.out;
        System.out.println("Loading grammar from " + inFileName + ".");
        String wsjLoc = opts.path;
        boolean columnOutput = true;
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        Lexicon lexicon = pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        grammar.splitRules();
        pData.Save(String.valueOf(outName) + ".gr");
        System.out.println("Writing grammar to file grammar.data...");
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(String.valueOf(outName) + ".grammar"));
            grammar.writeData(output);
            if (output != null) {
                ((Writer)output).close();
            }
            output = new BufferedWriter(new FileWriter(String.valueOf(outName) + ".lexicon"));
            output.write(lexicon.toString());
            if (output != null) {
                ((Writer)output).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if ((pData = ParserData.Load(inFileName)) == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        grammar = pData.getGrammar();
        grammar.splitRules();
        lexicon = pData.getLexicon();
        ParserData pDataNoLog = ParserData.Load(inFileName);
        if (pDataNoLog == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar nonLogGrammar = pDataNoLog.getGrammar();
        Lexicon nonLogLexicon = pDataNoLog.getLexicon();
        SpanPredictor spanPredictor = pDataNoLog.getSpanPredictor();
        ArrayParser parser = new ArrayParser(nonLogGrammar, nonLogLexicon);
        System.out.println("-->");
        Corpus corpus = new Corpus(wsjLoc, opts.treebank, 1.0, false);
        List<Tree<String>> trainTrees = Corpus.binarizeAndFilterTrees(corpus.getTrainTrees(), pData.getV_markov(), pData.getH_markov(), opts.maxL, pData.getBinarization(), false, false);
        trainTrees = Corpus.filterTreesForConditional(trainTrees, false, false, false);
        StateSetTreeList trainStateSetTrees = new StateSetTreeList(trainTrees, nonLogGrammar.numSubStates, false, tagNumberer);
        int padding = 3;
        topN = 30;
        GrammarStatistics.printLexiconStatistics(lexicon, tagNumberer, grammar.isGrammarTag, grammar, trainStateSetTrees, opts);
        GrammarStatistics gs = new GrammarStatistics(grammar, tagNumberer, topN);
        HashSet<Short> noContinueTags = new HashSet<Short>();
        HashSet<Short> continueTags = new HashSet<Short>();
        short i = 0;
        while (i < tagNumberer.total()) {
            if (grammar.isGrammarTag[i]) {
                if (!gs.continues(i)) {
                    noContinueTags.add(i);
                } else {
                    continueTags.add(i);
                }
            }
            i = (short)(i + 1);
        }
        GrammarStatistics.printGrammarStatistics(columnOutput, pData, tagNumberer, topN, gs, noContinueTags);
        GrammarStatistics.printTrunkStatistics(columnOutput, tagNumberer, padding, topN, gs, continueTags);
        System.out.println("<!--");
        System.out.println("-->");
        HashSet<Short> allRealTags = new HashSet<Short>(noContinueTags);
        short i2 = 0;
        while (i2 < grammar.numSubStates.length) {
            if (!grammar.isGrammarTag[i2]) {
                allRealTags.add(i2);
            }
            i2 = (short)(i2 + 1);
        }
        double[] probState = new double[grammar.numStates];
        double[][] probSubGivenState = new double[grammar.numStates][];
        int state = 0;
        while (state < grammar.numStates) {
            probSubGivenState[state] = new double[grammar.numSubStates[state]];
            ++state;
        }
        for (Tree<StateSet> tree : trainStateSetTrees) {
            parser.doInsideOutsideScores(tree, false, true);
            GrammarStatistics.tallyProbState(tree, probState, allRealTags);
            GrammarStatistics.tallyProbSubState(tree, probSubGivenState, allRealTags);
        }
        state = 0;
        while (state < grammar.numStates) {
            double sum = 0.0;
            int substate = 0;
            while (substate < grammar.numSubStates[state]) {
                sum += probSubGivenState[state][substate];
                ++substate;
            }
            substate = 0;
            while (substate < grammar.numSubStates[state]) {
                probSubGivenState[state][substate] = Math.log(probSubGivenState[state][substate] / sum);
                ++substate;
            }
            ++state;
        }
        double sumState = 0.0;
        int state2 = 0;
        while (state2 < grammar.numStates) {
            sumState += probState[state2];
            ++state2;
        }
        state2 = 0;
        while (state2 < grammar.numStates) {
            probState[state2] = Math.log(probState[state2] / sumState);
            ++state2;
        }
        GrammarStatistics.printParentRuleStatistics(columnOutput, pData, tagNumberer, topN, gs, allRealTags, probState, probSubGivenState);
        GrammarStatistics.printParentStatistics(columnOutput, grammar, tagNumberer, nonLogGrammar, nonLogLexicon, topN, gs, trainTrees, parser);
        System.out.println("</body></html>");
    }

    private static void tallyProbSubState(Tree<StateSet> tree, double[][] probSubGivenState, Set<Short> noContinueTags) {
        GrammarStatistics.tallyProbSubStateHelper(tree, tree.getLabel().getIScore(0), probSubGivenState, noContinueTags);
    }

    private static void tallyProbSubStateHelper(Tree<StateSet> tree, double treeProb, double[][] probSubGivenState, Set<Short> tags) {
        if (tree.isLeaf()) {
            return;
        }
        StateSet label = tree.getLabel();
        short state = label.getState();
        if (tags.contains(state)) {
            double[] iScores = label.getIScores();
            double[] oScores = label.getOScores();
            double[] scores = new double[iScores.length];
            double sum = 0.0;
            int substate = 0;
            while (substate < iScores.length) {
                scores[substate] = iScores[substate] / treeProb * oScores[substate];
                sum += scores[substate];
                ++substate;
            }
            substate = 0;
            while (substate < iScores.length) {
                int n = substate;
                scores[n] = scores[n] / sum;
                double[] dArray = probSubGivenState[state];
                int n2 = substate;
                dArray[n2] = dArray[n2] + scores[substate];
                ++substate;
            }
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            GrammarStatistics.tallyProbSubStateHelper(child, treeProb, probSubGivenState, tags);
        }
    }

    private static void tallyProbState(Tree<StateSet> tree, double[] probState, Set<Short> tags) {
        if (tree.isLeaf()) {
            return;
        }
        short state = tree.getLabel().getState();
        if (tags.contains(state)) {
            short s = state;
            probState[s] = probState[s] + 1.0;
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            GrammarStatistics.tallyProbState(child, probState, tags);
        }
    }

    private static FullState[][] printParentStatistics(boolean columnOutput, Grammar grammar, Numberer tagNumberer, Grammar nonLogGrammar, Lexicon nonLogLexicon, int topN, GrammarStatistics gs, List<Tree<String>> trainTrees, ArrayParser parser) {
        System.out.println("<a name=\"parents\"><h1>Parents</h1></a>");
        System.out.println("<!--");
        short s = grammar.numStates;
        double[][][][] parentProbs = new double[s][s][][];
        double[][] normFactors = new double[s][];
        FullState[][] parents = new FullState[grammar.numStates][];
        int state = 0;
        while (state < s) {
            normFactors[state] = new double[grammar.numSubStates[state]];
            ++state;
        }
        StateSetTreeList trainStateSetTrees = new StateSetTreeList(trainTrees, grammar.numSubStates, false, tagNumberer);
        int nTree = 0;
        System.out.print("Adding probabilities");
        for (Tree<StateSet> tree : trainStateSetTrees) {
            parser.doInsideOutsideScores(tree, false, true);
            GrammarStatistics.logarithmModeTree(tree);
            gs.addProbs(tree, grammar, parentProbs, normFactors, tree.getLabel().getIScore(0));
            if (nTree++ % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.print("done.\n");
        System.out.println("-->");
        short childState = 0;
        while (childState < s) {
            String[][] outputMatrix = new String[topN + 1][grammar.numSubStates[childState]];
            String tagName = (String)tagNumberer.object(childState);
            short cS = 0;
            while (cS < grammar.numSubStates[childState]) {
                String string = String.valueOf(tagName) + "-" + cS;
                outputMatrix[0][cS] = string;
                String childFullName = string;
                PriorityQueue<FullState> results = new PriorityQueue<FullState>(topN + 1);
                short parentState = 0;
                while (parentState < s) {
                    double[][] probs = parentProbs[parentState][childState];
                    if (probs != null) {
                        double normFactor = normFactors[childState][cS];
                        short pS = 0;
                        while (pS < grammar.numSubStates[parentState]) {
                            double score = probs[pS][cS] / normFactor;
                            if (results.isEmpty() || !(score < -results.getPriority())) {
                                FullState state2 = new FullState(parentState, pS);
                                state2.score = score;
                                results.add(state2, -state2.score);
                                if (results.size() > topN) {
                                    results.next();
                                }
                            }
                            pS = (short)(pS + 1);
                        }
                    }
                    parentState = (short)(parentState + 1);
                }
                ArrayList<FullState> resultsA = new ArrayList<FullState>(topN);
                while (results.size() != 0) {
                    resultsA.add(0, (FullState)results.next());
                }
                parents[childState] = new FullState[resultsA.size()];
                int j = 0;
                while (j < topN) {
                    String o = "";
                    double p = -1.0;
                    if (resultsA.size() > j) {
                        parents[childState][j] = (FullState)resultsA.get(j);
                        p = ((FullState)resultsA.get((int)j)).score;
                        String w = ((FullState)resultsA.get(j)).toString(tagNumberer, childFullName);
                        o = String.valueOf(f.format(p)) + " " + w;
                    }
                    outputMatrix[j + 1][cS] = o;
                    j = (short)(j + 1);
                }
                cS = (short)(cS + 1);
            }
            GrammarStatistics.printRules("Parent", "parent", columnOutput, outputMatrix);
            childState = (short)(childState + 1);
        }
        return parents;
    }

    private static void printTrunkStatistics(boolean columnOutput, Numberer tagNumberer, int padding, int topN, GrammarStatistics gs, Set<Short> continueTags) {
        System.out.println("<a name=\"trunks\"><h1>Trunks</h1></a>");
        for (short tag : continueTags) {
            String tagS = ((String)tagNumberer.object(tag)).substring(1);
            short parentTag = (short)tagNumberer.number(tagS);
            gs.printTopRules(parentTag, topN, columnOutput, padding);
            gs.printTopRules(tag, topN, columnOutput, padding);
            System.out.println("");
        }
    }

    private static void printGrammarStatistics(boolean columnOutput, ParserData pData, Numberer tagNumberer, int topN, GrammarStatistics gs, Set<Short> noContinueTags) {
        System.out.println("<a name=\"grammar\"><h1>Grammar</h1></a>");
        System.out.println("<div id=\"grammar\">");
        for (short curTag : noContinueTags) {
            int nSubStates = pData.numSubStatesArray[curTag];
            ArrayList[] results = new ArrayList[nSubStates];
            int i = 0;
            while (i < nSubStates) {
                PriorityQueue<SearchState> pq = gs.getTopProductions(new FullState(curTag, (short)i));
                results[i] = new ArrayList(topN);
                while (pq.size() != 0) {
                    pq.peek().score = Math.exp(pq.peek().score);
                    results[i].add(0, pq.next());
                }
                i = (short)(i + 1);
            }
            String[][] outputMatrix = new String[topN + 1][nSubStates];
            String tagName = (String)tagNumberer.object(curTag);
            int i2 = 0;
            while (i2 < nSubStates) {
                outputMatrix[0][i2] = String.valueOf(tagName) + "-" + i2;
                ++i2;
            }
            int j = 0;
            while (j < topN) {
                int i3 = 0;
                while (i3 < nSubStates) {
                    String o = "";
                    double p = -1.0;
                    if (results[i3].size() > j) {
                        p = ((SearchState)results[i3].get((int)j)).score;
                        String w = ((SearchState)results[i3].get(j)).toString(tagNumberer);
                        o = String.valueOf(f.format(p)) + " " + w;
                    }
                    outputMatrix[j + 1][i3] = o;
                    ++i3;
                }
                ++j;
            }
            GrammarStatistics.printRules("Grammar", "productions", columnOutput, outputMatrix);
        }
        System.out.println("</div>");
    }

    private static void printParentRuleStatistics(boolean columnOutput, ParserData pData, Numberer tagNumberer, int topN, GrammarStatistics gs, Set<Short> noContinueTags, double[] probState, double[][] probSubGivenState) {
        System.out.println("<a name=\"parentrules\"><h1>Parent Rules</h1></a>");
        for (short curTag : noContinueTags) {
            int nSubStates = pData.numSubStatesArray[curTag];
            ArrayList[] results = new ArrayList[nSubStates];
            int i = 0;
            while (i < nSubStates) {
                PriorityQueue<SearchState> pq = gs.getTopParentRuleProductions(new FullState(curTag, (short)i), probState, probSubGivenState);
                results[i] = new ArrayList(topN);
                while (pq.size() != 0) {
                    pq.peek().score = Math.exp(pq.peek().score);
                    results[i].add(0, pq.next());
                }
                i = (short)(i + 1);
            }
            String[][] outputMatrix = new String[topN + 1][nSubStates];
            String tagName = (String)tagNumberer.object(curTag);
            int i2 = 0;
            while (i2 < nSubStates) {
                outputMatrix[0][i2] = String.valueOf(tagName) + "-" + i2;
                ++i2;
            }
            int j = 0;
            while (j < topN) {
                int i3 = 0;
                while (i3 < nSubStates) {
                    String o = "";
                    double p = -1.0;
                    if (results[i3].size() > j) {
                        p = ((SearchState)results[i3].get((int)j)).score;
                        String w = ((SearchState)results[i3].get(j)).toString(tagNumberer);
                        o = String.valueOf(f.format(p)) + " " + w;
                    }
                    outputMatrix[j + 1][i3] = o;
                    ++i3;
                }
                ++j;
            }
            GrammarStatistics.printRules("Parent Rules", "parentrules", columnOutput, outputMatrix);
        }
    }

    private static void logarithmModeTree(Tree<StateSet> tree) {
        if (tree.isLeaf()) {
            return;
        }
        double[] iScores = tree.getLabel().getIScores();
        int iScale = tree.getLabel().getIScale();
        double[] oScores = tree.getLabel().getOScores();
        int oScale = tree.getLabel().getOScale();
        int i = 0;
        while (i < iScores.length) {
            iScores[i] = Math.log(iScores[i]) + (double)(100 * iScale);
            oScores[i] = Math.log(oScores[i]) + (double)(100 * oScale);
            ++i;
        }
        tree.getLabel().setIScores(iScores);
        tree.getLabel().setOScores(oScores);
        for (Tree<StateSet> child : tree.getChildren()) {
            GrammarStatistics.logarithmModeTree(child);
        }
    }

    private void addProbs(Tree<StateSet> tree, Grammar g, double[][][][] parentProbs, double[][] normFactors, double treeScore) {
        int nSubStates = tree.getLabel().numSubStates();
        double[][] viterbiProbs = new double[nSubStates][nSubStates];
        int i = 0;
        while (i < viterbiProbs.length) {
            int j = 0;
            while (j < viterbiProbs[i].length) {
                viterbiProbs[i][j] = i != j ? Double.NEGATIVE_INFINITY : tree.getLabel().getOScore(i) - treeScore;
                ++j;
            }
            ++i;
        }
        this.addProbsHelper(tree.getLabel().getState(), tree, g, parentProbs, normFactors, viterbiProbs, treeScore);
    }

    private void addProbsHelper(short gpState, Tree<StateSet> tree, Grammar g, double[][][][] parentProbs, double[][] normFactor, double[][] viterbiProbs, double treeScore) {
        if (tree.isPreTerminal() || tree.isLeaf()) {
            return;
        }
        short pState = tree.getLabel().getState();
        int nParentStates = tree.getLabel().numSubStates();
        List<Tree<StateSet>> children = tree.getChildren();
        switch (children.size()) {
            case 1: {
                Tree<StateSet> child = children.get(0);
                short cState = child.getLabel().getState();
                double[][] scores = g.getUnaryScore(pState, cState);
                int nChildStates = child.getLabel().numSubStates();
                double[][] newViterbiProbs = new double[viterbiProbs.length][nChildStates];
                int gpS = 0;
                while (gpS < viterbiProbs.length) {
                    int cS = 0;
                    while (cS < nChildStates) {
                        if (scores[cS] != null) {
                            double[] scoresToSum = new double[nParentStates];
                            int pS = 0;
                            while (pS < nParentStates) {
                                scoresToSum[pS] = viterbiProbs[gpS][pS] + scores[cS][pS];
                                ++pS;
                            }
                            newViterbiProbs[gpS][cS] = SloppyMath.logAdd(scoresToSum);
                        }
                        ++cS;
                    }
                    ++gpS;
                }
                if (this.continues(cState)) {
                    this.addProbsHelper(gpState, child, g, parentProbs, normFactor, newViterbiProbs, treeScore);
                    break;
                }
                this.addProbsFinal(child, gpState, cState, parentProbs, normFactor, newViterbiProbs);
                this.addProbs(child, g, parentProbs, normFactor, treeScore);
                break;
            }
            case 2: {
                Tree<StateSet> lChild = children.get(0);
                Tree<StateSet> rChild = children.get(1);
                short lcState = lChild.getLabel().getState();
                short rcState = rChild.getLabel().getState();
                double[][][] scoresB = g.getBinaryScore(pState, lcState, rcState);
                int nLChildStates = lChild.getLabel().numSubStates();
                int nRChildStates = rChild.getLabel().numSubStates();
                double[][] newLViterbiProbs = new double[viterbiProbs.length][nLChildStates];
                double[][] newRViterbiProbs = new double[viterbiProbs.length][nRChildStates];
                int gpS = 0;
                while (gpS < viterbiProbs.length) {
                    double[][] lScoresToSum = new double[nLChildStates][nParentStates * nRChildStates];
                    double[][] rScoresToSum = new double[nRChildStates][nParentStates * nLChildStates];
                    int lcS = 0;
                    while (lcS < nLChildStates) {
                        int rcS = 0;
                        while (rcS < nRChildStates) {
                            if (scoresB[lcS][rcS] != null) {
                                int pS = 0;
                                while (pS < nParentStates) {
                                    double vp = viterbiProbs[gpS][pS];
                                    double sc = scoresB[lcS][rcS][pS];
                                    lScoresToSum[lcS][pS * nRChildStates + rcS] = vp + sc + rChild.getLabel().getIScore(rcS);
                                    rScoresToSum[rcS][pS * nLChildStates + lcS] = vp + sc + lChild.getLabel().getIScore(lcS);
                                    ++pS;
                                }
                            }
                            ++rcS;
                        }
                        ++lcS;
                    }
                    lcS = 0;
                    while (lcS < nLChildStates) {
                        newLViterbiProbs[gpS][lcS] = SloppyMath.logAdd(lScoresToSum[lcS]);
                        ++lcS;
                    }
                    int rcS = 0;
                    while (rcS < nRChildStates) {
                        newRViterbiProbs[gpS][rcS] = SloppyMath.logAdd(rScoresToSum[rcS]);
                        ++rcS;
                    }
                    ++gpS;
                }
                if (this.continues(lcState)) {
                    this.addProbsHelper(gpState, lChild, g, parentProbs, normFactor, newLViterbiProbs, treeScore);
                } else {
                    this.addProbsFinal(lChild, gpState, lcState, parentProbs, normFactor, newLViterbiProbs);
                    this.addProbs(lChild, g, parentProbs, normFactor, treeScore);
                }
                if (this.continues(rcState)) {
                    this.addProbsHelper(gpState, rChild, g, parentProbs, normFactor, newRViterbiProbs, treeScore);
                    break;
                }
                this.addProbsFinal(rChild, gpState, rcState, parentProbs, normFactor, newRViterbiProbs);
                this.addProbs(rChild, g, parentProbs, normFactor, treeScore);
            }
        }
    }

    private void addProbsFinal(Tree<StateSet> child, short gpState, short cState, double[][][][] parentProbs, double[][] normFactor, double[][] viterbiProbs) {
        int gpS = 0;
        while (gpS < viterbiProbs.length) {
            int cS = 0;
            while (cS < viterbiProbs[gpS].length) {
                viterbiProbs[gpS][cS] = Math.exp(viterbiProbs[gpS][cS] + child.getLabel().getIScore(cS));
                ++cS;
            }
            ++gpS;
        }
        if (parentProbs[gpState][cState] == null) {
            parentProbs[gpState][cState] = new double[viterbiProbs.length][viterbiProbs[0].length];
        }
        double[][] parentProbsCC = parentProbs[gpState][cState];
        int gpS2 = 0;
        while (gpS2 < viterbiProbs.length) {
            int cS = 0;
            while (cS < viterbiProbs[gpS2].length) {
                double[] dArray = parentProbsCC[gpS2];
                int n = cS;
                dArray[n] = dArray[n] + viterbiProbs[gpS2][cS];
                double[] dArray2 = normFactor[cState];
                int n2 = cS;
                dArray2[n2] = dArray2[n2] + viterbiProbs[gpS2][cS];
                ++cS;
            }
            ++gpS2;
        }
    }

    private void printTopRules(short tag, int topN, boolean columnOutput, int padding) {
        String[][] outputMatrix = new String[topN + 1][this.grammar.numSubStates[tag]];
        int i = 0;
        while (i < outputMatrix.length) {
            int j = 0;
            while (j < outputMatrix[i].length) {
                outputMatrix[i][j] = "";
                ++j;
            }
            ++i;
        }
        int subState = 0;
        while (subState < this.grammar.numSubStates[tag]) {
            outputMatrix[0][subState] = String.valueOf((String)this.tagNumberer.object(tag)) + "-" + subState;
            PriorityQueue<RuleStruct> topRules = new PriorityQueue<RuleStruct>();
            BinaryRule[] binaryRuleArray = this.grammar.splitRulesWithP(tag);
            int n = binaryRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryRule binaryRule = binaryRuleArray[n2];
                int lSubState = 0;
                while (lSubState < this.grammar.numSubStates[binaryRule.getLeftChildState()]) {
                    int rSubState = 0;
                    while (rSubState < this.grammar.numSubStates[binaryRule.getRightChildState()]) {
                        double score = binaryRule.getScore(subState, lSubState, rSubState);
                        topRules.add(new RuleStruct(binaryRule, score, subState, lSubState, rSubState), -score);
                        if (topRules.size() > topN) {
                            topRules.next();
                        }
                        ++rSubState;
                    }
                    ++lSubState;
                }
                ++n2;
            }
            for (UnaryRule unaryRule : this.grammar.getUnaryRulesByParent(tag)) {
                int cSubState = 0;
                while (cSubState < this.grammar.numSubStates[unaryRule.getChildState()]) {
                    double score = unaryRule.getScore(subState, cSubState);
                    topRules.add(new RuleStruct(unaryRule, score, subState, cSubState), -score);
                    if (topRules.size() > topN) {
                        topRules.next();
                    }
                    ++cSubState;
                }
            }
            ArrayList<RuleStruct> arrayList = new ArrayList<RuleStruct>();
            while (topRules.hasNext()) {
                RuleStruct s = (RuleStruct)topRules.next();
                arrayList.add(0, s);
            }
            int i2 = 0;
            while (i2 < arrayList.size()) {
                outputMatrix[i2 + 1][subState] = this.ruleToString((RuleStruct)arrayList.get(i2));
                ++i2;
            }
            ++subState;
        }
        String tagName = (String)this.tagNumberer.object(tag);
        GrammarStatistics.printRules("Trunk", "topShortRules", columnOutput, outputMatrix);
    }

    public String ruleToString(RuleStruct r) {
        StringBuffer sB = new StringBuffer();
        sB.append(String.valueOf(f.format(Math.exp(r.score))) + " ");
        if (r.binary) {
            BinaryRule b = (BinaryRule)r.r;
            String leftName = this.tagNumberer.object(b.leftChildState) + "-" + r.lS;
            String rightName = this.tagNumberer.object(b.rightChildState) + "-" + r.rS;
            sB.append("<a href=" + GrammarStatistics.reflabel("productions", leftName) + ">" + leftName + "</a> ");
            sB.append("<a href=" + GrammarStatistics.reflabel("productions", rightName) + ">" + rightName + "</a> ");
        } else {
            UnaryRule u = (UnaryRule)r.r;
            String childName = this.tagNumberer.object(u.childState) + "-" + r.lS;
            sB.append("<a href=" + GrammarStatistics.reflabel("productions", childName) + ">" + childName + "</a> ");
        }
        return sB.toString();
    }

    private static void printRules(String typeName, String ruleTypeName, boolean columnOutput, String[][] outputMatrix) {
        System.out.println("<h3>" + typeName + "</h3><table border=\"1\">");
        if (columnOutput) {
            int i = 0;
            while (i < outputMatrix.length) {
                System.out.println("<tr>");
                int j = 0;
                while (j < outputMatrix[0].length) {
                    if (i == 0) {
                        System.out.println("<th><a name=" + GrammarStatistics.label(ruleTypeName, outputMatrix[i][j]) + "> <a href=" + GrammarStatistics.parentRefLabel(outputMatrix[i][j]) + ">");
                        System.out.print(outputMatrix[i][j]);
                        System.out.println("</a></a> (<a href=" + GrammarStatistics.label("parent", outputMatrix[i][j]) + ">p</a>)</th>");
                    } else {
                        System.out.print("<td>" + GrammarStatistics.sanitize(outputMatrix[i][j]) + "</td>");
                    }
                    ++j;
                }
                System.out.println("</tr>");
                ++i;
            }
        } else {
            int j = 0;
            while (j < outputMatrix[0].length) {
                System.out.println("<tr>");
                int i = 0;
                while (i < outputMatrix.length) {
                    if (j == 0) {
                        System.out.println("<th><a name=" + GrammarStatistics.label(ruleTypeName, outputMatrix[i][j]) + "> <a href=" + GrammarStatistics.parentRefLabel(outputMatrix[i][j]) + ">");
                        System.out.print(outputMatrix[i][j]);
                        System.out.println("</a></a></th>");
                    } else {
                        System.out.print("<td>" + GrammarStatistics.sanitize(outputMatrix[i][j]) + "</td>");
                    }
                    ++i;
                }
                System.out.println("</tr>");
                ++j;
            }
        }
        System.out.println("</table><br/>");
    }

    public static int maxWidthInRow(String[][] m, int row) {
        int l = 0;
        int c = 0;
        while (c < m[row].length) {
            l = Math.max(l, m[row][c].length());
            ++c;
        }
        return l;
    }

    public static int maxWidthInCol(String[][] m, int col) {
        int l = 0;
        int r = 0;
        while (r < m.length) {
            l = Math.max(l, m[r][col].length());
            ++r;
        }
        return l;
    }

    public static void computeAndPrintCounts(Grammar gr) {
        int nUnaries = 0;
        int nBinaries = 0;
        int totalU = 0;
        int totalB = 0;
        int notInfU = 0;
        int notInfB = 0;
        int nulledOutU = 0;
        int nulledOutB = 0;
        int notNulledOutU = 0;
        int notNulledOutB = 0;
        int state = 0;
        while (state < gr.numStates) {
            Object scores;
            int nChildSubStates;
            int nParentSubStates = gr.numSubStates[state];
            for (UnaryRule uRule : gr.getUnaryRulesByParent(state)) {
                ++nUnaries;
                nChildSubStates = gr.numSubStates[uRule.childState];
                scores = uRule.getScores2();
                int j = 0;
                while (j < ((BinaryRule[])scores).length) {
                    totalU += nChildSubStates;
                    ++notNulledOutU;
                    if (scores[j] == null) {
                        ++nulledOutU;
                    } else {
                        int i = 0;
                        while (i < nParentSubStates) {
                            if (!Double.isInfinite((double)scores[j][i])) {
                                ++notInfU;
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            }
            scores = gr.splitRulesWithP(state);
            nChildSubStates = ((BinaryRule[])scores).length;
            int n = 0;
            while (n < nChildSubStates) {
                BinaryRule bRule = scores[n];
                ++nBinaries;
                double[][][] scores2 = bRule.getScores2();
                int j = 0;
                while (j < scores2.length) {
                    int k = 0;
                    while (k < scores2[j].length) {
                        totalB += nParentSubStates;
                        ++notNulledOutB;
                        if (scores2[j][k] == null) {
                            ++nulledOutB;
                        } else {
                            int i = 0;
                            while (i < scores2[j][k].length) {
                                if (!Double.isInfinite(scores2[j][k][i])) {
                                    ++notInfB;
                                }
                                ++i;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++n;
            }
            ++state;
        }
        int totalUS = 0;
        int totalBS = 0;
        int notInfUS = 0;
        int notInfBS = 0;
        int state2 = 0;
        while (state2 < gr.numStates) {
            for (UnaryRule uRule : gr.getUnaryRulesByParent(state2)) {
                double[][] scores = uRule.getScores2();
                short nChildSubstates = gr.numSubStates[uRule.childState];
                int j = 0;
                while (j < scores.length) {
                    boolean okayInSomeSubstate = false;
                    if (scores[j] != null) {
                        int i = 0;
                        while (i < scores[j].length) {
                            if (!Double.isInfinite(scores[j][i])) {
                                okayInSomeSubstate = true;
                            }
                            ++i;
                        }
                    }
                    totalUS += nChildSubstates;
                    if (okayInSomeSubstate) {
                        notInfUS += nChildSubstates;
                    }
                    ++j;
                }
            }
            BinaryRule[] binaryRuleArray = gr.splitRulesWithP(state2);
            int n = binaryRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryRule bRule = binaryRuleArray[n2];
                double[][][] scores = bRule.getScores2();
                short nParentSubstates = gr.numSubStates[bRule.parentState];
                int j = 0;
                while (j < scores.length) {
                    int k = 0;
                    while (k < scores[0].length) {
                        boolean okayInSomeSubstate = false;
                        if (scores[j][k] != null) {
                            int i = 0;
                            while (i < scores[j][k].length) {
                                if (!Double.isInfinite(scores[j][k][i])) {
                                    okayInSomeSubstate = true;
                                }
                                ++i;
                            }
                        }
                        totalBS += nParentSubstates;
                        if (okayInSomeSubstate) {
                            notInfBS += nParentSubstates;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++n2;
            }
            ++state2;
        }
        System.out.println("The baseline grammar has " + nUnaries + " unary and " + nBinaries + " binary rules.");
        System.out.println("When using substates there could be " + totalU + " unaries, but in fact there are only " + notInfU + ".");
        System.out.println("When using substates there could be " + totalB + " binaries, but in fact there are only " + notInfB + ".");
        System.out.println("Out of " + notNulledOutU + " slices " + nulledOutU + " are nulled out.");
        System.out.println("Out of " + notNulledOutB + " slices " + nulledOutB + " are nulled out.");
        System.out.println("Summed across substates, there could be " + totalUS + " unaries, but there are only " + notInfUS + ".");
        System.out.println("Summed across substates, there could be " + totalBS + " binaries, but there are only " + notInfBS + ".");
    }

    public static void printLexiconUnknownStatistics(Lexicon lexicon, Numberer tagNumberer) {
    }

    public static void printLexiconStatistics(Lexicon lexicon, Numberer tagNumberer, boolean[] grammarTags, Grammar grammar, StateSetTreeList trainStateSetTrees, Options opts) {
        System.out.println("<a name=\"lexicon\"><h1>Lexicon</h1></a>");
        System.out.println("<div id=\"lexicon\">");
        double[][][] counts = null;
        double[][] posteriors = new double[grammar.numStates][(int)ArrayUtil.max(grammar.numSubStates)];
        if (lexicon instanceof SimpleLexicon) {
            counts = new double[grammar.numStates][((SimpleLexicon)lexicon).nWords][grammar.numSubStates[1]];
            ParserData pDataNoLog = ParserData.Load(opts.in);
            if (pDataNoLog == null) {
                System.exit(1);
            }
            Grammar nonLogGrammar = pDataNoLog.getGrammar();
            nonLogGrammar.splitRules();
            SimpleLexicon nonLogLexicon = (SimpleLexicon)pDataNoLog.getLexicon();
            nonLogLexicon.explicitlyComputeScores(nonLogGrammar.finalLevel);
            SpanPredictor spanPredictor = pDataNoLog.getSpanPredictor();
            if (opts.unkT < 0) {
                System.out.println("Replacing rare words");
                Corpus.replaceRareWords(trainStateSetTrees, new SimpleLexicon(grammar.numSubStates, -1.0), Math.abs(opts.unkT));
            }
            nonLogLexicon.labelTrees(trainStateSetTrees);
            ConstrainedHierarchicalTwoChartParser parser = new ConstrainedHierarchicalTwoChartParser(nonLogGrammar, nonLogLexicon, spanPredictor, grammar.finalLevel);
            for (Tree<StateSet> stateSetTree : trainStateSetTrees) {
                boolean noSmoothing = true;
                boolean debugOutput = false;
                parser.doInsideOutsideScores(stateSetTree, false, false);
                grammar.tallyMergeWeights(stateSetTree, posteriors);
                double tree_score = stateSetTree.getLabel().getIScore(0);
                int tree_scale = stateSetTree.getLabel().getIScale();
                List<StateSet> yield = stateSetTree.getYield();
                int i = 0;
                for (StateSet stateSet : stateSetTree.getPreTerminalYield()) {
                    double scalingFactor = ScalingTools.calcScaleFactor(stateSet.getOScale() + stateSet.getIScale() - tree_scale);
                    StateSet child = yield.get(i++);
                    int substate = 0;
                    while (substate < stateSet.numSubStates()) {
                        double pOS;
                        double pIS = stateSet.getIScore(substate);
                        if (pIS != 0.0 && (pOS = stateSet.getOScore(substate)) != 0.0) {
                            double weight = 1.0;
                            weight = pIS / tree_score * scalingFactor * pOS;
                            double[] dArray = counts[stateSet.getState()][child.wordIndex];
                            int n = substate;
                            dArray[n] = dArray[n] + weight;
                        }
                        substate = (short)(substate + 1);
                    }
                }
            }
        }
        short curTag = 0;
        while (curTag < grammarTags.length) {
            if (!grammarTags[curTag]) {
                Lexicon lex;
                int nSubStates = grammar.numSubStates[curTag];
                PriorityQueue[] pQs = new PriorityQueue[nSubStates];
                int i = 0;
                while (i < nSubStates) {
                    pQs[i] = new PriorityQueue();
                    ++i;
                }
                double[] sum = new double[grammar.numSubStates[curTag]];
                if (lexicon instanceof SophisticatedLexicon) {
                    sum = posteriors[curTag];
                    lex = (SophisticatedLexicon)lexicon;
                    HashMap<String, double[]> tagMap = lex.wordToTagCounters[curTag];
                    for (String word : tagMap.keySet()) {
                        double[] lexiconScores = lexicon.score(word, curTag, 0, false, false);
                        int i2 = 0;
                        while (i2 < nSubStates) {
                            pQs[i2].add(word, lexiconScores[i2]);
                            ++i2;
                        }
                    }
                } else {
                    sum = new double[grammar.numSubStates[curTag]];
                    lex = (SimpleLexicon)lexicon;
                    int w = 0;
                    while (w < ((SimpleLexicon)lex).nWords) {
                        String word;
                        word = ((SimpleLexicon)lex).wordIndexer.get(w);
                        double[] lexiconScores = counts[curTag][w];
                        boolean allZero = true;
                        int i3 = 0;
                        while (i3 < lexiconScores.length) {
                            allZero = allZero && lexiconScores[i3] == 0.0;
                            int n = i3;
                            sum[n] = sum[n] + lexiconScores[i3];
                            ++i3;
                        }
                        if (!allZero) {
                            i3 = 0;
                            while (i3 < nSubStates) {
                                pQs[i3].add(word, lexiconScores[i3]);
                                ++i3;
                            }
                        }
                        ++w;
                    }
                }
                double s = 0.0;
                int i4 = 0;
                while (i4 < sum.length) {
                    s += sum[i4];
                    ++i4;
                }
                String tagName = (String)tagNumberer.object(curTag);
                System.out.println("<h3>Lexicon</h3>");
                System.out.println("<table border=\"1\">");
                System.out.println("<tr>");
                int i5 = 0;
                while (i5 < nSubStates) {
                    System.out.println("<th>");
                    System.out.println("<a name=" + GrammarStatistics.lexiconLabel(String.valueOf(tagName) + "-" + i5) + "> <a href=" + GrammarStatistics.parentRefLabel(String.valueOf(tagName) + "-" + i5) + ">");
                    System.out.print(String.valueOf(GrammarStatistics.sanitize(tagName)) + "-" + i5);
                    System.out.println("</a></a> (<a href=" + GrammarStatistics.label("parent", tagName) + ">p</a>)");
                    System.out.println("<br>" + sum[i5] / s);
                    System.out.println("</th>");
                    ++i5;
                }
                System.out.println("</tr>");
                int j = 0;
                while (j < topN) {
                    System.out.println("<tr>");
                    int i6 = 0;
                    while (i6 < nSubStates) {
                        if (i6 == 0) {
                            System.out.print("\n");
                        }
                        String w = "";
                        double p = -1.0;
                        if (pQs[i6].hasNext()) {
                            p = pQs[i6].getPriority();
                            w = (String)pQs[i6].next();
                            String tmp = String.valueOf(GrammarStatistics.sanitize(w)) + " " + f.format(p);
                            if (tmp.length() < 8) {
                                tmp = tmp.concat("\t");
                            }
                            System.out.print("<td>" + tmp + "</td>");
                        }
                        ++i6;
                    }
                    System.out.println("</tr>");
                    ++j;
                }
                System.out.println("</table><br/>");
            }
            curTag = (short)(curTag + 1);
        }
        System.out.println("</div>");
    }

    static String lexiconLabel(String tagName) {
        return "\"productions-" + tagName + "\"";
    }

    static String label(String ruleTypeName, String tagName) {
        return "\"" + ruleTypeName + "-" + tagName + "\"";
    }

    static String reflabel(String ruleTypeName, String tagName) {
        return "\"#" + ruleTypeName + "-" + tagName + "\"";
    }

    static String parentLabel(String tagName) {
        return GrammarStatistics.label("parentrules", tagName);
    }

    static String parentRefLabel(String tagName) {
        return GrammarStatistics.reflabel("parentrules", tagName);
    }

    static String sanitize(String s) {
        return s.replaceAll("&", "&amp;");
    }

    public static class Options {
        @Option(name="-in", usage="Input File for Grammar")
        public String in;
        @Option(name="-out", usage="Output File")
        public String out;
        @Option(name="-path", usage="Path to Corpus")
        public String path = null;
        @Option(name="-treebank", usage="Language:  WSJ, CHNINESE, GERMAN, CONLL, SINGLEFILE (Default: ENGLISH)")
        public Corpus.TreeBankType treebank = Corpus.TreeBankType.WSJ;
        @Option(name="-unkT", usage="Unknown word threshold")
        public int unkT = 1;
        @Option(name="-maxL", usage="Maximum sentence length")
        public int maxL = 40;
    }

    static class RuleStruct {
        public Rule r;
        public double score;
        public int pS;
        public int lS;
        public int rS;
        boolean binary;

        public RuleStruct(Rule r, double score, int pS, int lS, int rS) {
            this.r = r;
            this.score = score;
            this.pS = pS;
            this.lS = lS;
            this.rS = rS;
            this.binary = true;
        }

        public RuleStruct(Rule r, double score, int pS, int lS) {
            this.r = r;
            this.score = score;
            this.pS = pS;
            this.lS = lS;
            this.rS = -1;
            this.binary = false;
        }
    }
}

