/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveBinaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveUnaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalGrammar;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.util.PriorityQueue;

public class HierarchicalAdaptiveGrammar
extends HierarchicalGrammar {
    private static final long serialVersionUID = 1L;

    public HierarchicalAdaptiveGrammar(short[] nSubStates, boolean findClosedPaths, Smoother smoother, Grammar oldGrammar, double thresh) {
        super(nSubStates, findClosedPaths, smoother, oldGrammar, thresh);
    }

    public HierarchicalAdaptiveGrammar(Grammar gr) {
        super(gr.numSubStates, gr.findClosedPaths, gr.smoother, gr, gr.threshold);
        Rule newRule;
        for (BinaryRule binaryRule : gr.binaryRuleMap.keySet()) {
            newRule = new HierarchicalAdaptiveBinaryRule(binaryRule);
            this.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : gr.unaryRuleMap.keySet()) {
            newRule = new HierarchicalAdaptiveUnaryRule(unaryRule);
            this.addUnary((UnaryRule)newRule);
        }
        this.closedViterbiRulesWithParent = this.unaryRulesWithParent;
        this.closedSumRulesWithParent = this.unaryRulesWithParent;
        this.closedViterbiRulesWithChild = this.unaryRulesWithC;
        this.closedSumRulesWithChild = this.unaryRulesWithC;
        this.makeCRArrays();
        this.isGrammarTag = gr.isGrammarTag;
    }

    public HierarchicalAdaptiveGrammar newInstance(short[] newNumSubStates) {
        return new HierarchicalAdaptiveGrammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
    }

    void printLevelCounts() {
        int[] counts;
        int nBinaryParams = 0;
        int nUnaryParams = 0;
        int nBinaryFringeParams = 0;
        int nUnaryFringeParams = 0;
        PriorityQueue<HierarchicalAdaptiveBinaryRule> pQb = new PriorityQueue<HierarchicalAdaptiveBinaryRule>();
        PriorityQueue<HierarchicalAdaptiveUnaryRule> pQu = new PriorityQueue<HierarchicalAdaptiveUnaryRule>();
        int state = 0;
        while (state < this.numStates) {
            counts = new int[8];
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            if (parentRules.length != 0) {
                double totalParamState = 0.0;
                double totalRulesState = 0.0;
                int i = 0;
                while (i < parentRules.length) {
                    HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)parentRules[i];
                    int n = r.hierarchy.getDepth();
                    counts[n] = counts[n] + 1;
                    nBinaryParams += r.countNonZeroFeatures();
                    int n2 = r.countNonZeroFringeFeatures();
                    nBinaryFringeParams += n2;
                    pQb.add(r, n2);
                    totalParamState += (double)n2;
                    totalRulesState += 1.0;
                    ++i;
                }
                System.out.print(this.tagNumberer.object(state) + ", binary rules per level: ");
                i = 1;
                while (i < 8) {
                    System.out.print(String.valueOf(counts[i]) + " ");
                    ++i;
                }
                System.out.print(" with \n " + this.tagNumberer.object(state) + "\t" + totalParamState / totalRulesState + "\n parameters on average :'\n");
            }
            ++state;
        }
        state = 0;
        while (state < this.numStates) {
            counts = new int[8];
            UnaryRule[] unaries = this.getClosedSumUnaryRulesByParent(state);
            if (unaries.length != 0) {
                int r = 0;
                while (r < unaries.length) {
                    HierarchicalAdaptiveUnaryRule ur = (HierarchicalAdaptiveUnaryRule)unaries[r];
                    int n = ur.hierarchy.getDepth();
                    counts[n] = counts[n] + 1;
                    nUnaryParams += ur.countNonZeroFeatures();
                    int n3 = ur.countNonZeroFringeFeatures();
                    nUnaryFringeParams += n3;
                    pQu.add(ur, n3);
                    ++r;
                }
                System.out.print(this.tagNumberer.object(state) + ", unary rules per level: ");
                int i = 1;
                while (i < 8) {
                    System.out.print(String.valueOf(counts[i]) + " ");
                    ++i;
                }
                System.out.print("\n");
            }
            ++state;
        }
        System.out.println("There are " + nBinaryParams + " binary features, of which " + nBinaryFringeParams + " are on the fringe.");
        System.out.println("There are " + nUnaryParams + " unary features, of which " + nUnaryFringeParams + " are on the fringe.");
        System.out.println("There are " + (nBinaryParams + nUnaryParams) + " total features, of which " + (nBinaryFringeParams + nUnaryFringeParams) + " are on the fringe.");
        while (pQb.hasNext()) {
            HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)pQb.next();
            System.out.println(String.valueOf(r.toStringShort()) + "\t" + r.countNonZeroFringeFeatures());
        }
        while (pQu.hasNext()) {
            HierarchicalAdaptiveUnaryRule r = (HierarchicalAdaptiveUnaryRule)pQu.next();
            System.out.println(String.valueOf(r.toStringShort()) + "\t" + r.countNonZeroFringeFeatures());
        }
    }
}

