/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalAdaptiveLexicalRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[] scores;
    public short[] mapping;
    Tree<Double> hierarchy = new Tree<Double>(0.0);
    public int nParam = 1;
    public int identifier;

    HierarchicalAdaptiveLexicalRule() {
        this.scores = new double[1];
        this.mapping = new short[1];
    }

    public Pair<Integer, Integer> countParameters() {
        int maxDepth = this.hierarchy.getDepth();
        this.nParam = this.hierarchy.getYield().size();
        return new Pair<Integer, Integer>(maxDepth, this.nParam);
    }

    public void splitRule(int nSubstates) {
        this.splitRuleHelper(this.hierarchy, 2);
        this.mapping = new short[nSubstates];
        int finalLevel = (int)(Math.log(this.mapping.length) / Math.log(2.0));
        this.updateMapping((short)0, 0, 0, finalLevel, this.hierarchy);
    }

    private Pair<Short, Integer> updateMapping(short myID, int nextSubstate, int myDepth, int finalDepth, Tree<Double> tree) {
        if (tree.isLeaf()) {
            if (myDepth == finalDepth) {
                this.mapping[nextSubstate++] = myID;
            } else {
                int substatesToCover = (int)Math.pow(2.0, finalDepth - myDepth);
                int i = 0;
                while (i < substatesToCover) {
                    this.mapping[nextSubstate++] = myID;
                    ++i;
                }
            }
            myID = (short)(myID + 1);
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                Pair<Short, Integer> tmp = this.updateMapping(myID, nextSubstate, myDepth + 1, finalDepth, child);
                myID = tmp.getFirst();
                nextSubstate = tmp.getSecond();
            }
        }
        return new Pair<Short, Integer>(myID, nextSubstate);
    }

    private void splitRuleHelper(Tree<Double> tree, int splitFactor) {
        if (tree.isLeaf()) {
            if (tree.getLabel() != 0.0 || this.nParam == 1) {
                ArrayList children = new ArrayList(splitFactor);
                int i = 0;
                while (i < splitFactor) {
                    Tree<Double> child = new Tree<Double>((GrammarTrainer.RANDOM.nextDouble() - 0.5) / 100.0);
                    children.add(child);
                    ++i;
                }
                tree.setChildren(children);
                this.nParam += splitFactor - 1;
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                this.splitRuleHelper(child, splitFactor);
            }
        }
    }

    public void explicitlyComputeScores(int finalLevel, boolean usingOnlyLastLevel) {
        int nSubstates = (int)Math.pow(2.0, finalLevel);
        this.scores = new double[nSubstates];
        int nextSubstate = this.fillScores(0.0, 0, 0, finalLevel, this.hierarchy, usingOnlyLastLevel);
        if (nextSubstate != nSubstates) {
            System.out.println("Didn't fill all lexical scores!");
        }
        this.mapping = new short[nSubstates];
        this.updateMapping((short)0, 0, 0, finalLevel, this.hierarchy);
    }

    private int fillScores(double previousScore, int nextSubstate, int myDepth, int finalDepth, Tree<Double> tree, boolean usingOnlyLastLevel) {
        if (tree.isLeaf()) {
            double myScore;
            double d = myScore = usingOnlyLastLevel ? Math.exp(tree.getLabel()) : Math.exp(previousScore + tree.getLabel());
            if (myDepth == finalDepth) {
                this.scores[nextSubstate++] = myScore;
            } else {
                int substatesToCover = (int)Math.pow(2.0, finalDepth - myDepth);
                int i = 0;
                while (i < substatesToCover) {
                    this.scores[nextSubstate++] = myScore;
                    ++i;
                }
            }
        } else {
            double myScore = previousScore + tree.getLabel();
            for (Tree<Double> child : tree.getChildren()) {
                nextSubstate = this.fillScores(myScore, nextSubstate, myDepth + 1, finalDepth, child, usingOnlyLastLevel);
            }
        }
        return nextSubstate;
    }

    public void updateScores(double[] scores) {
        int nSubstates = this.updateHierarchy(this.hierarchy, 0, scores);
        if (nSubstates != this.nParam) {
            System.out.println("Didn't update all parameters");
        }
    }

    private int updateHierarchy(Tree<Double> tree, int nextSubstate, double[] scores) {
        if (tree.isLeaf()) {
            int n = nextSubstate++;
            double val = scores[this.identifier + n];
            if (val > 200.0) {
                System.out.println("Ignored proposed lexical value since it was danegrous");
                val = 0.0;
            } else {
                tree.setLabel(val);
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                nextSubstate = this.updateHierarchy(child, nextSubstate, scores);
            }
        }
        return nextSubstate;
    }

    public List<Double> getFinalLevel() {
        return this.hierarchy.getYield();
    }

    private void compactifyHierarchy(Tree<Double> tree) {
        if (tree.getDepth() == 2) {
            boolean allZero = true;
            for (Tree<Double> child : tree.getChildren()) {
                boolean bl = allZero = allZero && child.getLabel() == 0.0;
            }
            if (allZero) {
                this.nParam -= tree.getChildren().size() - 1;
                tree.setChildren(Collections.EMPTY_LIST);
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                this.compactifyHierarchy(child);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.compactifyHierarchy(this.hierarchy);
        sb.append(Arrays.toString(this.scores));
        sb.append("\n");
        sb.append(Trees.PennTreeRenderer.render(this.hierarchy));
        sb.append("\n");
        return sb.toString();
    }

    public int mergeRule() {
        int paramBefore = this.nParam;
        this.compactifyHierarchy(this.hierarchy);
        this.scores = null;
        this.mapping = null;
        return paramBefore - this.nParam;
    }

    public int countNonZeroFeatures() {
        int total = 0;
        for (Tree<Double> d : this.hierarchy.getPreOrderTraversal()) {
            if (d.getLabel() == 0.0) continue;
            ++total;
        }
        return total;
    }

    public int countNonZeroFringeFeatures() {
        int total = 0;
        for (Tree<Double> d : this.hierarchy.getTerminals()) {
            if (d.getLabel() == 0.0) continue;
            ++total;
        }
        return total;
    }
}

