/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveLexicalRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalFullyConnectedLexicon;
import edu.berkeley.nlp.PCFGLA.HierarchicalLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import java.util.Arrays;

public class HierarchicalFullyConnectedAdaptiveLexicon
extends HierarchicalFullyConnectedLexicon {
    private static final long serialVersionUID = 1L;
    public HierarchicalAdaptiveLexicalRule[][] rules;

    public HierarchicalFullyConnectedAdaptiveLexicon(short[] numSubStates, int smoothingCutoff, double[] smoothParam, Smoother smoother, StateSetTreeList trainTrees, int knownWordCount) {
        super(numSubStates, knownWordCount);
        super.init(trainTrees);
        this.init();
    }

    public HierarchicalFullyConnectedAdaptiveLexicon(short[] numSubStates, int knownWordCount) {
        super(numSubStates, knownWordCount);
    }

    private void init() {
        this.scores = null;
        this.hierarchicalScores = null;
        this.finalLevels = null;
        this.rules = new HierarchicalAdaptiveLexicalRule[this.numStates][];
        int tag = 0;
        while (tag < this.numStates) {
            if (this.tagWordIndexer[tag] == null) {
                this.rules[tag] = new HierarchicalAdaptiveLexicalRule[0];
            } else {
                this.rules[tag] = new HierarchicalAdaptiveLexicalRule[this.tagWordIndexer[tag].size()];
                int word = 0;
                while (word < this.rules[tag].length) {
                    this.rules[tag][word] = new HierarchicalAdaptiveLexicalRule();
                    ++word;
                }
            }
            ++tag;
        }
    }

    public double[] score(int globalWordIndex, int globalSigIndex, short tag, int loc, boolean noSmoothing, boolean isSignature) {
        int i;
        int tagSpecificWordIndex;
        double[] res = new double[this.numSubStates[tag]];
        if (this.tagWordIndexer[tag] == null) {
            return res;
        }
        if (globalWordIndex != -1) {
            tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalWordIndex);
            if (tagSpecificWordIndex != -1) {
                i = 0;
                while (i < this.numSubStates[tag]) {
                    res[i] = this.rules[tag][tagSpecificWordIndex].scores[i];
                    ++i;
                }
            } else if (this.knownWordCount > 0) {
                Arrays.fill(res, 1.0);
            }
        } else if (this.knownWordCount > 0) {
            Arrays.fill(res, 1.0);
        }
        if (globalWordIndex >= 0 && this.wordCounter[globalWordIndex] > this.knownWordCount) {
            return res;
        }
        if (globalSigIndex > -1 && (tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalSigIndex)) != -1) {
            i = 0;
            while (i < this.numSubStates[tag]) {
                int n = i;
                res[n] = res[n] * this.rules[tag][tagSpecificWordIndex].scores[i];
                ++i;
            }
        }
        return res;
    }

    public HierarchicalLexicon copyLexicon() {
        return this;
    }

    public HierarchicalLexicon splitAllStates(int[] counts, boolean moreSubstatesThanCounts, int mode) {
        int finalLevel = (int)(Math.log((int)ArrayUtil.max(this.numSubStates)) / Math.log(2.0)) + 1;
        int tag = 0;
        while (tag < this.numStates) {
            int n = tag;
            this.numSubStates[n] = (short)(this.numSubStates[n] * 2);
            int word = 0;
            while (word < this.rules[tag].length) {
                this.rules[tag][word].splitRule(this.numSubStates[tag]);
                this.rules[tag][word].explicitlyComputeScores(finalLevel, false);
                ++word;
            }
            ++tag;
        }
        return this;
    }

    public void mergeLexicon() {
        int removedParam = 0;
        int tag = 0;
        while (tag < this.numStates) {
            int word = 0;
            while (word < this.rules[tag].length) {
                removedParam += this.rules[tag][word].mergeRule();
                ++word;
            }
            ++tag;
        }
        System.out.println("Removed " + removedParam + " parameters from the lexicon.");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        int tag = 0;
        while (tag < this.rules.length) {
            int[] counts = new int[7];
            String tagS = (String)tagNumberer.object(tag);
            if (this.rules[tag].length != 0) {
                int word = 0;
                while (word < this.rules[tag].length) {
                    sb.append(String.valueOf(tagS) + " " + (String)this.wordIndexer.get(this.tagWordIndexer[tag].get(word)) + "\n");
                    sb.append(this.rules[tag][word].toString());
                    sb.append("\n\n");
                    int n = this.rules[tag][word].hierarchy.getDepth();
                    counts[n] = counts[n] + 1;
                    ++word;
                }
                System.out.print(tagNumberer.object(tag) + ", lexical rules per level: ");
                int i = 1;
                while (i < 6) {
                    System.out.print(String.valueOf(counts[i]) + " ");
                    ++i;
                }
                System.out.print("\n");
            }
            ++tag;
        }
        return sb.toString();
    }

    public void explicitlyComputeScores(int finalLevel) {
        int tag = 0;
        while (tag < this.rules.length) {
            int word = 0;
            while (word < this.rules[tag].length) {
                this.rules[tag][word].explicitlyComputeScores(finalLevel, false);
                ++word;
            }
            tag = (short)(tag + 1);
        }
    }
}

