/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

public class HyperEdge {
    int parentState;
    int lChildState;
    int rChildState;
    int childState;
    boolean isUnary;
    double score;
    double ruleScore;
    int start;
    int split;
    int end;
    int parentBest;
    int lChildBest;
    int rChildBest;
    int childBest;
    boolean alreadyExpanded;

    public HyperEdge(int pState, int lState, int rState, int pBest, int lBest, int rBest, int begin, int mid, int finale, double cost, double ruleCost) {
        this.parentState = pState;
        this.lChildState = lState;
        this.rChildState = rState;
        this.parentBest = pBest;
        this.lChildBest = lBest;
        this.rChildBest = rBest;
        this.childState = -1;
        this.start = begin;
        this.split = mid;
        this.end = finale;
        this.score = cost;
        this.isUnary = false;
        this.ruleScore = ruleCost;
    }

    public HyperEdge(int pState, int cState, int pBest, int cBest, int begin, int finale, double cost, double ruleCost) {
        this.parentState = pState;
        this.childState = cState;
        this.lChildState = -1;
        this.rChildState = -1;
        this.parentBest = pBest;
        this.childBest = cBest;
        this.start = begin;
        this.end = finale;
        this.score = cost;
        this.isUnary = true;
        this.ruleScore = ruleCost;
    }

    public boolean differsInPOSatMost(HyperEdge other, boolean[] grammarTags) {
        if (this.split != other.split) {
            return false;
        }
        if (this.isUnary) {
            if (this.childBest == other.childBest && other.childState == this.childState) {
                return true;
            }
        } else {
            if (this.end - this.split == 1 && this.lChildState == other.lChildState && this.lChildBest == other.lChildBest && !grammarTags[this.rChildState] && !grammarTags[other.rChildState]) {
                return true;
            }
            if (this.split - this.start == 1 && this.rChildState == other.rChildState && this.rChildBest == other.rChildBest) {
                return true;
            }
            if (this.lChildState == other.lChildState && this.rChildState == other.rChildState && this.rChildBest == other.rChildBest && this.lChildBest == other.lChildBest && !grammarTags[this.lChildState] && !grammarTags[other.lChildState]) {
                return true;
            }
        }
        return false;
    }
}

