/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.HyperEdge;
import edu.berkeley.nlp.util.PriorityQueue;
import java.util.ArrayList;
import java.util.List;

public class LazyList {
    List<HyperEdge> sortedBegining = new ArrayList<HyperEdge>();
    PriorityQueue<HyperEdge> fringe = new PriorityQueue();
    int nSorted = 0;
    int nFringe = 0;
    boolean[] grammarTags;

    public LazyList(boolean[] tags) {
        this.grammarTags = tags;
    }

    public int sortedListSize() {
        return this.nSorted;
    }

    public void addToFringe(HyperEdge el) {
        this.fringe.add(el, el.score);
        ++this.nFringe;
    }

    public HyperEdge getKbest(int k) {
        if (k > this.nSorted) {
            System.out.println("Don't have this element yet");
            return null;
        }
        if (k == this.nSorted) {
            this.expandNextBest();
        }
        if (k == this.nSorted) {
            return null;
        }
        return this.sortedBegining.get(k);
    }

    public void expandNextBest() {
        while (this.fringe.hasNext()) {
            HyperEdge edge = this.fringe.next();
            boolean isNew = true;
            for (HyperEdge alreadyIn : this.sortedBegining) {
                if (!alreadyIn.differsInPOSatMost(edge, this.grammarTags)) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            this.sortedBegining.add(edge);
            --this.nFringe;
            ++this.nSorted;
            break;
        }
    }
}

