/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OptionParser {
    private final Map<String, Option> nameToOption = new HashMap<String, Option>();
    private final Map<String, Field> nameToField = new HashMap<String, Field>();
    private final Set<String> requiredOptions = new HashSet<String>();
    private final Class optionsClass;
    private StringBuilder passedInOptions;

    public OptionParser(Class optionsClass) {
        this.optionsClass = optionsClass;
        Field[] fieldArray = optionsClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Option option = field.getAnnotation(Option.class);
            if (option != null) {
                this.nameToOption.put(option.name(), option);
                this.nameToField.put(option.name(), field);
                if (option.required()) {
                    this.requiredOptions.add(option.name());
                }
            }
            ++n2;
        }
    }

    private void usage() {
        System.err.println();
        for (Option opt : this.nameToOption.values()) {
            System.err.printf("%-30s%s", opt.name(), opt.usage());
            if (opt.required()) {
                System.err.printf(" [required]", new Object[0]);
            }
            System.err.println();
        }
        System.err.printf("%-30shelp message\n", "-h");
        System.err.println();
        System.exit(2);
    }

    public Object parse(String[] args) {
        return this.parse(args, false, false);
    }

    public Object parse(String[] args, boolean failOnUnrecognized) {
        return this.parse(args, failOnUnrecognized, false);
    }

    public Object parse(String[] args, boolean failOnUnrecognized, boolean parrot) {
        if (parrot) {
            System.out.println("Calling with " + Arrays.deepToString(args));
        }
        try {
            HashSet<String> seenOpts = new HashSet<String>();
            this.passedInOptions = new StringBuilder("{");
            Object options = this.optionsClass.newInstance();
            int i = 0;
            while (i < args.length) {
                Option opt;
                if (args[i].equals("-h")) {
                    this.usage();
                }
                if ((opt = this.nameToOption.get(args[i])) == null) {
                    if (failOnUnrecognized) {
                        throw new RuntimeException("Did not recognize option " + args[i]);
                    }
                    System.err.println("WARNING: Did not recognize option " + args[i]);
                } else {
                    seenOpts.add(args[i]);
                    Field field = this.nameToField.get(args[i]);
                    Class<?> fieldType = field.getType();
                    if (fieldType == Boolean.TYPE) {
                        field.setBoolean(options, true);
                        this.passedInOptions.append(String.format(" %s => true", opt.name()));
                    } else {
                        String value = args[i + 1];
                        if (value != null) {
                            value.trim();
                        }
                        this.passedInOptions.append(String.format(" %s => %s", opt.name(), value));
                        if (fieldType == Integer.TYPE) {
                            field.setInt(options, Integer.parseInt(value));
                        } else if (fieldType == Double.TYPE) {
                            field.setDouble(options, Double.parseDouble(value));
                        } else if (fieldType == Float.TYPE) {
                            field.setFloat(options, Float.parseFloat(value));
                        } else if (fieldType == Short.TYPE) {
                            field.setFloat(options, Short.parseShort(value));
                        } else if (fieldType.isEnum()) {
                            ?[] possibleValues = fieldType.getEnumConstants();
                            boolean found = false;
                            ?[] objArray = possibleValues;
                            int n = possibleValues.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object possibleValue = objArray[n2];
                                String enumName = ((Enum)possibleValue).name();
                                if (value.equals(enumName)) {
                                    field.set(options, possibleValue);
                                    found = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!found) {
                                if (failOnUnrecognized) {
                                    throw new RuntimeException("Unrecognized enumeration option " + value);
                                }
                                System.err.println("WARNING: Did not recognize option Enumeration option " + value);
                            }
                        } else if (fieldType == String.class) {
                            field.set(options, value);
                        } else {
                            try {
                                Constructor<?> constructor = fieldType.getConstructor(String.class);
                                field.set(options, constructor.newInstance(value));
                            }
                            catch (NoSuchMethodException e) {
                                System.err.println("Cannot construct object of type " + fieldType.getCanonicalName() + " from just a string");
                            }
                        }
                        ++i;
                    }
                }
                ++i;
            }
            this.passedInOptions.append(" }");
            HashSet<String> optionsLeft = new HashSet<String>(this.requiredOptions);
            optionsLeft.removeAll(seenOpts);
            if (!optionsLeft.isEmpty()) {
                System.err.println("Failed to specify: " + optionsLeft);
                this.usage();
            }
            return options;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPassedInOptions() {
        return this.passedInOptions.toString();
    }
}

