/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.io.PTBLineLexer;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.ui.TreeJPanel;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.Pair;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceSegmenter {
    static TreeJPanel tjp;
    static JFrame frame;

    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        double threshold = 1.0;
        String inFileName = opts.grFileName;
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        Lexicon lexicon = pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        CoarseToFineMaxRuleParser parser = null;
        parser = new CoarseToFineMaxRuleParser(grammar, lexicon, threshold, -1, false, false, false, opts.accurate, false, true, true);
        parser.binarization = pData.getBinarization();
        try {
            BufferedReader inputData = opts.inputFile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.inputFile), "UTF-8"));
            PrintWriter outputData = opts.outputFile == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputFile), "UTF-8"), true);
            PTBLineLexer tokenizer = null;
            if (opts.tokenize) {
                tokenizer = new PTBLineLexer();
            }
            String line = "";
            while ((line = inputData.readLine()) != null) {
                List<String> sentence = null;
                List<String> posTags = null;
                String[] parts = line.split("\t");
                if (parts.length < 3) continue;
                int nPoints = Integer.parseInt(parts[0]);
                ArrayList<Pair<Integer, Integer>> points = new ArrayList<Pair<Integer, Integer>>(nPoints);
                String[] segments = parts[1].split("\\(");
                int i = 1;
                while (i <= nPoints) {
                    String[] numbers = segments[i].split(" ");
                    String n0 = numbers[0];
                    String string = numbers[1].substring(0, numbers[1].length() - 1);
                    Pair<Integer, Integer> number = new Pair<Integer, Integer>(Integer.parseInt(n0), Integer.parseInt(string));
                    points.add(number);
                    ++i;
                }
                sentence = !opts.tokenize ? Arrays.asList(parts[parts.length - 1].split(" ")) : tokenizer.tokenizeLine(parts[parts.length - 1]);
                if (sentence.size() >= 200) {
                    sentence = new ArrayList<String>();
                    System.err.println("Skipping sentence with " + sentence.size() + " words since it is too long.");
                    continue;
                }
                Tree<String> parsedTree = parser.getBestConstrainedParse(sentence, posTags, null);
                double allLL = parsedTree.getChildren().isEmpty() ? Double.NEGATIVE_INFINITY : parser.getLogLikelihood();
                outputData.write(String.valueOf(allLL) + " ");
                for (Pair pair : points) {
                    double partLL = parser.getSentenceProbability((Integer)pair.getFirst(), (Integer)pair.getSecond(), opts.constituent);
                    outputData.write(String.valueOf(partLL) + " ");
                }
                outputData.write("\n");
            }
            outputData.flush();
            outputData.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    public static void writeTreeToImage(Tree<String> tree, String fileName) throws IOException {
        tjp.setTree(tree);
        BufferedImage bi = new BufferedImage(tjp.width(), tjp.height(), 2);
        int t = tjp.height();
        Graphics2D g2 = bi.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(1, 1.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, tjp.width(), tjp.height());
        g2.fill(rect);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        tjp.paintComponent(g2);
        g2.dispose();
        ImageIO.write((RenderedImage)bi, "png", new File(fileName));
    }

    public static class Options {
        @Option(name="-gr", required=true, usage="Grammarfile (Required)\n")
        public String grFileName;
        @Option(name="-tokenize", usage="Tokenize input first. (Default: false=text is already tokenized)")
        public boolean tokenize;
        @Option(name="-accurate", usage="Set thresholds for accuracy. (Default: set thresholds for efficiency)")
        public boolean accurate;
        @Option(name="-constituent", usage="Instead of sentence probabilities return constituent probabilities")
        public boolean constituent = false;
        @Option(name="-inputFile", usage="Read input from this file instead of reading it from STDIN.")
        public String inputFile;
        @Option(name="-outputFile", usage="Store output in this file instead of printing it to STDOUT.")
        public String outputFile;
    }
}

