/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Indexer;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLexicon
implements Serializable,
Lexicon {
    public IntegerIndexer[] tagWordIndexer;
    public double[][][] expectedCounts;
    public double[][][] scores;
    public int[] wordCounter;
    private static final long serialVersionUID = 2L;
    public short[] numSubStates;
    int numStates;
    int nWords;
    double threshold;
    boolean isLogarithmMode;
    boolean useVarDP = false;
    public Indexer<String> wordIndexer;
    Smoother smoother;
    protected transient String lastSignature = "";
    protected transient int lastSentencePosition = -1;
    protected transient String lastWordToSignaturize = "";
    private int unknownLevel = 5;

    @Override
    public void optimize() {
        short tag = 0;
        while (tag < this.expectedCounts.length) {
            int substate = 0;
            while (substate < this.numSubStates[tag]) {
                double mass = ArrayUtil.sum(this.expectedCounts[tag][substate]);
                double normalizer = mass == 0.0 ? 0.0 : 1.0 / mass;
                int word = 0;
                while (word < this.expectedCounts[tag][substate].length) {
                    this.scores[tag][substate][word] = this.expectedCounts[tag][substate][word] * normalizer;
                    ++word;
                }
                ++substate;
            }
            ++tag;
        }
        if (this.smoother != null) {
            tag = 0;
            while (tag < this.expectedCounts.length) {
                int word = 0;
                while (word < this.expectedCounts[tag][0].length) {
                    double[] res = new double[this.numSubStates[tag]];
                    int substate = 0;
                    while (substate < this.numSubStates[tag]) {
                        res[substate] = this.scores[tag][substate][word];
                        ++substate;
                    }
                    this.smoother.smooth(tag, res);
                    substate = 0;
                    while (substate < this.numSubStates[tag]) {
                        this.scores[tag][substate][word] = res[substate];
                        ++substate;
                    }
                    ++word;
                }
                tag = (short)(tag + 1);
            }
        }
    }

    public SimpleLexicon(short[] numSubStates, int smoothingCutoff, double[] smoothParam, Smoother smoother, double threshold, StateSetTreeList trainTrees) {
        this(numSubStates, threshold);
        this.init(trainTrees);
    }

    public SimpleLexicon(short[] numSubStates, double threshold) {
        this.numSubStates = numSubStates;
        this.threshold = threshold;
        this.wordIndexer = new Indexer();
        this.numStates = numSubStates.length;
        this.isLogarithmMode = false;
        if (Corpus.myTreebank != Corpus.TreeBankType.WSJ || Corpus.myTreebank == Corpus.TreeBankType.BROWN) {
            this.unknownLevel = 4;
        }
    }

    @Override
    public double[] score(String word, short tag, int pos, boolean noSmoothing, boolean isSignature) {
        StateSet stateSet = new StateSet(tag, 1, word, (short)pos, (short)(pos + 1));
        stateSet.wordIndex = -2;
        stateSet.sigIndex = -2;
        return this.score(stateSet, tag, noSmoothing, isSignature);
    }

    @Override
    public double[] score(StateSet stateSet, short tag, boolean noSmoothing, boolean isSignature) {
        double[] res = new double[this.numSubStates[tag]];
        int globalWordIndex = stateSet.wordIndex;
        if (globalWordIndex == -2) {
            globalWordIndex = stateSet.wordIndex = this.wordIndexer.indexOf(stateSet.getWord());
        }
        if (globalWordIndex == -1) {
            globalWordIndex = stateSet.sigIndex;
        }
        if (globalWordIndex == -2) {
            globalWordIndex = stateSet.sigIndex = this.wordIndexer.indexOf(this.getSignature(stateSet.getWord(), stateSet.from));
        }
        if (globalWordIndex == -1) {
            System.out.println("unknown signature for word " + stateSet.getWord());
            Arrays.fill(res, 0.001);
            return res;
        }
        int tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalWordIndex);
        if (tagSpecificWordIndex == -1) {
            if (this.isLogarithmMode) {
                Arrays.fill(res, Double.NEGATIVE_INFINITY);
            }
            return res;
        }
        int i = 0;
        while (i < this.numSubStates[tag]) {
            res[i] = this.scores[tag][i][tagSpecificWordIndex];
            ++i;
        }
        if (this.smoother != null) {
            this.smoother.smooth(tag, res);
        }
        return res;
    }

    @Override
    public void trainTree(Tree<StateSet> trainTree, double randomness, Lexicon oldLexicon, boolean secondHalf, boolean noSmoothing, int unusedUnkThreshold) {
        double sentenceScore = 0.0;
        if (randomness == -1.0 && (sentenceScore = trainTree.getLabel().getIScore(0)) == 0.0) {
            System.out.println("Something is wrong with this tree. I will skip it.");
            return;
        }
        int sentenceScale = trainTree.getLabel().getIScale();
        List<StateSet> words = trainTree.getYield();
        List<StateSet> tags = trainTree.getPreTerminalYield();
        int position = 0;
        while (position < words.size()) {
            int nSubStates = tags.get(position).numSubStates();
            short tag = tags.get(position).getState();
            String word = words.get(position).getWord();
            int globalWordIndex = this.wordIndexer.indexOf(word);
            int tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalWordIndex);
            double[] oldLexiconScores = null;
            if (randomness == -1.0) {
                oldLexiconScores = oldLexicon.score(word, tag, position, noSmoothing, false);
            }
            StateSet currentState = tags.get(position);
            double scale = ScalingTools.calcScaleFactor(currentState.getOScale() - sentenceScale) / sentenceScore;
            int substate = 0;
            while (substate < nSubStates) {
                double weight = 1.0;
                weight = randomness == -1.0 ? (!Double.isInfinite(scale) ? currentState.getOScore(substate) * oldLexiconScores[substate] * scale : Math.exp(Math.log(ScalingTools.SCALE) * (double)(currentState.getOScale() - sentenceScale) - Math.log(sentenceScore) + Math.log(currentState.getOScore(substate)) + Math.log(oldLexiconScores[substate]))) : (randomness == 0.0 ? 1.0 : GrammarTrainer.RANDOM.nextDouble() * randomness / 100.0 + 1.0);
                if (weight != 0.0) {
                    double[] dArray = this.expectedCounts[tag][substate];
                    int n = tagSpecificWordIndex;
                    dArray[n] = dArray[n] + weight;
                }
                substate = (short)(substate + 1);
            }
            ++position;
        }
    }

    public void setUseVarDP(boolean useVarDP) {
        this.useVarDP = useVarDP;
    }

    public void init(StateSetTreeList trainTrees) {
        for (Tree<StateSet> tree : trainTrees) {
            List<StateSet> words = tree.getYield();
            for (StateSet word : words) {
                String sig = word.getWord();
                this.wordIndexer.add(sig);
            }
        }
        this.tagWordIndexer = new IntegerIndexer[this.numStates];
        int tag = 0;
        while (tag < this.numStates) {
            this.tagWordIndexer[tag] = new IntegerIndexer(this.wordIndexer.size());
            ++tag;
        }
        this.wordCounter = new int[this.wordIndexer.size()];
        for (Tree<StateSet> tree : trainTrees) {
            List<StateSet> tags = tree.getPreTerminalYield();
            List<StateSet> words = tree.getYield();
            int ind = 0;
            for (StateSet word : words) {
                String sig = word.getWord();
                int n = this.wordIndexer.indexOf(sig);
                this.wordCounter[n] = this.wordCounter[n] + 1;
                this.tagWordIndexer[tags.get(ind).getState()].add(this.wordIndexer.indexOf(sig));
                ++ind;
            }
        }
        this.expectedCounts = new double[this.numStates][][];
        this.scores = new double[this.numStates][][];
        tag = 0;
        while (tag < this.numStates) {
            this.expectedCounts[tag] = new double[this.numSubStates[tag]][this.tagWordIndexer[tag].size()];
            this.scores[tag] = new double[this.numSubStates[tag]][this.tagWordIndexer[tag].size()];
            ++tag;
        }
        this.nWords = this.wordIndexer.size();
        this.labelTrees(trainTrees);
    }

    @Override
    public SimpleLexicon copyLexicon() {
        SimpleLexicon copy = new SimpleLexicon(this.numSubStates, this.threshold);
        copy.expectedCounts = new double[this.numStates][][];
        copy.scores = ArrayUtil.clone(this.scores);
        copy.tagWordIndexer = new IntegerIndexer[this.numStates];
        copy.wordIndexer = this.wordIndexer;
        int tag = 0;
        while (tag < this.numStates) {
            copy.tagWordIndexer[tag] = this.tagWordIndexer[tag].copy();
            copy.expectedCounts[tag] = new double[this.numSubStates[tag]][this.tagWordIndexer[tag].size()];
            ++tag;
        }
        copy.nWords = this.nWords;
        copy.smoother = this.smoother;
        copy.wordCounter = (int[])this.wordCounter.clone();
        return copy;
    }

    @Override
    public boolean isLogarithmMode() {
        return this.isLogarithmMode;
    }

    @Override
    public void logarithmMode() {
        if (this.isLogarithmMode) {
            return;
        }
        int tag = 0;
        while (tag < this.scores.length) {
            int word = 0;
            while (word < this.scores[tag].length) {
                int substate = 0;
                while (substate < this.scores[tag][word].length) {
                    this.scores[tag][word][substate] = Math.log(this.scores[tag][word][substate]);
                    ++substate;
                }
                ++word;
            }
            ++tag;
        }
        this.isLogarithmMode = true;
    }

    @Override
    public SimpleLexicon splitAllStates(int[] counts, boolean moreSubstatesThanCounts, int mode) {
        SimpleLexicon splitLex = this.copyLexicon();
        short[] newNumSubStates = new short[this.numSubStates.length];
        newNumSubStates[0] = 1;
        Random random = GrammarTrainer.RANDOM;
        int i = 1;
        while (i < this.numSubStates.length) {
            newNumSubStates[i] = (short)(this.numSubStates[i] * 2);
            i = (short)(i + 1);
        }
        splitLex.numSubStates = newNumSubStates;
        double[][][] newScores = new double[this.scores.length][][];
        double[][][] newExpCounts = new double[this.scores.length][][];
        int tag = 0;
        while (tag < this.expectedCounts.length) {
            int nTagWords = this.tagWordIndexer[tag].size();
            newScores[tag] = new double[newNumSubStates[tag]][nTagWords];
            newExpCounts[tag] = new double[newNumSubStates[tag]][nTagWords];
            int substate = 0;
            while (substate < this.numSubStates[tag]) {
                int word = 0;
                while (word < this.expectedCounts[tag][substate].length) {
                    double d = this.scores[tag][substate][word];
                    newScores[tag][2 * substate + 1][word] = d;
                    newScores[tag][2 * substate][word] = d;
                    if (mode == 2) {
                        double d2 = 1.0 + random.nextDouble() / 100.0;
                        newScores[tag][2 * substate + 1][word] = d2;
                        newScores[tag][2 * substate][word] = d2;
                    }
                    ++word;
                }
                ++substate;
            }
            ++tag;
        }
        splitLex.scores = newScores;
        splitLex.expectedCounts = newExpCounts;
        return splitLex;
    }

    public String getNewSignature(String word, int loc) {
        StringBuffer sb = new StringBuffer("UNK");
        switch (this.unknownLevel) {
            case 5: {
                int wlen = word.length();
                int numCaps = 0;
                boolean hasDigit = false;
                boolean hasDash = false;
                boolean hasLower = false;
                int i = 0;
                while (i < wlen) {
                    char ch = word.charAt(i);
                    if (Character.isDigit(ch)) {
                        hasDigit = true;
                    } else if (ch == '-') {
                        hasDash = true;
                    } else if (Character.isLetter(ch)) {
                        if (Character.isLowerCase(ch)) {
                            hasLower = true;
                        } else if (Character.isTitleCase(ch)) {
                            hasLower = true;
                            ++numCaps;
                        } else {
                            ++numCaps;
                        }
                    }
                    ++i;
                }
                char ch0 = word.charAt(0);
                String lowered = word.toLowerCase();
                if (Character.isUpperCase(ch0) || Character.isTitleCase(ch0)) {
                    if (loc == 0 && numCaps == 1) {
                        sb.append("-INITC");
                        if (this.isKnown(lowered)) {
                            sb.append("-KNOWNLC");
                        }
                    } else {
                        sb.append("-CAPS");
                    }
                } else if (!Character.isLetter(ch0) && numCaps > 0) {
                    sb.append("-CAPS");
                } else if (hasLower) {
                    sb.append("-LC");
                }
                if (hasDigit) {
                    sb.append("-NUM");
                }
                if (hasDash) {
                    sb.append("-DASH");
                }
                if (lowered.endsWith("s") && wlen >= 3) {
                    char ch2 = lowered.charAt(wlen - 2);
                    if (ch2 == 's' || ch2 == 'i' || ch2 == 'u') break;
                    sb.append("-s");
                    break;
                }
                if (word.length() < 5 || hasDash || hasDigit && numCaps > 0) break;
                if (lowered.endsWith("ed")) {
                    sb.append("-ed");
                    break;
                }
                if (lowered.endsWith("ing")) {
                    sb.append("-ing");
                    break;
                }
                if (lowered.endsWith("ion")) {
                    sb.append("-ion");
                    break;
                }
                if (lowered.endsWith("er")) {
                    sb.append("-er");
                    break;
                }
                if (lowered.endsWith("est")) {
                    sb.append("-est");
                    break;
                }
                if (lowered.endsWith("ly")) {
                    sb.append("-ly");
                    break;
                }
                if (lowered.endsWith("ity")) {
                    sb.append("-ity");
                    break;
                }
                if (lowered.endsWith("y")) {
                    sb.append("-y");
                    break;
                }
                if (!lowered.endsWith("al")) break;
                sb.append("-al");
                break;
            }
            case 4: {
                char ch;
                boolean hasDigit = false;
                boolean hasNonDigit = false;
                boolean hasLetter = false;
                boolean hasLower = false;
                boolean hasDash = false;
                boolean hasPeriod = false;
                boolean hasComma = false;
                int i = 0;
                while (i < word.length()) {
                    char ch2 = word.charAt(i);
                    if (Character.isDigit(ch2)) {
                        hasDigit = true;
                    } else {
                        hasNonDigit = true;
                        if (Character.isLetter(ch2)) {
                            hasLetter = true;
                            if (Character.isLowerCase(ch2) || Character.isTitleCase(ch2)) {
                                hasLower = true;
                            }
                        } else if (ch2 == '-') {
                            hasDash = true;
                        } else if (ch2 == '.') {
                            hasPeriod = true;
                        } else if (ch2 == ',') {
                            hasComma = true;
                        }
                    }
                    ++i;
                }
                if (Character.isUpperCase(word.charAt(0)) || Character.isTitleCase(word.charAt(0))) {
                    if (!hasLower) {
                        sb.append("-AC");
                    } else if (loc == 0) {
                        sb.append("-SC");
                    } else {
                        sb.append("-C");
                    }
                } else if (hasLower) {
                    sb.append("-L");
                } else if (hasLetter) {
                    sb.append("-U");
                } else {
                    sb.append("-S");
                }
                if (hasDigit && !hasNonDigit) {
                    sb.append("-N");
                } else if (hasDigit) {
                    sb.append("-n");
                }
                if (hasDash) {
                    sb.append("-H");
                }
                if (hasPeriod) {
                    sb.append("-P");
                }
                if (hasComma) {
                    sb.append("-C");
                }
                if (word.length() <= 3 || !Character.isLetter(ch = word.charAt(word.length() - 1))) break;
                sb.append("-");
                sb.append(Character.toLowerCase(ch));
                break;
            }
            case 3: {
                sb.append("-");
                int lastClass = 45;
                int num = 0;
                int i = 0;
                while (i < word.length()) {
                    char ch = word.charAt(i);
                    int newClass = Character.isUpperCase(ch) || Character.isTitleCase(ch) ? (loc == 0 ? 83 : 76) : (Character.isLetter(ch) ? 108 : (Character.isDigit(ch) ? 100 : (ch == '-' ? 104 : (ch == '.' ? 112 : 115))));
                    if (newClass != lastClass) {
                        lastClass = newClass;
                        sb.append((char)lastClass);
                        num = 1;
                    } else {
                        if (num < 2) {
                            sb.append('+');
                        }
                        ++num;
                    }
                    ++i;
                }
                if (word.length() <= 3) break;
                char ch = Character.toLowerCase(word.charAt(word.length() - 1));
                sb.append('-');
                sb.append(ch);
                break;
            }
            case 2: {
                boolean hasDigit = false;
                boolean hasNonDigit = false;
                boolean hasLower = false;
                int i = 0;
                while (i < word.length()) {
                    char ch = word.charAt(i);
                    if (Character.isDigit(ch)) {
                        hasDigit = true;
                    } else {
                        hasNonDigit = true;
                        if (Character.isLetter(ch) && (Character.isLowerCase(ch) || Character.isTitleCase(ch))) {
                            hasLower = true;
                        }
                    }
                    ++i;
                }
                if (Character.isUpperCase(word.charAt(0)) || Character.isTitleCase(word.charAt(0))) {
                    if (!hasLower) {
                        sb.append("-ALLC");
                    } else if (loc == 0) {
                        sb.append("-INIT");
                    } else {
                        sb.append("-UC");
                    }
                } else if (hasLower) {
                    sb.append("-LC");
                }
                if (word.indexOf(45) >= 0) {
                    sb.append("-DASH");
                }
                if (hasDigit) {
                    if (!hasNonDigit) {
                        sb.append("-NUM");
                        break;
                    }
                    sb.append("-DIG");
                    break;
                }
                if (word.length() <= 3) break;
                char ch = word.charAt(word.length() - 1);
                sb.append(Character.toLowerCase(ch));
                break;
            }
            default: {
                sb.append("-");
                sb.append(word.substring(Math.max(word.length() - 2, 0), word.length()));
                sb.append("-");
                if (Character.isLowerCase(word.charAt(0))) {
                    sb.append("LOWER");
                    break;
                }
                if (Character.isUpperCase(word.charAt(0))) {
                    if (loc == 0) {
                        sb.append("INIT");
                        break;
                    }
                    sb.append("UPPER");
                    break;
                }
                sb.append("OTHER");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        int tag = 0;
        while (tag < this.expectedCounts.length) {
            String tagS = (String)tagNumberer.object(tag);
            if (this.tagWordIndexer[tag].size() != 0) {
                int word = 0;
                while (word < this.scores[tag][0].length) {
                    sb.append(String.valueOf(tagS) + " " + this.wordIndexer.get(this.tagWordIndexer[tag].get(word)) + " ");
                    int sub = 0;
                    while (sub < this.numSubStates[tag]) {
                        sb.append(" " + this.scores[tag][sub][word]);
                        ++sub;
                    }
                    sb.append("\n");
                    ++word;
                }
            }
            ++tag;
        }
        return sb.toString();
    }

    private boolean isKnown(String word) {
        return this.wordIndexer.indexOf(word) != -1;
    }

    @Override
    public String getSignature(String word, int sentencePosition) {
        String uwSig;
        if (word.equals(this.lastWordToSignaturize) && sentencePosition == this.lastSentencePosition) {
            return this.lastSignature;
        }
        this.lastSignature = uwSig = this.getNewSignature(word, sentencePosition);
        this.lastSentencePosition = sentencePosition;
        this.lastWordToSignaturize = word;
        return uwSig;
    }

    @Override
    public void mergeStates(boolean[][][] mergeThesePairs, double[][] mergeWeights) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        short[][] mapping = new short[this.numSubStates.length][];
        short[][][] partners = new short[this.numSubStates.length][][];
        Grammar.calculateMergeArrays(mergeThesePairs, newNumSubStates, mapping, partners, this.numSubStates);
        double[][][] newScores = new double[this.scores.length][][];
        int tag = 0;
        while (tag < this.expectedCounts.length) {
            int nTagWords = this.tagWordIndexer[tag].size();
            newScores[tag] = new double[newNumSubStates[tag]][nTagWords];
            if (this.numSubStates[tag] != 1) {
                int word = 0;
                while (word < this.expectedCounts[tag][0].length) {
                    int i = 0;
                    while (i < this.numSubStates[tag]) {
                        int nSplit = partners[tag][i].length;
                        if (nSplit == 2) {
                            double mergeWeightSum = mergeWeights[tag][partners[tag][i][0]] + mergeWeights[tag][partners[tag][i][1]];
                            if (mergeWeightSum == 0.0) {
                                mergeWeightSum = 1.0;
                            }
                            newScores[tag][mapping[tag][i]][word] = (mergeWeights[tag][partners[tag][i][0]] * this.scores[tag][partners[tag][i][0]][word] + mergeWeights[tag][partners[tag][i][1]] * this.scores[tag][partners[tag][i][1]][word]) / mergeWeightSum;
                        } else {
                            newScores[tag][mapping[tag][i]][word] = this.scores[tag][i][word];
                            newScores[tag][mapping[tag][i + 1]][word] = this.scores[tag][i + 1][word];
                        }
                        i += 2;
                    }
                    ++word;
                }
            }
            ++tag;
        }
        this.numSubStates = newNumSubStates;
        this.scores = newScores;
        tag = 0;
        while (tag < this.numStates) {
            this.expectedCounts[tag] = new double[newNumSubStates[tag]][this.tagWordIndexer[tag].size()];
            ++tag;
        }
    }

    @Override
    public void removeUnlikelyTags(double threshold, double exponent) {
        int tag = 0;
        while (tag < this.scores.length) {
            int word = 0;
            while (word < this.scores[tag].length) {
                int substate = 0;
                while (substate < this.scores[tag][word].length) {
                    double p = this.scores[tag][word][substate];
                    if (exponent != 1.0) {
                        p = Math.pow(p, exponent);
                    }
                    this.scores[tag][word][substate] = p;
                    ++substate;
                }
                ++word;
            }
            ++tag;
        }
    }

    @Override
    public SimpleLexicon projectLexicon(double[] condProbs, int[][] mapping, int[][] toSubstateMapping) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        int state = 0;
        while (state < this.numSubStates.length) {
            newNumSubStates[state] = (short)toSubstateMapping[state][0];
            ++state;
        }
        SimpleLexicon newLexicon = this.copyLexicon();
        double[][][] newScores = new double[this.scores.length][][];
        int tag = 0;
        while (tag < this.expectedCounts.length) {
            newScores[tag] = new double[newNumSubStates[tag]][this.expectedCounts[tag][0].length];
            int word = 0;
            while (word < this.expectedCounts[tag][0].length) {
                int substate = 0;
                while (substate < this.numSubStates[tag]) {
                    double[] dArray = newScores[tag][toSubstateMapping[tag][substate + 1]];
                    int n = word;
                    dArray[n] = dArray[n] + condProbs[mapping[tag][substate]] * this.scores[tag][substate][word];
                    ++substate;
                }
                ++word;
            }
            tag = (short)(tag + 1);
        }
        newLexicon.numSubStates = newNumSubStates;
        newLexicon.scores = newScores;
        return newLexicon;
    }

    @Override
    public Smoother getSmoother() {
        return this.smoother;
    }

    @Override
    public double[] getSmoothingParams() {
        return null;
    }

    @Override
    public void setSmoother(Smoother smoother) {
        this.smoother = smoother;
    }

    @Override
    public double getPruningThreshold() {
        return this.threshold;
    }

    @Override
    public double[] scoreSignature(StateSet stateSet, int tag) {
        return null;
    }

    @Override
    public double[] scoreWord(StateSet stateSet, int tag) {
        return null;
    }

    public void labelTrees(StateSetTreeList trainTrees) {
        for (Tree<StateSet> tree : trainTrees) {
            List<StateSet> words = tree.getYield();
            for (StateSet word : words) {
                word.wordIndex = this.wordIndexer.indexOf(word.getWord());
                word.sigIndex = -1;
            }
        }
    }

    @Override
    public void explicitlyComputeScores(int finalLevel) {
    }

    @Override
    public Counter<String> getWordCounter() {
        return null;
    }

    @Override
    public void tieRareWordStats(int threshold) {
    }

    public class IntegerIndexer
    implements Serializable {
        private int[] indexTo;
        private int[] indexFrom;
        private int n;

        IntegerIndexer(int capacity) {
            this.indexTo = new int[capacity];
            this.indexFrom = new int[capacity];
            Arrays.fill(this.indexTo, -1);
            Arrays.fill(this.indexFrom, -1);
            this.n = 0;
        }

        public void add(int i) {
            if (i == -1) {
                return;
            }
            if (this.indexTo[i] == -1) {
                this.indexTo[i] = this.n;
                this.indexFrom[this.n] = i;
                ++this.n;
            }
        }

        public int get(int i) {
            if (i < this.indexFrom.length) {
                return this.indexFrom[i];
            }
            return -1;
        }

        public int indexOf(int i) {
            if (i < this.indexTo.length) {
                return this.indexTo[i];
            }
            return -1;
        }

        public int size() {
            return this.n;
        }

        public IntegerIndexer copy() {
            IntegerIndexer copy = new IntegerIndexer(this.indexFrom.length);
            copy.n = this.n;
            copy.indexFrom = (int[])this.indexFrom.clone();
            copy.indexTo = (int[])this.indexTo.clone();
            return copy;
        }
    }
}

