/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SophisticatedLexicon
implements Serializable,
Lexicon {
    HashMap<String, double[]>[] wordToTagCounters = null;
    HashMap<String, double[]>[] unseenWordToTagCounters = null;
    double totalWordTypes = 0.0;
    double totalTokens = 0.0;
    double totalUnseenTokens = 0.0;
    double totalWords = 0.0;
    double[][] typeTagCounter;
    double[][] tagCounter;
    double[][] unseenTagCounter;
    double[] simpleTagCounter;
    Set<Short> allTags = new HashSet<Short>();
    Counter<String> wordCounter = new Counter();
    private static final long serialVersionUID = 2L;
    short[] numSubStates;
    int smoothingCutoff;
    public static int DEFAULT_SMOOTHING_CUTOFF = 10;
    double addXSmoothing = 1.0;
    Smoother smoother;
    double threshold;
    boolean isConditional;
    double[][][] conditionalWeights;
    Numberer wordNumberer;
    protected transient String lastSignature = "";
    protected transient int lastSentencePosition = -1;
    protected transient String lastWordToSignaturize = "";
    private int unknownLevel = 5;
    public static int openClassTypesThreshold = 50;
    public static double fractionBeforeUnseenCounting = 0.5;
    protected static final int nullWord = -1;
    protected static final short nullTag = -1;
    double smoothInUnknownsThreshold = 100.0;
    double[] smooth = null;
    boolean logarithmMode = false;

    public Set<Short> getAllTags() {
        return this.allTags;
    }

    public boolean isKnown(String word) {
        return this.wordCounter.keySet().contains(word);
    }

    public void writeData(Writer w) throws IOException {
        double prob;
        int substate;
        String tagState;
        PrintWriter out = new PrintWriter(w);
        Numberer n = Numberer.getGlobalNumberer("tags");
        out.print("WORD-COUNTER (c_W):\n");
        PriorityQueue<String> pq = this.wordCounter.asPriorityQueue();
        while (pq.hasNext()) {
            int priority = (int)Math.round(pq.getPriority());
            String element = pq.next();
            out.print(String.valueOf(element) + " " + priority + "\n");
        }
        out.print("--------------------------------------------------\n");
        out.print("TAG-COUNTER (c_T):\n");
        int state = 0;
        while (state < this.tagCounter.length) {
            tagState = (String)n.object(state);
            substate = 0;
            while (substate < this.tagCounter[state].length) {
                prob = this.tagCounter[state][substate];
                if (prob != 0.0) {
                    out.print(String.valueOf(tagState) + "_" + substate + " " + prob + "\n");
                }
                ++substate;
            }
            ++state;
        }
        out.print("--------------------------------------------------\n");
        out.print("UNSEEN-TAG-COUNTER (c_T):\n");
        state = 0;
        while (state < this.unseenTagCounter.length) {
            tagState = (String)n.object(state);
            substate = 0;
            while (substate < this.unseenTagCounter[state].length) {
                prob = this.unseenTagCounter[state][substate];
                if (prob != 0.0) {
                    out.print(String.valueOf(tagState) + "_" + substate + " " + prob + "\n");
                }
                ++substate;
            }
            ++state;
        }
        out.print("--------------------------------------------------\n");
        out.print("TAG-AND-WORD-COUNTER (c_TW):\n");
        int tag = 0;
        while (tag < this.wordToTagCounters.length) {
            if (this.wordToTagCounters[tag] != null) {
                tagState = (String)n.object(tag);
                for (String word : this.wordToTagCounters[tag].keySet()) {
                    out.print(String.valueOf(tagState) + " " + word + " " + Arrays.toString(this.wordToTagCounters[tag].get(word)) + "\n");
                }
            }
            ++tag;
        }
        out.print("--------------------------------------------------\n");
        out.print("UNSEEN-TAG-AND-SIGNATURE-COUNTER (c_TW):\n");
        tag = 0;
        while (tag < this.unseenWordToTagCounters.length) {
            if (this.unseenWordToTagCounters[tag] != null) {
                tagState = (String)n.object(tag);
                for (String word : this.unseenWordToTagCounters[tag].keySet()) {
                    out.print(String.valueOf(tagState) + " " + word + " " + Arrays.toString(this.unseenWordToTagCounters[tag].get(word)) + "\n");
                }
            }
            ++tag;
        }
        out.flush();
    }

    public String toString() {
        Numberer n = Numberer.getGlobalNumberer("tags");
        StringBuilder sb = new StringBuilder();
        int tag = 0;
        while (tag < this.wordToTagCounters.length) {
            double[] scores;
            String tagState = (String)n.object(tag);
            if (this.wordToTagCounters[tag] != null) {
                for (String word : this.wordToTagCounters[tag].keySet()) {
                    scores = this.score(word, (short)tag, 0, false, false);
                    sb.append(String.valueOf(tagState) + " " + word + " " + Arrays.toString(scores) + "\n");
                }
            }
            if (this.unseenWordToTagCounters[tag] != null) {
                for (String word : this.unseenWordToTagCounters[tag].keySet()) {
                    scores = this.score(word, (short)tag, 0, false, true);
                    sb.append(String.valueOf(tagState) + " " + word + " " + Arrays.toString(scores) + "\n");
                }
            }
            ++tag;
        }
        return sb.toString();
    }

    public String toString_old() {
        String s = "";
        for (String w : this.wordCounter.keySet()) {
            s = String.valueOf(s) + w + "\n";
        }
        String t = "";
        return String.valueOf(s) + ArrayUtil.toString(this.tagCounter) + "\n" + t;
    }

    public void newMstep() {
    }

    public double[] score2(String word, short tag, int loc, boolean noSmoothing) {
        if (this.wordToTagCounters[tag] == null) {
            return new double[this.numSubStates[tag]];
        }
        double[] resultArray = new double[this.numSubStates[tag]];
        double cW = this.wordCounter.getCount(word);
        if (cW > 0.0) {
            if (this.wordToTagCounters[tag] != null && (resultArray = this.wordToTagCounters[tag].get(word)) != null) {
                return resultArray;
            }
            return new double[this.numSubStates[tag]];
        }
        String sig = this.getCachedSignature(word, loc);
        resultArray = this.wordToTagCounters[tag].get(sig);
        if (resultArray != null) {
            return resultArray;
        }
        return new double[this.numSubStates[tag]];
    }

    @Override
    public void optimize() {
        short i = 0;
        while (i < this.wordToTagCounters.length) {
            if (this.wordToTagCounters[i] != null) {
                this.allTags.add(i);
            }
            i = (short)(i + 1);
        }
        this.removeUnlikelyTags(this.threshold, -1.0);
    }

    public SophisticatedLexicon(short[] numSubStates, int smoothingCutoff, double[] smoothParam, Smoother smoother, double threshold) {
        this.numSubStates = numSubStates;
        this.smoothingCutoff = smoothingCutoff;
        this.smooth = smoothParam;
        this.smoother = smoother;
        this.wordToTagCounters = new HashMap[numSubStates.length];
        this.unseenWordToTagCounters = new HashMap[numSubStates.length];
        this.tagCounter = new double[numSubStates.length][];
        this.unseenTagCounter = new double[numSubStates.length][];
        this.typeTagCounter = new double[numSubStates.length][];
        this.simpleTagCounter = new double[numSubStates.length];
        int i = 0;
        while (i < numSubStates.length) {
            this.tagCounter[i] = new double[numSubStates[i]];
            this.unseenTagCounter[i] = new double[numSubStates[i]];
            this.typeTagCounter[i] = new double[numSubStates[i]];
            ++i;
        }
        this.threshold = threshold;
        this.wordNumberer = Numberer.getGlobalNumberer("words");
        if (Corpus.myTreebank != Corpus.TreeBankType.WSJ && Corpus.myTreebank != Corpus.TreeBankType.BROWN && Corpus.myTreebank != Corpus.TreeBankType.SINGLEFILE) {
            this.unknownLevel = 4;
        }
    }

    public void printTagCounter(Numberer tagNumberer) {
        PriorityQueue<String> pq = new PriorityQueue<String>(this.tagCounter.length);
        int i = 0;
        while (i < this.tagCounter.length) {
            pq.add((String)tagNumberer.object(i), this.tagCounter[i][0]);
            ++i;
        }
        i = 0;
        while (pq.hasNext()) {
            int p = (int)pq.getPriority();
            System.out.println(String.valueOf(++i) + ". " + (String)pq.next() + "\t " + p);
        }
    }

    @Override
    public SophisticatedLexicon splitAllStates(int[] counts, boolean moreSubstatesThanCounts, int mode) {
        int i;
        int splitFactor;
        int substate;
        short[] newNumSubStates = new short[this.numSubStates.length];
        newNumSubStates[0] = 1;
        int i2 = 1;
        while (i2 < this.numSubStates.length) {
            newNumSubStates[i2] = (short)(this.numSubStates[i2] * 2);
            i2 = (short)(i2 + 1);
        }
        SophisticatedLexicon lexicon = new SophisticatedLexicon(newNumSubStates, this.smoothingCutoff, this.smooth, this.smoother, this.threshold);
        lexicon.wordToTagCounters = new HashMap[this.numSubStates.length];
        lexicon.unseenWordToTagCounters = new HashMap[this.numSubStates.length];
        int tag = 0;
        while (tag < this.wordToTagCounters.length) {
            if (this.wordToTagCounters[tag] != null) {
                lexicon.wordToTagCounters[tag] = new HashMap();
                for (String word : this.wordToTagCounters[tag].keySet()) {
                    lexicon.wordToTagCounters[tag].put(word, new double[newNumSubStates[tag]]);
                    substate = 0;
                    while (substate < this.wordToTagCounters[tag].get(word).length) {
                        splitFactor = 2;
                        if (newNumSubStates[tag] == this.numSubStates[tag]) {
                            splitFactor = 1;
                        }
                        i = 0;
                        while (i < splitFactor) {
                            lexicon.wordToTagCounters[tag].get((Object)word)[substate * splitFactor + i] = (double)(1.0f / (float)splitFactor) * this.wordToTagCounters[tag].get(word)[substate];
                            ++i;
                        }
                        ++substate;
                    }
                }
            }
            ++tag;
        }
        tag = 0;
        while (tag < this.unseenWordToTagCounters.length) {
            if (this.unseenWordToTagCounters[tag] != null) {
                lexicon.unseenWordToTagCounters[tag] = new HashMap();
                for (String word : this.unseenWordToTagCounters[tag].keySet()) {
                    lexicon.unseenWordToTagCounters[tag].put(word, new double[newNumSubStates[tag]]);
                    substate = 0;
                    while (substate < this.unseenWordToTagCounters[tag].get(word).length) {
                        splitFactor = 2;
                        if (newNumSubStates[tag] == this.numSubStates[tag]) {
                            splitFactor = 1;
                        }
                        i = 0;
                        while (i < splitFactor) {
                            lexicon.unseenWordToTagCounters[tag].get((Object)word)[substate * splitFactor + i] = (double)(1.0f / (float)splitFactor) * this.unseenWordToTagCounters[tag].get(word)[substate];
                            ++i;
                        }
                        ++substate;
                    }
                }
            }
            ++tag;
        }
        lexicon.totalWordTypes = this.totalWordTypes;
        lexicon.totalTokens = this.totalTokens;
        lexicon.totalUnseenTokens = this.totalUnseenTokens;
        lexicon.totalWords = this.totalWords;
        lexicon.smoother = this.smoother;
        lexicon.typeTagCounter = new double[this.typeTagCounter.length][];
        lexicon.tagCounter = new double[this.tagCounter.length][];
        lexicon.unseenTagCounter = new double[this.unseenTagCounter.length][];
        lexicon.simpleTagCounter = new double[this.tagCounter.length];
        tag = 0;
        while (tag < this.typeTagCounter.length) {
            lexicon.typeTagCounter[tag] = new double[newNumSubStates[tag]];
            lexicon.tagCounter[tag] = new double[newNumSubStates[tag]];
            lexicon.unseenTagCounter[tag] = new double[newNumSubStates[tag]];
            lexicon.simpleTagCounter[tag] = this.simpleTagCounter[tag];
            int substate2 = 0;
            while (substate2 < this.typeTagCounter[tag].length) {
                int splitFactor2 = 2;
                if (newNumSubStates[tag] == this.numSubStates[tag]) {
                    splitFactor2 = 1;
                }
                int i3 = 0;
                while (i3 < splitFactor2) {
                    lexicon.typeTagCounter[tag][substate2 * splitFactor2 + i3] = (double)(1.0f / (float)splitFactor2) * this.typeTagCounter[tag][substate2];
                    lexicon.tagCounter[tag][substate2 * splitFactor2 + i3] = (double)(1.0f / (float)splitFactor2) * this.tagCounter[tag][substate2];
                    lexicon.unseenTagCounter[tag][substate2 * splitFactor2 + i3] = (double)(1.0f / (float)splitFactor2) * this.unseenTagCounter[tag][substate2];
                    ++i3;
                }
                ++substate2;
            }
            ++tag;
        }
        lexicon.allTags = new HashSet<Short>(this.allTags);
        lexicon.wordCounter = new Counter();
        for (String word : this.wordCounter.keySet()) {
            lexicon.wordCounter.setCount(word, this.wordCounter.getCount(word));
        }
        lexicon.smoothingCutoff = this.smoothingCutoff;
        lexicon.addXSmoothing = this.addXSmoothing;
        lexicon.smoothInUnknownsThreshold = this.smoothInUnknownsThreshold;
        lexicon.wordNumberer = this.wordNumberer;
        return lexicon;
    }

    @Override
    public String getSignature(String word, int loc) {
        StringBuffer sb = new StringBuffer("UNK");
        if (word.length() == 0) {
            return sb.toString();
        }
        switch (this.unknownLevel) {
            case 5: {
                int wlen = word.length();
                int numCaps = 0;
                boolean hasDigit = false;
                boolean hasDash = false;
                boolean hasLower = false;
                int i = 0;
                while (i < wlen) {
                    char ch = word.charAt(i);
                    if (Character.isDigit(ch)) {
                        hasDigit = true;
                    } else if (ch == '-') {
                        hasDash = true;
                    } else if (Character.isLetter(ch)) {
                        if (Character.isLowerCase(ch)) {
                            hasLower = true;
                        } else if (Character.isTitleCase(ch)) {
                            hasLower = true;
                            ++numCaps;
                        } else {
                            ++numCaps;
                        }
                    }
                    ++i;
                }
                char ch0 = word.charAt(0);
                String lowered = word.toLowerCase();
                if (Character.isUpperCase(ch0) || Character.isTitleCase(ch0)) {
                    if (loc == 0 && numCaps == 1) {
                        sb.append("-INITC");
                        if (this.isKnown(lowered)) {
                            sb.append("-KNOWNLC");
                        }
                    } else {
                        sb.append("-CAPS");
                    }
                } else if (!Character.isLetter(ch0) && numCaps > 0) {
                    sb.append("-CAPS");
                } else if (hasLower) {
                    sb.append("-LC");
                }
                if (hasDigit) {
                    sb.append("-NUM");
                }
                if (hasDash) {
                    sb.append("-DASH");
                }
                if (lowered.endsWith("s") && wlen >= 3) {
                    char ch2 = lowered.charAt(wlen - 2);
                    if (ch2 == 's' || ch2 == 'i' || ch2 == 'u') break;
                    sb.append("-s");
                    break;
                }
                if (word.length() < 5 || hasDash || hasDigit && numCaps > 0) break;
                if (lowered.endsWith("ed")) {
                    sb.append("-ed");
                    break;
                }
                if (lowered.endsWith("ing")) {
                    sb.append("-ing");
                    break;
                }
                if (lowered.endsWith("ion")) {
                    sb.append("-ion");
                    break;
                }
                if (lowered.endsWith("er")) {
                    sb.append("-er");
                    break;
                }
                if (lowered.endsWith("est")) {
                    sb.append("-est");
                    break;
                }
                if (lowered.endsWith("ly")) {
                    sb.append("-ly");
                    break;
                }
                if (lowered.endsWith("ity")) {
                    sb.append("-ity");
                    break;
                }
                if (lowered.endsWith("y")) {
                    sb.append("-y");
                    break;
                }
                if (!lowered.endsWith("al")) break;
                sb.append("-al");
                break;
            }
            case 4: {
                char ch;
                boolean hasDigit = false;
                boolean hasNonDigit = false;
                boolean hasLetter = false;
                boolean hasLower = false;
                boolean hasDash = false;
                boolean hasPeriod = false;
                boolean hasComma = false;
                int i = 0;
                while (i < word.length()) {
                    char ch2 = word.charAt(i);
                    if (Character.isDigit(ch2)) {
                        hasDigit = true;
                    } else {
                        hasNonDigit = true;
                        if (Character.isLetter(ch2)) {
                            hasLetter = true;
                            if (Character.isLowerCase(ch2) || Character.isTitleCase(ch2)) {
                                hasLower = true;
                            }
                        } else if (ch2 == '-') {
                            hasDash = true;
                        } else if (ch2 == '.') {
                            hasPeriod = true;
                        } else if (ch2 == ',') {
                            hasComma = true;
                        }
                    }
                    ++i;
                }
                if (Character.isUpperCase(word.charAt(0)) || Character.isTitleCase(word.charAt(0))) {
                    if (!hasLower) {
                        sb.append("-AC");
                    } else if (loc == 0) {
                        sb.append("-SC");
                    } else {
                        sb.append("-C");
                    }
                } else if (hasLower) {
                    sb.append("-L");
                } else if (hasLetter) {
                    sb.append("-U");
                } else {
                    sb.append("-S");
                }
                if (hasDigit && !hasNonDigit) {
                    sb.append("-N");
                } else if (hasDigit) {
                    sb.append("-n");
                }
                if (hasDash) {
                    sb.append("-H");
                }
                if (hasPeriod) {
                    sb.append("-P");
                }
                if (hasComma) {
                    sb.append("-C");
                }
                if (word.length() <= 3 || !Character.isLetter(ch = word.charAt(word.length() - 1))) break;
                sb.append("-");
                sb.append(Character.toLowerCase(ch));
                break;
            }
            case 3: {
                sb.append("-");
                int lastClass = 45;
                int num = 0;
                int i = 0;
                while (i < word.length()) {
                    char ch = word.charAt(i);
                    int newClass = Character.isUpperCase(ch) || Character.isTitleCase(ch) ? (loc == 0 ? 83 : 76) : (Character.isLetter(ch) ? 108 : (Character.isDigit(ch) ? 100 : (ch == '-' ? 104 : (ch == '.' ? 112 : 115))));
                    if (newClass != lastClass) {
                        lastClass = newClass;
                        sb.append((char)lastClass);
                        num = 1;
                    } else {
                        if (num < 2) {
                            sb.append('+');
                        }
                        ++num;
                    }
                    ++i;
                }
                if (word.length() <= 3) break;
                char ch = Character.toLowerCase(word.charAt(word.length() - 1));
                sb.append('-');
                sb.append(ch);
                break;
            }
            case 2: {
                boolean hasDigit = false;
                boolean hasNonDigit = false;
                boolean hasLower = false;
                int i = 0;
                while (i < word.length()) {
                    char ch = word.charAt(i);
                    if (Character.isDigit(ch)) {
                        hasDigit = true;
                    } else {
                        hasNonDigit = true;
                        if (Character.isLetter(ch) && (Character.isLowerCase(ch) || Character.isTitleCase(ch))) {
                            hasLower = true;
                        }
                    }
                    ++i;
                }
                if (Character.isUpperCase(word.charAt(0)) || Character.isTitleCase(word.charAt(0))) {
                    if (!hasLower) {
                        sb.append("-ALLC");
                    } else if (loc == 0) {
                        sb.append("-INIT");
                    } else {
                        sb.append("-UC");
                    }
                } else if (hasLower) {
                    sb.append("-LC");
                }
                if (word.indexOf(45) >= 0) {
                    sb.append("-DASH");
                }
                if (hasDigit) {
                    if (!hasNonDigit) {
                        sb.append("-NUM");
                        break;
                    }
                    sb.append("-DIG");
                    break;
                }
                if (word.length() <= 3) break;
                char ch = word.charAt(word.length() - 1);
                sb.append(Character.toLowerCase(ch));
                break;
            }
            default: {
                sb.append("-");
                sb.append(word.substring(Math.max(word.length() - 2, 0), word.length()));
                sb.append("-");
                if (Character.isLowerCase(word.charAt(0))) {
                    sb.append("LOWER");
                    break;
                }
                if (Character.isUpperCase(word.charAt(0))) {
                    if (loc == 0) {
                        sb.append("INIT");
                        break;
                    }
                    sb.append("UPPER");
                    break;
                }
                sb.append("OTHER");
            }
        }
        return sb.toString();
    }

    @Override
    public double[] score(StateSet stateSet, short tag, boolean noSmoothing, boolean isSignature) {
        return this.score(stateSet.getWord(), tag, stateSet.from, noSmoothing, isSignature);
    }

    @Override
    public double[] score(String word, short tag, int loc, boolean noSmoothing, boolean isSignature) {
        if (this.isConditional) {
            return this.scoreConditional(word, tag, loc, noSmoothing, isSignature);
        }
        double c_W = this.wordCounter.getCount(word);
        double pb_W_T = 0.0;
        double[] resultArray = new double[this.numSubStates[tag]];
        int substate = 0;
        while (substate < this.numSubStates[tag]) {
            block13: {
                block14: {
                    block12: {
                        double p_T_U;
                        boolean seen;
                        boolean bl = seen = c_W > 0.0;
                        if (isSignature || !seen && !noSmoothing) break block12;
                        double c_tag = this.tagCounter[tag][substate];
                        double c_T = c_tag;
                        if (c_T == 0.0) break block13;
                        double c_TW = 0.0;
                        if (this.wordToTagCounters[tag] != null && this.wordToTagCounters[tag].get(word) != null) {
                            c_TW = this.wordToTagCounters[tag].get(word)[substate];
                        }
                        double c_Tunseen = this.unseenTagCounter[tag][substate];
                        double total = this.totalTokens;
                        double totalUnseen = this.totalUnseenTokens;
                        double d = p_T_U = totalUnseen == 0.0 ? 1.0 : c_Tunseen / totalUnseen;
                        double pb_T_W = c_W > this.smoothInUnknownsThreshold || noSmoothing ? (noSmoothing && c_W == 0.0 ? c_TW / 1.0 : (c_TW + 1.0E-4 * p_T_U) / (c_W + 1.0E-4)) : (c_TW + this.smooth[1] * p_T_U) / (c_W + this.smooth[1]);
                        if (pb_T_W == 0.0) break block13;
                        double p_T = c_T / total;
                        double p_W = c_W / total;
                        pb_W_T = pb_T_W * p_W / p_T;
                        break block14;
                    }
                    if (Corpus.myTreebank == Corpus.TreeBankType.CHINESE) {
                        double prob;
                        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
                        if (word.matches(".*[\u5e74\u6708\u65e5\u53f7]$")) {
                            prob = tag == tagNumberer.number("NT") ? 1.0 : 0.0;
                            Arrays.fill(resultArray, prob);
                            return resultArray;
                        }
                        if (word.matches(".*[\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff11\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u4ebf].*")) {
                            prob = tag == tagNumberer.number("CD") && !word.matches("^\u7b2c.*") ? 1.0 : (tag == tagNumberer.number("OD") && word.matches("^\u7b2c.*") ? 1.0 : 0.0);
                            Arrays.fill(resultArray, prob);
                            return resultArray;
                        }
                        if (word.matches(".*\u00b7.*")) {
                            prob = tag == tagNumberer.number("NR") ? 1.0 : 0.0;
                            Arrays.fill(resultArray, prob);
                            return resultArray;
                        }
                    }
                    String sig = isSignature ? word : this.getCachedSignature(word, loc);
                    double c_TS = 0.0;
                    if (this.unseenWordToTagCounters[tag] != null && this.unseenWordToTagCounters[tag].get(sig) != null) {
                        c_TS = this.unseenWordToTagCounters[tag].get(sig)[substate];
                    }
                    double c_S = this.wordCounter.getCount(sig);
                    double c_U = this.totalUnseenTokens;
                    double total = this.totalTokens;
                    double c_T = this.unseenTagCounter[tag][substate];
                    double c_Tseen = this.tagCounter[tag][substate];
                    double p_T_U = c_T / c_U;
                    if (this.unknownLevel == 0) {
                        c_TS = 0.0;
                        c_S = 0.0;
                    }
                    double pb_T_S = (c_TS + this.smooth[0] * p_T_U) / (c_S + this.smooth[0]);
                    double p_T = c_Tseen / total;
                    double p_W = 1.0 / total;
                    pb_W_T = pb_T_S * p_W / p_T;
                }
                resultArray[substate] = pb_W_T == 0.0 ? 1.0E-87 : pb_W_T;
            }
            ++substate;
        }
        this.smoother.smooth(tag, resultArray);
        if (this.logarithmMode) {
            int i = 0;
            while (i < resultArray.length) {
                resultArray[i] = Math.log(resultArray[i]);
                if (Double.isNaN(resultArray[i])) {
                    resultArray[i] = Double.NEGATIVE_INFINITY;
                }
                ++i;
            }
        }
        return resultArray;
    }

    @Override
    public Counter<String> getWordCounter() {
        return this.wordCounter;
    }

    @Override
    public void tieRareWordStats(int threshold) {
        int ni = 0;
        while (ni < this.numSubStates.length) {
            double unseenTagTokens = 0.0;
            int si = 0;
            while (si < this.numSubStates[ni]) {
                unseenTagTokens += this.unseenTagCounter[ni][si];
                ++si;
            }
            if (unseenTagTokens != 0.0) {
                for (Map.Entry<String, double[]> wordToTagEntry : this.wordToTagCounters[ni].entrySet()) {
                    String word = wordToTagEntry.getKey();
                    double[] substateCounter = wordToTagEntry.getValue();
                    if (!(this.wordCounter.getCount(word) < (double)threshold + 0.5)) continue;
                    double wordTagTokens = 0.0;
                    int si2 = 0;
                    while (si2 < this.numSubStates[ni]) {
                        wordTagTokens += substateCounter[si2];
                        ++si2;
                    }
                    si2 = 0;
                    while (si2 < this.numSubStates[ni]) {
                        substateCounter[si2] = this.unseenTagCounter[ni][si2] * wordTagTokens / unseenTagTokens;
                        ++si2;
                    }
                }
            }
            ++ni;
        }
    }

    @Override
    public void trainTree(Tree<StateSet> trainTree, double randomness, Lexicon oldLexicon, boolean secondHalf, boolean noSmoothing, int threshold) {
        double sentenceScore = 0.0;
        if (randomness == -1.0 && (sentenceScore = trainTree.getLabel().getIScore(0)) == 0.0) {
            System.out.println("Something is wrong with this tree. I will skip it.");
            return;
        }
        int sentenceScale = trainTree.getLabel().getIScale();
        List<StateSet> words = trainTree.getYield();
        List<StateSet> tags = trainTree.getPreTerminalYield();
        if (words.size() != tags.size()) {
            System.out.println("Yield an preterminal yield do not match!");
            System.out.println(words.toString());
            System.out.println(tags.toString());
        }
        Counter<String> oldWordCounter = null;
        if (oldLexicon != null) {
            oldWordCounter = oldLexicon.getWordCounter();
        }
        int position = 0;
        while (position < words.size()) {
            double[] substateCounter;
            double[] substateCounter2;
            this.totalWords += 1.0;
            String word = words.get(position).getWord();
            int nSubStates = tags.get(position).numSubStates();
            short tag = tags.get(position).getState();
            String sig = this.getCachedSignature(word, position);
            this.wordCounter.incrementCount(sig, 0.0);
            if (this.unseenWordToTagCounters[tag] == null) {
                this.unseenWordToTagCounters[tag] = new HashMap();
            }
            if ((substateCounter2 = this.unseenWordToTagCounters[tag].get(sig)) == null) {
                substateCounter2 = new double[this.numSubStates[tag]];
                this.unseenWordToTagCounters[tag].put(sig, substateCounter2);
            }
            if (this.wordToTagCounters[tag] == null) {
                this.wordToTagCounters[tag] = new HashMap();
            }
            if ((substateCounter = this.wordToTagCounters[tag].get(word)) == null) {
                substateCounter = new double[this.numSubStates[tag]];
                this.wordToTagCounters[tag].put(word, substateCounter);
            }
            double[] oldLexiconScores = null;
            if (randomness == -1.0) {
                oldLexiconScores = oldLexicon.score(word, tag, position, noSmoothing, false);
            }
            StateSet currentState = tags.get(position);
            double scale = ScalingTools.calcScaleFactor(currentState.getOScale() - sentenceScale) / sentenceScore;
            int substate = 0;
            while (substate < nSubStates) {
                double weight = 1.0;
                weight = randomness == -1.0 ? (!Double.isInfinite(scale) ? currentState.getOScore(substate) * oldLexiconScores[substate] * scale : Math.exp(Math.log(ScalingTools.SCALE) * (double)(currentState.getOScale() - sentenceScale) - Math.log(sentenceScore) + Math.log(currentState.getOScore(substate)) + Math.log(oldLexiconScores[substate]))) : (randomness == 0.0 ? 1.0 : GrammarTrainer.RANDOM.nextDouble() * randomness / 100.0 + 1.0);
                if (weight != 0.0) {
                    int n = substate;
                    substateCounter[n] = substateCounter[n] + weight;
                    double[] dArray = this.tagCounter[tag];
                    int n2 = substate;
                    dArray[n2] = dArray[n2] + weight;
                    this.wordCounter.incrementCount(word, weight);
                    this.totalTokens += weight;
                    if (Double.isNaN(this.totalTokens)) {
                        throw new Error("totalTokens is NaN: this would fail if we let it continue!");
                    }
                    if (oldLexicon != null && oldWordCounter.getCount(word) < (double)threshold + 0.5) {
                        this.wordCounter.incrementCount(sig, weight);
                        int n3 = substate;
                        substateCounter2[n3] = substateCounter2[n3] + weight;
                        double[] dArray2 = this.unseenTagCounter[tag];
                        int n4 = substate;
                        dArray2[n4] = dArray2[n4] + weight;
                        this.totalUnseenTokens += weight;
                    }
                }
                substate = (short)(substate + 1);
            }
            ++position;
        }
    }

    protected String getCachedSignature(String word, int sentencePosition) {
        String uwSig;
        if (word == null) {
            return this.lastWordToSignaturize;
        }
        if (word.equals(this.lastWordToSignaturize) && sentencePosition == this.lastSentencePosition) {
            return this.lastSignature;
        }
        this.lastSignature = uwSig = this.getSignature(word, sentencePosition);
        this.lastSentencePosition = sentencePosition;
        this.lastWordToSignaturize = word;
        return uwSig;
    }

    @Override
    public void mergeStates(boolean[][][] mergeThesePairs, double[][] mergeWeights) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        short[][] mapping = new short[this.numSubStates.length][];
        short[][][] partners = new short[this.numSubStates.length][][];
        Grammar.calculateMergeArrays(mergeThesePairs, newNumSubStates, mapping, partners, this.numSubStates);
        int tag = 0;
        while (tag < mergeThesePairs.length) {
            if (this.wordToTagCounters[tag] != null) {
                for (String word : this.wordToTagCounters[tag].keySet()) {
                    double[] scores = this.wordToTagCounters[tag].get(word);
                    double[] newScores = new double[newNumSubStates[tag]];
                    int i = 0;
                    while (i < this.numSubStates[tag]) {
                        short nSplit = (short)partners[tag][i].length;
                        newScores[mapping[tag][i]] = nSplit == 2 ? scores[partners[tag][i][0]] + scores[partners[tag][i][1]] : scores[i];
                        ++i;
                    }
                    this.wordToTagCounters[tag].put(word, newScores);
                }
            }
            double[] newTagCounter = new double[newNumSubStates[tag]];
            int i = 0;
            while (i < this.numSubStates[tag]) {
                newTagCounter[mapping[tag][i]] = partners[tag][i].length == 2 ? this.tagCounter[tag][partners[tag][i][0]] + this.tagCounter[tag][partners[tag][i][1]] : this.tagCounter[tag][i];
                ++i;
            }
            this.tagCounter[tag] = newTagCounter;
            ++tag;
        }
        this.numSubStates = newNumSubStates;
    }

    public Map<String, double[][]> getUnseenScores() {
        HashMap<String, double[][]> map = new HashMap<String, double[][]>();
        int tag = 0;
        while (tag < this.unseenWordToTagCounters.length) {
            if (this.unseenWordToTagCounters[tag] != null) {
                for (String sig : this.unseenWordToTagCounters[tag].keySet()) {
                    Object sigScores = (double[][])map.get(sig);
                    if (sigScores == null) {
                        sigScores = new double[this.numSubStates.length][];
                        map.put(sig, (double[][])sigScores);
                    }
                    sigScores[tag] = new double[this.numSubStates[tag]];
                    int substate = 0;
                    while (substate < this.numSubStates[tag]) {
                        double pb_W_T;
                        double c_TS = 0.0;
                        if (this.unseenWordToTagCounters[tag].get(sig) != null) {
                            c_TS = this.unseenWordToTagCounters[tag].get(sig)[substate];
                        }
                        double c_S = this.wordCounter.getCount(sig);
                        double c_U = this.totalUnseenTokens;
                        double total = this.totalTokens;
                        double c_T = this.unseenTagCounter[tag][substate];
                        double c_Tseen = this.tagCounter[tag][substate];
                        double p_T_U = c_T / c_U;
                        if (this.unknownLevel == 0) {
                            c_TS = 0.0;
                            c_S = 0.0;
                        }
                        double pb_T_S = (c_TS + this.smooth[0] * p_T_U) / (c_S + this.smooth[0]);
                        double p_T = c_Tseen / total;
                        double p_W = 1.0 / total;
                        sigScores[tag][substate] = p_T == 0.0 ? 1.0 : (pb_W_T = pb_T_S * p_W / p_T);
                        ++substate;
                    }
                }
            }
            ++tag;
        }
        return map;
    }

    @Override
    public void removeUnlikelyTags(double threshold, double exponent) {
        if (this.isLogarithmMode()) {
            threshold = Math.log(threshold);
        }
        int removed = 0;
        int total = 0;
        if (this.isConditional) {
            int i = 0;
            while (i < this.conditionalWeights.length) {
                int j = 0;
                while (j < this.conditionalWeights[i].length) {
                    if (this.conditionalWeights[i][j] != null) {
                        int k = 0;
                        while (k < this.conditionalWeights[i][j].length) {
                            ++total;
                            if (this.conditionalWeights[i][j][k] < threshold) {
                                this.conditionalWeights[i][j][k] = 0.0;
                                ++removed;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int tag = 0;
            while (tag < this.numSubStates.length) {
                if (this.wordToTagCounters[tag] != null) {
                    for (String word : this.wordToTagCounters[tag].keySet()) {
                        double[] c_TW = this.wordToTagCounters[tag].get(word);
                        int substate = 0;
                        while (substate < this.numSubStates[tag]) {
                            ++total;
                            if (c_TW[substate] < threshold) {
                                c_TW[substate] = 0.0;
                                ++removed;
                            }
                            ++substate;
                        }
                    }
                }
                ++tag;
            }
        }
    }

    @Override
    public void logarithmMode() {
        this.logarithmMode = true;
    }

    @Override
    public boolean isLogarithmMode() {
        return this.logarithmMode;
    }

    @Override
    public SophisticatedLexicon projectLexicon(double[] condProbs, int[][] mapping, int[][] toSubstateMapping) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        int state = 0;
        while (state < this.numSubStates.length) {
            newNumSubStates[state] = (short)toSubstateMapping[state][0];
            ++state;
        }
        Smoother newSmoother = this.smoother.copy();
        newSmoother.updateWeights(toSubstateMapping);
        SophisticatedLexicon newLexicon = new SophisticatedLexicon(newNumSubStates, this.smoothingCutoff, this.smooth, newSmoother, this.threshold);
        double[][] newTagCounter = new double[newNumSubStates.length][];
        double[][] newUnseenTagCounter = new double[newNumSubStates.length][];
        if (!this.isConditional) {
            int tag = 0;
            while (tag < this.numSubStates.length) {
                int i;
                double[] newScores;
                double[] scores;
                newTagCounter[tag] = new double[newNumSubStates[tag]];
                newUnseenTagCounter[tag] = new double[newNumSubStates[tag]];
                int substate = 0;
                while (substate < this.numSubStates[tag]) {
                    double[] dArray = newTagCounter[tag];
                    int n = toSubstateMapping[tag][substate + 1];
                    dArray[n] = dArray[n] + condProbs[mapping[tag][substate]] * this.tagCounter[tag][substate];
                    ++substate;
                }
                substate = 0;
                while (substate < this.numSubStates[tag]) {
                    double[] dArray = newUnseenTagCounter[tag];
                    int n = toSubstateMapping[tag][substate + 1];
                    dArray[n] = dArray[n] + condProbs[mapping[tag][substate]] * this.unseenTagCounter[tag][substate];
                    ++substate;
                }
                if (this.wordToTagCounters[tag] != null) {
                    newLexicon.wordToTagCounters[tag] = new HashMap();
                    for (String word : this.wordToTagCounters[tag].keySet()) {
                        scores = this.wordToTagCounters[tag].get(word);
                        newScores = new double[newNumSubStates[tag]];
                        i = 0;
                        while (i < this.numSubStates[tag]) {
                            int n = toSubstateMapping[tag][i + 1];
                            newScores[n] = newScores[n] + condProbs[mapping[tag][i]] * scores[i];
                            ++i;
                        }
                        newLexicon.wordToTagCounters[tag].put(word, newScores);
                    }
                }
                if (this.unseenWordToTagCounters[tag] != null) {
                    newLexicon.unseenWordToTagCounters[tag] = new HashMap();
                    for (String word : this.unseenWordToTagCounters[tag].keySet()) {
                        scores = this.unseenWordToTagCounters[tag].get(word);
                        newScores = new double[newNumSubStates[tag]];
                        i = 0;
                        while (i < this.numSubStates[tag]) {
                            int n = toSubstateMapping[tag][i + 1];
                            newScores[n] = newScores[n] + condProbs[mapping[tag][i]] * scores[i];
                            ++i;
                        }
                        newLexicon.unseenWordToTagCounters[tag].put(word, newScores);
                    }
                }
                ++tag;
            }
        } else {
            double[][][] newCondWeights = new double[this.conditionalWeights.length][this.conditionalWeights[0].length][];
            int w = 0;
            while (w < newCondWeights.length) {
                if (this.conditionalWeights[w] != null) {
                    int tag = 0;
                    while (tag < this.numSubStates.length) {
                        if (this.conditionalWeights[w][tag] != null) {
                            newCondWeights[w][tag] = new double[newNumSubStates[tag]];
                            int substate = 0;
                            while (substate < this.numSubStates[tag]) {
                                double[] dArray = newCondWeights[w][tag];
                                int n = toSubstateMapping[tag][substate + 1];
                                dArray[n] = dArray[n] + condProbs[mapping[tag][substate]] * this.conditionalWeights[w][tag][substate];
                                ++substate;
                            }
                        }
                        ++tag;
                    }
                }
                ++w;
            }
            newLexicon.conditionalWeights = newCondWeights;
            newLexicon.isConditional = true;
        }
        newLexicon.totalWordTypes = this.totalWordTypes;
        newLexicon.totalTokens = this.totalTokens;
        newLexicon.totalUnseenTokens = this.totalUnseenTokens;
        newLexicon.totalWords = this.totalWords;
        newLexicon.allTags = new HashSet<Short>(this.allTags);
        newLexicon.wordCounter = new Counter();
        for (String word : this.wordCounter.keySet()) {
            newLexicon.wordCounter.setCount(word, this.wordCounter.getCount(word));
        }
        newLexicon.smoothingCutoff = this.smoothingCutoff;
        newLexicon.addXSmoothing = this.addXSmoothing;
        newLexicon.smoothInUnknownsThreshold = this.smoothInUnknownsThreshold;
        newLexicon.tagCounter = newTagCounter;
        newLexicon.unseenTagCounter = newUnseenTagCounter;
        newLexicon.numSubStates = newNumSubStates;
        newLexicon.wordNumberer = this.wordNumberer;
        newLexicon.unknownLevel = this.unknownLevel;
        return newLexicon;
    }

    @Override
    public SophisticatedLexicon copyLexicon() {
        short[] newNumSubStates = (short[])this.numSubStates.clone();
        SophisticatedLexicon newLexicon = new SophisticatedLexicon(newNumSubStates, this.smoothingCutoff, this.smooth, this.smoother, this.threshold);
        double[][] newTagCounter = ArrayUtil.copy(this.tagCounter);
        double[][] newUnseenTagCounter = ArrayUtil.copy(this.unseenTagCounter);
        int tag = 0;
        while (tag < this.numSubStates.length) {
            double[] newScores;
            double[] scores;
            if (this.wordToTagCounters[tag] != null) {
                newLexicon.wordToTagCounters[tag] = new HashMap();
                for (String word : this.wordToTagCounters[tag].keySet()) {
                    scores = this.wordToTagCounters[tag].get(word);
                    newScores = (double[])scores.clone();
                    newLexicon.wordToTagCounters[tag].put(word, newScores);
                }
            }
            if (this.unseenWordToTagCounters[tag] != null) {
                newLexicon.unseenWordToTagCounters[tag] = new HashMap();
                for (String word : this.unseenWordToTagCounters[tag].keySet()) {
                    scores = this.unseenWordToTagCounters[tag].get(word);
                    newScores = (double[])scores.clone();
                    newLexicon.unseenWordToTagCounters[tag].put(word, newScores);
                }
            }
            ++tag;
        }
        if (this.conditionalWeights != null) {
            newLexicon.conditionalWeights = (double[][][])this.conditionalWeights.clone();
        }
        newLexicon.isConditional = this.isConditional;
        newLexicon.totalWordTypes = this.totalWordTypes;
        newLexicon.totalTokens = this.totalTokens;
        newLexicon.totalUnseenTokens = this.totalUnseenTokens;
        newLexicon.totalWords = this.totalWords;
        newLexicon.smoother = this.smoother;
        newLexicon.allTags = new HashSet<Short>(this.allTags);
        newLexicon.wordCounter = new Counter();
        for (String word : this.wordCounter.keySet()) {
            newLexicon.wordCounter.setCount(word, this.wordCounter.getCount(word));
        }
        newLexicon.smoothingCutoff = this.smoothingCutoff;
        newLexicon.addXSmoothing = this.addXSmoothing;
        newLexicon.smoothInUnknownsThreshold = this.smoothInUnknownsThreshold;
        newLexicon.tagCounter = newTagCounter;
        newLexicon.unseenTagCounter = newUnseenTagCounter;
        newLexicon.numSubStates = newNumSubStates;
        newLexicon.wordNumberer = this.wordNumberer;
        newLexicon.unknownLevel = this.unknownLevel;
        return newLexicon;
    }

    public int getNumberOfEntries() {
        int nEntries = 0;
        if (this.conditionalWeights == null) {
            for (String word : this.wordCounter.keySet()) {
                this.wordNumberer.number(word);
            }
        }
        int tag = 0;
        while (tag < this.wordToTagCounters.length) {
            if (this.wordToTagCounters[tag] != null) {
                nEntries += this.wordToTagCounters[tag].size() * this.numSubStates[tag];
                if (this.conditionalWeights == null) {
                    for (String word : this.wordToTagCounters[tag].keySet()) {
                        this.wordNumberer.number(word);
                    }
                }
            }
            if (this.unseenWordToTagCounters[tag] != null) {
                nEntries += this.unseenWordToTagCounters[tag].size() * this.numSubStates[tag];
                if (this.conditionalWeights == null) {
                    for (String word : this.unseenWordToTagCounters[tag].keySet()) {
                        this.wordNumberer.number(word);
                    }
                }
            }
            ++tag;
        }
        if (this.conditionalWeights == null) {
            this.conditionalWeights = new double[this.wordNumberer.total()][this.numSubStates.length][];
        }
        return nEntries;
    }

    public void delinearizeLexicon(double[] probs) {
        int ind = 0;
        int tag = 0;
        while (tag < this.wordToTagCounters.length) {
            double val;
            int i;
            double[] scores;
            if (this.wordToTagCounters[tag] != null) {
                for (String word : this.wordToTagCounters[tag].keySet()) {
                    scores = new double[this.numSubStates[tag]];
                    i = 0;
                    while (i < scores.length) {
                        double d = val = (val = probs[ind++]) == -1000.0 ? 0.0 : Math.exp(val);
                        if (SloppyMath.isVeryDangerous(val)) {
                            val = Double.isNaN(probs[ind - 1]) ? 1.0E-50 : probs[ind - 1];
                        }
                        scores[i] = val;
                        ++i;
                    }
                    this.conditionalWeights[this.wordNumberer.number((Object)word)][tag] = scores;
                }
            }
            if (this.unseenWordToTagCounters[tag] != null) {
                for (String word : this.unseenWordToTagCounters[tag].keySet()) {
                    scores = new double[this.numSubStates[tag]];
                    i = 0;
                    while (i < scores.length) {
                        double d = val = (val = probs[ind++]) == -1000.0 ? 0.0 : Math.exp(val);
                        if (SloppyMath.isVeryDangerous(val)) {
                            val = Double.isNaN(probs[ind - 1]) ? 1.0E-50 : probs[ind - 1];
                        }
                        scores[i] = val;
                        ++i;
                    }
                    this.conditionalWeights[this.wordNumberer.number((Object)word)][tag] = scores;
                }
            }
            ++tag;
        }
        this.isConditional = true;
    }

    public void setConditional(boolean b) {
        this.isConditional = b;
    }

    public double[] scoreConditional(String word, short tag, int loc, boolean noSmoothing, boolean isSignature) {
        if (isSignature) {
            return this.getConditionalSignatureScore(word, tag, noSmoothing);
        }
        if (!this.isKnown(word)) {
            return this.getConditionalSignatureScore(this.getCachedSignature(word, loc), tag, noSmoothing);
        }
        double[] resultArray = new double[this.numSubStates[tag]];
        double[] wordScore = this.getConditionalWordScore(word, tag, noSmoothing);
        String sig = this.getCachedSignature(word, loc);
        double[] sigScore = this.getConditionalSignatureScore(sig, tag, noSmoothing);
        int i = 0;
        while (i < resultArray.length) {
            resultArray[i] = wordScore[i] + sigScore[i];
            ++i;
        }
        return resultArray;
    }

    public double[] getConditionalSignatureScore(String sig, short tag, boolean noSmoothing) {
        int i;
        double[] resultArray = new double[this.numSubStates[tag]];
        int ind = this.wordNumberer.number(sig);
        if (ind >= this.conditionalWeights.length) {
            System.out.println(" We have a problem! sig " + sig + " ind " + ind);
            return resultArray;
        }
        double[] tmpArray = this.conditionalWeights[ind][tag];
        if (tmpArray != null) {
            i = 0;
            while (i < resultArray.length) {
                int n = i;
                resultArray[n] = resultArray[n] + tmpArray[i];
                ++i;
            }
        }
        if (this.isLogarithmMode()) {
            i = 0;
            while (i < resultArray.length) {
                resultArray[i] = Math.log(resultArray[i]);
                ++i;
            }
        }
        return resultArray;
    }

    public double[] getConditionalWordScore(String word, short tag, boolean noSmoothing) {
        int i;
        double[] resultArray = new double[this.numSubStates[tag]];
        int ind = this.wordNumberer.number(word);
        double[] tmpArray = this.conditionalWeights[ind][tag];
        if (tmpArray != null) {
            i = 0;
            while (i < resultArray.length) {
                resultArray[i] = tmpArray[i];
                ++i;
            }
        }
        if (this.isLogarithmMode()) {
            i = 0;
            while (i < resultArray.length) {
                resultArray[i] = Math.log(resultArray[i]);
                ++i;
            }
        }
        return resultArray;
    }

    @Override
    public void setSmoother(Smoother smoother) {
        this.smoother = smoother;
    }

    @Override
    public Smoother getSmoother() {
        return this.smoother;
    }

    @Override
    public double[] getSmoothingParams() {
        return this.smooth;
    }

    @Override
    public double getPruningThreshold() {
        return this.threshold;
    }

    public double[] getLinearizedLexicon() {
        return null;
    }

    public int getLinearIndex(String word, int tag) {
        return 0;
    }

    public void clearMapping() {
    }

    @Override
    public double[] scoreSignature(StateSet stateSet, int tag) {
        return null;
    }

    @Override
    public double[] scoreWord(StateSet stateSet, int tag) {
        return null;
    }

    @Override
    public void explicitlyComputeScores(int finalLevel) {
    }

    public SophisticatedLexicon remapStates(Numberer thisNumberer, Numberer newNumberer) {
        SophisticatedLexicon remappedLexicon = this.copyLexicon();
        remappedLexicon.wordToTagCounters = new HashMap[newNumberer.size()];
        remappedLexicon.unseenWordToTagCounters = new HashMap[newNumberer.size()];
        remappedLexicon.typeTagCounter = new double[newNumberer.size()][];
        remappedLexicon.tagCounter = new double[newNumberer.size()][];
        remappedLexicon.unseenTagCounter = new double[newNumberer.size()][];
        remappedLexicon.simpleTagCounter = new double[newNumberer.size()];
        remappedLexicon.allTags = new HashSet<Short>();
        remappedLexicon.numSubStates = new short[newNumberer.size()];
        remappedLexicon.smoother = this.smoother.remapStates(thisNumberer, newNumberer);
        if (this.conditionalWeights != null) {
            int w = 0;
            while (w < this.conditionalWeights.length) {
                remappedLexicon.conditionalWeights[w] = new double[newNumberer.size()][];
                ++w;
            }
        }
        short s = 0;
        while (s < newNumberer.size()) {
            short translatedState = this.translateState(s, newNumberer, thisNumberer);
            if (translatedState >= 0) {
                remappedLexicon.wordToTagCounters[s] = this.wordToTagCounters[translatedState];
                remappedLexicon.unseenWordToTagCounters[s] = this.unseenWordToTagCounters[translatedState];
                remappedLexicon.typeTagCounter[s] = this.typeTagCounter[translatedState];
                remappedLexicon.tagCounter[s] = this.tagCounter[translatedState];
                remappedLexicon.unseenTagCounter[s] = this.unseenTagCounter[translatedState];
                remappedLexicon.simpleTagCounter[s] = this.simpleTagCounter[translatedState];
                if (this.allTags.contains(translatedState)) {
                    remappedLexicon.allTags.add(s);
                }
                remappedLexicon.numSubStates[s] = this.numSubStates[translatedState];
                if (this.conditionalWeights != null) {
                    int w = 0;
                    while (w < this.conditionalWeights[w].length) {
                        remappedLexicon.conditionalWeights[w][s] = this.conditionalWeights[w][translatedState];
                        ++w;
                    }
                }
            } else {
                remappedLexicon.wordToTagCounters[s] = new HashMap();
                remappedLexicon.unseenWordToTagCounters[s] = new HashMap();
                remappedLexicon.typeTagCounter[s] = new double[1];
                remappedLexicon.tagCounter[s] = new double[1];
                remappedLexicon.unseenTagCounter[s] = new double[1];
                remappedLexicon.numSubStates[s] = 1;
            }
            s = (short)(s + 1);
        }
        return remappedLexicon;
    }

    private short translateState(int state, Numberer baseNumberer, Numberer translationNumberer) {
        Object object = baseNumberer.object(state);
        if (translationNumberer.hasSeen(object)) {
            return (short)translationNumberer.number(object);
        }
        return -1;
    }

    class ChineseLexicon
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String encoding = "GB18030";
        public static final String dateMatch = ".*[\u5e74\u6708\u65e5\u53f7]$";
        public static final String numberMatch = ".*[\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff11\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u4ebf].*";
        public static final String ordinalMatch = "^\u7b2c.*";
        public static final String properNameMatch = ".*\u00b7.*";

        ChineseLexicon() {
        }
    }
}

