/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Numberer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateSetTreeList
extends AbstractCollection<Tree<StateSet>> {
    List<Tree<StateSet>> trees = new ArrayList<Tree<StateSet>>();
    static short zero = 0;
    static short one = 1;

    void allocate(Tree<StateSet> tree) {
        tree.getLabel().allocate();
        for (Tree<StateSet> child : tree.getChildren()) {
            this.allocate(child);
        }
    }

    void deallocate(Tree<StateSet> tree) {
        tree.getLabel().deallocate();
        for (Tree<StateSet> child : tree.getChildren()) {
            this.deallocate(child);
        }
    }

    public StateSetTreeList copy() {
        StateSetTreeList copy = new StateSetTreeList();
        for (Tree<StateSet> tree : this.trees) {
            copy.add(this.copyTree(tree));
        }
        return copy;
    }

    private Tree<StateSet> copyTree(Tree<StateSet> tree) {
        ArrayList newChildren = new ArrayList(tree.getChildren().size());
        for (Tree<StateSet> child : tree.getChildren()) {
            newChildren.add(this.copyTree(child));
        }
        return new Tree<StateSet>(tree.getLabel().copy(), newChildren);
    }

    public StateSetTreeList(List<Tree<String>> trees, short[] numStates, boolean allSplitTheSame, Numberer tagNumberer) {
        for (Tree<String> tree : trees) {
            this.trees.add(StateSetTreeList.stringTreeToStatesetTree(tree, numStates, allSplitTheSame, tagNumberer));
            tree = null;
        }
    }

    public StateSetTreeList(StateSetTreeList treeList, short[] numStates, boolean constant) {
        for (Tree<StateSet> tree : treeList.trees) {
            this.trees.add(StateSetTreeList.resizeStateSetTree(tree, numStates, constant));
        }
    }

    public StateSetTreeList() {
    }

    @Override
    public boolean add(Tree<StateSet> tree) {
        return this.trees.add(tree);
    }

    public Tree<StateSet> get(int i) {
        return this.trees.get(i);
    }

    @Override
    public int size() {
        return this.trees.size();
    }

    @Override
    public boolean isEmpty() {
        return this.trees.isEmpty();
    }

    @Override
    public Iterator<Tree<StateSet>> iterator() {
        return new StateSetTreeListIterator();
    }

    public static Tree<StateSet> stringTreeToStatesetTree(Tree<String> tree, short[] numStates, boolean allSplitTheSame, Numberer tagNumberer) {
        Tree<StateSet> result = StateSetTreeList.stringTreeToStatesetTree(tree, numStates, allSplitTheSame, tagNumberer, false, 0, tree.getYield().size());
        List<StateSet> words = result.getYield();
        int position = 0;
        while (position < words.size()) {
            words.get((int)position).from = (short)position;
            words.get((int)position).to = (short)(position + 1);
            position = (short)(position + 1);
        }
        return result;
    }

    private static Tree<StateSet> stringTreeToStatesetTree(Tree<String> tree, short[] numStates, boolean allSplitTheSame, Numberer tagNumberer, boolean splitRoot, int from, int to) {
        short nodeNumStates;
        if (tree.isLeaf()) {
            StateSet newState = new StateSet(zero, one, tree.getLabel().intern(), (short)from, (short)to);
            return new Tree<StateSet>(newState);
        }
        short label = (short)tagNumberer.number(tree.getLabel());
        if (label < 0) {
            label = 0;
        }
        int cfr_ignored_0 = numStates.length;
        short s = nodeNumStates = allSplitTheSame || numStates.length <= label ? numStates[0] : numStates[label];
        if (!splitRoot) {
            nodeNumStates = 1;
        }
        StateSet newState = new StateSet(label, nodeNumStates, null, (short)from, (short)to);
        Tree<StateSet> newTree = new Tree<StateSet>(newState);
        ArrayList newChildren = new ArrayList();
        for (Tree<String> child : tree.getChildren()) {
            short length = (short)child.getYield().size();
            Tree<StateSet> newChild = StateSetTreeList.stringTreeToStatesetTree(child, numStates, allSplitTheSame, tagNumberer, true, from, from + length);
            from += length;
            newChildren.add(newChild);
        }
        newTree.setChildren(newChildren);
        return newTree;
    }

    private static Tree<StateSet> resizeStateSetTree(Tree<StateSet> tree, short[] numStates, boolean constant) {
        if (tree.isLeaf()) {
            return tree;
        }
        short state = tree.getLabel().getState();
        short newNumStates = constant ? numStates[0] : numStates[state];
        StateSet newState = new StateSet(tree.getLabel(), newNumStates);
        Tree<StateSet> newTree = new Tree<StateSet>(newState);
        ArrayList newChildren = new ArrayList();
        for (Tree<StateSet> child : tree.getChildren()) {
            newChildren.add(StateSetTreeList.resizeStateSetTree(child, numStates, constant));
        }
        newTree.setChildren(newChildren);
        return newTree;
    }

    public static void initializeTagNumberer(List<Tree<String>> trees, Numberer tagNumberer) {
        short[] nSub = new short[]{1, 1};
        for (Tree<String> tree : trees) {
            Tree<StateSet> tree2 = StateSetTreeList.stringTreeToStatesetTree(tree, nSub, true, tagNumberer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StateSetTreeListIterator
    implements Iterator<Tree<StateSet>> {
        Iterator<Tree<StateSet>> stringTreeListIterator;
        Tree<StateSet> currentTree;

        public StateSetTreeListIterator() {
            this.stringTreeListIterator = StateSetTreeList.this.trees.iterator();
            this.currentTree = null;
        }

        @Override
        public boolean hasNext() {
            if (this.currentTree != null) {
                StateSetTreeList.this.deallocate(this.currentTree);
            }
            return this.stringTreeListIterator.hasNext();
        }

        @Override
        public Tree<StateSet> next() {
            this.currentTree = this.stringTreeListIterator.next();
            return this.currentTree;
        }

        @Override
        public void remove() {
            this.stringTreeListIterator.remove();
        }
    }
}

