/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLabeler {
    Grammar grammar;
    SophisticatedLexicon lexicon;
    ArrayParser labeler;
    CoarseToFineMaxRuleParser parser;
    Numberer tagNumberer;
    Binarization binarization;

    public TreeLabeler(Grammar grammar, SophisticatedLexicon lexicon, int labelLevel, Binarization bin) {
        if (labelLevel == -1) {
            this.grammar = grammar.copyGrammar(false);
            this.lexicon = lexicon.copyLexicon();
        } else {
            int[][] fromMapping = grammar.computeMapping(1);
            int[][] toSubstateMapping = grammar.computeSubstateMapping(labelLevel);
            int[][] toMapping = grammar.computeToMapping(labelLevel, toSubstateMapping);
            double[] condProbs = grammar.computeConditionalProbabilities(fromMapping, toMapping);
            this.grammar = grammar.projectGrammar(condProbs, fromMapping, toSubstateMapping);
            this.lexicon = lexicon.projectLexicon(condProbs, fromMapping, toSubstateMapping);
            this.grammar.splitRules();
            double filter = 1.0E-10;
            this.grammar.removeUnlikelyRules(filter, 1.0);
            this.lexicon.removeUnlikelyTags(filter, 1.0);
        }
        this.grammar.logarithmMode();
        this.lexicon.logarithmMode();
        this.labeler = new ArrayParser(this.grammar, this.lexicon);
        this.parser = new CoarseToFineMaxRuleParser(grammar, lexicon, 1.0, -1, true, false, false, false, false, false, true);
        this.tagNumberer = Numberer.getGlobalNumberer("tags");
        this.binarization = bin;
    }

    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        System.err.println("Calling with " + optParser.getPassedInOptions());
        String inFileName = opts.inFileName;
        Grammar grammar = null;
        SophisticatedLexicon lexicon = null;
        TreeLabeler treeLabeler = null;
        boolean labelTree = false;
        ParserData pData = null;
        short[] numSubstates = null;
        if (inFileName == null) {
            System.err.println("Did not provide a grammar.");
        } else {
            labelTree = true;
            System.err.println("Loading grammar from " + inFileName + ".");
            pData = ParserData.Load(inFileName);
            if (pData == null) {
                System.out.println("Failed to load grammar from file" + inFileName + ".");
                System.exit(1);
            }
            grammar = pData.getGrammar();
            grammar.splitRules();
            lexicon = (SophisticatedLexicon)pData.getLexicon();
            Numberer.setNumberers(pData.getNumbs());
            int labelLevel = opts.labelLevel;
            if (labelLevel != -1) {
                System.err.println("Labeling with projected grammar from level " + labelLevel + ".");
            }
            treeLabeler = new TreeLabeler(grammar, lexicon, labelLevel, pData.bin);
            numSubstates = treeLabeler.grammar.numSubStates;
        }
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        Trees.StandardTreeNormalizer treeTransformer = new Trees.StandardTreeNormalizer();
        try {
            InputStreamReader inputData = opts.inputFile == null ? new InputStreamReader(System.in) : new InputStreamReader((InputStream)new FileInputStream(opts.inputFile), "UTF-8");
            Trees.PennTreeReader treeReader = new Trees.PennTreeReader(inputData);
            PrintWriter outputData = opts.outputFile == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputFile), "UTF-8"), true);
            Tree<String> tree = null;
            while (treeReader.hasNext()) {
                tree = treeReader.next();
                if (tree.getChildren().size() == 0 || ((String)tree.getChildren().get(0).getLabel()).equals("(") || ((String)tree.getYield().get(0)).equals("")) {
                    outputData.write("(())\n");
                    continue;
                }
                if (tree.getYield().size() > opts.maxLength) continue;
                if (!labelTree) {
                    if (opts.getyield) {
                        List words = tree.getYield();
                        for (String word : words) {
                            outputData.write(String.valueOf(word) + " ");
                        }
                        outputData.write("\n");
                        continue;
                    }
                    Tree normalizedTree = treeTransformer.transformTree(tree);
                    outputData.write(normalizedTree + "\n");
                    continue;
                }
                tree = TreeAnnotations.processTree(tree, pData.v_markov, pData.h_markov, pData.bin, false);
                List<String> sentence = tree.getYield();
                Tree<StateSet> stateSetTree = StateSetTreeList.stringTreeToStatesetTree(tree, numSubstates, false, tagNumberer);
                TreeLabeler.allocate(stateSetTree);
                Tree<String> labeledTree = treeLabeler.label(stateSetTree, sentence, opts.scores);
                if (opts.onlyConfidence) {
                    double treeLL = stateSetTree.getLabel().getIScore(0);
                    outputData.write(String.valueOf(treeLL) + "\n");
                    outputData.flush();
                    continue;
                }
                if (labeledTree != null && labeledTree.getChildren().size() > 0) {
                    if (opts.prettyPrint) {
                        outputData.write(String.valueOf(Trees.PennTreeRenderer.render(labeledTree)) + "\n");
                    } else {
                        outputData.write(labeledTree.getChildren().get(0) + "\n");
                    }
                } else {
                    outputData.write("(())\n");
                }
                outputData.flush();
            }
            outputData.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private Tree<String> label(Tree<StateSet> stateSetTree, List<String> sentence, boolean outputScores) {
        Tree<String> tree = this.labeler.getBestViterbiDerivation(stateSetTree, outputScores);
        return tree;
    }

    static void allocate(Tree<StateSet> tree) {
        tree.getLabel().allocate();
        for (Tree<StateSet> child : tree.getChildren()) {
            TreeLabeler.allocate(child);
        }
    }

    public static class Options {
        @Option(name="-gr", usage="Input File for Grammar (Required)\n")
        public String inFileName;
        @Option(name="-labelLevel", usage="Parse with projected grammar from this level (yielding 2^level substates) (Default: -1 = input grammar)")
        public int labelLevel = -1;
        @Option(name="-scores", usage="Output inside scores. (Default: false)")
        public boolean scores;
        @Option(name="-getYield", usage="Get the sentences only")
        public boolean getyield;
        @Option(name="-onlyConfidence", usage="Output only confidence measure, i.e. tree likelihood: P(T|w) (Default: false)")
        public boolean onlyConfidence;
        @Option(name="-maxLength", usage="Remove sentences that are longer than this (doesn't print an empty line)")
        public int maxLength = 1000;
        @Option(name="-inputFile", usage="Read input from this file instead of reading it from STDIN.")
        public String inputFile;
        @Option(name="-outputFile", usage="Store output in this file instead of printing it to STDOUT.")
        public String outputFile;
        @Option(name="-prettyPrint", usage="Print in human readable form rather than one tree per line")
        public boolean prettyPrint;
    }
}

