/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.Random;

public class UnaryRule
extends Rule
implements Serializable,
Comparable {
    public short childState = (short)-1;
    public double[][] scores;
    private static final char[] charsToEscape = new char[]{'\"'};
    private static final long serialVersionUID = 2L;

    public UnaryRule(short pState, short cState, double[][] scores) {
        this.parentState = pState;
        this.childState = cState;
        this.scores = scores;
    }

    public UnaryRule(short pState, short cState) {
        this.parentState = pState;
        this.childState = cState;
    }

    public UnaryRule(UnaryRule u) {
        this(u.parentState, u.childState, ArrayUtil.copy(u.scores));
    }

    public UnaryRule(UnaryRule u, double[][] newScores) {
        this(u.parentState, u.childState, newScores);
    }

    public UnaryRule(short pState, short cState, short pSubStates, short cSubStates) {
        this.parentState = pState;
        this.childState = cState;
        this.scores = new double[cSubStates][pSubStates];
    }

    public boolean isUnary() {
        return true;
    }

    public int hashCode() {
        return this.parentState << 18 ^ this.childState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnaryRule) {
            UnaryRule ur = (UnaryRule)o;
            if (this.parentState == ur.parentState && this.childState == ur.childState) {
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object o) {
        UnaryRule ur = (UnaryRule)o;
        if (this.parentState < ur.parentState) {
            return -1;
        }
        if (this.parentState > ur.parentState) {
            return 1;
        }
        if (this.childState < ur.childState) {
            return -1;
        }
        if (this.childState > ur.childState) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String pState;
        Numberer n = Numberer.getGlobalNumberer("tags");
        String cState = (String)n.object(this.childState);
        if (cState.endsWith("^g")) {
            cState = cState.substring(0, cState.length() - 2);
        }
        if ((pState = (String)n.object(this.parentState)).endsWith("^g")) {
            pState = pState.substring(0, pState.length() - 2);
        }
        if (this.scores == null) {
            return String.valueOf(pState) + " -> " + cState + "\n";
        }
        StringBuilder sb = new StringBuilder();
        int cS = 0;
        while (cS < this.scores.length) {
            if (this.scores[cS] != null) {
                int pS = 0;
                while (pS < this.scores[cS].length) {
                    double p = this.scores[cS][pS];
                    if (p > 0.0) {
                        sb.append(String.valueOf(pState) + "_" + pS + " -> " + cState + "_" + cS + " " + p + "\n");
                    }
                    ++pS;
                }
            }
            ++cS;
        }
        return sb.toString();
    }

    public String toString_old() {
        Numberer n = Numberer.getGlobalNumberer("tags");
        return "\"" + StringUtils.escapeString(n.object(this.parentState).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(n.object(this.childState).toString(), charsToEscape, '\\') + "\" " + ArrayUtil.toString(this.scores);
    }

    public short getChildState() {
        return this.childState;
    }

    public void setScore(int pS, int cS, double score) {
        this.scores[cS][pS] = score;
    }

    public double getScore(int pS, int cS) {
        if (this.scores[cS] == null) {
            if (this.logarithmMode) {
                return Double.NEGATIVE_INFINITY;
            }
            return 0.0;
        }
        return this.scores[cS][pS];
    }

    public void setScores2(double[][] scores) {
        this.scores = scores;
    }

    public double[][] getScores2() {
        return this.scores;
    }

    public void setNodes(short pState, short cState) {
        this.parentState = pState;
        this.childState = cState;
    }

    public UnaryRule splitRule(short[] numSubStates, short[] newNumSubStates, Random random, double randomness, boolean doNotNormalize, int mode) {
        int parentSplitFactor;
        int n = parentSplitFactor = this.getParentState() == 0 ? 1 : 2;
        if (newNumSubStates[this.parentState] == numSubStates[this.parentState]) {
            parentSplitFactor = 1;
        }
        int childSplitFactor = 2;
        if (newNumSubStates[this.childState] == numSubStates[this.childState]) {
            childSplitFactor = 1;
        }
        double[][] oldScores = this.getScores2();
        double[][] newScores = new double[newNumSubStates[this.childState]][];
        int cS = 0;
        while (cS < oldScores.length) {
            if (oldScores[cS] != null) {
                int c = 0;
                while (c < childSplitFactor) {
                    short newCS = (short)(childSplitFactor * cS + c);
                    newScores[newCS] = new double[newNumSubStates[this.parentState]];
                    c = (short)(c + 1);
                }
                int pS = 0;
                while (pS < oldScores[cS].length) {
                    double score = oldScores[cS][pS];
                    int p = 0;
                    while (p < parentSplitFactor) {
                        double divFactor = doNotNormalize ? 1.0 : (double)childSplitFactor;
                        double randomComponent = score / divFactor * randomness / 100.0 * (random.nextDouble() - 0.5);
                        int c2 = 0;
                        while (c2 < childSplitFactor) {
                            if (c2 == 1) {
                                randomComponent *= -1.0;
                            }
                            if (childSplitFactor == 1) {
                                randomComponent = 0.0;
                            }
                            short newPS = (short)(parentSplitFactor * pS + p);
                            short newCS = (short)(childSplitFactor * cS + c2);
                            double splitFactor = doNotNormalize ? 1.0 : (double)childSplitFactor;
                            newScores[newCS][newPS] = score / splitFactor + randomComponent;
                            if (mode == 2) {
                                newScores[newCS][newPS] = 1.0 + random.nextDouble() / 100.0;
                            }
                            c2 = (short)(c2 + 1);
                        }
                        p = (short)(p + 1);
                    }
                    pS = (short)(pS + 1);
                }
            }
            cS = (short)(cS + 1);
        }
        return new UnaryRule(this, newScores);
    }
}

