/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA.smoothing;

import edu.berkeley.nlp.PCFGLA.BinaryCounterTable;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.UnaryCounterTable;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Numberer;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothAcrossParentBits
implements Smoother,
Serializable {
    private static final long serialVersionUID = 1L;
    double same;
    double[][][] diffWeights;
    double weightBasis = 0.5;
    double totalWeight;

    @Override
    public SmoothAcrossParentBits copy() {
        return new SmoothAcrossParentBits(this.same, this.diffWeights, this.weightBasis, this.totalWeight);
    }

    /*
     * Unable to fully structure code
     */
    public SmoothAcrossParentBits(double smooth, Tree<Short>[] splitTrees) {
        super();
        this.same = 1.0 - smooth;
        nStates = splitTrees.length;
        this.diffWeights = new double[nStates][][];
        state = 0;
        while (state < nStates) {
            block7: {
                splitTree = splitTrees[state];
                allSubstates = splitTree.getYield();
                nSubstates = 1;
                i = 0;
                while (i < allSubstates.size()) {
                    if (allSubstates.get(i) >= nSubstates) {
                        nSubstates = allSubstates.get(i) + 1;
                    }
                    ++i;
                }
                this.diffWeights[state] = new double[nSubstates][nSubstates];
                if (nSubstates != 1) ** GOTO lbl22
                this.diffWeights[state][0][0] = 1.0;
                break block7;
lbl-1000:
                // 1 sources

                {
                    splitTree = splitTree.getChildren().get(0);
lbl22:
                    // 2 sources

                    ** while (splitTree.getChildren().size() == 1)
                }
lbl23:
                // 1 sources

                branch = 0;
                while (branch < 2) {
                    substatesInBranch = splitTree.getChildren().get(branch).getYield();
                    total = substatesInBranch.size();
                    normalizedSmooth = smooth / (double)(total - 1);
                    for (short i : substatesInBranch) {
                        for (short j : substatesInBranch) {
                            this.diffWeights[state][i][j] = i == j ? this.same : normalizedSmooth;
                        }
                    }
                    ++branch;
                }
            }
            state = (short)(state + 1);
        }
    }

    public SmoothAcrossParentBits(double same2, double[][][] diffWeights2, double weightBasis2, double totalWeight2) {
        this.same = same2;
        this.diffWeights = diffWeights2;
        this.weightBasis = weightBasis2;
        this.totalWeight = totalWeight2;
    }

    @Override
    public void smooth(UnaryCounterTable unaryCounter, BinaryCounterTable binaryCounter) {
        int j;
        short pState;
        Object scopy;
        Object scores;
        for (UnaryRule unaryRule : unaryCounter.keySet()) {
            scores = unaryCounter.getCount(unaryRule);
            scopy = new double[((double[][])scores).length][];
            pState = unaryRule.parentState;
            j = 0;
            while (j < ((double[][])scores).length) {
                if (scores[j] != null) {
                    scopy[j] = new double[scores[j].length];
                    int i = 0;
                    while (i < scores[j].length) {
                        int k = 0;
                        while (k < scores[j].length) {
                            double[] dArray = scopy[j];
                            int n = i;
                            dArray[n] = dArray[n] + this.diffWeights[pState][i][k] * scores[j][k];
                            ++k;
                        }
                        ++i;
                    }
                }
                ++j;
            }
            unaryCounter.setCount(unaryRule, (double[][])scopy);
        }
        for (BinaryRule binaryRule : binaryCounter.keySet()) {
            scores = binaryCounter.getCount(binaryRule);
            scopy = new double[((double[][])scores).length][scores[0].length][];
            pState = binaryRule.parentState;
            j = 0;
            while (j < ((double[][])scores).length) {
                int l = 0;
                while (l < scores[j].length) {
                    if (scores[j][l] != null) {
                        scopy[j][l] = (double)new double[((double)scores[j][l]).length];
                        int i = 0;
                        while (i < ((double)scores[j][l]).length) {
                            int k = 0;
                            while (k < ((double)scores[j][l]).length) {
                                double d = scopy[j][l];
                                int n = i;
                                d[n] = d[n] + this.diffWeights[pState][i][k] * scores[j][l][k];
                                ++k;
                            }
                            ++i;
                        }
                    }
                    ++l;
                }
                ++j;
            }
            binaryCounter.setCount(binaryRule, (double[][][])scopy);
        }
    }

    private void fillWeightsArray(short state, short substate, double weight, Tree<Short> subTree) {
        if (subTree.isLeaf()) {
            if (subTree.getLabel() == substate) {
                this.diffWeights[state][substate][substate] = this.same;
            } else {
                this.diffWeights[state][substate][subTree.getLabel().shortValue()] = weight;
                this.totalWeight += weight;
            }
            return;
        }
        if (subTree.getChildren().size() == 1) {
            this.fillWeightsArray(state, substate, weight, subTree.getChildren().get(0));
            return;
        }
        int branch = 0;
        while (branch < 2) {
            Tree<Short> branchTree = subTree.getChildren().get(branch);
            List<Short> substatesInBranch = branchTree.getYield();
            if (substatesInBranch.contains(substate)) {
                this.fillWeightsArray(state, substate, weight, branchTree);
            } else {
                this.fillWeightsArray(state, substate, weight * this.weightBasis / 2.0, branchTree);
            }
            ++branch;
        }
    }

    @Override
    public void smooth(short tag, double[] scores) {
        double[] scopy = new double[scores.length];
        int i = 0;
        while (i < scores.length) {
            int k = 0;
            while (k < scores.length) {
                int n = i;
                scopy[n] = scopy[n] + this.diffWeights[tag][i][k] * scores[k];
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < scores.length) {
            scores[i] = scopy[i];
            ++i;
        }
    }

    @Override
    public void updateWeights(int[][] toSubstateMapping) {
        double[][][] newWeights = new double[toSubstateMapping.length][][];
        int state = 0;
        while (state < toSubstateMapping.length) {
            int nSub = toSubstateMapping[state][0];
            newWeights[state] = new double[nSub][nSub];
            if (nSub == 1) {
                newWeights[state][0][0] = 1.0;
            } else {
                int substate2;
                double[] total = new double[nSub];
                int substate1 = 0;
                while (substate1 < this.diffWeights[state].length) {
                    substate2 = 0;
                    while (substate2 < this.diffWeights[state].length) {
                        double[] dArray = newWeights[state][toSubstateMapping[state][substate1 + 1]];
                        int n = toSubstateMapping[state][substate2 + 1];
                        dArray[n] = dArray[n] + this.diffWeights[state][substate1][substate2];
                        int n2 = toSubstateMapping[state][substate1 + 1];
                        total[n2] = total[n2] + this.diffWeights[state][substate1][substate2];
                        ++substate2;
                    }
                    ++substate1;
                }
                substate1 = 0;
                while (substate1 < nSub) {
                    substate2 = 0;
                    while (substate2 < nSub) {
                        double[] dArray = newWeights[state][substate1];
                        int n = substate2++;
                        dArray[n] = dArray[n] / total[substate1];
                    }
                    ++substate1;
                }
            }
            ++state;
        }
        this.diffWeights = newWeights;
    }

    @Override
    public Smoother remapStates(Numberer thisNumberer, Numberer newNumberer) {
        SmoothAcrossParentBits remappedSmoother = this.copy();
        remappedSmoother.diffWeights = new double[newNumberer.size()][][];
        int s = 0;
        while (s < newNumberer.size()) {
            short translatedState = this.translateState(s, newNumberer, thisNumberer);
            remappedSmoother.diffWeights[s] = translatedState >= 0 ? this.diffWeights[translatedState] : new double[1][1];
            ++s;
        }
        return remappedSmoother;
    }

    private short translateState(int state, Numberer baseNumberer, Numberer translationNumberer) {
        Object object = baseNumberer.object(state);
        if (translationNumberer.hasSeen(object)) {
            return (short)translationNumberer.number(object);
        }
        return -1;
    }
}

