/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.classify;

import edu.berkeley.nlp.util.Indexer;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoding<F, L>
implements Serializable {
    private static final long serialVersionUID = 6349512704632759684L;
    Indexer<F> featureIndexer;
    Indexer<L> labelIndexer;

    public int getNumFeatures() {
        return this.featureIndexer.size();
    }

    public boolean hasFeature(F feature) {
        return this.featureIndexer.contains(feature);
    }

    public int getFeatureIndex(F feature) {
        return this.featureIndexer.indexOf(feature);
    }

    public F getFeature(int featureIndex) {
        return this.featureIndexer.getObject(featureIndex);
    }

    public int getNumLabels() {
        return this.labelIndexer.size();
    }

    public int getLabelIndex(L label) {
        return this.labelIndexer.indexOf(label);
    }

    public L getLabel(int labelIndex) {
        return this.labelIndexer.getObject(labelIndex);
    }

    public Encoding(Indexer<F> featureIndexer, Indexer<L> labelIndexer) {
        this.featureIndexer = featureIndexer;
        this.labelIndexer = labelIndexer;
    }
}

