/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.classify;

import edu.berkeley.nlp.classify.Feature;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureManager
implements Serializable {
    private static final long serialVersionUID = 42L;
    private transient Map<Feature, Feature> featureInterner = new HashMap<Feature, Feature>();
    private transient List<Feature> featureList = new ArrayList<Feature>();
    private boolean locked = false;

    public void lock() {
        this.locked = true;
    }

    public Feature getFeatrue(String pred, String val) {
        return this.getFeature(String.valueOf(pred) + "=" + val);
    }

    public void addFeature(String pred, String val) {
        assert (!this.locked);
        this.addFeature(String.format("%s=%s", pred, val));
    }

    public void addFeature(String val) {
        assert (!this.locked);
        this.getFeature(val);
    }

    public Feature getFeature(int index) {
        return this.featureList.get(index);
    }

    public Feature getFeature(String val) {
        Feature feat = new Feature(val, -1);
        Feature canonicalFeat = this.featureInterner.get(feat);
        if (canonicalFeat == null) {
            assert (!this.locked) : "Can't find feature " + val + " in locked FeatureManager";
            feat = new Feature(feat.toString(), this.featureInterner.size());
            this.featureInterner.put(feat, feat);
            this.featureList.add(feat);
            canonicalFeat = feat;
        }
        return canonicalFeat;
    }

    public int getNumFeatures() {
        return this.featureInterner.size();
    }

    public boolean hasFeature(String val) {
        Feature feat = new Feature(val, -1);
        return this.featureInterner.containsKey(feat);
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.featureList.size());
        for (Feature feat : this.featureList) {
            out.writeObject(feat.toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.featureList = new ArrayList<Feature>();
        this.featureInterner = new HashMap<Feature, Feature>();
        boolean oldLocked = this.locked;
        this.locked = false;
        int numFeats = (Integer)in.readObject();
        int i = 0;
        while (i < numFeats) {
            String f = (String)in.readObject();
            this.addFeature(f);
            ++i;
        }
        this.locked = oldLocked;
    }
}

