/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.util.Indexer;
import edu.berkeley.nlp.util.SubIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoding<F, L> {
    Indexer<F> featureIndexer;
    SubIndexer<L> labelIndexer;

    public int getNumFeatures() {
        return this.featureIndexer.size();
    }

    public int getFeatureIndex(F feature) {
        return this.featureIndexer.indexOf(feature);
    }

    public F getFeature(int featureIndex) {
        return this.featureIndexer.get(featureIndex);
    }

    public int getNumLabels() {
        return this.labelIndexer.size();
    }

    public int getNumSubLabels() {
        return this.labelIndexer.totalSize();
    }

    public int getLabelIndex(L label) {
        return this.labelIndexer.indexOf(label);
    }

    public int getLabelSubindexBegin(int labelIndex) {
        return this.labelIndexer.subindexBegin(labelIndex);
    }

    public int getLabelSubindexEnd(int labelIndex) {
        return this.labelIndexer.subindexEnd(labelIndex);
    }

    public L getLabel(int labelIndex) {
        return this.labelIndexer.get(labelIndex);
    }

    public Encoding(Indexer<F> featureIndexer, SubIndexer<L> labelIndexer) {
        this.featureIndexer = featureIndexer;
        this.labelIndexer = labelIndexer;
    }
}

