/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ling;

import edu.berkeley.nlp.ling.AbstractCollinsHeadFinder;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.treebank.PennTreebankLanguagePack;
import edu.berkeley.nlp.treebank.TreebankLanguagePack;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollinsHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = -8747319554557223437L;

    public CollinsHeadFinder() {
        this(new PennTreebankLanguagePack());
    }

    @Override
    protected int postOperationFix(int headIdx, List<Tree<String>> daughterTrees) {
        String prevLab;
        if (headIdx >= 2 && (prevLab = daughterTrees.get(headIdx - 1).getLabel()).equals("CC")) {
            int newHeadIdx = headIdx - 2;
            Tree<String> t = daughterTrees.get(newHeadIdx);
            while (newHeadIdx >= 0 && t.isPreTerminal() && this.tlp.isPunctuationTag(t.getLabel())) {
                --newHeadIdx;
            }
            if (newHeadIdx >= 0) {
                headIdx = newHeadIdx;
            }
        }
        return headIdx;
    }

    public CollinsHeadFinder(TreebankLanguagePack tlp) {
        super(tlp);
        this.nonTerminalInfo = new HashMap();
        this.nonTerminalInfo.put("ADJP", new String[][]{{"left", "NNS", "QP", "NN", "$", "ADVP", "JJ", "VBN", "VBG", "ADJP", "JJR", "NP", "JJS", "DT", "FW", "RBR", "RBS", "SBAR", "RB"}});
        this.nonTerminalInfo.put("ADVP", new String[][]{{"right", "RB", "RBR", "RBS", "FW", "ADVP", "TO", "CD", "JJR", "JJ", "IN", "NP", "JJS", "NN"}});
        this.nonTerminalInfo.put("CONJP", new String[][]{{"right", "CC", "RB", "IN"}});
        this.nonTerminalInfo.put("FRAG", new String[][]{{"right"}});
        this.nonTerminalInfo.put("INTJ", new String[][]{{"left"}});
        this.nonTerminalInfo.put("LST", new String[][]{{"right", "LS", ":"}});
        this.nonTerminalInfo.put("NAC", new String[][]{{"left", "NN", "NNS", "NNP", "NNPS", "NP", "NAC", "EX", "$", "CD", "QP", "PRP", "VBG", "JJ", "JJS", "JJR", "ADJP", "FW"}});
        this.nonTerminalInfo.put("NX", new String[][]{{"left"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"right", "IN", "TO", "VBG", "VBN", "RP", "FW"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{"left"}});
        this.nonTerminalInfo.put("PRT", new String[][]{{"right", "RP"}});
        this.nonTerminalInfo.put("QP", new String[][]{{"left", "$", "IN", "NNS", "NN", "JJ", "RB", "DT", "CD", "NCD", "QP", "JJR", "JJS"}});
        this.nonTerminalInfo.put("RRC", new String[][]{{"right", "VP", "NP", "ADVP", "ADJP", "PP"}});
        this.nonTerminalInfo.put("S", new String[][]{{"left", "TO", "IN", "VP", "S", "SBAR", "ADJP", "UCP", "NP"}});
        this.nonTerminalInfo.put("SBAR", new String[][]{{"left", "WHNP", "WHPP", "WHADVP", "WHADJP", "IN", "DT", "S", "SQ", "SINV", "SBAR", "FRAG"}});
        this.nonTerminalInfo.put("SBARQ", new String[][]{{"left", "SQ", "S", "SINV", "SBARQ", "FRAG"}});
        this.nonTerminalInfo.put("SINV", new String[][]{{"left", "VBZ", "VBD", "VBP", "VB", "MD", "VP", "S", "SINV", "ADJP", "NP"}});
        this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VBZ", "VBD", "VBP", "VB", "MD", "VP", "SQ"}});
        this.nonTerminalInfo.put("UCP", new String[][]{{"right"}});
        this.nonTerminalInfo.put("VP", new String[][]{{"left", "TO", "VBD", "VBN", "MD", "VBZ", "VB", "VBG", "VBP", "AUX", "AUXG", "VP", "ADJP", "NN", "NNS", "NP"}});
        this.nonTerminalInfo.put("WHADJP", new String[][]{{"left", "CC", "WRB", "JJ", "ADJP"}});
        this.nonTerminalInfo.put("WHADVP", new String[][]{{"right", "CC", "WRB"}});
        this.nonTerminalInfo.put("WHNP", new String[][]{{"left", "WDT", "WP", "WP$", "WHADJP", "WHPP", "WHNP"}});
        this.nonTerminalInfo.put("WHPP", new String[][]{{"right", "IN", "TO", "FW"}});
        this.nonTerminalInfo.put("X", new String[][]{{"right"}});
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "POS", "JJR"}, {"left", "NP"}, {"rightdis", "$", "ADJP", "PRN"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP"}});
        this.nonTerminalInfo.put("TYPO", new String[][]{{"left"}});
    }

    public static void main(String[] args) {
        Trees.PennTreeReader reader = new Trees.PennTreeReader(new StringReader("((S (NP (DT the) (JJ quick) (JJ (AA (BB (CC brown)))) (NN fox)) (VP (VBD jumped) (PP (IN over) (NP (DT the) (JJ lazy) (NN dog)))) (. .)))"));
        Tree<String> tree = reader.next();
        System.out.println("tree " + tree);
        CollinsHeadFinder headFinder = new CollinsHeadFinder();
        while (!tree.isLeaf()) {
            Tree<String> head = headFinder.determineHead(tree);
            System.out.println("head " + head);
            tree = head;
        }
    }
}

