/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.DifferentiableFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.GradientLineSearcher;
import edu.berkeley.nlp.util.Logger;

public class BacktrackingLineSearcher
implements GradientLineSearcher {
    private double EPS = 1.0E-10;
    double stepSizeMultiplier = 0.5;
    public double sufficientDecreaseConstant = 1.0E-4;
    public double initialStepSize = 1.0;
    public double stepSize;
    int maxIterations = Integer.MAX_VALUE;

    public double[] minimize(DifferentiableFunction function, double[] initial, double[] direction) {
        return this.minimize(function, initial, direction, false);
    }

    public double[] minimize(DifferentiableFunction function, double[] initial, double[] direction, boolean project) {
        this.stepSize = this.initialStepSize;
        double initialFunctionValue = function.valueAt(initial);
        double initialDirectionalDerivative = DoubleArrays.innerProduct(function.derivativeAt(initial), direction);
        double[] guess = null;
        double guessValue = 0.0;
        boolean sufficientDecreaseObtained = false;
        int iter = 0;
        while (!sufficientDecreaseObtained) {
            double sufficientDecreaseValue;
            guess = DoubleArrays.addMultiples(initial, 1.0, direction, this.stepSize);
            if (project) {
                DoubleArrays.project2(guess, initial);
            }
            boolean bl = sufficientDecreaseObtained = (guessValue = function.valueAt(guess)) <= (sufficientDecreaseValue = initialFunctionValue + this.sufficientDecreaseConstant * initialDirectionalDerivative * this.stepSize);
            if (!sufficientDecreaseObtained) {
                this.stepSize *= this.stepSizeMultiplier;
                if (this.stepSize < this.EPS) {
                    Logger.err("BacktrackingSearcher.minimize: stepSize underflow.");
                    return initial;
                }
            }
            if (iter++ <= this.maxIterations) continue;
            return initial;
        }
        return guess;
    }

    public double getFinalStepSize() {
        return this.stepSize;
    }

    public static void main(String[] args) {
        DifferentiableFunction function = new DifferentiableFunction(){

            public int dimension() {
                return 1;
            }

            public double valueAt(double[] x) {
                return x[0] * (x[0] - 0.01);
            }

            public double[] derivativeAt(double[] x) {
                return new double[]{2.0 * x[0] - 0.01};
            }

            public double[] unregularizedDerivativeAt(double[] x) {
                return new double[]{2.0 * x[0] - 0.01};
            }
        };
        BacktrackingLineSearcher lineSearcher = new BacktrackingLineSearcher();
        lineSearcher.minimize(function, new double[]{0.0}, new double[]{1.0}, false);
    }

    public void setMaxIterations(int i) {
        this.maxIterations = i;
    }
}

