/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.mapper.AsynchronousMapper;
import edu.berkeley.nlp.mapper.SimpleMapper;
import edu.berkeley.nlp.math.CachingDifferentiableFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.ObjectiveItemDifferentiableFunction;
import edu.berkeley.nlp.math.Regularizer;
import edu.berkeley.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingObjectiveDifferentiableFunction<I>
extends CachingDifferentiableFunction {
    private List<? extends ObjectiveItemDifferentiableFunction<I>> itemFns;
    private Regularizer regularizer;
    private Collection<I> items;

    public CachingObjectiveDifferentiableFunction(Collection<I> items, List<? extends ObjectiveItemDifferentiableFunction<I>> itemFns, Regularizer regularizer) {
        this.itemFns = itemFns;
        this.regularizer = regularizer;
        this.items = items;
    }

    public CachingObjectiveDifferentiableFunction(Collection<I> items, ObjectiveItemDifferentiableFunction<I> itemFn, Regularizer regularizer) {
        this(items, Collections.singletonList(itemFn), regularizer);
    }

    private List<Mapper> getMappers() {
        ArrayList<Mapper> mappers = new ArrayList<Mapper>();
        for (ObjectiveItemDifferentiableFunction<I> itemFn : this.itemFns) {
            mappers.add(new Mapper(itemFn));
        }
        return mappers;
    }

    @Override
    protected Pair<Double, double[]> calculate(double[] x) {
        for (ObjectiveItemDifferentiableFunction<I> itemFn : this.itemFns) {
            itemFn.setWeights(x);
        }
        List<Mapper> mappers = this.getMappers();
        AsynchronousMapper.doMapping(this.items, mappers);
        double objVal = 0.0;
        double[] grad = new double[this.dimension()];
        for (Mapper mapper : mappers) {
            objVal += mapper.objVal;
            DoubleArrays.addInPlace(grad, mapper.localGrad);
        }
        if (this.regularizer != null) {
            objVal += this.regularizer.update(x, grad, 1.0);
        }
        return Pair.newPair(objVal, grad);
    }

    @Override
    public int dimension() {
        return this.itemFns.get(0).dimension();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Mapper
    implements SimpleMapper<I> {
        ObjectiveItemDifferentiableFunction<I> itemFn;
        double objVal;
        double[] localGrad;

        Mapper(ObjectiveItemDifferentiableFunction<I> itemFn) {
            this.itemFn = itemFn;
            this.objVal = 0.0;
            this.localGrad = new double[itemFn.dimension()];
        }

        @Override
        public void map(I elem) {
            this.objVal += this.itemFn.update(elem, this.localGrad);
        }
    }
}

