/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.SloppyMath;
import java.util.Arrays;

public class DoubleArrays {
    public static double[] clone(double[] x) {
        double[] y = new double[x.length];
        DoubleArrays.assign(y, x);
        return y;
    }

    public static void assign(double[] y, double[] x) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static double innerProduct(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        double result = 0.0;
        int i = 0;
        while (i < x.length) {
            result += x[i] * y[i];
            ++i;
        }
        return result;
    }

    public static double innerProduct(Double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        double result = 0.0;
        int i = 0;
        while (i < x.length) {
            result += x[i] * y[i];
            ++i;
        }
        return result;
    }

    public static double[] addMultiples(double[] x, double xMultiplier, double[] y, double yMuliplier) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        double[] z = new double[x.length];
        int i = 0;
        while (i < z.length) {
            z[i] = x[i] * xMultiplier + y[i] * yMuliplier;
            ++i;
        }
        return z;
    }

    public static double[] constantArray(double c, int length) {
        double[] x = new double[length];
        Arrays.fill(x, c);
        return x;
    }

    public static double[] pointwiseMultiply(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        double[] z = new double[x.length];
        int i = 0;
        while (i < z.length) {
            z[i] = x[i] * y[i];
            ++i;
        }
        return z;
    }

    public static boolean probabilisticNormalize(double[] x) {
        double sum = DoubleArrays.add(x);
        if (sum <= 0.0) {
            return false;
        }
        DoubleArrays.scale(x, 1.0 / sum);
        return true;
    }

    public static String toString(double[] x) {
        return DoubleArrays.toString(x, x.length);
    }

    public static String toString(double[][] x) {
        StringBuilder sb = new StringBuilder();
        double[][] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            sb.append(DoubleArrays.toString(row));
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public static String toString(double[] x, int length) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while ((float)i < SloppyMath.min(x.length, length)) {
            sb.append(String.format("%.5f", x[i]));
            if ((float)(i + 1) < SloppyMath.min(x.length, length)) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void scale(double[] x, double s) {
        if (s == 1.0) {
            return;
        }
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] * s;
        }
    }

    public static double[] multiply(double[] x, double s) {
        double[] result = new double[x.length];
        if (s == 1.0) {
            System.arraycopy(x, 0, result, 0, x.length);
            return result;
        }
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] * s;
            ++i;
        }
        return result;
    }

    public static int argMax(double[] v) {
        int maxI = -1;
        double maxV = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < v.length) {
            if (v[i] > maxV) {
                maxV = v[i];
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static double max(double[] v) {
        double maxV = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < v.length) {
            if (v[i] > maxV) {
                maxV = v[i];
            }
            ++i;
        }
        return maxV;
    }

    public static double max(double[][] m) {
        double max = Double.NEGATIVE_INFINITY;
        double[][] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            max = Math.max(DoubleArrays.max(row), max);
            ++n2;
        }
        return max;
    }

    public static int argMin(double[] v) {
        int minI = -1;
        double minV = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < v.length) {
            if (v[i] < minV) {
                minV = v[i];
                minI = i;
            }
            ++i;
        }
        return minI;
    }

    public static double min(double[] v) {
        double minV = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < v.length) {
            if (v[i] < minV) {
                minV = v[i];
            }
            ++i;
        }
        return minV;
    }

    public static double min(double[][] m) {
        double min = Double.POSITIVE_INFINITY;
        double[][] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            min = Math.min(DoubleArrays.min(row), min);
            ++n2;
        }
        return min;
    }

    public static double maxAbs(double[] v) {
        double maxV = 0.0;
        int i = 0;
        while (i < v.length) {
            double abs;
            double d = abs = v[i] <= 0.0 ? 0.0 - v[i] : v[i];
            if (abs > maxV) {
                maxV = abs;
            }
            ++i;
        }
        return maxV;
    }

    public static double[] add(double[] a, double b) {
        double[] result = new double[a.length];
        int i = 0;
        while (i < a.length) {
            double v = a[i];
            result[i] = v + b;
            ++i;
        }
        return result;
    }

    public static double add(double[] a) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public static int add(int[] a) {
        int sum = 0;
        int i = 0;
        while (i < a.length) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public static double add(double[] a, int first, int last) {
        if (last >= a.length) {
            throw new RuntimeException("last beyond end of array");
        }
        if (first < 0) {
            throw new RuntimeException("first must be at least 0");
        }
        double sum = 0.0;
        int i = first;
        while (i <= last) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public static double vectorLength(double[] x) {
        return Math.sqrt(DoubleArrays.innerProduct(x, x));
    }

    public static double[] add(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        double[] result = new double[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] + y[i];
            ++i;
        }
        return result;
    }

    public static void subtractInPlace(double[] x, double[] y) {
        int i = 0;
        while (i < x.length) {
            int n = i;
            x[n] = x[n] - y[i];
            ++i;
        }
    }

    public static void subtractInPlaceUnsafe(double[] x, double[] y) {
        int i = 0;
        while (i < x.length) {
            if (!Double.isNaN(x[i] - y[i])) {
                int n = i;
                x[n] = x[n] - y[i];
            }
            ++i;
        }
    }

    public static double[] subtract(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        double[] result = new double[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] - y[i];
            ++i;
        }
        return result;
    }

    public static double[] exponentiate(double[] pUnexponentiated) {
        double[] exponentiated = new double[pUnexponentiated.length];
        int index = 0;
        while (index < pUnexponentiated.length) {
            exponentiated[index] = SloppyMath.exp(pUnexponentiated[index]);
            ++index;
        }
        return exponentiated;
    }

    public static double[][] exponentiate(double[][] pUnexponentiated) {
        double[][] exponentiated = new double[pUnexponentiated.length][];
        int index = 0;
        while (index < pUnexponentiated.length) {
            exponentiated[index] = DoubleArrays.exponentiate(pUnexponentiated[index]);
            ++index;
        }
        return exponentiated;
    }

    public static void truncate(double[] x, double maxVal) {
        int index = 0;
        while (index < x.length) {
            if (x[index] > maxVal) {
                x[index] = maxVal;
            } else if (x[index] < -maxVal) {
                x[index] = -maxVal;
            }
            ++index;
        }
    }

    public static void initialize(double[] x, double d) {
        Arrays.fill(x, d);
    }

    public static void initialize(Object[] x, double d) {
        int i = 0;
        while (i < x.length) {
            Object o = x[i];
            if (o instanceof double[]) {
                DoubleArrays.initialize((double[])o, d);
            } else {
                DoubleArrays.initialize((Object[])o, d);
            }
            ++i;
        }
    }

    public static void addInPlace(double[] x, double c) {
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] + c;
        }
    }

    public static void addInPlace(double[] x, double[] y) {
        assert (y.length >= x.length);
        int i = 0;
        while (i < x.length) {
            int n = i;
            x[n] = x[n] + y[i];
            ++i;
        }
    }

    public static void addInPlace2D(double[][] x, double[][] y) {
        assert (y.length >= x.length);
        int i = 0;
        while (i < x.length) {
            DoubleArrays.addInPlace(x[i], y[i]);
            ++i;
        }
    }

    public static void multiplyInPlace(double[] x, double[] y) {
        int i = 0;
        while (i < x.length) {
            int n = i;
            x[n] = x[n] * y[i];
            ++i;
        }
    }

    public static double[] average(double[][] x) {
        if (x.length == 0) {
            return null;
        }
        double[] sum = x[0];
        int i = 1;
        while (i < x.length) {
            sum = DoubleArrays.add(sum, x[i]);
            ++i;
        }
        double[] avg = DoubleArrays.multiply(sum, 1.0 / (double)x.length);
        return avg;
    }

    public static void project(double[] x, double[] y) {
        int i = 0;
        while (i < x.length) {
            if (x[i] * y[i] <= 0.0) {
                x[i] = 0.0;
            }
            ++i;
        }
    }

    public static void project2(double[] x, double[] y) {
        int i = 0;
        while (i < x.length) {
            if (x[i] * y[i] < 0.0) {
                x[i] = 0.0;
            }
            ++i;
        }
    }

    public static void checkNonNegative(double[] x) {
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (v < -1.0E-10) {
                throw new RuntimeException("Negative number " + v);
            }
            ++n2;
        }
    }

    public static void checkNonNegative(double[][] m) {
        double[][] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            DoubleArrays.checkNonNegative(row);
            ++n2;
        }
    }

    public static void checkValid(double[] x) {
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (Double.isNaN(v)) {
                throw new RuntimeException("Invalid entry " + v);
            }
            ++n2;
        }
    }

    public static void checkValid(double[][] m) {
        double[][] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            DoubleArrays.checkValid(row);
            ++n2;
        }
    }

    public static double lInfinityDist(double[] x, double[] y) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < x.length) {
            max = Math.max(max, Math.abs(x[i] - y[i]));
            ++i;
        }
        return max;
    }

    public static void logInPlace(double[] vec) {
        int i = 0;
        while (i < vec.length) {
            vec[i] = Math.log(vec[i]);
            ++i;
        }
    }

    public static void checkNonInfinite(double[] vec) {
        double[] dArray = vec;
        int n = vec.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (Double.isInfinite(v)) {
                throw new RuntimeException("Invalid Entry: " + v);
            }
            ++n2;
        }
    }

    public static void checkNonInfinite(double[][] m) {
        double[][] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            DoubleArrays.checkNonInfinite(row);
            ++n2;
        }
    }

    public static void addInPlace(double[] a, double[] b, double c) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] + b[i] * c;
            ++i;
        }
    }

    public static void addInPlace(double[][] a, double[][] b, double c) {
        int i = 0;
        while (i < a.length) {
            DoubleArrays.addInPlace(a[i], b[i], c);
            ++i;
        }
    }

    public static double[] multiply(double[][] X, double[] y) {
        int m = X.length;
        int n = X[0].length;
        assert (n == y.length);
        double[] result = new double[m];
        int i = 0;
        while (i < result.length) {
            result[i] = DoubleArrays.innerProduct(X[i], y);
            ++i;
        }
        return result;
    }

    public static double[][] clone(double[][] M) {
        double[][] copy = new double[M.length][];
        int i = 0;
        while (i < M.length) {
            copy[i] = DoubleArrays.clone(M[i]);
            ++i;
        }
        return copy;
    }

    public static double[][][] clone(double[][][] M) {
        double[][][] copy = new double[M.length][][];
        int i = 0;
        while (i < M.length) {
            copy[i] = DoubleArrays.clone(M[i]);
            ++i;
        }
        return copy;
    }

    public static double[][][][] clone(double[][][][] M) {
        double[][][][] copy = new double[M.length][][][];
        int i = 0;
        while (i < M.length) {
            copy[i] = DoubleArrays.clone(M[i]);
            ++i;
        }
        return copy;
    }

    public static float[] clone(float[] x) {
        float[] y = new float[x.length];
        DoubleArrays.assign(y, x);
        return y;
    }

    public static void assign(float[] y, float[] x) {
        if (x.length != y.length) {
            throw new RuntimeException("diff lengths: " + x.length + " " + y.length);
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static float[][] clone(float[][] M) {
        float[][] copy = new float[M.length][];
        int i = 0;
        while (i < M.length) {
            copy[i] = DoubleArrays.clone(M[i]);
            ++i;
        }
        return copy;
    }

    public static float[][][] clone(float[][][] M) {
        float[][][] copy = new float[M.length][][];
        int i = 0;
        while (i < M.length) {
            copy[i] = DoubleArrays.clone(M[i]);
            ++i;
        }
        return copy;
    }

    public static float[][][][] clone(float[][][][] M) {
        float[][][][] copy = new float[M.length][][][];
        int i = 0;
        while (i < M.length) {
            copy[i] = DoubleArrays.clone(M[i]);
            ++i;
        }
        return copy;
    }

    public static double outerProduct(double[][] M, double[] x) {
        double sum = 0.0;
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < M[i].length) {
                sum += M[i][j] * x[i] * x[j];
                ++j;
            }
            ++i;
        }
        return sum;
    }
}

