/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.DoubleArrays;

public class DoubleMatrices {
    public static double[][] transpose(double[][] A) {
        double[][] B = new double[A[0].length][A.length];
        int i = 0;
        while (i < B.length) {
            int j = 0;
            while (j < B[0].length) {
                B[i][j] = A[j][i];
                ++j;
            }
            ++i;
        }
        return B;
    }

    public static double[] getColumnVector(double[][] A, int j) {
        double[] v = new double[A.length];
        int i = 0;
        while (i < v.length) {
            v[i] = A[i][j];
            ++i;
        }
        return v;
    }

    public static double[][] product(double[][] A, double[][] B) {
        if (A[0].length != B.length) {
            throw new RuntimeException("cols in A (" + A.length + ") differs from rows in B ( " + B.length + ")");
        }
        double[][] C = new double[A.length][B[0].length];
        int i = 0;
        while (i < A.length) {
            int j = 0;
            while (j < B[0].length) {
                C[i][j] = DoubleArrays.innerProduct(A[i], DoubleMatrices.getColumnVector(B, j));
                ++j;
            }
            ++i;
        }
        return C;
    }

    public static double add(double[][] m) {
        double sum = 0.0;
        double[][] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            sum += DoubleArrays.add(row);
            ++n2;
        }
        return sum;
    }

    public static double[] product(double[] v, double[][] B) {
        double[][] A = new double[][]{v};
        return DoubleMatrices.product((double[][])A, B)[0];
    }

    public static double[] product(double[][] A, double[] v) {
        double[][] B = new double[][]{v};
        return DoubleMatrices.transpose(DoubleMatrices.product(A, DoubleMatrices.transpose(B)))[0];
    }

    public static void normalizeEachRow(double[][] M) {
        double[][] dArray = M;
        int n = M.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            DoubleArrays.probabilisticNormalize(row);
            ++n2;
        }
    }

    public static void scale(double[][] M, double scale) {
        double[][] dArray = M;
        int n = M.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            DoubleArrays.scale(row, scale);
            ++n2;
        }
    }

    public static double[][] constantMatrix(double c, int m, int n) {
        double[][] M = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                M[i][j] = c;
                ++j;
            }
            ++i;
        }
        return M;
    }
}

