/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.BacktrackingLineSearcher;
import edu.berkeley.nlp.math.DifferentiableFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.GradientMinimizer;
import edu.berkeley.nlp.util.CallbackFunction;
import edu.berkeley.nlp.util.Logger;
import java.io.Serializable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LBFGSMinimizer
implements GradientMinimizer,
Serializable {
    private static final long serialVersionUID = 36473897808840226L;
    double EPS = 1.0E-10;
    int maxIterations = 20;
    int maxHistorySize = 5;
    LinkedList<double[]> inputDifferenceVectorList = new LinkedList();
    LinkedList<double[]> derivativeDifferenceVectorList = new LinkedList();
    transient CallbackFunction iterCallbackFunction = null;
    int minIterations = -1;
    double initialStepSizeMultiplier = 0.01;
    double stepSizeMultiplier = 0.5;
    boolean dumpHistoryBeforeConverge = false;
    boolean alreadyDumped = false;
    int historyDropIters = -1;
    boolean verbose = true;

    public void setDumpHistoryBeforeConverge(boolean dumpHistoryBeforeConverge) {
        this.dumpHistoryBeforeConverge = dumpHistoryBeforeConverge;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void dumpHistoryPeriodically(int numIters) {
        this.historyDropIters = numIters;
    }

    public void setMinIteratons(int minIterations) {
        this.minIterations = minIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setInitialStepSizeMultiplier(double initialStepSizeMultiplier) {
        this.initialStepSizeMultiplier = initialStepSizeMultiplier;
    }

    public void setStepSizeMultiplier(double stepSizeMultiplier) {
        this.stepSizeMultiplier = stepSizeMultiplier;
    }

    public double[] getSearchDirection(int dimension, double[] derivative) {
        double[] initialInverseHessianDiagonal = this.getInitialInverseHessianDiagonal(dimension);
        double[] direction = this.implicitMultiply(initialInverseHessianDiagonal, derivative);
        return direction;
    }

    protected double[] getInitialInverseHessianDiagonal(int dimension) {
        double scale = 1.0;
        if (this.derivativeDifferenceVectorList.size() >= 1) {
            double[] lastDerivativeDifference = this.getLastDerivativeDifference();
            double[] lastInputDifference = this.getLastInputDifference();
            double num = DoubleArrays.innerProduct(lastDerivativeDifference, lastInputDifference);
            double den = DoubleArrays.innerProduct(lastDerivativeDifference, lastDerivativeDifference);
            scale = num / den;
        }
        return DoubleArrays.constantArray(scale, dimension);
    }

    @Override
    public double[] minimize(DifferentiableFunction function, double[] initial, double tolerance) {
        return this.minimize(function, initial, tolerance, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double[] minimize(DifferentiableFunction function, double[] initial, double tolerance, boolean printProgress) {
        BacktrackingLineSearcher lineSearcher = new BacktrackingLineSearcher();
        double[] guess = DoubleArrays.clone(initial);
        int iteration = 0;
        iteration = 0;
        while (iteration < this.maxIterations) {
            if (this.historyDropIters > 0 && iteration % this.historyDropIters == 0) {
                this.dumpHistory();
                if (this.verbose) {
                    Logger.logs("[LBFGSMinimizer.minimize] Dumped History at iter %d", iteration);
                }
            }
            double[] derivative = function.derivativeAt(guess);
            double value = function.valueAt(guess);
            double[] initialInverseHessianDiagonal = this.getInitialInverseHessianDiagonal(function);
            double[] direction = this.implicitMultiply(initialInverseHessianDiagonal, derivative);
            DoubleArrays.scale(direction, -1.0);
            lineSearcher.stepSizeMultiplier = iteration == 0 ? this.initialStepSizeMultiplier : this.stepSizeMultiplier;
            double[] nextGuess = this.doLineSearch(function, lineSearcher, guess, direction);
            double nextValue = function.valueAt(nextGuess);
            double[] nextDerivative = function.derivativeAt(nextGuess);
            if (printProgress) {
                this.printProgress(iteration, nextValue);
            }
            if (iteration >= this.minIterations && this.converged(value, nextValue, tolerance)) {
                if (this.verbose) {
                    Logger.logs("[LBFGSMinimizer.minimize] Converged.");
                }
                if (!this.dumpHistoryBeforeConverge || this.alreadyDumped) return nextGuess;
                this.dumpHistory();
                if (this.verbose) {
                    Logger.logs("[LBFGSMinimizer.minimize] Dumping History. Doing Iteration Over");
                }
                this.alreadyDumped = true;
                --iteration;
            } else {
                this.updateHistories(guess, nextGuess, derivative, nextDerivative);
                guess = nextGuess;
                value = nextValue;
                derivative = nextDerivative;
                if (this.iterCallbackFunction != null) {
                    this.iterCallbackFunction.callback(guess, iteration, value, derivative);
                }
            }
            ++iteration;
        }
        if (!this.verbose) return guess;
        Logger.logs("[LBFGSMinimizer.minimize] Stopped after " + iteration + " iterations.");
        return guess;
    }

    protected double[] doLineSearch(DifferentiableFunction function, BacktrackingLineSearcher lineSearcher, double[] guess, double[] direction) {
        return lineSearcher.minimize(function, guess, direction);
    }

    private void printProgress(int iteration, double nextValue) {
        if (this.verbose) {
            Logger.logs("[LBFGSMinimizer.minimize] Iteration %d ended with value %.6f", iteration, nextValue);
        }
    }

    protected boolean converged(double value, double nextValue, double tolerance) {
        double valueAverage;
        if (value == nextValue) {
            return true;
        }
        double valueChange = Math.abs(nextValue - value);
        return valueChange / (valueAverage = Math.abs(nextValue + value + this.EPS) / 2.0) < tolerance;
    }

    protected void updateHistories(double[] guess, double[] nextGuess, double[] derivative, double[] nextDerivative) {
        double[] guessChange = DoubleArrays.addMultiples(nextGuess, 1.0, guess, -1.0);
        double[] derivativeChange = DoubleArrays.addMultiples(nextDerivative, 1.0, derivative, -1.0);
        this.pushOntoList(guessChange, this.inputDifferenceVectorList);
        this.pushOntoList(derivativeChange, this.derivativeDifferenceVectorList);
    }

    private void pushOntoList(double[] vector, LinkedList<double[]> vectorList) {
        vectorList.addFirst(vector);
        if (vectorList.size() > this.maxHistorySize) {
            vectorList.removeLast();
        }
    }

    private int historySize() {
        return this.inputDifferenceVectorList.size();
    }

    public void setMaxHistorySize(int maxHistorySize) {
        this.maxHistorySize = maxHistorySize;
    }

    private double[] getInputDifference(int num) {
        return this.inputDifferenceVectorList.get(num);
    }

    private double[] getDerivativeDifference(int num) {
        return this.derivativeDifferenceVectorList.get(num);
    }

    private double[] getLastDerivativeDifference() {
        return this.derivativeDifferenceVectorList.getFirst();
    }

    private double[] getLastInputDifference() {
        return this.inputDifferenceVectorList.getFirst();
    }

    private double[] implicitMultiply(double[] initialInverseHessianDiagonal, double[] derivative) {
        double[] rho = new double[this.historySize()];
        double[] alpha = new double[this.historySize()];
        double[] right = DoubleArrays.clone(derivative);
        int i = this.historySize() - 1;
        while (i >= 0) {
            double[] inputDifference = this.getInputDifference(i);
            double[] derivativeDifference = this.getDerivativeDifference(i);
            rho[i] = DoubleArrays.innerProduct(inputDifference, derivativeDifference);
            if (rho[i] == 0.0) {
                throw new RuntimeException("[LBFGSMinimizer.implicitMultiply]: Curvature problem.");
            }
            alpha[i] = DoubleArrays.innerProduct(inputDifference, right) / rho[i];
            right = DoubleArrays.addMultiples(right, 1.0, derivativeDifference, -1.0 * alpha[i]);
            --i;
        }
        double[] left = DoubleArrays.pointwiseMultiply(initialInverseHessianDiagonal, right);
        int i2 = 0;
        while (i2 < this.historySize()) {
            double[] inputDifference = this.getInputDifference(i2);
            double[] derivativeDifference = this.getDerivativeDifference(i2);
            double beta = DoubleArrays.innerProduct(derivativeDifference, left) / rho[i2];
            left = DoubleArrays.addMultiples(left, 1.0, inputDifference, alpha[i2] - beta);
            ++i2;
        }
        return left;
    }

    private double[] getInitialInverseHessianDiagonal(DifferentiableFunction function) {
        double scale = 1.0;
        if (this.derivativeDifferenceVectorList.size() >= 1) {
            double[] lastDerivativeDifference = this.getLastDerivativeDifference();
            double[] lastInputDifference = this.getLastInputDifference();
            double num = DoubleArrays.innerProduct(lastDerivativeDifference, lastInputDifference);
            double den = DoubleArrays.innerProduct(lastDerivativeDifference, lastDerivativeDifference);
            scale = num / den;
        }
        return DoubleArrays.constantArray(scale, function.dimension());
    }

    public void setIterationCallbackFunction(CallbackFunction callbackFunction) {
        this.iterCallbackFunction = callbackFunction;
    }

    public LBFGSMinimizer() {
    }

    public LBFGSMinimizer(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void dumpHistory() {
        this.inputDifferenceVectorList.clear();
        this.derivativeDifferenceVectorList.clear();
    }
}

