/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.SloppyMath;

public class LogAdder {
    boolean inited = false;
    double sum;
    boolean superSloppy;

    public LogAdder(boolean superSloppy) {
        this.superSloppy = superSloppy;
    }

    public LogAdder() {
        this(false);
    }

    public void logAdd(double logProb) {
        if (this.inited) {
            this.sum = this.sloppyLogAdd(this.sum, logProb);
        } else {
            this.inited = true;
            this.sum = logProb;
        }
    }

    public double sloppyLogAdd(double lx, double ly) {
        double negDiff;
        double max;
        if (lx > ly) {
            max = lx;
            negDiff = ly - lx;
        } else {
            max = ly;
            negDiff = lx - ly;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            return max;
        }
        if (negDiff < -30.0) {
            return max;
        }
        if (this.superSloppy) {
            return max + SloppyMath.approxLog(1.0 + SloppyMath.approxExp(negDiff));
        }
        return max + Math.log(1.0 + Math.exp(negDiff));
    }

    public double getSum() {
        return this.inited ? this.sum : Double.NEGATIVE_INFINITY;
    }
}

