/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.TreePath;
import edu.berkeley.nlp.syntax.TreePathFinder;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.IdentityHashSet;
import edu.berkeley.nlp.util.functional.FunctionalUtils;
import edu.berkeley.nlp.util.functional.Predicate;
import java.io.StringReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GrammaticalRole {
    SUBJECT,
    OBJECT,
    OTHER,
    NONE,
    NULL;


    private static boolean isObject(TreePath<String> treePath) {
        for (TreePath.Transition<String> transition : treePath.getTransitions()) {
            if (transition.getDirection() == TreePath.Direction.UP) continue;
            return false;
        }
        return true;
    }

    private static boolean isSubject(TreePath<String> treePath) {
        boolean hitS = false;
        for (TreePath.Transition<String> trans : treePath.getTransitions()) {
            Tree<String> toNode = trans.getToNode();
            TreePath.Direction dir = trans.getDirection();
            Tree<String> dest = trans.getToNode();
            if (dest.getLabel().startsWith("S")) {
                hitS = true;
                continue;
            }
            if (!hitS && dir != TreePath.Direction.UP) {
                return false;
            }
            if (!hitS || dir == TreePath.Direction.DOWN_RIGHT) continue;
            return false;
        }
        return hitS;
    }

    public static GrammaticalRole findRole(Tree<String> node, Tree<String> root) {
        IdentityHashSet<Tree<String>> nodes = new IdentityHashSet<Tree<String>>(root.getPostOrderTraversal());
        if (!nodes.contains(node)) {
            return NONE;
        }
        GrammaticalRole curRole = OTHER;
        List<Tree<String>> vpNodes = FunctionalUtils.filter(nodes, new Predicate<Tree<String>>(){

            @Override
            public Boolean apply(Tree<String> input) {
                if (input.isPhrasal() && input.getLabel().startsWith("VP")) {
                    return true;
                }
                return false;
            }
        });
        TreePathFinder<String> tpf = new TreePathFinder<String>(root);
        for (Tree<String> vpNode : vpNodes) {
            if (vpNode == node) continue;
            TreePath<String> tp = tpf.findPath(node, vpNode);
            if (GrammaticalRole.isSubject(tp)) {
                return SUBJECT;
            }
            if (!GrammaticalRole.isObject(tp)) continue;
            curRole = OBJECT;
        }
        return curRole;
    }

    public static void main(String[] args) {
        String treeStr = "(ROOT (S (NP (DT The) (NN dog)) (VP (VBD ran) (NN home))))";
        StringReader reader = new StringReader(treeStr);
        Object tree = new Trees.PennTreeReader(reader).next();
        Tree<String> subjNode = ((Tree)tree).getChildren().get(0).getChildren().get(0);
        Tree<String> objNode = ((Tree)tree).getChild(0).getChild(1).getChild(1);
        System.out.println("subjNode is " + (Object)((Object)GrammaticalRole.findRole(subjNode, (Tree<String>)tree)));
        System.out.println("objNode is " + (Object)((Object)GrammaticalRole.findRole(objNode, (Tree<String>)tree)));
    }
}

