/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanTree<L> {
    int start;
    int end;
    L label;
    List<SpanTree<L>> children;

    public List<SpanTree<L>> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public boolean isPreTerminal() {
        return this.getChildren().size() == 1 && this.getChildren().get(0).isLeaf();
    }

    public void setChildren(List<SpanTree<L>> c) {
        this.children = c;
    }

    public SpanTree(L label) {
        this.label = label;
        this.children = Collections.emptyList();
        this.end = -1;
        this.start = -1;
    }

    public L getLabel() {
        return this.label;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setSpans() {
        ArrayList yield = new ArrayList();
        this.setSpansHelper(this, yield);
    }

    public void setSpansHelper(SpanTree<L> tree, List<L> yield) {
        if (tree.isLeaf()) {
            int pos = yield.size();
            yield.add(tree.getLabel());
            tree.setStart(pos);
            tree.setEnd(pos + 1);
            return;
        }
        List<SpanTree<L>> children = tree.getChildren();
        for (SpanTree<L> child : children) {
            this.setSpansHelper(child, yield);
        }
        SpanTree<L> child1 = children.get(0);
        SpanTree<L> child2 = children.get(children.size() - 1);
        tree.setStart(child1.getStart());
        tree.setEnd(child2.getEnd());
    }
}

