/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.syntax.Tree;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePath<L> {
    private Tree<L> startNode;
    private Tree<L> endNode;
    private List<Transition<L>> transitions;
    private String cacheStr = null;

    public TreePath(List<Transition<L>> transitions) {
        if (transitions == null || transitions.size() == 0) {
            throw new IllegalArgumentException("Cannot have empty transitions list");
        }
        this.transitions = transitions;
        this.startNode = ((Transition)transitions.get(0)).fromNode;
        this.endNode = ((Transition)transitions.get(transitions.size() - 1)).toNode;
    }

    public Tree<L> getStartNode() {
        return this.startNode;
    }

    public Tree<L> getEndNode() {
        return this.endNode;
    }

    public List<Transition<L>> getTransitions() {
        return this.transitions;
    }

    public String toString() {
        if (this.cacheStr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (Transition<L> transition : this.transitions) {
                sb.append(((Transition)transition).fromNode.getLabel() + " " + (Object)((Object)((Transition)transition).direction) + " ");
            }
            sb.append(this.endNode.getLabel() + " ]");
            this.cacheStr = sb.toString();
        }
        return this.cacheStr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN,
        DOWN_LEFT,
        DOWN_RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Transition<L> {
        private Tree<L> fromNode;
        private Tree<L> toNode;
        private Direction direction;

        public Transition(Tree<L> fromNode, Tree<L> toNode, Direction direction) {
            this.fromNode = fromNode;
            this.toNode = toNode;
            this.direction = direction;
        }

        public Tree<L> getFromNode() {
            return this.fromNode;
        }

        public Tree<L> getToNode() {
            return this.toNode;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }
}

