/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.TreePath;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePathFinder<L> {
    private Tree<L> root;
    private IdentityHashMap<Tree<L>, List<Tree<L>>> pathsFromRoot;

    public Tree<L> getRoot() {
        return this.root;
    }

    public TreePathFinder(Tree<L> tree) {
        this.root = tree;
        this.pathsFromRoot = new IdentityHashMap(tree.getPreOrderTraversal().size());
        this.constructPaths(this.root, new ArrayList<Tree<L>>());
    }

    private void constructPaths(Tree<L> node, List<Tree<L>> path) {
        path.add(node);
        this.pathsFromRoot.put(node, path);
        for (Tree<L> child : node.getChildren()) {
            ArrayList<Tree<L>> childPath = new ArrayList<Tree<L>>(path.size() + 1);
            childPath.addAll(path);
            this.constructPaths(child, childPath);
        }
    }

    public Tree<L> findParent(Tree<L> node) {
        if (!this.pathsFromRoot.containsKey(node)) {
            throw new IllegalArgumentException("Tree must be node in the tree used to initialize the TreePathFinder");
        }
        if (node == this.root) {
            return null;
        }
        List<Tree<L>> path = this.pathsFromRoot.get(node);
        return path.get(path.size() - 2);
    }

    public TreePath<L> findPath(Tree<L> start, Tree<L> end) {
        this.validateInput(start, end);
        ArrayList transitions = new ArrayList();
        if (start != end) {
            List<Tree<L>> startPath = this.pathsFromRoot.get(start);
            List<Tree<L>> endPath = this.pathsFromRoot.get(end);
            int rootIndex = this.findRootIndex(startPath, endPath);
            int i = startPath.size() - 1;
            while (i > rootIndex) {
                transitions.add(new TreePath.Transition<L>(startPath.get(i), startPath.get(i - 1), TreePath.Direction.UP));
                --i;
            }
            if (rootIndex < endPath.size() - 1) {
                TreePath.Direction postRootDirection = TreePath.Direction.DOWN;
                if (rootIndex < startPath.size() - 1) {
                    postRootDirection = TreePath.Direction.DOWN_RIGHT;
                    for (Tree<L> rootChild : startPath.get(rootIndex).getChildren()) {
                        if (startPath.get(rootIndex + 1) == rootChild) break;
                        if (endPath.get(rootIndex + 1) != rootChild) continue;
                        postRootDirection = TreePath.Direction.DOWN_LEFT;
                        break;
                    }
                }
                transitions.add(new TreePath.Transition<L>(endPath.get(rootIndex), endPath.get(rootIndex + 1), postRootDirection));
            }
            i = rootIndex + 1;
            while (i < endPath.size() - 1) {
                transitions.add(new TreePath.Transition<L>(endPath.get(i), endPath.get(i + 1), TreePath.Direction.DOWN));
                ++i;
            }
        }
        return new TreePath(transitions);
    }

    private int findRootIndex(List<Tree<L>> startPath, List<Tree<L>> endPath) {
        int rootIndex = 0;
        for (Tree<L> node : startPath) {
            if (rootIndex == endPath.size() || node != endPath.get(rootIndex)) break;
            ++rootIndex;
        }
        return --rootIndex;
    }

    public Tree<L> findLowestCommonAncestor(Tree<L> start, Tree<L> end) {
        this.validateInput(start, end);
        if (start == end) {
            return start;
        }
        List<Tree<L>> startPath = this.pathsFromRoot.get(start);
        List<Tree<L>> endPath = this.pathsFromRoot.get(end);
        int rootIndex = this.findRootIndex(startPath, endPath);
        return startPath.get(rootIndex);
    }

    private void validateInput(Tree<L> start, Tree<L> end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Cannot provide null trees");
        }
        if (!this.pathsFromRoot.containsKey(start) || !this.pathsFromRoot.containsKey(end)) {
            throw new IllegalArgumentException("Both trees must be nodes in the tree used to initialize the TreePathFinder");
        }
    }
}

