/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ui;

import edu.berkeley.nlp.ui.EasyFormat;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Pair;
import edu.berkeley.nlp.util.StrUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class Table {
    private final Map<Pair<Integer, Integer>, String[]> entries = new HashMap<Pair<Integer, Integer>, String[]>();
    private final Counter<Integer> maxHeights = new Counter();
    private final Counter<Integer> maxWidths = new Counter();
    private int nColumns;
    private int nRows;
    private boolean borderDefault = true;
    public static final String css = "table.with-borders {border-width: 1px 1px 1px 1px;border-spacing: 2px;border-style: solid solid solid solid;border-color: black black black black;border-collapse: collapse;background-color: white;}table.with-borders td {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: dotted dotted dotted dotted;border-color: gray gray gray gray;background-color: white;-moz-border-radius: 0px 0px 0px 0px;}table.without-borders {border-width: 1px 1px 1px 1px;border-spacing: 2px;border-style: none none none none;border-collapse: collapse;background-color: white;}table.without-borders td {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: none none none none;background-color: white;-moz-border-radius: 0px 0px 0px 0px;}";

    public Table(Populator populator) {
        populator.setTable(this);
        populator.populate();
    }

    public void setBorder(boolean value) {
        this.borderDefault = value;
    }

    public String toString() {
        return this.toString(this.borderDefault);
    }

    public String toHTML() {
        return this.toHTML(this.borderDefault);
    }

    public String toHTML(boolean printBorders) {
        StringBuilder builder = new StringBuilder();
        builder.append("<table class=\"" + (printBorders ? "with-borders" : "without-borders") + "\">");
        int row = 0;
        while (row < this.nRows) {
            builder.append("<tr>");
            int col = 0;
            while (col < this.nColumns) {
                builder.append("<td>");
                Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
                String[] entry = this.entries.get(key);
                if (entry != null) {
                    int i = 0;
                    while (i < entry.length) {
                        builder.append(String.valueOf(entry[i]) + (i < entry.length - 1 ? "<br/>" : ""));
                        ++i;
                    }
                }
                builder.append("</td>");
                ++col;
            }
            builder.append("</tr>");
            ++row;
        }
        builder.append("</table>\n");
        return builder.toString();
    }

    public String toString(boolean printBorders) {
        StringBuilder builder = new StringBuilder();
        if (printBorders) {
            builder.append(this.horizontalSeparator() + "\n");
        }
        int row = 0;
        while (row < this.nRows) {
            int rowLine = 0;
            while ((double)rowLine < this.maxHeights.getCount(row)) {
                if (printBorders) {
                    builder.append("|");
                }
                int col = 0;
                while (col < this.nColumns) {
                    Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
                    String text = this.entries.get(key) == null || rowLine >= this.entries.get(key).length ? "" : this.entries.get(key)[rowLine];
                    builder.append(this.pad(text, (int)this.maxWidths.getCount(col), " "));
                    if (printBorders) {
                        builder.append("|");
                    }
                    ++col;
                }
                if ((double)rowLine != this.maxHeights.getCount(row) - 1.0) {
                    builder.append("\n");
                }
                ++rowLine;
            }
            if (printBorders) {
                builder.append("\n" + this.horizontalSeparator());
            }
            builder.append("\n");
            ++row;
        }
        return builder.toString();
    }

    private StringBuilder horizontalSeparator() {
        StringBuilder builder = new StringBuilder();
        builder.append("+");
        int col = 0;
        while (col < this.nColumns) {
            builder.append(String.valueOf(this.pad("", (int)this.maxWidths.getCount(col), "-")) + "+");
            ++col;
        }
        return builder;
    }

    private String pad(String s, int finalLength, String pad) {
        if (s.length() > finalLength) {
            throw new RuntimeException();
        }
        StringBuilder b = new StringBuilder();
        b.append(s);
        while (b.length() < finalLength) {
            b.append(pad);
        }
        return b.toString();
    }

    public static void main(String[] args) {
        Table table = new Table(new Populator(){

            public void populate() {
                int j;
                int i = 0;
                while (i < 10) {
                    j = 0;
                    while (j < 10) {
                        if (i <= j) {
                            this.addLines(i, j, "Sum:" + (i + j));
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < 10) {
                    j = 0;
                    while (j < 10) {
                        if (i <= j) {
                            this.addLines(i, j, "Prod:" + i * j);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        System.out.println(table.toString());
    }

    public static abstract class Populator {
        private Table table;
        private DecimalFormat fmt = EasyFormat.getStdFormat();

        private void setTable(Table table) {
            this.table = table;
        }

        public Populator() {
        }

        public Populator(DecimalFormat fmt) {
            this.fmt = fmt;
        }

        public abstract void populate();

        public final void set(int row, int column, double number) {
            this.set(row, column, this.fmt.format(number));
        }

        public final void set(int row, int column, String text) {
            this.table.nColumns = Math.max(this.table.nColumns, column + 1);
            this.table.nRows = Math.max(this.table.nRows, row + 1);
            String[] lines = text.split("\\n");
            this.table.maxHeights.setCount(row, Math.max(this.table.maxHeights.getCount(row), (double)lines.length));
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.table.maxWidths.setCount(column, Math.max(this.table.maxWidths.getCount(column), (double)line.length()));
                ++n2;
            }
            this.table.entries.put(new Pair<Integer, Integer>(row, column), lines);
        }

        public final void append(int row, int column, String text) {
            String[] entries = (String[])this.table.entries.get(new Pair<Integer, Integer>(row, column));
            String lastEntry = entries != null ? entries[entries.length - 1] : null;
            this.set(row, column, String.valueOf(lastEntry != null ? lastEntry : "") + text);
        }

        public final void addLines(int row, int column, String text) {
            Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, column);
            String currentString = StrUtils.join((String[])this.table.entries.get(key), "\n");
            if (!currentString.equals("")) {
                currentString = String.valueOf(currentString) + "\n";
            }
            currentString = String.valueOf(currentString) + text;
            this.set(row, column, currentString);
        }
    }
}

