/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ui;

import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeJPanel
extends JPanel {
    int VERTICAL_ALIGN = 0;
    int HORIZONTAL_ALIGN = 0;
    int maxFontSize = 10;
    int minFontSize = 2;
    int preferredX = 400;
    int preferredY = 300;
    double sisterSkip = 2.5;
    double parentSkip = 0.5;
    double belowLineSkip = 0.1;
    double aboveLineSkip = 0.1;
    FontMetrics myFont;
    Tree<String> tree;
    WidthResult wr = new WidthResult();

    public Tree<String> getTree() {
        return this.tree;
    }

    public void setTree(Tree<String> tree) {
        this.tree = tree;
        this.repaint();
    }

    String nodeToString(Tree<String> t) {
        if (t == null) {
            return " ";
        }
        String l = t.getLabel();
        if (l == null) {
            return " ";
        }
        String str = l;
        if (str == null) {
            return " ";
        }
        return str;
    }

    double width(Tree<String> tree, FontMetrics fM) {
        return this.widthResult(tree, (FontMetrics)fM).width;
    }

    public int width() {
        return (int)this.widthResult(this.getTree(), (FontMetrics)this.myFont).width;
    }

    WidthResult widthResult(Tree<String> tree, FontMetrics fM) {
        if (tree == null) {
            this.wr.width = 0.0;
            this.wr.nodeTab = 0.0;
            this.wr.nodeCenter = 0.0;
            this.wr.childTab = 0.0;
            return this.wr;
        }
        double local = fM.stringWidth(this.nodeToString(tree));
        if (tree.isLeaf()) {
            this.wr.width = local;
            this.wr.nodeTab = 0.0;
            this.wr.nodeCenter = local / 2.0;
            this.wr.childTab = 0.0;
            return this.wr;
        }
        double sub = 0.0;
        double nodeCenter = 0.0;
        double childTab = 0.0;
        int i = 0;
        while (i < tree.getChildren().size()) {
            WidthResult subWR = this.widthResult(tree.getChildren().get(i), fM);
            if (i == 0) {
                nodeCenter += (sub + subWR.nodeCenter) / 2.0;
            }
            if (i == tree.getChildren().size() - 1) {
                nodeCenter += (sub + subWR.nodeCenter) / 2.0;
            }
            sub += subWR.width;
            if (i < tree.getChildren().size() - 1) {
                sub += this.sisterSkip * (double)fM.stringWidth(" ");
            }
            ++i;
        }
        double localLeft = local / 2.0;
        double subLeft = nodeCenter;
        double totalLeft = Math.max(localLeft, subLeft);
        double localRight = local / 2.0;
        double subRight = sub - nodeCenter;
        double totalRight = Math.max(localRight, subRight);
        this.wr.width = totalLeft + totalRight;
        this.wr.childTab = totalLeft - subLeft;
        this.wr.nodeTab = totalLeft - localLeft;
        this.wr.nodeCenter = nodeCenter + this.wr.childTab;
        return this.wr;
    }

    double height(Tree<String> tree, FontMetrics fM) {
        if (tree == null) {
            return 0.0;
        }
        double depth = tree.getDepth();
        return (double)fM.getHeight() * (depth * (1.0 + this.parentSkip + this.aboveLineSkip + this.belowLineSkip) - this.parentSkip);
    }

    public int height() {
        return (int)this.height(this.getTree(), this.myFont);
    }

    FontMetrics pickFont(Graphics2D g2, Tree<String> tree, Dimension space) {
        Font font = g2.getFont();
        String name = font.getName();
        int style = font.getStyle();
        int size = this.maxFontSize;
        while (size > this.minFontSize) {
            font = new Font(name, style, size);
            g2.setFont(font);
            FontMetrics fontMetrics = g2.getFontMetrics();
            if (!(this.height(tree, fontMetrics) > space.getHeight()) && !(this.width(tree, fontMetrics) > space.getWidth())) {
                return fontMetrics;
            }
            --size;
        }
        font = new Font(name, style, this.minFontSize);
        g2.setFont(font);
        return g2.getFontMetrics();
    }

    double paintTree(Tree<String> t, Point2D start, Graphics2D g2, FontMetrics fM) {
        if (t == null) {
            return 0.0;
        }
        String nodeStr = this.nodeToString(t);
        double nodeWidth = fM.stringWidth(nodeStr);
        double nodeHeight = fM.getHeight();
        double nodeAscent = fM.getAscent();
        WidthResult wr = this.widthResult(t, fM);
        double treeWidth = wr.width;
        double nodeTab = wr.nodeTab;
        double childTab = wr.childTab;
        double nodeCenter = wr.nodeCenter;
        g2.drawString(nodeStr, (float)(nodeTab + start.getX()), (float)(start.getY() + nodeAscent));
        if (t.isLeaf()) {
            return nodeWidth;
        }
        double layerMultiplier = 1.0 + this.belowLineSkip + this.aboveLineSkip + this.parentSkip;
        double layerHeight = nodeHeight * layerMultiplier;
        double childStartX = start.getX() + childTab;
        double childStartY = start.getY() + layerHeight;
        double lineStartX = start.getX() + nodeCenter;
        double lineStartY = start.getY() + nodeHeight * (1.0 + this.belowLineSkip);
        double lineEndY = lineStartY + nodeHeight * this.parentSkip;
        int i = 0;
        while (i < t.getChildren().size()) {
            Tree<String> child = t.getChildren().get(i);
            double cWidth = this.paintTree(child, new Point2D.Double(childStartX, childStartY), g2, fM);
            wr = this.widthResult(child, fM);
            double lineEndX = childStartX + wr.nodeCenter;
            g2.draw(new Line2D.Double(lineStartX, lineStartY, lineEndX, lineEndY));
            childStartX += cWidth;
            if (i < t.getChildren().size() - 1) {
                childStartX += this.sisterSkip * (double)fM.stringWidth(" ");
            }
            ++i;
        }
        return treeWidth;
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.paintComponent(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        double width = this.width(this.tree, this.myFont);
        double height = this.height(this.tree, this.myFont);
        this.preferredX = (int)width;
        this.preferredY = (int)height;
        this.setSize(new Dimension(this.preferredX, this.preferredY));
        this.setPreferredSize(new Dimension(this.preferredX, this.preferredY));
        this.setMaximumSize(new Dimension(this.preferredX, this.preferredY));
        this.setMinimumSize(new Dimension(this.preferredX, this.preferredY));
        g2.setFont(this.myFont.getFont());
        Dimension space = this.getSize();
        double startX = 0.0;
        double startY = 0.0;
        if (this.HORIZONTAL_ALIGN == 0) {
            startX = (space.getWidth() - width) / 2.0;
        }
        if (this.HORIZONTAL_ALIGN == 4) {
            startX = space.getWidth() - width;
        }
        if (this.VERTICAL_ALIGN == 0) {
            startY = (space.getHeight() - height) / 2.0;
        }
        if (this.VERTICAL_ALIGN == 3) {
            startY = space.getHeight() - height;
        }
        super.paintComponent(g);
        g2.setBackground(Color.white);
        g2.clearRect(0, 0, space.width, space.height);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setPaint(Color.black);
        this.paintTree(this.tree, new Point2D.Double(startX, startY), g2, this.myFont);
    }

    public TreeJPanel() {
        this(0, 0);
    }

    public TreeJPanel(int hAlign, int vAlign) {
        this.HORIZONTAL_ALIGN = hAlign;
        this.VERTICAL_ALIGN = vAlign;
        Font font = this.getFont();
        font = new Font(font.getName(), font.getStyle(), this.maxFontSize);
        this.myFont = this.getFontMetrics(font);
    }

    public void setMinFontSize(int size) {
        this.minFontSize = size;
    }

    public void setMaxFontSize(int size) {
        this.maxFontSize = size;
    }

    public static void main(String[] args) throws IOException {
        TreeJPanel tjp = new TreeJPanel();
        String ptbTreeString = "(NP-2 (NP-1 (QP-1 (CD-1 One) (JJR-1 more)) (NN-2 try)) (PP-0 (IN-1 with) (NP-2 (NP-1 (NN-1 something)) (ADVP-0 (RB-1 longer)))))";
        if (args.length > 0) {
            ptbTreeString = args[0];
        }
        Object tree = new Trees.PennTreeReader(new StringReader(ptbTreeString)).next();
        tjp.setTree((Tree<String>)tree);
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)tjp, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        frame.setVisible(true);
        frame.setSize(tjp.preferredX, tjp.preferredY);
        int t = 1;
        ++t;
        BufferedImage bi = new BufferedImage(tjp.width(), tjp.height(), 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(1, 1.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight());
        g2.fill(rect);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        tjp.paintComponent(g2);
        ImageIO.write((RenderedImage)bi, "png", new File("example.png"));
    }

    static class WidthResult {
        double width = 0.0;
        double nodeTab = 0.0;
        double nodeCenter = 0.0;
        double childTab = 0.0;

        WidthResult() {
        }
    }
}

