/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beam<T> {
    private int size;
    private double kstat = Double.POSITIVE_INFINITY;
    private List<T> kbest;
    private double[] kbestValues;

    public Beam(int size) {
        this.size = size;
        this.kbest = new ArrayList<T>(size + 1);
        this.kbestValues = new double[size];
        Arrays.fill(this.kbestValues, Double.POSITIVE_INFINITY);
    }

    public void observe(T t, double val) {
        if (val < this.kstat || val <= this.kstat && this.kbest.size() < this.size) {
            int index;
            if (this.kbest.size() == this.size) {
                this.kbest.remove(this.kbest.size() - 1);
            }
            int pos = (index = Arrays.binarySearch(this.kbestValues, val)) < 0 ? -1 * index - 1 : index;
            this.kbest.add(pos, t);
            this.kbestValues[this.kbest.size() - 1] = val;
            Arrays.sort(this.kbestValues);
            this.kstat = this.kbestValues[this.size - 1];
        }
    }

    public int getSize() {
        return this.size;
    }

    public double beamCutoff() {
        return this.kstat;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<T> contents() {
        return this.kbest;
    }

    public double[] getKbestValues() {
        return this.kbestValues;
    }

    public int size() {
        return this.kbest.size();
    }

    public T argMin() {
        if (this.size() == 0) {
            return null;
        }
        return this.kbest.get(0);
    }

    public static void main(String[] args) {
        Beam<String> bs = new Beam<String>(3);
        bs.observe("what1", 1.0);
        bs.observe("what2", 4.0);
        bs.observe("what3", 0.0);
        bs.observe("what4", 2.0);
        bs.observe("what5", 3.0);
        bs.observe("what6", 1.0);
        System.out.println(bs.contents());
        int n = 10000;
        Beam<Double> bsd = new Beam<Double>(n / 10);
        ArrayList<Double> l = new ArrayList<Double>(n);
        Random random = new Random();
        int i = 0;
        while (i < n) {
            double r = random.nextDouble();
            bsd.observe(r, r);
            l.add(r);
            ++i;
        }
        Collections.sort(l);
        i = 0;
        while (i < n) {
            if (i < bsd.kbest.size()) {
                System.out.println("Same?:\t" + bsd.kbest.get(i) + "\t" + l.get(i));
            }
            ++i;
        }
    }
}

