/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Counter;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_NUM_BINS = 10;
    private static int currentNumBins = 10;
    private boolean binsHaveBeenSet;
    private List<Double> data;
    private int[] m_hist;
    private String title;
    private double minValue;
    private double maxValue;
    private int numBins;
    private double[] binLowerBounds;
    private double[] binUpperBounds;
    private int m_entries;
    private double m_overflow;
    private double m_underflow;

    public Histogram() {
        this("Histogram");
    }

    public Histogram(String title) {
        this.title = title;
        this.data = new ArrayList<Double>();
    }

    public static <T> Histogram histogramOfCounts(Counter<T> counter) {
        Histogram h = new Histogram();
        for (T o : counter.keySet()) {
            h.add(counter.getCount(o));
        }
        return h;
    }

    public static <T> Histogram histogramOfValues(Counter<Double> counter) {
        Histogram h = new Histogram();
        for (Double d : counter.keySet()) {
            double count = counter.getCount(d);
            int i = 0;
            while ((double)i < count) {
                h.add(d);
                ++i;
            }
        }
        return h;
    }

    public void add(double value) {
        this.data.add(value);
    }

    private void fill(double x) {
        BinInfo bin = this.findBin(x);
        if (bin.isUnderflow) {
            this.m_underflow += 1.0;
        }
        if (bin.isOverflow) {
            this.m_overflow += 1.0;
        }
        if (bin.isInRange) {
            int n = bin.index;
            this.m_hist[n] = this.m_hist[n] + 1;
        }
        ++this.m_entries;
    }

    private BinInfo findBin(double x) {
        BinInfo bin = new BinInfo();
        bin.isInRange = false;
        bin.isUnderflow = false;
        bin.isOverflow = false;
        if (x < this.minValue) {
            bin.isUnderflow = true;
        } else if (x > this.maxValue) {
            bin.isOverflow = true;
        } else {
            bin.isInRange = true;
            int i = 0;
            while (i < this.numBins) {
                if (x < this.binUpperBounds[i]) {
                    bin.index = i;
                    break;
                }
                ++i;
            }
            if (x == this.maxValue) {
                bin.index = this.numBins - 1;
            }
        }
        return bin;
    }

    public void write(PrintWriter outfile) {
        this.setBuckets();
        this.fillHistogram();
        this.writeToPrintWriter(outfile);
    }

    private void writeToPrintWriter(PrintWriter outfile) {
        outfile.println(this.title);
        outfile.println("Bins:\t" + this.numBins);
        outfile.println("Min:\t" + this.minValue);
        outfile.println("Max:\t" + this.maxValue);
        outfile.println("Entries:\t" + this.m_entries);
        if (this.m_overflow > 0.0) {
            outfile.println("Over:\t" + this.m_overflow);
        }
        if (this.m_underflow > 0.0) {
            outfile.println("Under:\t" + this.m_underflow);
        }
        int i = 0;
        while (i < this.numBins) {
            String l = String.format("%.2f", this.binLowerBounds[i]);
            String u = String.format("%.2f", this.binUpperBounds[i]);
            outfile.print("[" + l + ", " + u);
            if (this.numBins - 1 != i) {
                outfile.print(")");
            } else {
                outfile.print("]");
            }
            outfile.println(":\t" + this.m_hist[i]);
            ++i;
        }
        outfile.close();
    }

    public String toString() {
        this.setBuckets();
        this.fillHistogram();
        StringWriter s = new StringWriter();
        PrintWriter pw = new PrintWriter(new BufferedWriter(s));
        this.writeToPrintWriter(pw);
        return s.getBuffer().toString();
    }

    private void fillHistogram() {
        this.m_entries = 0;
        this.m_overflow = 0.0;
        this.m_underflow = 0.0;
        this.m_hist = new int[this.numBins];
        for (double d : this.data) {
            this.fill(d);
        }
    }

    private void setBuckets() {
        this.setBuckets(currentNumBins);
    }

    private void setBuckets(int numBins) {
        if (!this.binsHaveBeenSet) {
            this.setBuckets(numBins, this.getMin(), this.getMax());
            this.binsHaveBeenSet = false;
        }
    }

    public void setBuckets(int numBins, double min, double max) {
        double[] lowers = new double[numBins];
        double step = (max - min) / (double)numBins;
        int i = 0;
        while (i < numBins) {
            lowers[i] = min + (double)i * step;
            ++i;
        }
        this.setBuckets(lowers, min, max);
    }

    private void setBuckets(double[] lowers) {
        this.setBuckets(lowers, lowers[0], Double.POSITIVE_INFINITY);
    }

    public void setBuckets(double[] binLowerBounds, double min, double max) {
        this.numBins = binLowerBounds.length;
        this.binLowerBounds = binLowerBounds;
        assert (min == binLowerBounds[0]);
        this.minValue = min;
        this.maxValue = max;
        this.updateBinUpperBounds();
        this.binsHaveBeenSet = true;
    }

    private void updateBinUpperBounds() {
        this.binUpperBounds = new double[this.numBins];
        int i = 0;
        while (i < this.numBins - 1) {
            this.binUpperBounds[i] = this.binLowerBounds[i + 1];
            ++i;
        }
        this.binUpperBounds[this.numBins - 1] = this.maxValue;
    }

    public double getMax() {
        double max = Double.NEGATIVE_INFINITY;
        for (double d : this.data) {
            max = Math.max(max, d);
        }
        return max;
    }

    public double getMin() {
        double min = Double.POSITIVE_INFINITY;
        for (double d : this.data) {
            min = Math.min(min, d);
        }
        return min;
    }

    public static void main(String[] args) {
        Histogram h = new Histogram();
        double i = 1.0;
        while (i < 43400.0) {
            h.add(i);
            i *= 1.2;
        }
        System.out.println(h);
        double[] lowers = new double[]{0.0, 100.0, 1000.0};
        h.setBuckets(lowers);
        System.out.println(h);
        h.setLogBuckets(10);
        System.out.println(h);
    }

    public void setLogBuckets(int numBuckets) {
        this.setLogBuckets(numBuckets, this.getMin(), this.getMax());
    }

    public void setLogBuckets(int numBuckets, double min, double max) {
        double step = Math.pow(max - min + 1.0, 1.0 / (double)numBuckets);
        double[] lowers = new double[numBuckets];
        int i = 0;
        while (i < numBuckets) {
            lowers[i] = min - 1.0 + Math.pow(step, i);
            ++i;
        }
        this.setBuckets(lowers, min, max);
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public static int getNumBins() {
        return currentNumBins;
    }

    public static void setNumBins(int currentNumBins) {
        Histogram.currentNumBins = currentNumBins;
    }

    private class BinInfo {
        public int index;
        public boolean isUnderflow;
        public boolean isOverflow;
        public boolean isInRange;

        private BinInfo() {
        }
    }
}

