/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtil {
    public static File createTempDirectory(String prefix) throws IOException {
        File tempFile = File.createTempFile(prefix, "");
        if (!tempFile.delete()) {
            throw new IOException();
        }
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile;
    }

    public static List<File> getFilesUnder(String dir, String filePrefix, String fileExt, boolean recursive) {
        ArrayList<File> files = new ArrayList<File>();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return files;
        }
        if (!dirFile.isDirectory()) {
            return Collections.singletonList(dirFile);
        }
        File[] fileArray = dirFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                if (recursive) {
                    files.addAll(IOUtil.getFilesUnder(f.getAbsolutePath(), filePrefix, fileExt, recursive));
                }
            } else {
                String name = f.getName();
                if (name.startsWith(filePrefix) && name.endsWith(fileExt)) {
                    files.add(f);
                }
            }
            ++n2;
        }
        return files;
    }

    public static FileFilter getFileFilter(final String prefix, final String ext) {
        return new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.startsWith(prefix) && name.endsWith(ext);
            }
        };
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = IOUtil.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static FileReader fileReaderHard(String filename) {
        try {
            return new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
            throw new IllegalStateException();
        }
    }

    public static String getPath(String parentPath, String childName) {
        return new File(parentPath, childName).getPath();
    }
}

