/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Lists {
    public static <T> ArrayList<T> newList(T ... els) {
        ArrayList<T> l = new ArrayList<T>(els.length);
        int i = 0;
        while (i < els.length) {
            l.add(els[i]);
            ++i;
        }
        return l;
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        ArrayList<T> l = new ArrayList<T>(l1.size() + l2.size());
        l.addAll(l1);
        l.addAll(l2);
        return l;
    }

    public static <T> void reverse(List<T> list) {
        ArrayList<T> temp = new ArrayList<T>(list.size());
        temp.addAll(list);
        int len = list.size();
        int i = 0;
        while (i < len) {
            list.set(i, temp.get(len - i - 1));
            ++i;
        }
    }

    public static <T> List<T> subList(List<T> list, Set<Integer> indices) {
        ArrayList<T> l = new ArrayList<T>(indices.size());
        for (int i : indices) {
            l.add(list.get(i));
        }
        return l;
    }

    public static <T> void set(List<T> list, int index, T element) {
        int gap = index - list.size() + 1;
        while (gap-- > 0) {
            list.add(null);
        }
        list.set(index, element);
    }

    public static <T extends Comparable<T>> Comparator<List<T>> comparator(T example) {
        return new Comparator<List<T>>(){

            @Override
            public int compare(List<T> o1, List<T> o2) {
                int i = 0;
                while (i < o1.size()) {
                    Comparable c2;
                    if (i == o2.size()) {
                        return 1;
                    }
                    Comparable c1 = (Comparable)o1.get(i);
                    int r = c1.compareTo(c2 = (Comparable)o2.get(i));
                    if (r != 0) {
                        return r;
                    }
                    ++i;
                }
                return o2.size() > o1.size() ? -1 : 0;
            }
        };
    }

    public static int min(List<Integer> list) {
        int min = Integer.MAX_VALUE;
        for (int i : list) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    public static int max(List<Integer> list) {
        int max = Integer.MIN_VALUE;
        for (int i : list) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    public static <T> List<T> truncate(List<T> list, int len) {
        if (len >= list.size()) {
            return list;
        }
        ArrayList<T> newlist = new ArrayList<T>(list.subList(0, len));
        return newlist;
    }

    public static double dotProduct(List<Double> v1, List<Double> v2) {
        double sum = 0.0;
        int i = 0;
        while (i < v1.size()) {
            sum += v1.get(i) * v2.get(i);
            ++i;
        }
        return sum;
    }

    public static <T> List<T> fromArray(T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static int[] toPrimitiveArray(List<Integer> curList) {
        int[] newArray = new int[curList.size()];
        int i = 0;
        while (i < newArray.length) {
            newArray[i] = curList.get(i);
            ++i;
        }
        return newArray;
    }

    public static double[] toPrimitiveArray(List<Double> curList) {
        double[] newArray = new double[curList.size()];
        int i = 0;
        while (i < newArray.length) {
            newArray[i] = curList.get(i);
            ++i;
        }
        return newArray;
    }

    public static List<Integer> rangeList(int i, int j) {
        ArrayList<Integer> l = new ArrayList<Integer>(j - i);
        int k = i;
        while (k < j) {
            l.add(k);
            ++k;
        }
        return l;
    }
}

